/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.HashMapExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBigDecimal;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableLong;
import fm.icelink.callstats.Utility;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

abstract class DataStatsCSRTPStats {
    private String _codecId;
    private String _csId;
    private Date _csTimestamp = new Date();
    private String _csType;
    private boolean _isRemote;
    private BigDecimal _jitter = new BigDecimal(0);
    private String _mediaType;
    private long _packetsLost;
    private long _ssrc;
    private String _trackId;
    private String _transportId;

    protected DataStatsCSRTPStats() {
    }

    protected void deserializeProperties(String key, String valueJson) {
        String _var0 = key;
        if (_var0.equals("id")) {
            this.setCsId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("timestamp")) {
            this.setCsTimestamp(Utility.callStatsMillisToDateTime(valueJson));
        } else if (_var0.equals("type")) {
            this.setCsType(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("ssrc")) {
            this.setSsrc(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("isRemote")) {
            this.setIsRemote(JsonSerializer.deserializeBoolean((String)valueJson).getValue());
        } else if (_var0.equals("mediaType")) {
            this.setMediaType(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("trackId")) {
            this.setTrackId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("transportId")) {
            this.setTransportId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("codecId")) {
            this.setCodecId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("packetsLost")) {
            this.setPacketsLost(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("jitter")) {
            this.setJitter(JsonSerializer.deserializeDecimal((String)valueJson).getValue());
        }
    }

    String getCodecId() {
        return this._codecId;
    }

    public String getCsId() {
        return this._csId;
    }

    public Date getCsTimestamp() {
        return this._csTimestamp;
    }

    public String getCsType() {
        return this._csType;
    }

    boolean getIsRemote() {
        return this._isRemote;
    }

    BigDecimal getJitter() {
        return this._jitter;
    }

    String getMediaType() {
        return this._mediaType;
    }

    long getPacketsLost() {
        return this._packetsLost;
    }

    long getSsrc() {
        return this._ssrc;
    }

    String getTrackId() {
        return this._trackId;
    }

    String getTransportId() {
        return this._transportId;
    }

    protected void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        if (this.getCsType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"type", (Object)JsonSerializer.serializeString((String)this.getCsType()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"ssrc", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getSsrc())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"isRemote", (Object)JsonSerializer.serializeBoolean((NullableBoolean)new NullableBoolean(this.getIsRemote())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"mediaType", (Object)JsonSerializer.serializeString((String)this.getMediaType()));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"trackId", (Object)JsonSerializer.serializeString((String)this.getTrackId()));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"transportId", (Object)JsonSerializer.serializeString((String)this.getTransportId()));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"codecId", (Object)JsonSerializer.serializeString((String)this.getCodecId()));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"packetsLost", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getPacketsLost())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"jitter", (Object)JsonSerializer.serializeDecimal((NullableBigDecimal)new NullableBigDecimal(this.getJitter())));
    }

    void setCodecId(String value) {
        this._codecId = value;
    }

    public void setCsId(String value) {
        this._csId = value;
    }

    public void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    public void setCsType(String value) {
        this._csType = value;
    }

    void setIsRemote(boolean value) {
        this._isRemote = value;
    }

    void setJitter(BigDecimal value) {
        this._jitter = value;
    }

    void setMediaType(String value) {
        this._mediaType = value;
    }

    void setPacketsLost(long value) {
        this._packetsLost = value;
    }

    void setSsrc(long value) {
        this._ssrc = value;
    }

    void setTrackId(String value) {
        this._trackId = value;
    }

    void setTransportId(String value) {
        this._transportId = value;
    }
}

