/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.CandidateType;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import fm.icelink.ProtocolType;
import fm.icelink.callstats.Utility;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class DataStatsCSCandidateStats {
    private CandidateType _candidateType;
    private String _csId;
    private Date _csTimestamp = new Date();
    private String _csType;
    private String _ip;
    private boolean _isRemote;
    private int _port;
    private long _priority;
    private ProtocolType _protocolType;
    private String _transportId;

    private CandidateType candidateTypeFromString(String typeString) {
        String _var0 = typeString;
        if (_var0.equals("host")) {
            return CandidateType.Host;
        }
        if (_var0.equals("serverReflexive")) {
            return CandidateType.ServerReflexive;
        }
        if (_var0.equals("relayed")) {
            return CandidateType.Relayed;
        }
        if (_var0.equals("peerReflexive")) {
            return CandidateType.PeerReflexive;
        }
        if (_var0.equals("unknown")) {
            return CandidateType.Unknown;
        }
        return CandidateType.Unknown;
    }

    private String candidateTypeToString(CandidateType type) {
        CandidateType _var0 = type;
        if (_var0 == CandidateType.Host) {
            return "host";
        }
        if (_var0 == CandidateType.ServerReflexive) {
            return "serverReflexive";
        }
        if (_var0 == CandidateType.Relayed) {
            return "relayed";
        }
        if (_var0 == CandidateType.PeerReflexive) {
            return "peerReflexive";
        }
        if (_var0 == CandidateType.Unknown) {
            return "unknown";
        }
        return null;
    }

    void deserializeProperties(String key, String valueJson) {
        String _var0 = key;
        if (_var0.equals("id")) {
            this.setCsId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("timestamp")) {
            this.setCsTimestamp(Utility.callStatsMillisToDateTime(valueJson));
        } else if (_var0.equals("type")) {
            this.setCsType(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("transportId")) {
            this.setTransportId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("isRemote")) {
            this.setIsRemote(JsonSerializer.deserializeBoolean((String)valueJson).getValue());
        } else if (_var0.equals("ip")) {
            this.setIP(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("port")) {
            this.setPort(JsonSerializer.deserializeInteger((String)valueJson).getValue());
        } else if (_var0.equals("protocol")) {
            this.setProtocolType(this.protocolTypeFromString(JsonSerializer.deserializeString((String)valueJson)));
        } else if (_var0.equals("candidateType")) {
            this.setCandidateType(this.candidateTypeFromString(JsonSerializer.deserializeString((String)valueJson)));
        } else if (_var0.equals("priority")) {
            this.setPriority(JsonSerializer.deserializeLong((String)valueJson).getValue());
        }
    }

    static DataStatsCSCandidateStats fromJson(String iceCandidateStatsJson) {
        return (DataStatsCSCandidateStats)JsonSerializer.deserializeObject((String)iceCandidateStatsJson, (IFunction0)new IFunction0<DataStatsCSCandidateStats>(){

            public DataStatsCSCandidateStats invoke() {
                return new DataStatsCSCandidateStats();
            }
        }, (IAction3)new IAction3<DataStatsCSCandidateStats, String, String>(){

            public void invoke(DataStatsCSCandidateStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    static DataStatsCSCandidateStats[] fromJsonArray(String iceCandidateStatsJson) {
        ArrayList list = JsonSerializer.deserializeObjectArray((String)iceCandidateStatsJson, (IFunction1)new IFunctionDelegate1<String, DataStatsCSCandidateStats>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSCandidateStats.fromJson";
            }

            public DataStatsCSCandidateStats invoke(String iceCandidateStatsJson) {
                return DataStatsCSCandidateStats.fromJson(iceCandidateStatsJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new DataStatsCSCandidateStats[0]);
    }

    CandidateType getCandidateType() {
        return this._candidateType;
    }

    public String getCsId() {
        return this._csId;
    }

    public Date getCsTimestamp() {
        return this._csTimestamp;
    }

    public String getCsType() {
        return this._csType;
    }

    String getIP() {
        return this._ip;
    }

    boolean getIsRemote() {
        return this._isRemote;
    }

    int getPort() {
        return this._port;
    }

    long getPriority() {
        return this._priority;
    }

    ProtocolType getProtocolType() {
        return this._protocolType;
    }

    String getTransportId() {
        return this._transportId;
    }

    private ProtocolType protocolTypeFromString(String typeString) {
        String _var0 = typeString;
        if (_var0.equals("udp")) {
            return ProtocolType.Udp;
        }
        if (_var0.equals("tcp")) {
            return ProtocolType.Tcp;
        }
        if (_var0.equals("tls")) {
            return ProtocolType.Tls;
        }
        if (_var0.equals("unknown")) {
            return ProtocolType.Unknown;
        }
        return ProtocolType.Unknown;
    }

    private String protocolTypeToString(ProtocolType type) {
        ProtocolType _var0 = type;
        if (_var0 == ProtocolType.Udp) {
            return "udp";
        }
        if (_var0 == ProtocolType.Tcp) {
            return "tcp";
        }
        if (_var0 == ProtocolType.Tls) {
            return "tls";
        }
        if (_var0 == ProtocolType.Unknown) {
            return "unknown";
        }
        return null;
    }

    void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        if (this.getCsType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"type", (Object)JsonSerializer.serializeString((String)this.getCsType()));
        }
        if (this.getTransportId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"transportId", (Object)JsonSerializer.serializeString((String)this.getTransportId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"isRemote", (Object)JsonSerializer.serializeString((String)JsonSerializer.serializeBoolean((NullableBoolean)new NullableBoolean(this.getIsRemote()))));
        if (this.getIP() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"ip", (Object)JsonSerializer.serializeString((String)this.getIP()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"port", (Object)JsonSerializer.serializeInteger((NullableInteger)new NullableInteger(this.getPort())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"protocol", (Object)JsonSerializer.serializeString((String)this.protocolTypeToString(this.getProtocolType())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"candidateType", (Object)JsonSerializer.serializeString((String)this.candidateTypeToString(this.getCandidateType())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"priority", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getPriority())));
    }

    void setCandidateType(CandidateType value) {
        this._candidateType = value;
    }

    public void setCsId(String value) {
        this._csId = value;
    }

    public void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    public void setCsType(String value) {
        this._csType = value;
    }

    void setIP(String value) {
        this._ip = value;
    }

    void setIsRemote(boolean value) {
        this._isRemote = value;
    }

    void setPort(int value) {
        this._port = value;
    }

    void setPriority(long value) {
        this._priority = value;
    }

    void setProtocolType(ProtocolType value) {
        this._protocolType = value;
    }

    void setTransportId(String value) {
        this._transportId = value;
    }

    static String toJson(DataStatsCSCandidateStats iceCandidateStats) {
        return JsonSerializer.serializeObject((Object)iceCandidateStats, (IAction2)new IAction2<DataStatsCSCandidateStats, HashMap<String, String>>(){

            public void invoke(DataStatsCSCandidateStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    String toJson() {
        return DataStatsCSCandidateStats.toJson(this);
    }

    static String toJsonArray(DataStatsCSCandidateStats[] iceCandidateStats) {
        return JsonSerializer.serializeObjectArray((Object[])iceCandidateStats, (IFunction1)new IFunctionDelegate1<DataStatsCSCandidateStats, String>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSCandidateStats.toJson";
            }

            public String invoke(DataStatsCSCandidateStats iceCandidateStats) {
                return DataStatsCSCandidateStats.toJson(iceCandidateStats);
            }
        });
    }
}

