/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.CandidatePairState;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableDouble;
import fm.icelink.NullableLong;
import fm.icelink.callstats.Utility;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class DataStatsCSCandidatePairStats {
    private long _bytesReceived;
    private long _bytesSent;
    private long _consentRequestsSent;
    private String _csId;
    private Date _csTimestamp = new Date();
    private double _currentRoundTripTime;
    private String _localCandidateId;
    private boolean _nominated;
    private long _priority;
    private String _remoteCandidateId;
    private long _requestsReceived;
    private long _requestsSent;
    private long _responsesReceived;
    private long _responsesSent;
    private CandidatePairState _state;
    private double _totalRoundTripTime;
    private String _transportId;

    private CandidatePairState candidatePairStateFromString(String typeString) {
        String _var0 = typeString;
        if (_var0.equals("new")) {
            return CandidatePairState.New;
        }
        if (_var0.equals("waiting")) {
            return CandidatePairState.Waiting;
        }
        if (_var0.equals("inprogress")) {
            return CandidatePairState.InProgress;
        }
        if (_var0.equals("succeeded")) {
            return CandidatePairState.Succeeded;
        }
        if (_var0.equals("failed")) {
            return CandidatePairState.Failed;
        }
        if (_var0.equals("closed")) {
            return CandidatePairState.Closed;
        }
        if (_var0.equals("connectivityLost")) {
            return CandidatePairState.ConnectivityLost;
        }
        return CandidatePairState.Waiting;
    }

    private String candidatePairStateToString(CandidatePairState type) {
        CandidatePairState _var0 = type;
        if (_var0 == CandidatePairState.New) {
            return "new";
        }
        if (_var0 == CandidatePairState.Waiting) {
            return "waiting";
        }
        if (_var0 == CandidatePairState.InProgress) {
            return "inprogress";
        }
        if (_var0 == CandidatePairState.Succeeded) {
            return "succeeded";
        }
        if (_var0 == CandidatePairState.Failed) {
            return "failed";
        }
        if (_var0 == CandidatePairState.Closed) {
            return "closed";
        }
        if (_var0 == CandidatePairState.ConnectivityLost) {
            return "connectivityLost";
        }
        return null;
    }

    void deserializeProperties(String key, String valueJson) {
        String _var0 = key;
        if (_var0.equals("id")) {
            this.setCsId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("timestamp")) {
            this.setCsTimestamp(Utility.callStatsMillisToDateTime(valueJson));
        } else if (_var0.equals("transportId")) {
            this.setTransportId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("localCandidateId")) {
            this.setLocalCandidateId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("remoteCandidateId")) {
            this.setRemoteCandidateId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("state")) {
            this.setState(this.candidatePairStateFromString(JsonSerializer.deserializeString((String)valueJson)));
        } else if (_var0.equals("priorty")) {
            this.setPriority(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("nominated")) {
            this.setNominated(JsonSerializer.deserializeBoolean((String)valueJson).getValue());
        } else if (_var0.equals("bytesSent")) {
            this.setBytesSent(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("bytesReceived")) {
            this.setBytesReceived(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("totalRoundTripTime")) {
            this.setTotalRoundTripTime(JsonSerializer.deserializeDouble((String)valueJson).getValue());
        } else if (_var0.equals("currentRoundTripTime")) {
            this.setCurrentRoundTripTime(JsonSerializer.deserializeDouble((String)valueJson).getValue());
        } else if (_var0.equals("requestsReceived")) {
            this.setRequestsReceived(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("requestsSent")) {
            this.setRequestsSent(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("responsesReceived")) {
            this.setResponsesReceived(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("responsesSent")) {
            this.setResponsesSent(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("consentRequestsSent")) {
            this.setConsentRequestsSent(JsonSerializer.deserializeLong((String)valueJson).getValue());
        }
    }

    static DataStatsCSCandidatePairStats fromJson(String csCandidatePairStatsJson) {
        return (DataStatsCSCandidatePairStats)JsonSerializer.deserializeObject((String)csCandidatePairStatsJson, (IFunction0)new IFunction0<DataStatsCSCandidatePairStats>(){

            public DataStatsCSCandidatePairStats invoke() {
                return new DataStatsCSCandidatePairStats();
            }
        }, (IAction3)new IAction3<DataStatsCSCandidatePairStats, String, String>(){

            public void invoke(DataStatsCSCandidatePairStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    static DataStatsCSCandidatePairStats[] fromJsonArray(String csCandidatePairStatsJson) {
        ArrayList list = JsonSerializer.deserializeObjectArray((String)csCandidatePairStatsJson, (IFunction1)new IFunctionDelegate1<String, DataStatsCSCandidatePairStats>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSCandidatePairStats.fromJson";
            }

            public DataStatsCSCandidatePairStats invoke(String csCandidatePairStatsJson) {
                return DataStatsCSCandidatePairStats.fromJson(csCandidatePairStatsJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new DataStatsCSCandidatePairStats[0]);
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public long getConsentRequestsSent() {
        return this._consentRequestsSent;
    }

    String getCsId() {
        return this._csId;
    }

    Date getCsTimestamp() {
        return this._csTimestamp;
    }

    public double getCurrentRoundTripTime() {
        return this._currentRoundTripTime;
    }

    public String getLocalCandidateId() {
        return this._localCandidateId;
    }

    public boolean getNominated() {
        return this._nominated;
    }

    public long getPriority() {
        return this._priority;
    }

    public String getRemoteCandidateId() {
        return this._remoteCandidateId;
    }

    public long getRequestsReceived() {
        return this._requestsReceived;
    }

    public long getRequestsSent() {
        return this._requestsSent;
    }

    public long getResponsesReceived() {
        return this._responsesReceived;
    }

    public long getResponsesSent() {
        return this._responsesSent;
    }

    public CandidatePairState getState() {
        return this._state;
    }

    public double getTotalRoundTripTime() {
        return this._totalRoundTripTime;
    }

    public String getTransportId() {
        return this._transportId;
    }

    void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        if (this.getTransportId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"transportId", (Object)JsonSerializer.serializeString((String)this.getTransportId()));
        }
        if (this.getLocalCandidateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"localCandidateId", (Object)JsonSerializer.serializeString((String)this.getLocalCandidateId()));
        }
        if (this.getRemoteCandidateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"remoteCandidateId", (Object)JsonSerializer.serializeString((String)this.getRemoteCandidateId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"state", (Object)JsonSerializer.serializeString((String)this.candidatePairStateToString(this.getState())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"priorty", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getPriority())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"nominated", (Object)JsonSerializer.serializeString((String)JsonSerializer.serializeBoolean((NullableBoolean)new NullableBoolean(this.getNominated()))));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"bytesSent", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getBytesSent())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"bytesReceived", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getBytesReceived())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"totalRoundTripTime", (Object)JsonSerializer.serializeDouble((NullableDouble)new NullableDouble(this.getTotalRoundTripTime())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"currentRoundTripTime", (Object)JsonSerializer.serializeDouble((NullableDouble)new NullableDouble(this.getCurrentRoundTripTime())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"requestsReceived", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getRequestsReceived())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"requestsSent", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getRequestsSent())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"responsesReceived", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getResponsesReceived())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"responsesSent", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getResponsesSent())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"consentRequestsSent", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getConsentRequestsSent())));
    }

    void setBytesReceived(long value) {
        this._bytesReceived = value;
    }

    void setBytesSent(long value) {
        this._bytesSent = value;
    }

    public void setConsentRequestsSent(long value) {
        this._consentRequestsSent = value;
    }

    void setCsId(String value) {
        this._csId = value;
    }

    void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    void setCurrentRoundTripTime(double value) {
        this._currentRoundTripTime = value;
    }

    void setLocalCandidateId(String value) {
        this._localCandidateId = value;
    }

    void setNominated(boolean value) {
        this._nominated = value;
    }

    void setPriority(long value) {
        this._priority = value;
    }

    void setRemoteCandidateId(String value) {
        this._remoteCandidateId = value;
    }

    public void setRequestsReceived(long value) {
        this._requestsReceived = value;
    }

    public void setRequestsSent(long value) {
        this._requestsSent = value;
    }

    public void setResponsesReceived(long value) {
        this._responsesReceived = value;
    }

    public void setResponsesSent(long value) {
        this._responsesSent = value;
    }

    void setState(CandidatePairState value) {
        this._state = value;
    }

    void setTotalRoundTripTime(double value) {
        this._totalRoundTripTime = value;
    }

    void setTransportId(String value) {
        this._transportId = value;
    }

    static String toJson(DataStatsCSCandidatePairStats csCandidatePairStats) {
        return JsonSerializer.serializeObject((Object)csCandidatePairStats, (IAction2)new IAction2<DataStatsCSCandidatePairStats, HashMap<String, String>>(){

            public void invoke(DataStatsCSCandidatePairStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    static String toJsonArray(DataStatsCSCandidatePairStats[] csCandidatePairStats) {
        return JsonSerializer.serializeObjectArray((Object[])csCandidatePairStats, (IFunction1)new IFunctionDelegate1<DataStatsCSCandidatePairStats, String>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSCandidatePairStats.toJson";
            }

            public String invoke(DataStatsCSCandidatePairStats csCandidatePairStats) {
                return DataStatsCSCandidatePairStats.toJson(csCandidatePairStats);
            }
        });
    }
}

