/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.CandidatePairState;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableLong;
import java.util.HashMap;

abstract class DataCandidatePairBase {
    private String _id;
    private String _localCandidateId;
    private boolean _nominated;
    private long _priority;
    private String _remoteCandidateId;
    private CandidatePairState _state;

    private CandidatePairState candidatePairStateFromString(String stateString) {
        String _var0 = stateString;
        if (_var0.equals("waiting")) {
            return CandidatePairState.Waiting;
        }
        if (_var0.equals("inprogress")) {
            return CandidatePairState.InProgress;
        }
        if (_var0.equals("succeeded")) {
            return CandidatePairState.Succeeded;
        }
        if (_var0.equals("failed")) {
            return CandidatePairState.Failed;
        }
        if (_var0.equals("cancelled")) {
            return CandidatePairState.Closed;
        }
        if (_var0.equals("frozen")) {
            return CandidatePairState.ConnectivityLost;
        }
        return CandidatePairState.Waiting;
    }

    private String candidatePairStateToString(CandidatePairState state) {
        CandidatePairState _var0 = state;
        if (_var0 == CandidatePairState.New || _var0 == CandidatePairState.Waiting) {
            return "waiting";
        }
        if (_var0 == CandidatePairState.InProgress) {
            return "inprogress";
        }
        if (_var0 == CandidatePairState.Succeeded) {
            return "succeeded";
        }
        if (_var0 == CandidatePairState.Failed) {
            return "failed";
        }
        if (_var0 == CandidatePairState.Closed) {
            return "cancelled";
        }
        if (_var0 == CandidatePairState.ConnectivityLost) {
            return "frozen";
        }
        return "waiting";
    }

    protected DataCandidatePairBase() {
    }

    protected void deserializeProperties(String key, String valueJson) {
        String str = key;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"id")) {
                if (Global.equals((Object)str, (Object)"localCandidateId")) {
                    this.setLocalCandidateId(JsonSerializer.deserializeString((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"remoteCandidateId")) {
                    this.setRemoteCandidateId(JsonSerializer.deserializeString((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"state")) {
                    this.setState(this.candidatePairStateFromString(JsonSerializer.deserializeString((String)valueJson)));
                } else if (Global.equals((Object)str, (Object)"priority")) {
                    this.setPriority(JsonSerializer.deserializeLong((String)valueJson).getValue());
                } else if (Global.equals((Object)str, (Object)"nominated")) {
                    this.setNominated(JsonSerializer.deserializeBoolean((String)valueJson).getValue());
                }
            } else {
                this.setId(JsonSerializer.deserializeString((String)valueJson));
            }
        }
    }

    String getId() {
        return this._id;
    }

    String getLocalCandidateId() {
        return this._localCandidateId;
    }

    boolean getNominated() {
        return this._nominated;
    }

    long getPriority() {
        return this._priority;
    }

    String getRemoteCandidateId() {
        return this._remoteCandidateId;
    }

    CandidatePairState getState() {
        return this._state;
    }

    protected void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getId()));
        }
        if (this.getLocalCandidateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"localCandidateId", (Object)JsonSerializer.serializeString((String)this.getLocalCandidateId()));
        }
        if (this.getRemoteCandidateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"remoteCandidateId", (Object)JsonSerializer.serializeString((String)this.getRemoteCandidateId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"state", (Object)JsonSerializer.serializeString((String)this.candidatePairStateToString(this.getState())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"priority", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getPriority())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"nominated", (Object)JsonSerializer.serializeBoolean((NullableBoolean)new NullableBoolean(this.getNominated())));
    }

    void setId(String value) {
        this._id = value;
    }

    void setLocalCandidateId(String value) {
        this._localCandidateId = value;
    }

    void setNominated(boolean value) {
        this._nominated = value;
    }

    void setPriority(long value) {
        this._priority = value;
    }

    void setRemoteCandidateId(String value) {
        this._remoteCandidateId = value;
    }

    void setState(CandidatePairState value) {
        this._state = value;
    }
}

