/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.Connection;
import fm.icelink.ConnectionState;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ManagedThread;
import fm.icelink.callstats.ApiManager;
import fm.icelink.callstats.DataUserJoinconferenceEndPointInfo;
import fm.icelink.callstats.Result;
import fm.icelink.callstats.ResultType;

class ConnectionManager {
    private ApiManager __apiManager;
    private Connection __connection;
    private boolean __isAlive;
    private boolean __isStats;
    private int __statsInterval;

    ConnectionManager(Connection connection, ApiManager apiManager, int statsInterval) {
        this.__apiManager = apiManager;
        this.__connection = connection;
        this.__statsInterval = statsInterval;
    }

    private void initializeCallStats(DataUserJoinconferenceEndPointInfo endPointInfo) {
        Result result = this.__apiManager.joinConference(endPointInfo);
        this.__isStats = true;
        this.__isAlive = true;
        if (Global.equals((Object)((Object)result.getType()), (Object)((Object)ResultType.Success))) {
            new ManagedThread((IAction1)new IActionDelegate1<ManagedThread>(){

                public String getId() {
                    return "fm.icelink.callstats.ConnectionManager.sendUserAlive";
                }

                public void invoke(ManagedThread thread) {
                    ConnectionManager.this.sendUserAlive(thread);
                }
            }).start();
        }
        this.__connection.addOnStateChange((IAction1)new IAction1<Connection>(){

            public void invoke(Connection c) {
                ConnectionManager.this.__apiManager.fabricConnectionStateChange(c);
                if (Global.equals((Object)c.getState(), (Object)ConnectionState.Connected)) {
                    ConnectionManager.this.__apiManager.fabricSetUpEvent(c);
                    new ManagedThread((IAction1)new IActionDelegate1<ManagedThread>(){

                        public String getId() {
                            return "fm.icelink.callstats.ConnectionManager.sendStats";
                        }

                        public void invoke(ManagedThread thread) {
                            ConnectionManager.this.sendStats(thread);
                        }
                    }).start();
                }
            }
        });
        this.__connection.addOnSignallingStateChange((IAction1)new IAction1<Connection>(){

            public void invoke(Connection c) {
                ConnectionManager.this.__apiManager.fabricSignallingStateChange(c);
            }
        });
        this.__connection.addOnGatheringStateChange((IAction1)new IAction1<Connection>(){

            public void invoke(Connection c) {
                ConnectionManager.this.__apiManager.fabricIceGatheringStateChange(c);
            }
        });
        this.__connection.addOnIceConnectionStateChange((IAction1)new IAction1<Connection>(){

            public void invoke(Connection c) {
                ConnectionManager.this.__apiManager.fabricIceConnectionStateChange(c);
            }
        });
    }

    private void sendStats(ManagedThread thread) {
        while (this.__isStats) {
            thread.loopBegin();
            this.__apiManager.submitConferenceStats(this.__connection);
            this.__apiManager.specialSSRCMapEvent(this.__connection);
            ManagedThread.sleep((int)this.__statsInterval);
            thread.loopEnd();
        }
    }

    private void sendUserAlive(ManagedThread thread) {
        while (this.__isAlive) {
            thread.loopBegin();
            this.__apiManager.userAlive();
            ManagedThread.sleep((int)5000);
            thread.loopEnd();
        }
    }

    void start(DataUserJoinconferenceEndPointInfo endPointInfo) {
        this.initializeCallStats(endPointInfo);
    }

    void stop() {
        this.__isStats = false;
        this.__isAlive = false;
        this.__apiManager.userLeft();
        this.__apiManager.fabricTerminated(this.__connection);
    }
}

