/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.Build;
import fm.icelink.Connection;
import fm.icelink.ConnectionState;
import fm.icelink.EcdsaKey;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction1;
import fm.icelink.OperatingSystem;
import fm.icelink.callstats.ApiManager;
import fm.icelink.callstats.ConnectionManager;
import fm.icelink.callstats.DataUserJoinconferenceEndPointInfo;
import java.util.HashMap;

public class Client {
    private String __applicationId;
    private ConnectionManager __connection;
    private HashMap<String, ConnectionManager> __connections;
    private Object __connectionsLock = new Object();
    private String __ecdsaPublicKeyId;
    private EcdsaKey __privateKey = null;
    private int __statsInterval = 10000;
    private String _endPointAppVersion;
    private String _endPointClientName;
    private String _endPointClientVersion;
    private OperatingSystem _endPointOS;
    private String _endPointOSVersion;
    private String _endPointType;
    private int _tokenValidity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(final Connection connection, String userId, String deviceId, String confId, String remoteId) {
        ApiManager apiManager = new ApiManager(userId, deviceId, confId, remoteId, this.__privateKey, this.__applicationId, this.__ecdsaPublicKeyId, this.getTokenValidity());
        DataUserJoinconferenceEndPointInfo info2 = new DataUserJoinconferenceEndPointInfo();
        info2.setType(this.getEndPointType());
        info2.setOs(this.getEndPointOS());
        info2.setOsVersion(this.getEndPointOSVersion());
        info2.setBuildName(this.getEndPointClientName());
        info2.setBuildVersion(this.getEndPointClientVersion());
        info2.setAppVersion(this.getEndPointAppVersion());
        DataUserJoinconferenceEndPointInfo endPointInfo = info2;
        this.__connection = new ConnectionManager(connection, apiManager, this.getStatsInterval());
        Object object = this.__connectionsLock;
        synchronized (object) {
            HashMapExtensions.add(this.__connections, (Object)connection.getId(), (Object)this.__connection);
        }
        connection.addOnStateChange((IAction1)new IAction1<Connection>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(Connection c) {
                if (Global.equals((Object)c.getState(), (Object)ConnectionState.Failed) || Global.equals((Object)c.getState(), (Object)ConnectionState.Closed)) {
                    Client.this.__connection.stop();
                    Object object = Client.this.__connectionsLock;
                    synchronized (object) {
                        HashMapExtensions.remove((HashMap)Client.this.__connections, (Object)connection.getId());
                    }
                }
            }
        });
        this.__connection.start(endPointInfo);
    }

    public Client(EcdsaKey privateKey, String applicationId, String ecdsaPublicKeyId) {
        this.__privateKey = privateKey;
        this.__applicationId = applicationId;
        this.__ecdsaPublicKeyId = ecdsaPublicKeyId;
        this.__connections = new HashMap();
        this.setTokenValidity(5);
        this.setEndPointType("native");
        this.setEndPointOS(OperatingSystem.Unknown);
        this.setEndPointOSVersion("unknown");
        this.setEndPointAppVersion("0.0.0.0");
        this.setEndPointClientName("IceLink");
        this.setEndPointClientVersion(Build.getVersion());
    }

    public String getEndPointAppVersion() {
        return this._endPointAppVersion;
    }

    public String getEndPointClientName() {
        return this._endPointClientName;
    }

    public String getEndPointClientVersion() {
        return this._endPointClientVersion;
    }

    public OperatingSystem getEndPointOS() {
        return this._endPointOS;
    }

    public String getEndPointOSVersion() {
        return this._endPointOSVersion;
    }

    public String getEndPointType() {
        return this._endPointType;
    }

    public int getStatsInterval() {
        return this.__statsInterval;
    }

    public int getTokenValidity() {
        return this._tokenValidity;
    }

    public void setEndPointAppVersion(String value) {
        this._endPointAppVersion = value;
    }

    public void setEndPointClientName(String value) {
        this._endPointClientName = value;
    }

    public void setEndPointClientVersion(String value) {
        this._endPointClientVersion = value;
    }

    public void setEndPointOS(OperatingSystem value) {
        this._endPointOS = value;
    }

    public void setEndPointOSVersion(String value) {
        this._endPointOSVersion = value;
    }

    public void setEndPointType(String value) {
        this._endPointType = value;
    }

    public void setStatsInterval(int value) {
        this.__statsInterval = value * 1000;
    }

    public void setTokenValidity(int value) {
        this._tokenValidity = value;
    }
}

