/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.ArrayListExtensions;
import fm.icelink.CandidateStats;
import fm.icelink.CodecStats;
import fm.icelink.Connection;
import fm.icelink.ConnectionState;
import fm.icelink.ConnectionStats;
import fm.icelink.DateExtensions;
import fm.icelink.EcdsaKey;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.HttpMethod;
import fm.icelink.HttpRequestArgs;
import fm.icelink.HttpResponseArgs;
import fm.icelink.HttpTransfer;
import fm.icelink.HttpTransferFactory;
import fm.icelink.ILog;
import fm.icelink.IceConnectionState;
import fm.icelink.IceGatheringState;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.MediaReceiverStats;
import fm.icelink.MediaSenderStats;
import fm.icelink.MediaStreamStats;
import fm.icelink.MediaTrackStats;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableDouble;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import fm.icelink.SignallingState;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.TransportStats;
import fm.icelink.UnixTimestamp;
import fm.icelink.callstats.ChangedStateType;
import fm.icelink.callstats.Client;
import fm.icelink.callstats.DataFabricCandidate;
import fm.icelink.callstats.DataFabricCandidatePair;
import fm.icelink.callstats.DataFabricSetupRequest;
import fm.icelink.callstats.DataFabricStatechangeRequest;
import fm.icelink.callstats.DataFabricTerminatedRequest;
import fm.icelink.callstats.DataJwtClaim;
import fm.icelink.callstats.DataJwtToken;
import fm.icelink.callstats.DataSpecialSsrcData;
import fm.icelink.callstats.DataSpecialSsrcRequest;
import fm.icelink.callstats.DataStatsCSStatistics;
import fm.icelink.callstats.DataStatsConferenceRequest;
import fm.icelink.callstats.DataUserAliveRequest;
import fm.icelink.callstats.DataUserDetailsRequest;
import fm.icelink.callstats.DataUserJoinconferenceEndPointInfo;
import fm.icelink.callstats.DataUserJoinconferenceRequest;
import fm.icelink.callstats.DataUserJoinconferenceResponse;
import fm.icelink.callstats.DataUserLeftRequest;
import fm.icelink.callstats.EventType;
import fm.icelink.callstats.Result;
import fm.icelink.callstats.ResultType;
import fm.icelink.callstats.Utility;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.rtp.SsrcAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class ApiManager {
    private String __accessToken;
    private String __applicationId;
    private String __confId;
    private String __deviceId;
    private String __ecdsaPublicKeyId;
    private HttpTransfer __httpClient = HttpTransferFactory.getHttpTransfer();
    private static ILog __log = Log.getLogger(Client.class);
    private EcdsaKey __privateKey;
    private String __remoteId;
    private int __tokenValidity;
    private String __ucId;
    private String __userId;

    ApiManager(String userId, String deviceId, String confId, String remoteId, EcdsaKey privateKey, String applicationId, String ecdsaPublicKeyId, int jwtTokenValidity) {
        this.__userId = userId;
        this.__deviceId = deviceId;
        this.__confId = confId;
        this.__remoteId = remoteId;
        this.__privateKey = privateKey;
        this.__applicationId = applicationId;
        this.__ecdsaPublicKeyId = ecdsaPublicKeyId;
        this.__tokenValidity = jwtTokenValidity;
    }

    private Result conferenceStats(DataStatsConferenceRequest eventData) {
        if (eventData != null) {
            return this.postData(EventType.Stats_Conference, eventData.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    void fabricConnectionStateChange(Connection connection) {
        ConnectionState state = connection.getState();
        String str = null;
        ConnectionState _var0 = state;
        if (_var0 == ConnectionState.Closed) {
            str = "closed";
        } else if (_var0 == ConnectionState.Connected) {
            str = "connected";
        } else if (_var0 == ConnectionState.Connecting) {
            str = "connecting";
        } else if (_var0 == ConnectionState.Failed) {
            str = "failed";
        } else if (_var0 == ConnectionState.Initializing) {
            str = "new";
        }
        DataFabricStatechangeRequest eventData = new DataFabricStatechangeRequest();
        eventData.setLocalId(this.__userId);
        eventData.setDeviceId(this.__deviceId);
        eventData.setTimestamp(DateExtensions.getUtcNow());
        eventData.setRemoteId(this.__remoteId);
        eventData.setConnectionId(connection.getId());
        eventData.setNewState(str);
        eventData.setChangedState(ChangedStateType.ConnectionState);
        this.fabricState(eventData);
    }

    void fabricIceConnectionStateChange(Connection connection) {
        IceConnectionState iceConnectionState = connection.getIceConnectionState();
        String str = null;
        IceConnectionState _var0 = iceConnectionState;
        if (_var0 == IceConnectionState.Checking) {
            str = "checking";
        } else if (_var0 == IceConnectionState.Closed) {
            str = "closed";
        } else if (_var0 == IceConnectionState.Completed) {
            str = "completed";
        } else if (_var0 == IceConnectionState.Connected) {
            str = "connected";
        } else if (_var0 == IceConnectionState.Disconnected) {
            str = "disconnected";
        } else if (_var0 == IceConnectionState.Failed) {
            str = "failed";
        } else if (_var0 == IceConnectionState.New) {
            str = "new";
        }
        DataFabricStatechangeRequest eventData = new DataFabricStatechangeRequest();
        eventData.setLocalId(this.__userId);
        eventData.setDeviceId(this.__deviceId);
        eventData.setTimestamp(DateExtensions.getUtcNow());
        eventData.setRemoteId(this.__remoteId);
        eventData.setConnectionId(connection.getId());
        eventData.setNewState(str);
        eventData.setChangedState(ChangedStateType.IceConnectionState);
        this.fabricState(eventData);
    }

    void fabricIceGatheringStateChange(Connection connection) {
        IceGatheringState gatheringState = connection.getGatheringState();
        String str = null;
        IceGatheringState _var0 = gatheringState;
        if (_var0 == IceGatheringState.Closed) {
            str = "closed";
        } else if (_var0 == IceGatheringState.Closing) {
            str = "closing";
        } else if (_var0 == IceGatheringState.Complete) {
            str = "complete";
        } else if (_var0 == IceGatheringState.Failed) {
            str = "failed";
        } else if (_var0 == IceGatheringState.Gathering) {
            str = "gathering";
        } else if (_var0 == IceGatheringState.New) {
            str = "new";
        }
        DataFabricStatechangeRequest eventData = new DataFabricStatechangeRequest();
        eventData.setLocalId(this.__userId);
        eventData.setDeviceId(this.__deviceId);
        eventData.setTimestamp(DateExtensions.getUtcNow());
        eventData.setRemoteId(this.__remoteId);
        eventData.setConnectionId(connection.getId());
        eventData.setNewState(str);
        eventData.setChangedState(ChangedStateType.IceGatheringState);
        this.fabricState(eventData);
    }

    private Result fabricSetup(DataFabricSetupRequest eventData) {
        if (eventData != null) {
            return this.postData(EventType.Fabric_Setup, eventData.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    void fabricSetUpEvent(Connection connection) {
        ArrayList<DataFabricCandidate> list = new ArrayList<DataFabricCandidate>();
        ArrayList<DataFabricCandidate> list2 = new ArrayList<DataFabricCandidate>();
        ArrayList<DataFabricCandidatePair> list3 = new ArrayList<DataFabricCandidatePair>();
        ConnectionStats stats = (ConnectionStats)connection.getStats().waitForResult();
        for (MediaStreamStats stats2 : stats.getMediaStreams()) {
            if (stats2 == null || stats2.getTransport() == null) continue;
            TransportStats transport = stats2.getTransport();
            for (CandidateStats candidateStats : transport.getLocalCandidates()) {
                DataFabricCandidate item = new DataFabricCandidate();
                item.setId(candidateStats.getId());
                item.setType("local-candidate");
                item.setIP(candidateStats.getIPAddress());
                item.setPort(candidateStats.getPort());
                item.setCandidateType(candidateStats.getType());
                item.setProtocolType(candidateStats.getProtocol());
                list.add(item);
            }
            for (CandidateStats candidateStats : transport.getRemoteCandidates()) {
                DataFabricCandidate candidate2 = new DataFabricCandidate();
                candidate2.setId(candidateStats.getId());
                candidate2.setType("remote-candidate");
                candidate2.setIP(candidateStats.getIPAddress());
                candidate2.setPort(candidateStats.getPort());
                candidate2.setCandidateType(candidateStats.getType());
                candidate2.setProtocolType(candidateStats.getProtocol());
                list2.add(candidate2);
            }
            for (CandidateStats candidateStats : transport.getCandidatePairs()) {
                DataFabricCandidatePair pair = new DataFabricCandidatePair();
                pair.setId(candidateStats.getId());
                pair.setLocalCandidateId(candidateStats.getLocalCandidateId());
                pair.setRemoteCandidateId(candidateStats.getRemoteCandidateId());
                pair.setState(candidateStats.getState());
                pair.setPriority(candidateStats.getPriority());
                pair.setNominated(candidateStats.getNominated());
                list3.add(pair);
            }
        }
        DataFabricSetupRequest eventData = new DataFabricSetupRequest();
        eventData.setLocalId(this.__userId);
        eventData.setOriginId(null);
        eventData.setDeviceId(this.__deviceId);
        eventData.setTimestamp(DateExtensions.getUtcNow());
        eventData.setRemoteId(this.__remoteId);
        eventData.setConnectionId(connection.getId());
        eventData.setFabricTransmissionDirection("sendrecv");
        eventData.setRemoteEndpointType("peer");
        eventData.setLocalIceCandidates(list.toArray(new DataFabricCandidate[0]));
        eventData.setRemoteIceCandidates(list2.toArray(new DataFabricCandidate[0]));
        eventData.setCandidatePairs(list3.toArray(new DataFabricCandidatePair[0]));
        this.fabricSetup(eventData);
    }

    void fabricSignallingStateChange(Connection connection) {
        SignallingState signallingState = connection.getSignallingState();
        String str = null;
        SignallingState _var0 = signallingState;
        if (_var0 == SignallingState.Stable) {
            str = "stable";
        } else if (_var0 == SignallingState.HaveLocalOffer) {
            str = "have-local-offer";
        } else if (_var0 == SignallingState.HaveRemoteOffer) {
            str = "have-remote-offer";
        }
        DataFabricStatechangeRequest eventData = new DataFabricStatechangeRequest();
        eventData.setLocalId(this.__userId);
        eventData.setDeviceId(this.__deviceId);
        eventData.setTimestamp(DateExtensions.getUtcNow());
        eventData.setRemoteId(this.__remoteId);
        eventData.setConnectionId(connection.getId());
        eventData.setNewState(str);
        eventData.setChangedState(ChangedStateType.SignalingState);
        this.fabricState(eventData);
    }

    private Result fabricState(DataFabricStatechangeRequest eventData) {
        if (eventData != null) {
            return this.postData(EventType.Fabric_State_Change, eventData.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    Result fabricTerminated(Connection connection) {
        DataFabricTerminatedRequest request2 = new DataFabricTerminatedRequest();
        request2.setLocalId(this.__userId);
        request2.setDeviceId(this.__deviceId);
        request2.setTimestamp(DateExtensions.getUtcNow());
        request2.setRemoteId(this.__remoteId);
        request2.setConnectionId(connection.getId());
        DataFabricTerminatedRequest request = request2;
        if (request != null) {
            return this.postData(EventType.Fabric_Terminated, request.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    private String generateJwtToken() {
        Date utcNow = DateExtensions.getUtcNow();
        long num = UnixTimestamp.dateTimeToUnix((Date)utcNow);
        long num2 = UnixTimestamp.dateTimeToUnix((Date)DateExtensions.addSeconds((Date)utcNow, (double)(this.__tokenValidity * 60)));
        long num3 = UnixTimestamp.dateTimeToUnix((Date)DateExtensions.addSeconds((Date)utcNow, (double)(-this.__tokenValidity * 60)));
        DataJwtClaim claim2 = new DataJwtClaim();
        claim2.setUserId(this.__userId);
        claim2.setApplicationId(this.__applicationId);
        claim2.setEcdsaPublicKeyId(this.__ecdsaPublicKeyId);
        claim2.setJwtId(Guid.newGuid().toString());
        claim2.setIssuedAt(num);
        claim2.setNotBefore(num3);
        claim2.setExpiry(num2);
        DataJwtClaim claim = claim2;
        return Utility.signJWT(this.__privateKey, claim);
    }

    private String getAccessToken() {
        if (Utility.isExpired(this.__accessToken)) {
            String str = this.generateJwtToken();
            HttpRequestArgs args3 = new HttpRequestArgs();
            args3.setTextContent(StringExtensions.format((String)"grant_type=authorization_code&code={0}&client_id={1}@{2}", (Object)str, (Object)this.__userId, (Object)this.__applicationId));
            args3.setMethod(HttpMethod.Post);
            args3.setUrl(StringExtensions.format((String)"{0}{1}", (Object)"https://auth.callstats.io", (Object)"/authenticate"));
            args3.setTimeout(15000);
            HttpRequestArgs requestArgs = args3;
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem((HashMap)requestArgs.getHeaders()), (Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
            HttpResponseArgs args2 = this.__httpClient.sendText(requestArgs);
            if (args2.getStatusCode() == 200) {
                String textContent = args2.getTextContent();
                this.__accessToken = DataJwtToken.fromJson(textContent).getAccessToken();
            } else {
                __log.error("Token Error : ", args2.getException());
            }
        }
        return this.__accessToken;
    }

    private String getEndpoint(EventType eventType) {
        String str = null;
        EventType _var0 = eventType;
        if (_var0 == EventType.User_Action_Join_Conference) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}", (Object)this.__applicationId, (Object)this.__confId);
        }
        if (_var0 == EventType.User_Action_Alive) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/user/alive", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.User_Action_Details) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/userdetails", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.User_Action_Left) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/user/left", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.User_Media_ConnectedDevices) {
            return str;
        }
        if (_var0 == EventType.User_Media_Actions) {
            return str;
        }
        if (_var0 == EventType.Fabric_Setup) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/fabric/setup", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Fabric_Setup_Failed) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/fabric/setupfailed", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Fabric_Terminated) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/fabric/terminated", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Fabric_State_Change) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/fabric/statechange", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Fabric_Dropped) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/fabric/status", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Fabric_Action) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/fabric/actions", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Stats_Conference) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/stats", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Stats_System) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/stats/system", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.Special_Feedback) {
            return str;
        }
        if (_var0 == EventType.Special_Dominant_Speaker) {
            return str;
        }
        if (_var0 == EventType.SSRC_Map) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/ssrcmap", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        if (_var0 == EventType.SDP) {
            return StringExtensions.format((String)"/v1/apps/{0}/conferences/{1}/{2}/events/sdp", (Object)this.__applicationId, (Object)this.__confId, (Object)this.__ucId);
        }
        return str;
    }

    Result joinConference(DataUserJoinconferenceEndPointInfo endPointInfo) {
        DataUserJoinconferenceRequest request2 = new DataUserJoinconferenceRequest();
        request2.setLocalId(this.__userId);
        request2.setDeviceId(this.__deviceId);
        request2.setTimestamp(DateExtensions.getUtcNow());
        request2.setEndPointInfo(endPointInfo);
        DataUserJoinconferenceRequest request = request2;
        if (request != null) {
            Result result = this.postData(EventType.User_Action_Join_Conference, request.toJson());
            if (Global.equals((Object)((Object)result.getType()), (Object)((Object)ResultType.Success))) {
                DataUserJoinconferenceResponse response = DataUserJoinconferenceResponse.fromJson(result.getResponse());
                this.__ucId = response.getUcId();
            }
            return result;
        }
        Result result2 = new Result();
        result2.setType(ResultType.Error);
        result2.setResponse("Event data can't be empty");
        return result2;
    }

    private Result postData(EventType eventType, String data) {
        Result result = null;
        if (data == null) {
            return result;
        }
        try {
            String accessToken = this.getAccessToken();
            String endpoint = this.getEndpoint(eventType);
            String str3 = Global.equals((Object)((Object)eventType), (Object)((Object)EventType.Stats_Conference)) ? StringExtensions.concat((String)"https://stats.callstats.io", (String)endpoint) : StringExtensions.concat((String)"https://events.callstats.io", (String)endpoint);
            HttpRequestArgs args3 = new HttpRequestArgs();
            args3.setTextContent(data);
            args3.setMethod(HttpMethod.Post);
            args3.setUrl(str3);
            args3.setTimeout(15000);
            HttpRequestArgs requestArgs = args3;
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem((HashMap)requestArgs.getHeaders()), (Object)"Authorization", (Object)StringExtensions.format((String)"Bearer {0}", (Object)accessToken));
            HttpResponseArgs args2 = this.__httpClient.sendText(requestArgs);
            __log.verbose(StringExtensions.format((String)"Url: {0} | Request: {1}", (Object)str3, (Object)data));
            if (args2.getException() != null) {
                __log.error(StringExtensions.format((String)"Url: {0} | Error: {1}", (Object)str3, (Object)args2.getException().getMessage()));
                return result;
            }
            String textContent = args2.getTextContent();
            if (args2.getStatusCode() != 200) {
                __log.error(StringExtensions.format((String)"Url: {0} | Response: {1}", (Object)str3, (Object)textContent));
            } else {
                __log.debug(StringExtensions.format((String)"Url: {0} | Response: {1}", (Object)str3, (Object)textContent));
            }
            Result result2 = new Result();
            result2.setType(args2.getStatusCode() == 200 ? ResultType.Success : ResultType.Error);
            result2.setResponse(textContent);
            return result2;
        }
        catch (Exception exception) {
            __log.error("PostData error : ", exception);
            Result result3 = new Result();
            result3.setType(ResultType.Error);
            result3.setException(exception);
            return result3;
        }
    }

    void specialSSRCMapEvent(Connection connection) {
        ArrayList<DataSpecialSsrcData> list = new ArrayList<DataSpecialSsrcData>();
        HashMap<String, String> dictionary = this.specialSSRSDPAttributes(connection, false);
        HashMap<String, String> dictionary2 = this.specialSSRSDPAttributes(connection, true);
        ConnectionStats stats = (ConnectionStats)connection.getStats().waitForResult();
        for (MediaStreamStats stats2 : stats.getMediaStreams()) {
            String str = StringExtensions.toLower((String)MediaType.fromStreamType((StreamType)stats2.getType()));
            if (stats2.getReceiver() != null) {
                DataSpecialSsrcData item = new DataSpecialSsrcData();
                item.setSsrc((String)HashMapExtensions.getItem(dictionary2).get(StringExtensions.concat((String)str, (String)"-ssrc")));
                item.setCName((String)HashMapExtensions.getItem(dictionary2).get(StringExtensions.concat((String)str, (String)"-cname")));
                item.setStreamType("inbound");
                item.setReportType("remote");
                item.setMediaType(str);
                item.setUserId(this.__userId);
                item.setMSid((String)HashMapExtensions.getItem(dictionary2).get(StringExtensions.concat((String)str, (String)"-msid")));
                item.setMSlabel((String)HashMapExtensions.getItem(dictionary2).get(StringExtensions.concat((String)str, (String)"-mslabel")));
                item.setLabel((String)HashMapExtensions.getItem(dictionary2).get(StringExtensions.concat((String)str, (String)"-label")));
                item.setLocalStartTime(stats2.getTimestamp());
                list.add(item);
            }
            if (stats2.getSender() == null) continue;
            DataSpecialSsrcData data2 = new DataSpecialSsrcData();
            data2.setSsrc((String)HashMapExtensions.getItem(dictionary).get(StringExtensions.concat((String)str, (String)"-ssrc")));
            data2.setCName((String)HashMapExtensions.getItem(dictionary).get(StringExtensions.concat((String)str, (String)"-cname")));
            data2.setStreamType("outbound");
            data2.setReportType("local");
            data2.setMediaType(str);
            data2.setUserId(this.__userId);
            data2.setMSid((String)HashMapExtensions.getItem(dictionary).get(StringExtensions.concat((String)str, (String)"-msid")));
            data2.setMSlabel((String)HashMapExtensions.getItem(dictionary).get(StringExtensions.concat((String)str, (String)"-mslabel")));
            data2.setLabel((String)HashMapExtensions.getItem(dictionary).get(StringExtensions.concat((String)str, (String)"-label")));
            data2.setLocalStartTime(stats2.getTimestamp());
            list.add(data2);
        }
        DataSpecialSsrcRequest eventData = new DataSpecialSsrcRequest();
        eventData.setLocalId(this.__userId);
        eventData.setDeviceId(this.__deviceId);
        eventData.setTimestamp(DateExtensions.getUtcNow());
        eventData.setRemoteId(this.__remoteId);
        eventData.setConnectionId(connection.getId());
        eventData.setSsrcData(list.toArray(new DataSpecialSsrcData[0]));
        this.ssrcMap(eventData);
    }

    private HashMap<String, String> specialSSRSDPAttributes(Connection connection, boolean isRemote) {
        MediaDescription[] descriptionArray;
        HashMap<String, String> dictionary = new HashMap<String, String>();
        for (MediaDescription description : descriptionArray = isRemote ? connection.getRemoteDescription().getSdpMessage().getMediaDescriptions() : connection.getLocalDescription().getSdpMessage().getMediaDescriptions()) {
            for (SsrcAttribute attribute : description.getSsrcAttributes()) {
                String _var0;
                String key = StringExtensions.concat((String)description.getMedia().getMediaType(), (String)"-ssrc");
                if (!dictionary.containsKey(key)) {
                    HashMapExtensions.add(dictionary, (Object)key, (Object)LongExtensions.toString((Long)attribute.getSynchronizationSource()));
                }
                if ((_var0 = attribute.getName().toString()).equals("cname")) {
                    HashMapExtensions.add(dictionary, (Object)StringExtensions.concat((String)description.getMedia().getMediaType(), (String)"-cname"), (Object)attribute.getValue());
                    continue;
                }
                if (_var0.equals("msid")) {
                    HashMapExtensions.add(dictionary, (Object)StringExtensions.concat((String)description.getMedia().getMediaType(), (String)"-msid"), (Object)attribute.getValue());
                    continue;
                }
                if (_var0.equals("mslabel")) {
                    HashMapExtensions.add(dictionary, (Object)StringExtensions.concat((String)description.getMedia().getMediaType(), (String)"-mslabel"), (Object)attribute.getValue());
                    continue;
                }
                if (!_var0.equals("label")) continue;
                HashMapExtensions.add(dictionary, (Object)StringExtensions.concat((String)description.getMedia().getMediaType(), (String)"-label"), (Object)attribute.getValue());
            }
        }
        return dictionary;
    }

    private Result ssrcMap(DataSpecialSsrcRequest eventData) {
        if (eventData != null) {
            return this.postData(EventType.SSRC_Map, eventData.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    void submitConferenceStats(Connection connection) {
        ArrayList<DataStatsCSStatistics> list = new ArrayList<DataStatsCSStatistics>();
        ConnectionStats stats = (ConnectionStats)connection.getStats().waitForResult();
        for (MediaStreamStats stats2 : stats.getMediaStreams()) {
            TransportStats transport;
            CodecStats codec;
            MediaTrackStats track;
            String str = StringExtensions.toLower((String)MediaType.fromStreamType((StreamType)stats2.getType()));
            if (stats2.getReceiver() != null) {
                MediaReceiverStats receiver = stats2.getReceiver();
                track = receiver.getTrack();
                if (Global.equals((Object)str, (Object)"audio")) {
                    DataStatsCSStatistics item = new DataStatsCSStatistics();
                    item.setCsId(track.getId());
                    item.setCsTimestamp(track.getTimestamp());
                    item.setCsType("track");
                    item.setKind("audio");
                    item.setFramesReceived(new NullableLong(track.getFramesReceived()));
                    item.setFramesDecoded(new NullableLong(track.getFramesDecoded()));
                    item.setFramesDropped(new NullableLong(track.getFramesDropped()));
                    list.add(item);
                    DataStatsCSStatistics statistics2 = new DataStatsCSStatistics();
                    statistics2.setCsId(receiver.getId());
                    statistics2.setCsTimestamp(receiver.getTimestamp());
                    statistics2.setCsType("inbound-rtp");
                    statistics2.setSsrc(new NullableLong(receiver.getSynchronizationSource()));
                    statistics2.setIsRemote(new NullableBoolean(false));
                    statistics2.setMediaType(str);
                    statistics2.setTrackId(receiver.getTrack().getId());
                    statistics2.setTransportId(stats2.getTransport().getId());
                    statistics2.setCodecId(receiver.getCodec() != null ? receiver.getCodec().getId() : null);
                    statistics2.setPacketsReceived(new NullableLong(receiver.getPacketsReceived()));
                    statistics2.setBytesReceived(new NullableLong(receiver.getBytesReceived()));
                    statistics2.setPacketsLost(new NullableLong(receiver.getPacketsLost()));
                    statistics2.setJitter(new NullableInteger(receiver.getJitter()));
                    list.add(statistics2);
                } else if (Global.equals((Object)str, (Object)"video")) {
                    DataStatsCSStatistics statistics3 = new DataStatsCSStatistics();
                    statistics3.setCsId(track.getId());
                    statistics3.setCsTimestamp(track.getTimestamp());
                    statistics3.setCsType("track");
                    statistics3.setKind("video");
                    statistics3.setFramesSent(new NullableLong(track.getFramesSent()));
                    statistics3.setFrameHeight(new NullableInteger(track.getFrameHeight()));
                    statistics3.setFrameWidth(new NullableInteger(track.getFrameWidth()));
                    statistics3.setFramesReceived(new NullableLong(track.getFramesReceived()));
                    statistics3.setFramesDecoded(new NullableLong(track.getFramesDecoded()));
                    statistics3.setFramesDropped(new NullableLong(track.getFramesDropped()));
                    list.add(statistics3);
                    DataStatsCSStatistics statistics4 = new DataStatsCSStatistics();
                    statistics4.setCsId(receiver.getId());
                    statistics4.setCsTimestamp(receiver.getTimestamp());
                    statistics4.setCsType("inbound-rtp");
                    statistics4.setSsrc(new NullableLong(receiver.getSynchronizationSource()));
                    statistics4.setIsRemote(new NullableBoolean(false));
                    statistics4.setMediaType(str);
                    statistics4.setTrackId(receiver.getTrack().getId());
                    statistics4.setTransportId(stats2.getTransport().getId());
                    statistics4.setCodecId(receiver.getCodec() != null ? receiver.getCodec().getId() : null);
                    statistics4.setFirCount(new NullableLong(receiver.getFirCount()));
                    statistics4.setPliCount(new NullableLong(receiver.getPliCount()));
                    statistics4.setNackCount(new NullableLong(receiver.getNackCount()));
                    statistics4.setPacketsReceived(new NullableLong(receiver.getPacketsReceived()));
                    statistics4.setBytesReceived(new NullableLong(receiver.getBytesReceived()));
                    statistics4.setPacketsLost(new NullableLong(receiver.getPacketsLost()));
                    statistics4.setJitter(new NullableInteger(receiver.getJitter()));
                    statistics4.setSliCount(new NullableLong(receiver.getSliCount()));
                    list.add(statistics4);
                }
                codec = receiver.getCodec();
                if (codec != null) {
                    DataStatsCSStatistics statistics5 = new DataStatsCSStatistics();
                    statistics5.setCsId(codec.getId());
                    statistics5.setCsTimestamp(codec.getTimestamp());
                    statistics5.setCsType("codec");
                    statistics5.setMimeType(StringExtensions.concat((String)str, (String)"/", (String)StringExtensions.toLower((String)codec.getName())));
                    statistics5.setCodecType(codec.getCodecType());
                    statistics5.setPayloadType(new NullableInteger(codec.getPayloadType()));
                    statistics5.setClockRate(new NullableInteger(codec.getClockRate()));
                    list.add(statistics5);
                }
            }
            if (stats2.getSender() != null) {
                MediaSenderStats sender = stats2.getSender();
                track = sender.getTrack();
                String _var0 = str;
                if (_var0.equals("audio")) {
                    DataStatsCSStatistics statistics6 = new DataStatsCSStatistics();
                    statistics6.setCsId(track.getId());
                    statistics6.setCsTimestamp(track.getTimestamp());
                    statistics6.setCsType("track");
                    statistics6.setKind("audio");
                    statistics6.setFramesReceived(new NullableLong(track.getFramesReceived()));
                    statistics6.setFramesDecoded(new NullableLong(track.getFramesDecoded()));
                    statistics6.setFramesDropped(new NullableLong(track.getFramesDropped()));
                    list.add(statistics6);
                    DataStatsCSStatistics statistics7 = new DataStatsCSStatistics();
                    statistics7.setCsId(sender.getId());
                    statistics7.setCsTimestamp(sender.getTimestamp());
                    statistics7.setCsType("outbound-rtp");
                    statistics7.setSsrc(new NullableLong(sender.getSynchronizationSource()));
                    statistics7.setIsRemote(new NullableBoolean(false));
                    statistics7.setMediaType(str);
                    statistics7.setCodecId(sender.getCodec() != null ? sender.getCodec().getId() : null);
                    statistics7.setTrackId(sender.getTrack().getId());
                    statistics7.setTransportId(stats2.getTransport().getId());
                    statistics7.setPacketsSent(new NullableLong(sender.getPacketsSent()));
                    statistics7.setBytesSent(new NullableLong(sender.getBytesSent()));
                    list.add(statistics7);
                } else if (_var0.equals("video")) {
                    DataStatsCSStatistics statistics8 = new DataStatsCSStatistics();
                    statistics8.setCsId(track.getId());
                    statistics8.setCsTimestamp(track.getTimestamp());
                    statistics8.setCsType("track");
                    statistics8.setKind("video");
                    statistics8.setFramesSent(new NullableLong(track.getFramesSent()));
                    statistics8.setFrameHeight(new NullableInteger(track.getFrameHeight()));
                    statistics8.setFrameWidth(new NullableInteger(track.getFrameWidth()));
                    statistics8.setFramesReceived(new NullableLong(track.getFramesReceived()));
                    statistics8.setFramesDecoded(new NullableLong(track.getFramesDecoded()));
                    statistics8.setFramesDropped(new NullableLong(track.getFramesDropped()));
                    list.add(statistics8);
                    DataStatsCSStatistics statistics9 = new DataStatsCSStatistics();
                    statistics9.setCsId(sender.getId());
                    statistics9.setCsTimestamp(sender.getTimestamp());
                    statistics9.setCsType("outbound-rtp");
                    statistics9.setSsrc(new NullableLong(sender.getSynchronizationSource()));
                    statistics9.setIsRemote(new NullableBoolean(false));
                    statistics9.setMediaType(str);
                    statistics9.setCodecId(sender.getCodec() != null ? sender.getCodec().getId() : null);
                    statistics9.setFirCount(new NullableLong(sender.getFirCount()));
                    statistics9.setPliCount(new NullableLong(sender.getPliCount()));
                    statistics9.setNackCount(new NullableLong(sender.getNackCount()));
                    statistics9.setTrackId(sender.getTrack().getId());
                    statistics9.setTransportId(stats2.getTransport().getId());
                    statistics9.setPacketsSent(new NullableLong(sender.getPacketsSent()));
                    statistics9.setBytesSent(new NullableLong(sender.getBytesSent()));
                    list.add(statistics9);
                }
                codec = sender.getCodec();
                if (codec != null) {
                    DataStatsCSStatistics statistics10 = new DataStatsCSStatistics();
                    statistics10.setCsId(codec.getId());
                    statistics10.setCsTimestamp(codec.getTimestamp());
                    statistics10.setCsType("codec");
                    statistics10.setMimeType(StringExtensions.concat((String)str, (String)"/", (String)StringExtensions.toLower((String)codec.getName())));
                    statistics10.setPayloadType(new NullableInteger(codec.getPayloadType()));
                    statistics10.setClockRate(new NullableInteger(codec.getClockRate()));
                    list.add(statistics10);
                }
            }
            if ((transport = stats2.getTransport()) == null) continue;
            DataStatsCSStatistics statistics14 = new DataStatsCSStatistics();
            statistics14.setCsId(transport.getId());
            statistics14.setCsTimestamp(transport.getTimestamp());
            statistics14.setCsType("transport");
            statistics14.setBytesSent(new NullableLong(transport.getBytesSent()));
            statistics14.setBytesReceived(new NullableLong(transport.getBytesReceived()));
            statistics14.setSelectedCandidatePairId(transport.getActiveCandidatePair() != null ? transport.getActiveCandidatePair().getId() : null);
            statistics14.setLocalCertificateId(transport.getLocalCertificate() != null ? StringExtensions.concat((String)StringExtensions.substring((String)transport.getLocalCertificate().getFingerprint(), (int)0, (int)11), (String)"......", (String)transport.getLocalCertificate().getFingerprint().substring(StringExtensions.getLength((String)transport.getLocalCertificate().getFingerprint()) - 11)) : null);
            statistics14.setRemoteCertificateId(transport.getRemoteCertificate() != null ? StringExtensions.concat((String)StringExtensions.substring((String)transport.getRemoteCertificate().getFingerprint(), (int)0, (int)11), (String)"......", (String)transport.getRemoteCertificate().getFingerprint().substring(StringExtensions.getLength((String)transport.getRemoteCertificate().getFingerprint()) - 11)) : null);
            list.add(statistics14);
            for (CandidateStats candidateStats : transport.getLocalCandidates()) {
                DataStatsCSStatistics statistics11 = new DataStatsCSStatistics();
                statistics11.setCsId(candidateStats.getId());
                statistics11.setCsTimestamp(candidateStats.getTimestamp());
                statistics11.setCsType("local-candidate");
                statistics11.setTransportId(transport.getId());
                statistics11.setIsRemote(new NullableBoolean(false));
                statistics11.setIP(candidateStats.getIPAddress());
                statistics11.setPort(new NullableInteger(candidateStats.getPort()));
                statistics11.setProtocolType(candidateStats.getProtocol());
                statistics11.setCandidateType(candidateStats.getType());
                statistics11.setPriority(new NullableLong(candidateStats.getPriority()));
                list.add(statistics11);
            }
            for (CandidateStats candidateStats : transport.getRemoteCandidates()) {
                DataStatsCSStatistics statistics12 = new DataStatsCSStatistics();
                statistics12.setCsId(candidateStats.getId());
                statistics12.setCsTimestamp(candidateStats.getTimestamp());
                statistics12.setCsType("remote-candidate");
                statistics12.setTransportId(transport.getId());
                statistics12.setIsRemote(new NullableBoolean(true));
                statistics12.setIP(candidateStats.getIPAddress());
                statistics12.setPort(new NullableInteger(candidateStats.getPort()));
                statistics12.setProtocolType(candidateStats.getProtocol());
                statistics12.setCandidateType(candidateStats.getType());
                statistics12.setPriority(new NullableLong(candidateStats.getPriority()));
                list.add(statistics12);
            }
            for (CandidateStats candidateStats : transport.getCandidatePairs()) {
                DataStatsCSStatistics statistics13 = new DataStatsCSStatistics();
                statistics13.setCsId(candidateStats.getId());
                statistics13.setCsTimestamp(candidateStats.getTimestamp());
                statistics13.setCsType("candidate-pair");
                statistics13.setTransportId(transport.getId());
                statistics13.setLocalCandidateId(candidateStats.getLocalCandidateId());
                statistics13.setRemoteCandidateId(candidateStats.getRemoteCandidateId());
                statistics13.setState(candidateStats.getState());
                statistics13.setPriority(new NullableLong(candidateStats.getPriority()));
                statistics13.setNominated(new NullableBoolean(candidateStats.getNominated()));
                statistics13.setBytesSent(new NullableLong(candidateStats.getBytesSent()));
                statistics13.setBytesReceived(new NullableLong(candidateStats.getBytesReceived()));
                statistics13.setTotalRoundTripTime(new NullableDouble(candidateStats.getTotalRoundTripTime()));
                statistics13.setCurrentRoundTripTime(new NullableDouble(candidateStats.getCurrentRoundTripTime()));
                statistics13.setRequestsReceived(new NullableLong(0L));
                statistics13.setRequestsSent(new NullableLong(candidateStats.getRequestsSent()));
                statistics13.setResponsesReceived(new NullableLong(candidateStats.getResponsesReceived()));
                statistics13.setResponsesSent(new NullableLong(0L));
                statistics13.setConsentRequestsSent(new NullableLong(candidateStats.getConsentRequestsSent()));
                list.add(statistics13);
            }
        }
        DataStatsConferenceRequest request2 = new DataStatsConferenceRequest();
        request2.setLocalId(this.__userId);
        request2.setRemoteId(this.__remoteId);
        request2.setDeviceId(this.__deviceId);
        request2.setTimestamp(DateExtensions.getUtcNow());
        request2.setConnectionId(connection.getId());
        request2.setStatistics(list.toArray(new DataStatsCSStatistics[0]));
        DataStatsConferenceRequest eventData = request2;
        if (ArrayListExtensions.getCount(list) > 0) {
            this.conferenceStats(eventData);
        }
    }

    Result userAlive() {
        DataUserAliveRequest request2 = new DataUserAliveRequest();
        request2.setLocalId(this.__userId);
        request2.setDeviceId(this.__deviceId);
        request2.setTimestamp(DateExtensions.getUtcNow());
        DataUserAliveRequest request = request2;
        if (request != null) {
            return this.postData(EventType.User_Action_Alive, request.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    private Result userDetails(DataUserDetailsRequest eventData) {
        if (eventData != null) {
            return this.postData(EventType.User_Action_Details, eventData.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }

    Result userLeft() {
        DataUserLeftRequest request2 = new DataUserLeftRequest();
        request2.setLocalId(this.__userId);
        request2.setDeviceId(this.__deviceId);
        request2.setTimestamp(DateExtensions.getUtcNow());
        DataUserLeftRequest request = request2;
        if (request != null) {
            return this.postData(EventType.User_Action_Left, request.toJson());
        }
        Result result = new Result();
        result.setType(ResultType.Error);
        result.setResponse("Event data can't be empty");
        return result;
    }
}

