/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.BitAssistant;
import fm.Global;
import fm.HashMapExtensions;
import fm.Log;
import java.util.HashMap;

public class Binary {
    private static void check(boolean condition) throws Exception {
        Binary.check(condition, "Condition failed.");
    }

    private static void check(boolean condition, String message) throws Exception {
        if (!condition) {
            throw new Exception(message);
        }
    }

    private static void checkSequenceEqual(byte[] test, byte[] actual) throws Exception {
        if (ArrayExtensions.getLength(test) != ArrayExtensions.getLength(actual)) {
            Binary.check(false);
        }
        for (int i = 0; i < ArrayExtensions.getLength(test); ++i) {
            if (test[i] == actual[i]) continue;
            Binary.check(false);
        }
    }

    public static void deinterleave(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int length, boolean reversePlanes) {
        int num = outputStart + length;
        int num2 = length / 2;
        if (num > ArrayExtensions.getLength(outputFrame)) {
            Log.error("start + length greater than outputFrame length");
        } else {
            int num4;
            int num3;
            if (reversePlanes) {
                num3 = outputStart + num2;
                num4 = outputStart;
            } else {
                num3 = outputStart;
                num4 = outputStart + num2;
            }
            for (int i = inputStart; i < num; i += 2) {
                outputFrame[num3++] = inputFrame[i];
                outputFrame[num4++] = inputFrame[i + 1];
            }
        }
    }

    public static void deinterleave(byte[] inputFrame, byte[] outputFrame, int inputLength) {
        Binary.deinterleave(inputFrame, 0, outputFrame, 0, inputLength, false);
    }

    public static void deinterleave(byte[] inputFrame, byte[] outputFrame) {
        Binary.deinterleave(inputFrame, 0, outputFrame, 0, ArrayExtensions.getLength(inputFrame), false);
    }

    private static void deinterleaveReverseTest() throws Exception {
        byte[] inputFrame = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] test = new byte[]{1, 3, 5, 7, 9, 0, 2, 4, 6, 8};
        byte[] outputFrame = new byte[ArrayExtensions.getLength(inputFrame)];
        Binary.deinterleave(inputFrame, 0, outputFrame, 0, ArrayExtensions.getLength(inputFrame), true);
        Binary.checkSequenceEqual(test, outputFrame);
    }

    private static void deinterleaveTest() throws Exception {
        byte[] inputFrame = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] test = new byte[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        byte[] outputFrame = new byte[ArrayExtensions.getLength(inputFrame)];
        Binary.deinterleave(inputFrame, outputFrame);
        Binary.checkSequenceEqual(test, outputFrame);
    }

    public static void deinterleaveTransform(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int width, int height, int stride, int rotation, boolean reversePlanes) {
        int num = width * height;
        int length = stride > 0 ? stride * height * 2 : num * 2;
        int num3 = stride - width;
        int num4 = outputStart + num * 2;
        if (num4 > ArrayExtensions.getLength(outputFrame)) {
            Log.error("outputStart + calculated length needed are greater than outputFrame length");
        } else {
            int num9;
            int num6;
            int num5;
            if (reversePlanes) {
                num5 = outputStart + num;
                num6 = outputStart;
            } else {
                num5 = outputStart;
                num6 = outputStart + num;
            }
            int num7 = height + 1;
            int[] numArray = new int[num7];
            int num8 = width * 2;
            for (num9 = 0; num9 < num7; ++num9) {
                numArray[num9] = num8 * num9 + inputStart;
                if (num9 <= 1) continue;
                numArray[num9] = numArray[num9] + num3 * (num9 - 1);
            }
            if (rotation == 270) {
                for (num9 = 1; num9 <= num8; num9 += 2) {
                    for (int num10 = 1; num10 < num7; ++num10) {
                        outputFrame[num5++] = inputFrame[numArray[num10] - (num9 + 1)];
                        outputFrame[num6++] = inputFrame[numArray[num10] - num9];
                    }
                }
            } else if (rotation == 90) {
                for (num9 = 0; num9 < num8; num9 += 2) {
                    for (int num10 = num7 - 2; num10 >= 0; --num10) {
                        outputFrame[num5++] = inputFrame[numArray[num10] + num9];
                        outputFrame[num6++] = inputFrame[numArray[num10] + (num9 + 1)];
                    }
                }
            } else if (rotation == 180) {
                for (num9 = inputStart + length - 1; num9 >= inputStart; num9 -= 2) {
                    outputFrame[num5++] = inputFrame[num9 - 1];
                    outputFrame[num6++] = inputFrame[num9];
                }
            } else {
                Binary.deinterleave(inputFrame, inputStart, outputFrame, outputStart, length, reversePlanes);
            }
        }
    }

    public static void deinterleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation) {
        Binary.deinterleaveTransform(inputFrame, 0, outputFrame, 0, width, height, stride, rotation, false);
    }

    private static void deinterleaveTransformTest() throws Exception {
        byte[] inputFrame = new byte[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        byte[] test = new byte[]{3, 6, 2, 5, 1, 4, 3, 6, 2, 5, 1, 4};
        byte[] outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.deinterleaveTransform(inputFrame, outputFrame, 3, 2, 3, 270);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        test = new byte[]{0, 0, 0, 0, 3, 6, 2, 5, 1, 4, 3, 6, 2, 5, 1, 4};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.deinterleaveTransform(inputFrame, 5, outputFrame, 4, 3, 2, 3, 270, false);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9};
        test = new byte[]{7, 4, 1, 8, 5, 2, 9, 6, 3, 7, 4, 1, 8, 5, 2, 9, 6, 3};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.deinterleaveTransform(inputFrame, outputFrame, 3, 3, 3, 90);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9};
        test = new byte[]{9, 8, 7, 6, 5, 4, 3, 2, 2, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.deinterleaveTransform(inputFrame, 0, outputFrame, 0, 3, 3, 3, 180, true);
        Binary.checkSequenceEqual(test, outputFrame);
    }

    public static int fromBytes16(byte[] input, int inputIndex, boolean littleEndian) {
        int num = 0;
        if (littleEndian) {
            return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8);
        }
        return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0);
    }

    public static int fromBytes24(byte[] input, int inputIndex, boolean littleEndian) {
        int num = 0;
        if (littleEndian) {
            num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0);
            return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 16);
        }
        num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0);
    }

    public static long fromBytes32(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static long fromBytes40(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static long fromBytes48(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static long fromBytes56(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static long fromBytes64(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 56);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 56);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static void interleave(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int inputLength) {
        Binary.interleave(inputFrame, inputStart, outputFrame, outputStart, inputLength, false);
    }

    public static void interleave(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int inputLength, boolean reversePlanes) {
        int num = outputStart + inputLength;
        int num2 = inputLength / 2;
        if (num > ArrayExtensions.getLength(outputFrame)) {
            Log.error("outputStart + inputLength greater than outputFrame length");
        } else {
            int num4;
            int num3;
            if (reversePlanes) {
                num3 = inputStart + num2;
                num4 = inputStart;
            } else {
                num3 = inputStart;
                num4 = inputStart + num2;
            }
            int num5 = outputStart;
            for (int i = 0; i < num2; ++i) {
                outputFrame[num5++] = inputFrame[num3 + i];
                outputFrame[num5++] = inputFrame[num4 + i];
            }
        }
    }

    public static void interleave(byte[] inputFrame, byte[] outputFrame) {
        Binary.interleave(inputFrame, 0, outputFrame, 0, ArrayExtensions.getLength(inputFrame), false);
    }

    private static void interleaveTest() throws Exception {
        byte[] inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 11, 22, 33, 44, 55, 66};
        byte[] test = new byte[]{1, 11, 2, 22, 3, 33, 4, 44, 5, 55, 6, 66};
        byte[] outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleave(inputFrame, outputFrame);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 11, 22, 33, 44, 55, 66};
        test = new byte[]{0, 0, 0, 0, 0, 0, 11, 1, 22, 2, 33, 3, 44, 4, 55, 5, 66, 6};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        outputFrame[0] = 0;
        outputFrame[1] = 0;
        outputFrame[2] = 0;
        outputFrame[3] = 0;
        outputFrame[4] = 0;
        outputFrame[5] = 0;
        Binary.interleave(inputFrame, 6, outputFrame, 6, ArrayExtensions.getLength(inputFrame) - 6, true);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 11, 22, 33, 44, 55, 66};
        test = new byte[]{3, 33, 6, 66, 2, 22, 5, 55, 1, 11, 4, 44};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, outputFrame, 3, 2, 3, 270);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 0, 0, 0, 4, 5, 6, 0, 0, 0, 11, 22, 33, 0, 0, 0, 44, 55, 66, 0, 0, 0};
        test = new byte[]{3, 33, 6, 66, 2, 22, 5, 55, 1, 11, 4, 44};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, outputFrame, 3, 2, 6, 270);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 0, 0, 0, 4, 5, 6, 0, 0, 0, 11, 22, 33, 0, 0, 0, 44, 55, 66, 0, 0, 0};
        test = new byte[]{33, 3, 66, 6, 22, 2, 55, 5, 11, 1, 44, 4};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, 0, outputFrame, 0, 3, 2, 6, 270, true);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 0, 0, 0, 4, 5, 6, 0, 0, 0, 1, 2, 3, 0, 0, 0, 4, 5, 6, 0, 0, 0, 11, 22, 33, 0, 0, 0, 44, 55, 66, 0, 0, 0};
        test = new byte[]{1, 2, 3, 0, 0, 0, 4, 5, 6, 0, 0, 0, 33, 3, 66, 6, 22, 2, 55, 5, 11, 1, 44, 4};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        outputFrame[0] = 1;
        outputFrame[1] = 2;
        outputFrame[2] = 3;
        outputFrame[3] = 0;
        outputFrame[4] = 0;
        outputFrame[5] = 0;
        outputFrame[6] = 4;
        outputFrame[7] = 5;
        outputFrame[8] = 6;
        outputFrame[9] = 0;
        outputFrame[10] = 0;
        outputFrame[11] = 0;
        Binary.interleaveTransform(inputFrame, 12, outputFrame, 12, 3, 2, 6, 270, true);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 11, 22, 33, 44, 55, 66};
        test = new byte[]{4, 44, 1, 11, 5, 55, 2, 22, 6, 66, 3, 33};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, outputFrame, 3, 2, 3, 90);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 0, 4, 5, 6, 0, 11, 22, 33, 0, 44, 55, 66, 0};
        test = new byte[]{4, 44, 1, 11, 5, 55, 2, 22, 6, 66, 3, 33};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, outputFrame, 3, 2, 4, 90);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 0, 4, 5, 6, 0, 11, 22, 33, 0, 44, 55, 66, 0};
        test = new byte[]{44, 4, 11, 1, 55, 5, 22, 2, 66, 6, 33, 3};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, 0, outputFrame, 0, 3, 2, 4, 90, true);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 11, 22, 33, 44, 55, 66};
        test = new byte[]{6, 66, 5, 55, 4, 44, 3, 33, 2, 22, 1, 11};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, outputFrame, 3, 2, 0, 180);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 11, 22, 33, 44, 55, 66};
        test = new byte[]{66, 6, 55, 5, 44, 4, 33, 3, 22, 2, 11, 1};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.interleaveTransform(inputFrame, 0, outputFrame, 0, 3, 2, 0, 180, true);
        Binary.checkSequenceEqual(test, outputFrame);
    }

    public static void interleaveTransform(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int width, int height, int stride, int rotation) {
        Binary.interleaveTransform(inputFrame, inputStart, outputFrame, outputStart, width, height, stride, rotation, false);
    }

    public static void interleaveTransform(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int width, int height, int stride, int rotation, boolean reversePlanes) {
        int num = stride > 0 ? stride * height : width * height;
        int num2 = width * height * 2;
        int num3 = stride > 0 ? stride - width : width;
        int num4 = outputStart + num2;
        if (num4 > ArrayExtensions.getLength(outputFrame)) {
            Log.error("start + length greater than outputFrame length");
        } else {
            int num9;
            int num6;
            int num5;
            if (reversePlanes) {
                num5 = inputStart + num;
                num6 = inputStart;
            } else {
                num5 = inputStart;
                num6 = inputStart + num;
            }
            int num7 = height + 1;
            int[] numArray = new int[num7];
            int num8 = width;
            for (num9 = 0; num9 < num7; ++num9) {
                numArray[num9] = num8 * num9 + num3 * (num9 - 1);
            }
            int num10 = outputStart;
            if (rotation == 270) {
                for (num9 = 1; num9 <= num8; ++num9) {
                    for (int num11 = 1; num11 < num7; ++num11) {
                        outputFrame[num10++] = inputFrame[num5 + numArray[num11] - num9];
                        outputFrame[num10++] = inputFrame[num6 + numArray[num11] - num9];
                    }
                }
            } else if (rotation == 90) {
                for (num9 = 0; num9 < num8; ++num9) {
                    for (int num11 = num7 - 2; num11 >= 0; --num11) {
                        outputFrame[num10++] = inputFrame[num5 + numArray[num11] + num9 + num3];
                        outputFrame[num10++] = inputFrame[num6 + numArray[num11] + num9 + num3];
                    }
                }
            } else if (rotation == 180) {
                for (num9 = num - 1; num9 >= 0; --num9) {
                    outputFrame[num10++] = inputFrame[num5 + num9];
                    outputFrame[num10++] = inputFrame[num6 + num9];
                }
            } else {
                Binary.interleave(inputFrame, inputStart, outputFrame, outputStart, num * 2, reversePlanes);
            }
        }
    }

    public static void interleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation) {
        Binary.interleaveTransform(inputFrame, 0, outputFrame, 0, width, height, stride, rotation, false);
    }

    public static void test() throws Exception {
        long num2;
        int num;
        HashMap dictionary9 = new HashMap();
        HashMapExtensions.add(dictionary9, "ffff", 65535);
        HashMapExtensions.add(dictionary9, "0000", 0);
        HashMapExtensions.add(dictionary9, "ff00", 255);
        HashMapExtensions.add(dictionary9, "00ff", 65280);
        HashMap dictionary = dictionary9;
        HashMap dictionary10 = new HashMap();
        HashMapExtensions.add(dictionary10, "ffff", 65535);
        HashMapExtensions.add(dictionary10, "0000", 0);
        HashMapExtensions.add(dictionary10, "00ff", 255);
        HashMapExtensions.add(dictionary10, "ff00", 65280);
        HashMap dictionary2 = dictionary10;
        for (String str : HashMapExtensions.getKeys(dictionary)) {
            num = (Integer)HashMapExtensions.getItem(dictionary).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes16(num, true)), str));
            Binary.check(Binary.fromBytes16(BitAssistant.getHexBytes(str), 0, true) == num);
        }
        for (String str : HashMapExtensions.getKeys(dictionary2)) {
            num = (Integer)HashMapExtensions.getItem(dictionary2).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes16(num, false)), str));
            Binary.check(Binary.fromBytes16(BitAssistant.getHexBytes(str), 0, false) == num);
        }
        HashMap dictionary11 = new HashMap();
        HashMapExtensions.add(dictionary11, "ffffff", 0xFFFFFF);
        HashMapExtensions.add(dictionary11, "000000", 0);
        HashMapExtensions.add(dictionary11, "ffff00", 65535);
        HashMapExtensions.add(dictionary11, "00ffff", 0xFFFF00);
        HashMapExtensions.add(dictionary11, "ff0000", 255);
        HashMapExtensions.add(dictionary11, "00ff00", 65280);
        HashMapExtensions.add(dictionary11, "0000ff", 0xFF0000);
        HashMap dictionary3 = dictionary11;
        HashMap dictionary12 = new HashMap();
        HashMapExtensions.add(dictionary12, "ffffff", 0xFFFFFF);
        HashMapExtensions.add(dictionary12, "000000", 0);
        HashMapExtensions.add(dictionary12, "00ffff", 65535);
        HashMapExtensions.add(dictionary12, "ffff00", 0xFFFF00);
        HashMapExtensions.add(dictionary12, "0000ff", 255);
        HashMapExtensions.add(dictionary12, "00ff00", 65280);
        HashMapExtensions.add(dictionary12, "ff0000", 0xFF0000);
        HashMap dictionary4 = dictionary12;
        for (String str : HashMapExtensions.getKeys(dictionary3)) {
            num = (Integer)HashMapExtensions.getItem(dictionary3).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes24(num, true)), str));
            Binary.check(Binary.fromBytes24(BitAssistant.getHexBytes(str), 0, true) == num);
        }
        for (String str : HashMapExtensions.getKeys(dictionary4)) {
            num = (Integer)HashMapExtensions.getItem(dictionary4).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes24(num, false)), str));
            Binary.check(Binary.fromBytes24(BitAssistant.getHexBytes(str), 0, false) == num);
        }
        HashMap dictionary13 = new HashMap();
        HashMapExtensions.add(dictionary13, "ffffffff", 0xFFFFFFFFL);
        HashMapExtensions.add(dictionary13, "00000000", 0L);
        HashMapExtensions.add(dictionary13, "ffffff00", 0xFFFFFFL);
        HashMapExtensions.add(dictionary13, "00ffffff", 0xFFFFFF00L);
        HashMapExtensions.add(dictionary13, "ffff0000", 65535L);
        HashMapExtensions.add(dictionary13, "00ffff00", 0xFFFF00L);
        HashMapExtensions.add(dictionary13, "0000ffff", 0xFFFF0000L);
        HashMapExtensions.add(dictionary13, "ff000000", 255L);
        HashMapExtensions.add(dictionary13, "00ff0000", 65280L);
        HashMapExtensions.add(dictionary13, "0000ff00", 0xFF0000L);
        HashMapExtensions.add(dictionary13, "000000ff", 0xFF000000L);
        HashMap dictionary5 = dictionary13;
        HashMap dictionary14 = new HashMap();
        HashMapExtensions.add(dictionary14, "ffffffff", 0xFFFFFFFFL);
        HashMapExtensions.add(dictionary14, "00000000", 0L);
        HashMapExtensions.add(dictionary14, "00ffffff", 0xFFFFFFL);
        HashMapExtensions.add(dictionary14, "ffffff00", 0xFFFFFF00L);
        HashMapExtensions.add(dictionary14, "0000ffff", 65535L);
        HashMapExtensions.add(dictionary14, "00ffff00", 0xFFFF00L);
        HashMapExtensions.add(dictionary14, "ffff0000", 0xFFFF0000L);
        HashMapExtensions.add(dictionary14, "000000ff", 255L);
        HashMapExtensions.add(dictionary14, "0000ff00", 65280L);
        HashMapExtensions.add(dictionary14, "00ff0000", 0xFF0000L);
        HashMapExtensions.add(dictionary14, "ff000000", 0xFF000000L);
        HashMap dictionary6 = dictionary14;
        for (String str : HashMapExtensions.getKeys(dictionary5)) {
            num2 = (Long)HashMapExtensions.getItem(dictionary5).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes32(num2, true)), str));
            Binary.check(Binary.fromBytes32(BitAssistant.getHexBytes(str), 0, true) == num2);
        }
        for (String str : HashMapExtensions.getKeys(dictionary6)) {
            num2 = (Long)HashMapExtensions.getItem(dictionary6).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes32(num2, false)), str));
            Binary.check(Binary.fromBytes32(BitAssistant.getHexBytes(str), 0, false) == num2);
        }
        HashMap dictionary15 = new HashMap();
        HashMapExtensions.add(dictionary15, "ffffffffff", 0xFFFFFFFFFFL);
        HashMapExtensions.add(dictionary15, "0000000000", 0L);
        HashMapExtensions.add(dictionary15, "ffffffff00", 0xFFFFFFFFL);
        HashMapExtensions.add(dictionary15, "00ffffffff", 0xFFFFFFFF00L);
        HashMapExtensions.add(dictionary15, "ffffff0000", 0xFFFFFFL);
        HashMapExtensions.add(dictionary15, "00ffffff00", 0xFFFFFF00L);
        HashMapExtensions.add(dictionary15, "0000ffffff", 0xFFFFFF0000L);
        HashMapExtensions.add(dictionary15, "ffff000000", 65535L);
        HashMapExtensions.add(dictionary15, "00ffff0000", 0xFFFF00L);
        HashMapExtensions.add(dictionary15, "0000ffff00", 0xFFFF0000L);
        HashMapExtensions.add(dictionary15, "000000ffff", 0xFFFF000000L);
        HashMapExtensions.add(dictionary15, "ff00000000", 255L);
        HashMapExtensions.add(dictionary15, "00ff000000", 65280L);
        HashMapExtensions.add(dictionary15, "0000ff0000", 0xFF0000L);
        HashMapExtensions.add(dictionary15, "000000ff00", 0xFF000000L);
        HashMapExtensions.add(dictionary15, "00000000ff", 0xFF00000000L);
        HashMap dictionary7 = dictionary15;
        HashMap dictionary16 = new HashMap();
        HashMapExtensions.add(dictionary16, "ffffffffff", 0xFFFFFFFFFFL);
        HashMapExtensions.add(dictionary16, "0000000000", 0L);
        HashMapExtensions.add(dictionary16, "00ffffffff", 0xFFFFFFFFL);
        HashMapExtensions.add(dictionary16, "ffffffff00", 0xFFFFFFFF00L);
        HashMapExtensions.add(dictionary16, "0000ffffff", 0xFFFFFFL);
        HashMapExtensions.add(dictionary16, "00ffffff00", 0xFFFFFF00L);
        HashMapExtensions.add(dictionary16, "ffffff0000", 0xFFFFFF0000L);
        HashMapExtensions.add(dictionary16, "000000ffff", 65535L);
        HashMapExtensions.add(dictionary16, "0000ffff00", 0xFFFF00L);
        HashMapExtensions.add(dictionary16, "00ffff0000", 0xFFFF0000L);
        HashMapExtensions.add(dictionary16, "ffff000000", 0xFFFF000000L);
        HashMapExtensions.add(dictionary16, "00000000ff", 255L);
        HashMapExtensions.add(dictionary16, "000000ff00", 65280L);
        HashMapExtensions.add(dictionary16, "0000ff0000", 0xFF0000L);
        HashMapExtensions.add(dictionary16, "00ff000000", 0xFF000000L);
        HashMapExtensions.add(dictionary16, "ff00000000", 0xFF00000000L);
        HashMap dictionary8 = dictionary16;
        for (String str : HashMapExtensions.getKeys(dictionary7)) {
            num2 = (Long)HashMapExtensions.getItem(dictionary7).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes40(num2, true)), str));
            Binary.check(Binary.fromBytes40(BitAssistant.getHexBytes(str), 0, true) == num2);
        }
        for (String str : HashMapExtensions.getKeys(dictionary8)) {
            num2 = (Long)HashMapExtensions.getItem(dictionary8).get(str);
            Binary.check(Global.equals(BitAssistant.getHexString(Binary.toBytes40(num2, false)), str));
            Binary.check(Binary.fromBytes40(BitAssistant.getHexBytes(str), 0, false) == num2);
        }
        Binary.interleaveTest();
        Binary.deinterleaveReverseTest();
        Binary.deinterleaveTransformTest();
        Binary.transformTest();
    }

    public static void toBytes16(int value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
        }
    }

    public static byte[] toBytes16(int value, boolean littleEndian) {
        byte[] output = new byte[2];
        Binary.toBytes16(value, littleEndian, output, 0);
        return output;
    }

    public static void toBytes24(int value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF0000, 16);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF0000, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
        }
    }

    public static byte[] toBytes24(int value, boolean littleEndian) {
        byte[] output = new byte[3];
        Binary.toBytes24(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes32(long value, boolean littleEndian) {
        byte[] output = new byte[4];
        Binary.toBytes32(value, littleEndian, output, 0);
        return output;
    }

    public static void toBytes32(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
        }
    }

    public static byte[] toBytes40(long value, boolean littleEndian) {
        byte[] output = new byte[5];
        Binary.toBytes40(value, littleEndian, output, 0);
        return output;
    }

    public static void toBytes40(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
        }
    }

    public static byte[] toBytes48(long value, boolean littleEndian) {
        byte[] output = new byte[6];
        Binary.toBytes48(value, littleEndian, output, 0);
        return output;
    }

    public static void toBytes48(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
        }
    }

    public static byte[] toBytes56(long value, boolean littleEndian) {
        byte[] output = new byte[7];
        Binary.toBytes56(value, littleEndian, output, 0);
        return output;
    }

    public static void toBytes56(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
        }
    }

    public static byte[] toBytes64(long value, boolean littleEndian) {
        byte[] output = new byte[8];
        Binary.toBytes64(value, littleEndian, output, 0);
        return output;
    }

    public static void toBytes64(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (littleEndian) {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value, 0);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value, 56);
        } else {
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value, 56);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
        }
    }

    public static void transform(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int width, int height, int stride, int rotation) {
        Binary.transform(inputFrame, inputStart, outputFrame, outputStart, width, height, stride, rotation, 1);
    }

    public static void transform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation) {
        Binary.transform(inputFrame, 0, outputFrame, 0, width, height, stride, rotation);
    }

    public static void transform(byte[] inputFrame, int inputStart, byte[] outputFrame, int outputStart, int width, int height, int stride, int rotation, int chunkLength) {
        int num = width * height * chunkLength;
        int length = stride > 0 ? stride * height * chunkLength : num;
        int num3 = outputStart > 0 ? outputStart : inputStart;
        int num4 = stride > 0 ? (stride - width) * chunkLength : 0;
        int num5 = outputStart + num;
        if (num5 > ArrayExtensions.getLength(outputFrame)) {
            Log.error("otuputStart + calculated output plane length is greater than outputFrame length");
        } else {
            int num8;
            int num6 = height + 1;
            int[] numArray = new int[num6];
            int num7 = width * chunkLength;
            for (num8 = 0; num8 < num6; ++num8) {
                numArray[num8] = num7 * num8 + inputStart + num4 * (num8 - 1);
            }
            if (rotation == 270) {
                for (num8 = 1; num8 <= num7; num8 += chunkLength) {
                    for (int num9 = 1; num9 < num6; ++num9) {
                        for (int num10 = chunkLength - 1; num10 >= 0; --num10) {
                            outputFrame[num3++] = inputFrame[numArray[num9] - num8 - num10];
                        }
                    }
                }
            } else if (rotation == 90) {
                for (num8 = 0; num8 < num7; num8 += chunkLength) {
                    for (int num9 = num6 - 2; num9 >= 0; --num9) {
                        for (int num10 = 0; num10 < chunkLength; ++num10) {
                            outputFrame[num3++] = inputFrame[numArray[num9] + num4 + num8 + num10];
                        }
                    }
                }
            } else if (rotation == 180) {
                int num11 = 0;
                for (num8 = inputStart + length - num4 - 1; num8 >= inputStart; num8 -= chunkLength) {
                    if (num4 == 0 || num11 == 0 || num11 % num7 != 0) {
                        for (int num10 = chunkLength - 1; num10 >= 0; --num10) {
                            outputFrame[num3++] = inputFrame[num8 - num10];
                            ++num11;
                        }
                        continue;
                    }
                    num8 -= num4 - chunkLength;
                    num11 = 0;
                }
            } else if (num4 == 0) {
                BitAssistant.copy(inputFrame, inputStart, outputFrame, outputStart, length);
            } else {
                for (num8 = 0; num8 < height; ++num8) {
                    BitAssistant.copy(inputFrame, inputStart + stride * chunkLength * num8, outputFrame, outputStart + width * chunkLength * num8, width * chunkLength);
                }
            }
        }
    }

    private static void transformTest() throws Exception {
        byte[] inputFrame = new byte[]{1, 2, 3, 4, 5, 6};
        byte[] test = new byte[]{3, 6, 2, 5, 1, 4};
        byte[] outputFrame = new byte[ArrayExtensions.getLength(inputFrame)];
        Binary.transform(inputFrame, outputFrame, 3, 2, 3, 270);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6};
        test = new byte[]{4, 1, 5, 2, 6, 3};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, outputFrame, 3, 2, 3, 90);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6};
        test = new byte[]{6, 5, 4, 3, 2, 1};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, outputFrame, 3, 2, 3, 180);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6};
        test = new byte[]{2, 4, 6, 1, 3, 5};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, outputFrame, 2, 3, 2, 270);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 9, 10, 11, 12, 13, 14, 15, 16, 0, 0, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 25, 26, 27, 28, 29, 30, 31, 32, 0, 0, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0};
        test = new byte[]{8, 16, 24, 32, 40, 7, 15, 23, 31, 39, 6, 14, 22, 30, 38, 5, 13, 21, 29, 37, 4, 12, 20, 28, 36, 3, 11, 19, 27, 35, 2, 10, 18, 26, 34, 1, 9, 17, 25, 33};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, outputFrame, 8, 5, 10, 270);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 9, 10, 11, 12, 13, 14, 15, 16, 0, 0, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 25, 26, 27, 28, 29, 30, 31, 32, 0, 0, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0};
        test = new byte[]{33, 25, 17, 9, 1, 34, 26, 18, 10, 2, 35, 27, 19, 11, 3, 36, 28, 20, 12, 4, 37, 29, 21, 13, 5, 38, 30, 22, 14, 6, 39, 31, 23, 15, 7, 40, 32, 24, 16, 8};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, outputFrame, 8, 5, 10, 90);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 9, 10, 11, 12, 13, 14, 15, 16, 0, 0, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 25, 26, 27, 28, 29, 30, 31, 32, 0, 0, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0};
        test = new byte[]{0, 0, 0, 0, 0, 33, 25, 17, 9, 1, 34, 26, 18, 10, 2, 35, 27, 19, 11, 3, 36, 28, 20, 12, 4, 37, 29, 21, 13, 5, 38, 30, 22, 14, 6, 39, 31, 23, 15, 7, 40, 32, 24, 16, 8};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, 0, outputFrame, 5, 8, 5, 10, 90);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 11, 2, 22, 3, 33, 4, 44, 5, 55, 6, 66, 7, 77, 8, 88, 9, 99};
        test = new byte[]{3, 33, 6, 66, 9, 99, 2, 22, 5, 55, 8, 88, 1, 11, 4, 44, 7, 77};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, 0, outputFrame, 0, 3, 3, 0, 270, 2);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 11, 2, 22, 3, 33, 0, 0, 4, 44, 5, 55, 6, 66, 0, 0, 7, 77, 8, 88, 9, 99, 0, 0};
        test = new byte[]{3, 33, 6, 66, 9, 99, 2, 22, 5, 55, 8, 88, 1, 11, 4, 44, 7, 77};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, 0, outputFrame, 0, 3, 3, 4, 270, 2);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 11, 2, 22, 3, 33, 0, 0, 4, 44, 5, 55, 6, 66, 0, 0, 7, 77, 8, 88, 9, 99, 0, 0};
        test = new byte[]{7, 77, 4, 44, 1, 11, 8, 88, 5, 55, 2, 22, 9, 99, 6, 66, 3, 33};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, 0, outputFrame, 0, 3, 3, 4, 90, 2);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 11, 2, 22, 3, 33, 0, 0, 4, 44, 5, 55, 6, 66, 0, 0, 7, 77, 8, 88, 9, 99, 0, 0};
        test = new byte[]{9, 99, 8, 88, 7, 77, 6, 66, 5, 55, 4, 44, 3, 33, 2, 22, 1, 11};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, 0, outputFrame, 0, 3, 3, 4, 180, 2);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 11, 2, 22, 3, 33, 0, 0, 4, 44, 5, 55, 6, 66, 0, 0, 7, 77, 8, 88, 9, 99, 0, 0};
        test = new byte[]{0, 0, 0, 0, 0, 0, 1, 11, 2, 22, 3, 33, 4, 44, 5, 55, 6, 66, 7, 77, 8, 88, 9, 99};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, 0, outputFrame, 6, 3, 3, 4, 0, 2);
        Binary.checkSequenceEqual(test, outputFrame);
        inputFrame = new byte[]{1, 11, 2, 22, 3, 33, 4, 44, 5, 55, 6, 66, 7, 77, 8, 88, 9, 99};
        test = new byte[]{1, 11, 2, 22, 3, 33, 4, 44, 5, 55, 6, 66, 7, 77, 8, 88, 9, 99};
        outputFrame = new byte[ArrayExtensions.getLength(test)];
        Binary.transform(inputFrame, outputFrame, 6, 3, 6, 0);
        Binary.checkSequenceEqual(test, outputFrame);
    }
}

