/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.ogg;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBufferStream;
import fm.icelink.Encoding;
import fm.icelink.MathAssistant;

public class Page {
    private int _absoluteGranulePosition;
    private boolean _beginningOfStream;
    private boolean _continuedPacket;
    private static int[] _crcLookup = new int[256];
    private boolean _endOfStream;
    private byte[] _payload;
    private int _sequenceNumber;
    private int _streamSerialNumber;

    private static int calculateChecksum(byte[] data, int offset, int length) {
        int num = 0;
        int num2 = offset + length;
        while (offset < num2) {
            num = num << 8 ^ _crcLookup[num >> 24 & 0xFF ^ data[offset] & 0xFF];
            ++offset;
        }
        return num;
    }

    public int getAbsoluteGranulePosition() {
        return this._absoluteGranulePosition;
    }

    public boolean getBeginningOfStream() {
        return this._beginningOfStream;
    }

    public byte[] getBytes() {
        int num = 0;
        if (this.getContinuedPacket()) {
            num |= 1;
        }
        if (this.getBeginningOfStream()) {
            num |= 2;
        }
        if (this.getEndOfStream()) {
            num |= 4;
        }
        int num2 = 0;
        int dataBufferSize = 27;
        if (this.getPayload() != null) {
            num2 = (int)MathAssistant.ceil((double)(ArrayExtensions.getLength(this.getPayload()) + 1) / 255.0);
            if (num2 > 255) {
                throw new RuntimeException(new Exception("Payload exceeds Ogg page limits, and Ogg page-splitting is not currently supported."));
            }
            dataBufferSize += num2 + ArrayExtensions.getLength(this.getPayload());
        }
        DataBufferStream stream = new DataBufferStream(dataBufferSize, true);
        stream.writeBytes(Encoding.getUtf8().getBytes("OggS"));
        stream.write8(0);
        stream.write8(num);
        stream.write64(this.getAbsoluteGranulePosition());
        stream.write32(this.getStreamSerialNumber());
        stream.write32(this.getSequenceNumber());
        int position = stream.getPosition();
        stream.write32(0L);
        stream.write8(num2);
        if (this.getPayload() != null) {
            int length = ArrayExtensions.getLength(this.getPayload());
            for (int i = 0; i < num2; ++i) {
                int num7 = MathAssistant.min(255, length);
                stream.write8(num7);
                length -= num7;
            }
            stream.writeBytes(this.getPayload());
        }
        stream.setPosition(position);
        stream.write32(Page.calculateChecksum(stream.getBuffer().getData(), stream.getBuffer().getIndex(), stream.getBuffer().getLength()));
        return stream.getBuffer().toArray();
    }

    public boolean getContinuedPacket() {
        return this._continuedPacket;
    }

    public boolean getEndOfStream() {
        return this._endOfStream;
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public int getStreamSerialNumber() {
        return this._streamSerialNumber;
    }

    public Page() {
        this.setStreamSerialNumber(1);
    }

    public void setAbsoluteGranulePosition(int value) {
        this._absoluteGranulePosition = value;
    }

    public void setBeginningOfStream(boolean value) {
        this._beginningOfStream = value;
    }

    public void setContinuedPacket(boolean value) {
        this._continuedPacket = value;
    }

    public void setEndOfStream(boolean value) {
        this._endOfStream = value;
    }

    public void setPayload(byte[] value) {
        this._payload = value;
    }

    public void setSequenceNumber(int value) {
        this._sequenceNumber = value;
    }

    public void setStreamSerialNumber(int value) {
        this._streamSerialNumber = value;
    }

    static {
        for (int i = 0; i < ArrayExtensions.getLength(_crcLookup); ++i) {
            int num2 = i << 24;
            for (int j = 0; j < 8; ++j) {
                if (((long)num2 & 0x80000000L) != 0L) {
                    num2 = num2 << 1 ^ 0x4C11DB7;
                    continue;
                }
                num2 <<= 1;
            }
            Page._crcLookup[i] = num2 & 0xFFFFFFFF;
        }
    }
}

