/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1Explicit;
import fm.icelink.Asn1Implicit;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Sequence;
import fm.icelink.Asn1Unknown;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.X501Name;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509Extensions;
import fm.icelink.X509SubjectPublicKeyInfo;
import fm.icelink.X509Validity;
import java.util.ArrayList;

class X509TbsCertificate {
    private X509Extensions _extensions;
    private X501Name _issuer;
    private byte[] _issuerUniqueId;
    private boolean _missingVersion;
    private byte[] _serialNumber;
    private X509AlgorithmIdentifier _signatureAlgorithm;
    private Asn1Any _sourceAsn;
    private X501Name _subject;
    private X509SubjectPublicKeyInfo _subjectPublicKeyInfo;
    private byte[] _subjectUniqueId;
    private X509Validity _validity;
    private int _version;

    private static <T extends Asn1Any> Asn1Explicit<T> explicitWrap(int tag, T value) {
        if (value == null) {
            return null;
        }
        return new Asn1Explicit<T>(tag, 128, value);
    }

    public static X509TbsCertificate fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 6) {
            return null;
        }
        X509TbsCertificate certificate = new X509TbsCertificate();
        int index = 0;
        if (sequence.getValues()[0] instanceof Asn1Unknown && sequence.getValues()[1] instanceof Asn1Integer) {
            certificate.setVersion((int)((Asn1Integer)X509TbsCertificate.unwrap(sequence.getValues()[index++])).getLongValue());
        } else {
            certificate.setMissingVersion(true);
        }
        certificate.setSerialNumber(((Asn1Integer)sequence.getValues()[index++]).getValue());
        certificate.setSignatureAlgorithm(X509AlgorithmIdentifier.fromAsn1(sequence.getValues()[index++]));
        certificate.setIssuer(X501Name.fromAsn1(sequence.getValues()[index++]));
        certificate.setValidity(X509Validity.fromAsn1(sequence.getValues()[index++]));
        certificate.setSubject(X501Name.fromAsn1(sequence.getValues()[index++]));
        certificate.setSubjectPublicKeyInfo(X509SubjectPublicKeyInfo.fromAsn1(sequence.getValues()[index++]));
        if (ArrayExtensions.getLength(sequence.getValues()) > index) {
            if (sequence.getValues()[index] instanceof Asn1BitString) {
                certificate.setIssuerUniqueId(((Asn1BitString)X509TbsCertificate.unwrap(sequence.getValues()[index])).getValueBytes());
            } else {
                certificate.setExtensions(X509Extensions.fromAsn1(X509TbsCertificate.unwrap(sequence.getValues()[index])));
            }
            ++index;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) > index) {
            if (sequence.getValues()[index] instanceof Asn1BitString) {
                certificate.setSubjectUniqueId(((Asn1BitString)X509TbsCertificate.unwrap(sequence.getValues()[index])).getValueBytes());
            } else {
                certificate.setExtensions(X509Extensions.fromAsn1(X509TbsCertificate.unwrap(sequence.getValues()[index])));
            }
            ++index;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) > index) {
            certificate.setExtensions(X509Extensions.fromAsn1(X509TbsCertificate.unwrap(sequence.getValues()[index])));
            ++index;
        }
        certificate.setSourceAsn(any);
        return certificate;
    }

    public X509Extensions getExtensions() {
        return this._extensions;
    }

    public X501Name getIssuer() {
        return this._issuer;
    }

    public byte[] getIssuerUniqueId() {
        return this._issuerUniqueId;
    }

    public boolean getMissingVersion() {
        return this._missingVersion;
    }

    public byte[] getSerialNumber() {
        return this._serialNumber;
    }

    public X509AlgorithmIdentifier getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public Asn1Any getSourceAsn() {
        return this._sourceAsn;
    }

    public X501Name getSubject() {
        return this._subject;
    }

    public X509SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this._subjectPublicKeyInfo;
    }

    public byte[] getSubjectUniqueId() {
        return this._subjectUniqueId;
    }

    public X509Validity getValidity() {
        return this._validity;
    }

    public int getVersion() {
        return this._version;
    }

    public static int getVersion1() {
        return 0;
    }

    public static int getVersion2() {
        return 1;
    }

    public static int getVersion3() {
        return 2;
    }

    private static <T extends Asn1Any> Asn1Implicit<T> implicitWrap(int tag, T value) {
        if (value == null) {
            return null;
        }
        return new Asn1Implicit<T>(tag, 128, value);
    }

    private static Asn1Explicit<Asn1Sequence> makeExplicitExtensions(Asn1Sequence extensions) {
        return X509TbsCertificate.explicitWrap(3, extensions);
    }

    private static Asn1Explicit<Asn1Integer> makeExplicitVersion(Asn1Integer version) {
        return X509TbsCertificate.explicitWrap(0, version);
    }

    private static Asn1Implicit<Asn1BitString> makeImplicitIssuerUniqueId(Asn1BitString issuerUniqueId) {
        return X509TbsCertificate.implicitWrap(1, issuerUniqueId);
    }

    private static Asn1Implicit<Asn1BitString> makeImplicitSubjectUniqueId(Asn1BitString subjectUniqueId) {
        return X509TbsCertificate.implicitWrap(2, subjectUniqueId);
    }

    public void setExtensions(X509Extensions value) {
        this._extensions = value;
    }

    public void setIssuer(X501Name value) {
        this._issuer = value;
    }

    public void setIssuerUniqueId(byte[] value) {
        this._issuerUniqueId = value;
    }

    private void setMissingVersion(boolean value) {
        this._missingVersion = value;
    }

    public void setSerialNumber(byte[] value) {
        this._serialNumber = value;
    }

    public void setSignatureAlgorithm(X509AlgorithmIdentifier value) {
        this._signatureAlgorithm = value;
    }

    private void setSourceAsn(Asn1Any value) {
        this._sourceAsn = value;
    }

    public void setSubject(X501Name value) {
        this._subject = value;
    }

    public void setSubjectPublicKeyInfo(X509SubjectPublicKeyInfo value) {
        this._subjectPublicKeyInfo = value;
    }

    public void setSubjectUniqueId(byte[] value) {
        this._subjectUniqueId = value;
    }

    public void setValidity(X509Validity value) {
        this._validity = value;
    }

    public void setVersion(int value) {
        this._version = value;
    }

    public Asn1Sequence toAsn1() {
        if (!this.getMissingVersion()) {
            if ((this.getIssuerUniqueId() != null || this.getSubjectUniqueId() != null) && this.getVersion() < X509TbsCertificate.getVersion2()) {
                Log.error("Version must be at least v2 if IssuerUniqueId or SubjectUniqueId are not null.");
                return null;
            }
            if (this.getExtensions() != null && this.getVersion() < X509TbsCertificate.getVersion3()) {
                Log.error("Version must be at least v3 if Extensions is not null.");
                return null;
            }
        }
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        if (!this.getMissingVersion()) {
            list.add(X509TbsCertificate.makeExplicitVersion(new Asn1Integer(this.getVersion())));
        }
        list.add(new Asn1Integer(this.getSerialNumber()));
        list.add(this.getSignatureAlgorithm().toAsn1());
        list.add(this.getIssuer().toAsn1());
        list.add(this.getValidity().toAsn1());
        list.add(this.getSubject().toAsn1());
        list.add(this.getSubjectPublicKeyInfo().toAsn1());
        if (this.getIssuerUniqueId() != null) {
            list.add(X509TbsCertificate.makeImplicitIssuerUniqueId(new Asn1BitString(this.getIssuerUniqueId())));
        } else if (this.getSubjectUniqueId() != null) {
            list.add(X509TbsCertificate.makeImplicitSubjectUniqueId(new Asn1BitString(this.getSubjectUniqueId())));
        } else if (this.getExtensions() != null) {
            list.add(X509TbsCertificate.makeExplicitExtensions(this.getExtensions().toAsn1()));
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    private static Asn1Any unwrap(Asn1Any any) {
        Asn1Unknown unknown = Global.tryCast(any, Asn1Unknown.class);
        if (unknown == null) {
            return null;
        }
        return Asn1Any.parseBytes(unknown.getValue());
    }
}

