/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicInteger;
import fm.icelink.DoubleExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;

public class PoolStatistics {
    AtomicInteger __creates;
    AtomicInteger __hits = new AtomicInteger();
    AtomicInteger __misses = new AtomicInteger();
    AtomicInteger __paddingWasted;
    AtomicInteger __pendingPoolSize;
    AtomicInteger __totalPoolSize;

    public int getActivePools() {
        return this.__creates.getValue();
    }

    public double getHitPercentage() {
        return (double)this.__hits.getValue() / (double)this.getTotalCalls() * 100.0;
    }

    public double getMissPercentage() {
        return (double)(this.__misses.getValue() - this.__creates.getValue()) / (double)this.getTotalCalls() * 100.0;
    }

    public int getPaddingWasted() {
        return this.__paddingWasted.getValue();
    }

    public int getPendingPoolSize() {
        return this.__pendingPoolSize.getValue();
    }

    public int getTotalCalls() {
        return this.__hits.getValue() + this.__misses.getValue();
    }

    public int getTotalPools() {
        return this.__creates.getValue();
    }

    public int getTotalPoolSize() {
        return this.__totalPoolSize.getValue();
    }

    PoolStatistics() {
        this.__creates = new AtomicInteger();
        this.__paddingWasted = new AtomicInteger();
        this.__totalPoolSize = new AtomicInteger();
        this.__pendingPoolSize = new AtomicInteger();
    }

    public String toString() {
        return StringExtensions.format("Hits: {0}, Misses: {1}, TotalPools: {2}, ActivePools: {3}, PendingSize: {4}, TotalSize:{5}, WastedPadding: {6}", new Object[]{DoubleExtensions.toString(this.getHitPercentage()), DoubleExtensions.toString(this.getMissPercentage()), IntegerExtensions.toString(this.getTotalPools()), IntegerExtensions.toString(this.getActivePools()), IntegerExtensions.toString(this.getPendingPoolSize()), IntegerExtensions.toString(this.getTotalPoolSize()), IntegerExtensions.toString(this.getPaddingWasted())});
    }
}

