/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.MediaComponentStats;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import java.util.HashMap;

public class MediaSenderStats
extends MediaComponentStats {
    private long _bytesSent;
    private long _packetsSent;
    private int _roundTripTime;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "packetsSent")) {
                if (Global.equals(str, "bytesSent")) {
                    this.setBytesSent(JsonSerializer.deserializeLong(valueJson).getValue());
                } else if (Global.equals(str, "rtt")) {
                    this.setRoundTripTime(JsonSerializer.deserializeInteger(valueJson).getValue());
                }
            } else {
                this.setPacketsSent(JsonSerializer.deserializeLong(valueJson).getValue());
            }
        }
    }

    public static MediaSenderStats fromJson(String mediaSenderJson) {
        return JsonSerializer.deserializeObject(mediaSenderJson, new IFunction0<MediaSenderStats>(){

            @Override
            public MediaSenderStats invoke() {
                return new MediaSenderStats();
            }
        }, new IAction3<MediaSenderStats, String, String>(){

            @Override
            public void invoke(MediaSenderStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public long getPacketsSent() {
        return this._packetsSent;
    }

    public int getRoundTripTime() {
        return this._roundTripTime;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "packetsSent", JsonSerializer.serializeLong(new NullableLong(this.getPacketsSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesSent", JsonSerializer.serializeLong(new NullableLong(this.getBytesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "rtt", JsonSerializer.serializeInteger(new NullableInteger(this.getRoundTripTime())));
    }

    void setBytesSent(long value) {
        this._bytesSent = value;
    }

    void setPacketsSent(long value) {
        this._packetsSent = value;
    }

    void setRoundTripTime(int value) {
        this._roundTripTime = value;
    }

    public String toJson() {
        return MediaSenderStats.toJson(this);
    }

    public static String toJson(MediaSenderStats mediaSender) {
        return JsonSerializer.serializeObject(mediaSender, new IAction2<MediaSenderStats, HashMap<String, String>>(){

            @Override
            public void invoke(MediaSenderStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }
}

