/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AesCounterContext;
import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;

class AesCounter {
    private AesCounterContext _context;
    private byte[] _counterData;
    private DataBuffer _key;
    private byte[] _offset;
    private DataBuffer _output;
    private byte[] _packetIndexBytes;
    private DataBuffer _salt;
    private byte[] _ssrcBytes;

    public AesCounter(DataBuffer key, DataBuffer salt) {
        int num;
        if (key.getLength() != 16) {
            throw new RuntimeException(new Exception("Invalid key length."));
        }
        if (salt.getLength() != 14) {
            throw new RuntimeException(new Exception("Invalid salt length."));
        }
        this._key = key;
        this._salt = salt;
        this._context = new AesCounterContext(key);
        this._offset = new byte[16];
        this._ssrcBytes = new byte[4];
        this._packetIndexBytes = new byte[6];
        this._output = DataBuffer.allocate(65536);
        for (num = 0; num < ArrayExtensions.getLength(this._offset); ++num) {
            this._offset[num] = 0;
        }
        for (num = 0; num < this._salt.getLength(); ++num) {
            this._offset[num] = (byte)this._salt.read8(num);
        }
    }

    public void clear() {
        if (this._context != null) {
            this._context.clear();
            this._context = null;
        }
    }

    public DataBuffer decrypt(DataBuffer buffer, long ssrc, long packetIndex) {
        return this.encrypt(buffer, ssrc, packetIndex);
    }

    public DataBuffer encrypt(DataBuffer buffer, long ssrc, long packetIndex) {
        int num;
        if (this._counterData == null) {
            this._counterData = new byte[16];
            for (num = 0; num < 4; ++num) {
                this._counterData[num] = this._offset[num];
            }
            Binary.toBytes32(ssrc, false, this._ssrcBytes, 0);
            num = 0;
            int i = 4;
            while (num < ArrayExtensions.getLength(this._ssrcBytes)) {
                this._counterData[i] = (byte)(this._offset[i] ^ this._ssrcBytes[num]);
                ++num;
                ++i;
            }
        }
        this._counterData[8] = (byte)((long)this._offset[8] ^ BitAssistant.rightShiftLong(packetIndex & 0xFF0000000000L, 40));
        this._counterData[9] = (byte)((long)this._offset[9] ^ BitAssistant.rightShiftLong(packetIndex & 0xFF00000000L, 32));
        this._counterData[10] = (byte)((long)this._offset[10] ^ BitAssistant.rightShiftLong(packetIndex & 0xFF000000L, 24));
        this._counterData[11] = (byte)((long)this._offset[11] ^ BitAssistant.rightShiftLong(packetIndex & 0xFF0000L, 16));
        this._counterData[12] = (byte)((long)this._offset[12] ^ BitAssistant.rightShiftLong(packetIndex & 0xFF00L, 8));
        this._counterData[13] = (byte)((long)this._offset[13] ^ BitAssistant.rightShiftLong(packetIndex & 0xFFL, 0));
        this._counterData[14] = this._offset[14];
        this._counterData[15] = this._offset[15];
        int length = buffer.getLength() / 16 * 16;
        if (length < buffer.getLength()) {
            length += 16;
        }
        if (this._context.generateKeystream(this._output, length, this._counterData)) {
            DataBuffer buffer2 = DataBuffer.wrap(this._output.getData(), this._output.getIndex(), buffer.getLength());
            byte[] data = buffer2.getData();
            int index = buffer2.getIndex();
            byte[] buffer4 = buffer.getData();
            int num5 = buffer.getIndex();
            for (num = 0; num < buffer2.getLength(); ++num) {
                data[index] = (byte)(data[index] ^ buffer4[num5]);
                ++index;
                ++num5;
            }
            return buffer2;
        }
        return DataBuffer.getEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer generate(byte label, int length) {
        int num;
        byte[] buffer = new byte[16];
        for (num = 0; num < ArrayExtensions.getLength(buffer); ++num) {
            buffer[num] = 0;
        }
        buffer[7] = label;
        byte[] counter = new byte[16];
        for (num = 0; num < ArrayExtensions.getLength(counter); ++num) {
            counter[num] = (byte)(this._offset[num] ^ buffer[num]);
        }
        int count = length / 16 * 16;
        if (count < length) {
            count += 16;
        }
        DataBuffer output = DataBuffer.allocate(count);
        AesCounterContext context = null;
        try {
            context = new AesCounterContext(this._key);
        }
        catch (Exception exception1) {
            return DataBuffer.getEmpty();
        }
        try {
            if (!context.generateKeystream(output, count, counter)) {
                DataBuffer dataBuffer = DataBuffer.getEmpty();
                return dataBuffer;
            }
        }
        finally {
            if (context != null) {
                context.clear();
            }
        }
        return output.subset(0, length);
    }
}

