/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import fm.icelink.LayoutScale;
import fm.icelink.Log;
import fm.icelink.VideoBuffer;
import fm.icelink.android.OpenGLState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class OpenGLView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private volatile boolean renderRequested;
    private String vertShaderCode = "attribute vec4 position;\nattribute vec2 texCoord;\n\nvarying vec2 texCoordVarying;\n\nvoid main()\n{\n    gl_Position = position;\n    texCoordVarying = texCoord;\n}";
    private String fragShaderCode = "uniform sampler2D SamplerY;\nuniform sampler2D SamplerU;\nuniform sampler2D SamplerV;\n\nvarying highp vec2 texCoordVarying;\n\nvoid main()\n{\n    mediump vec3 yuv;\n    lowp vec3 rgb;\n\n    yuv.x = texture2D(SamplerY, texCoordVarying).r;\n    yuv.y = texture2D(SamplerU, texCoordVarying).r - 0.5;\n    yuv.z = texture2D(SamplerV, texCoordVarying).r - 0.5;\n\n    rgb = mat3(      1,       1,      1,\n                     0, -.18732, 1.8556,\n               1.57481, -.46813,      0) * yuv;\n\n    gl_FragColor = vec4(rgb, 1);\n}";
    private int yTexture;
    private int uTexture;
    private int vTexture;
    private int program;
    private int[] uniforms = new int[3];
    private IntBuffer texcoordVBO = IntBuffer.allocate(1);
    private IntBuffer positionVBO = IntBuffer.allocate(1);
    private IntBuffer indexVBO = IntBuffer.allocate(1);
    private boolean buffersInitialized = false;
    private boolean reconfigureBuffers = false;
    private int bufferWidth = 0;
    private int bufferHeight = 0;
    private OpenGLState state;
    private OpenGLState lastState;
    private LayoutScale scale;

    public LayoutScale getScale() {
        return this.scale;
    }

    public OpenGLView(Context context) {
        this(context, LayoutScale.Contain);
    }

    public OpenGLView(Context context, LayoutScale scale) {
        super(context);
        this.scale = scale;
        this.renderRequested = false;
        this.setEGLContextClientVersion(2);
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glActiveTexture((int)34016);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.bufferWidth = 0;
        this.bufferHeight = 0;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.loadShaders();
        int[] textureNames = new int[3];
        GLES20.glEnable((int)3553);
        GLES20.glGenTextures((int)3, (int[])textureNames, (int)0);
        this.yTexture = textureNames[0];
        this.uTexture = textureNames[1];
        this.vTexture = textureNames[2];
        GLES20.glUseProgram((int)this.program);
        GLES20.glUniform1i((int)this.uniforms[UNIFORM.Y.ordinal()], (int)0);
        GLES20.glUniform1i((int)this.uniforms[UNIFORM.U.ordinal()], (int)1);
        GLES20.glUniform1i((int)this.uniforms[UNIFORM.V.ordinal()], (int)2);
    }

    public final void onDrawFrame(GL10 gl) {
        if (this.lastState != null) {
            this.lastState.free();
            this.lastState = null;
        }
        GLES20.glClear((int)16384);
        OpenGLState s = this.state;
        if (s != null) {
            int width = s.width;
            int height = s.height;
            ByteBuffer yBuffer = s.yBuffer;
            ByteBuffer uBuffer = s.uBuffer;
            ByteBuffer vBuffer = s.vBuffer;
            if (this.buffersInitialized && (this.bufferWidth != width || this.bufferHeight != height)) {
                this.reconfigureBuffers = true;
            }
            if (!this.buffersInitialized || this.reconfigureBuffers) {
                this.initializeBuffers(width, height);
                this.reconfigureBuffers = false;
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)width, (int)height, (int)0, (int)6409, (int)5121, (Buffer)yBuffer);
            GLES20.glBindTexture((int)3553, (int)this.yTexture);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glActiveTexture((int)33985);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(width / 2), (int)(height / 2), (int)0, (int)6409, (int)5121, (Buffer)uBuffer);
            GLES20.glBindTexture((int)3553, (int)this.uTexture);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glActiveTexture((int)33986);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(width / 2), (int)(height / 2), (int)0, (int)6409, (int)5121, (Buffer)vBuffer);
            GLES20.glBindTexture((int)3553, (int)this.vTexture);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glDrawElements((int)5, (int)6, (int)5123, (int)0);
            this.lastState = s;
            this.state = null;
        }
        this.renderRequested = false;
    }

    void initializeBuffers(int textureWidth, int textureHeight) {
        float right;
        float top;
        float texCoordOffsetT;
        float texCoordFactorT;
        float texCoordOffsetS;
        float texCoordFactorS;
        this.destroyBuffers();
        this.buffersInitialized = true;
        this.bufferWidth = textureWidth;
        this.bufferHeight = textureHeight;
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        if (this.scale == LayoutScale.Cover) {
            if ((float)viewHeight / (float)viewWidth < (float)textureHeight / (float)textureWidth) {
                texCoordFactorS = 1.0f;
                texCoordOffsetS = 0.0f;
                texCoordFactorT = (float)(textureWidth * viewHeight) / (float)(textureHeight * viewWidth);
                texCoordOffsetT = (1.0f - texCoordFactorT) / 2.0f;
            } else {
                texCoordFactorS = (float)(textureHeight * viewWidth) / (float)(textureWidth * viewHeight);
                texCoordOffsetS = (1.0f - texCoordFactorS) / 2.0f;
                texCoordFactorT = 1.0f;
                texCoordOffsetT = 0.0f;
            }
        } else {
            texCoordFactorS = 1.0f;
            texCoordOffsetS = 0.0f;
            texCoordFactorT = 1.0f;
            texCoordOffsetT = 0.0f;
        }
        if (this.scale == LayoutScale.Contain) {
            float viewRatio = (float)viewWidth / (float)viewHeight;
            float imageRatio = (float)textureWidth / (float)textureHeight;
            if (viewRatio > imageRatio) {
                top = 1.0f;
                right = imageRatio / viewRatio;
            } else {
                top = viewRatio / imageRatio;
                right = 1.0f;
            }
        } else {
            top = 1.0f;
            right = 1.0f;
        }
        float[] verticesData = new float[]{-right, top, right, top, -right, -top, right, -top};
        FloatBuffer vertices = ByteBuffer.allocateDirect(verticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        vertices.put(verticesData).position(0);
        float[] texCoordsData = new float[]{texCoordOffsetS, texCoordOffsetT, texCoordOffsetS + texCoordFactorS, texCoordOffsetT, texCoordOffsetS, texCoordOffsetT + texCoordFactorT, texCoordOffsetS + texCoordFactorS, texCoordOffsetT + texCoordFactorT};
        FloatBuffer texCoords = ByteBuffer.allocateDirect(texCoordsData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        texCoords.put(texCoordsData).position(0);
        short[] indicesData = new short[]{0, 1, 2, 1, 2, 3};
        ShortBuffer indices = ByteBuffer.allocateDirect(indicesData.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        indices.put(indicesData).position(0);
        GLES20.glGenBuffers((int)1, (IntBuffer)this.indexVBO);
        GLES20.glBindBuffer((int)34963, (int)this.indexVBO.get(0));
        GLES20.glBufferData((int)34963, (int)(indices.capacity() * 2), (Buffer)indices, (int)35044);
        GLES20.glGenBuffers((int)1, (IntBuffer)this.positionVBO);
        GLES20.glBindBuffer((int)34962, (int)this.positionVBO.get(0));
        GLES20.glBufferData((int)34962, (int)(vertices.capacity() * 4), (Buffer)vertices, (int)35044);
        GLES20.glEnableVertexAttribArray((int)ATTRIB.VERTEX.ordinal());
        GLES20.glVertexAttribPointer((int)ATTRIB.VERTEX.ordinal(), (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glGenBuffers((int)1, (IntBuffer)this.texcoordVBO);
        GLES20.glBindBuffer((int)34962, (int)this.texcoordVBO.get(0));
        GLES20.glBufferData((int)34962, (int)(texCoords.capacity() * 4), (Buffer)texCoords, (int)35048);
        GLES20.glEnableVertexAttribArray((int)ATTRIB.TEXCOORD.ordinal());
        GLES20.glVertexAttribPointer((int)ATTRIB.TEXCOORD.ordinal(), (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        if (textureWidth % 16 == 0) {
            GLES20.glPixelStorei((int)3317, (int)8);
        } else if (textureWidth % 8 == 0) {
            GLES20.glPixelStorei((int)3317, (int)4);
        } else if (textureWidth % 4 == 0) {
            GLES20.glPixelStorei((int)3317, (int)2);
        } else {
            GLES20.glPixelStorei((int)3317, (int)1);
        }
    }

    void destroyBuffers() {
        if (this.buffersInitialized) {
            GLES20.glDeleteBuffers((int)1, (IntBuffer)this.texcoordVBO);
            GLES20.glDeleteBuffers((int)1, (IntBuffer)this.positionVBO);
            GLES20.glDeleteBuffers((int)1, (IntBuffer)this.indexVBO);
            this.buffersInitialized = false;
        }
    }

    boolean loadShaders() {
        this.program = GLES20.glCreateProgram();
        int vertShader = this.compileShader(35633, this.vertShaderCode);
        if (vertShader == 0) {
            Log.error((String)"Could not compile vertex shader.");
            return false;
        }
        int fragShader = this.compileShader(35632, this.fragShaderCode);
        if (fragShader == 0) {
            Log.error((String)"Could not compile fragment shader.");
            return false;
        }
        GLES20.glAttachShader((int)this.program, (int)vertShader);
        GLES20.glAttachShader((int)this.program, (int)fragShader);
        GLES20.glBindAttribLocation((int)this.program, (int)ATTRIB.VERTEX.ordinal(), (String)"position");
        GLES20.glBindAttribLocation((int)this.program, (int)ATTRIB.TEXCOORD.ordinal(), (String)"texCoord");
        if (!this.linkProgram(this.program)) {
            Log.error((String)"Could not link program.");
            if (vertShader > 0) {
                GLES20.glDeleteShader((int)vertShader);
                vertShader = 0;
            }
            if (fragShader > 0) {
                GLES20.glDeleteShader((int)fragShader);
                fragShader = 0;
            }
            if (this.program > 0) {
                GLES20.glDeleteProgram((int)this.program);
                this.program = 0;
            }
            return false;
        }
        this.uniforms[UNIFORM.Y.ordinal()] = GLES20.glGetUniformLocation((int)this.program, (String)"SamplerY");
        this.uniforms[UNIFORM.U.ordinal()] = GLES20.glGetUniformLocation((int)this.program, (String)"SamplerU");
        this.uniforms[UNIFORM.V.ordinal()] = GLES20.glGetUniformLocation((int)this.program, (String)"SamplerV");
        if (vertShader > 0) {
            GLES20.glDetachShader((int)this.program, (int)vertShader);
            GLES20.glDeleteShader((int)vertShader);
        }
        if (fragShader > 0) {
            GLES20.glDetachShader((int)this.program, (int)fragShader);
            GLES20.glDeleteShader((int)fragShader);
        }
        return true;
    }

    int compileShader(int type, String source) {
        int s = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)s, (String)source);
        GLES20.glCompileShader((int)s);
        IntBuffer params = IntBuffer.allocate(1);
        GLES20.glGetShaderiv((int)s, (int)35713, (IntBuffer)params);
        if (params.get(0) == 0) {
            GLES20.glDeleteShader((int)s);
            return 0;
        }
        return s;
    }

    boolean linkProgram(int prog) {
        GLES20.glLinkProgram((int)prog);
        IntBuffer params = IntBuffer.allocate(1);
        GLES20.glGetProgramiv((int)prog, (int)35714, (IntBuffer)params);
        return params.get(0) != 0;
    }

    public void render(VideoBuffer buffer) {
        if (this.renderRequested) {
            return;
        }
        this.renderRequested = true;
        if (this.state == null) {
            this.state = new OpenGLState(buffer);
        }
        this.requestRender();
    }

    static enum ATTRIB {
        VERTEX,
        TEXCOORD;

    }

    static enum UNIFORM {
        Y,
        U,
        V;

    }
}

