/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.VideoBuffer;
import java.nio.ByteBuffer;

public class OpenGLState {
    public DataBuffer y;
    public DataBuffer u;
    public DataBuffer v;
    public ByteBuffer yBuffer;
    public ByteBuffer uBuffer;
    public ByteBuffer vBuffer;
    private int yLength;
    private int uLength;
    private int vLength;
    public int width;
    public int height;

    public OpenGLState(VideoBuffer buffer) {
        this.width = buffer.getWidth();
        this.height = buffer.getHeight();
        this.yLength = this.width * this.height;
        this.uLength = this.vLength = this.yLength / 4;
        this.y = DataBufferPool.getInstance().take(this.yLength);
        this.u = DataBufferPool.getInstance().take(this.uLength);
        this.v = DataBufferPool.getInstance().take(this.vLength);
        this.yBuffer = ByteBuffer.wrap(this.y.getData());
        this.uBuffer = ByteBuffer.wrap(this.u.getData());
        this.vBuffer = ByteBuffer.wrap(this.v.getData());
        int yStride = buffer.getStrides()[0];
        int uStride = buffer.getStrides()[1];
        int vStride = buffer.getStrides()[2];
        DataBuffer yPlane = buffer.getDataBuffers()[0];
        DataBuffer uPlane = buffer.getDataBuffers()[1];
        DataBuffer vPlane = buffer.getDataBuffers()[2];
        for (int x = 0; x < this.height; ++x) {
            this.yBuffer.put(yPlane.getData(), yPlane.getIndex() + x * yStride, this.width);
            if (x >= this.height / 2) continue;
            this.uBuffer.put(uPlane.getData(), uPlane.getIndex() + x * uStride, this.width / 2);
            this.vBuffer.put(vPlane.getData(), vPlane.getIndex() + x * vStride, this.width / 2);
        }
        this.yBuffer.position(0);
        this.uBuffer.position(0);
        this.vBuffer.position(0);
    }

    public void free() {
        this.y.free();
        this.u.free();
        this.v.free();
    }
}

