/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtp;

import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttributeSubType;
import fm.icelink.sdp.rtcp.FeedbackAttributeType;
import fm.icelink.sdp.rtp.FeedbackAttributeCollection;

public class MapAttribute
extends Attribute {
    private FeedbackAttributeCollection __relatedRtcpFeedbackAttributes = new FeedbackAttributeCollection();
    private int _clockRate;
    private String _formatName;
    private String _formatParameters;
    private int _payloadType;
    private FormatParametersAttribute _relatedFormatParametersAttribute;

    public void addRelatedRtcpFeedbackAttribute(FeedbackAttribute attribute) {
        this.__relatedRtcpFeedbackAttributes.addAttribute(attribute);
    }

    public static MapAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ");
        int num2 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, index));
        value = value.substring(index + 1);
        int length = StringExtensions.indexOf(value, "/");
        String str = StringExtensions.substring(value, 0, length);
        value = value.substring(length + 1);
        length = StringExtensions.indexOf(value, "/");
        int num4 = 0;
        String str2 = null;
        if (length == -1) {
            num4 = ParseAssistant.parseIntegerValue(value);
        } else {
            num4 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, length));
            str2 = value.substring(length + 1);
        }
        MapAttribute attribute = new MapAttribute();
        attribute.setPayloadType(num2);
        attribute.setFormatName(str);
        attribute.setClockRate(num4);
        attribute.setFormatParameters(str2);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getPayloadType()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getFormatName());
        StringBuilderExtensions.append(builder, "/");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getClockRate()));
        if (!StringExtensions.isNullOrEmpty(this.getFormatParameters())) {
            StringBuilderExtensions.append(builder, "/");
            StringBuilderExtensions.append(builder, this.getFormatParameters());
        }
        return builder.toString();
    }

    public int getClockRate() {
        return this._clockRate;
    }

    public String getFormatName() {
        return this._formatName;
    }

    public String getFormatParameters() {
        return this._formatParameters;
    }

    public int getPayloadType() {
        return this._payloadType;
    }

    public FeedbackAttribute getRelatedCcmFirFeedbackAttribute(int payloadType) {
        return this.getRelatedRtcpFeedbackAttribute(FeedbackAttributeType.getCcm(), FeedbackAttributeSubType.getFir());
    }

    public FormatParametersAttribute getRelatedFormatParametersAttribute() {
        return this._relatedFormatParametersAttribute;
    }

    public FeedbackAttribute getRelatedNackFeedbackAttribute() {
        return this.getRelatedRtcpFeedbackAttribute(FeedbackAttributeType.getNack(), null);
    }

    public FeedbackAttribute getRelatedNackPliFeedbackAttribute() {
        return this.getRelatedRtcpFeedbackAttribute(FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getPli());
    }

    public FeedbackAttribute getRelatedNackRpsiFeedbackAttribute(int payloadType) {
        return this.getRelatedRtcpFeedbackAttribute(FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getRpsi());
    }

    public FeedbackAttribute getRelatedNackSliFeedbackAttribute(int payloadType) {
        return this.getRelatedRtcpFeedbackAttribute(FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getSli());
    }

    public FeedbackAttribute getRelatedRtcpFeedbackAttribute(int payloadType, String type, String subType) {
        for (FeedbackAttribute attribute : this.getRelatedRtcpFeedbackAttributes()) {
            if (attribute == null || !Global.equals(attribute.getType(), type) || !Global.equals(attribute.getSubType(), subType) || attribute.getPayloadType() != payloadType) continue;
            return attribute;
        }
        return null;
    }

    public FeedbackAttribute getRelatedRtcpFeedbackAttribute(String type, String subType) {
        for (FeedbackAttribute attribute : this.getRelatedRtcpFeedbackAttributes()) {
            if (attribute == null || !Global.equals(attribute.getType(), type) || !Global.equals(attribute.getSubType(), subType)) continue;
            return attribute;
        }
        return null;
    }

    public FeedbackAttribute[] getRelatedRtcpFeedbackAttributes() {
        return this.__relatedRtcpFeedbackAttributes.toArray();
    }

    public MapAttribute(int payloadType, String formatName, int clockRate, String formatParameters) {
        super.setAttributeType(AttributeType.RtpMapAttribute);
        if (formatName == null) {
            throw new RuntimeException(new Exception("formatName cannot be null."));
        }
        this.setPayloadType(payloadType);
        this.setFormatName(formatName);
        this.setClockRate(clockRate);
        this.setFormatParameters(formatParameters);
    }

    private MapAttribute() {
        super.setAttributeType(AttributeType.RtpMapAttribute);
    }

    public MapAttribute(int payloadType, String formatName, int clockRate) {
        this(payloadType, formatName, clockRate, null);
    }

    public boolean removeRelatedRtcpFeedbackAttribute(FeedbackAttribute attribute) {
        return this.__relatedRtcpFeedbackAttributes.remove(attribute);
    }

    public void resetRtcpFeedbackAttributes(FeedbackAttribute[] attributes) {
        this.__relatedRtcpFeedbackAttributes.clear();
        for (FeedbackAttribute attribute : attributes) {
            this.__relatedRtcpFeedbackAttributes.addAttribute(attribute);
        }
    }

    private void setClockRate(int value) {
        this._clockRate = value;
    }

    private void setFormatName(String value) {
        this._formatName = value;
    }

    private void setFormatParameters(String value) {
        this._formatParameters = value;
    }

    private void setPayloadType(int value) {
        this._payloadType = value;
    }

    public void setRelatedFormatParametersAttribute(FormatParametersAttribute value) {
        this._relatedFormatParametersAttribute = value;
    }
}

