/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.ContentCompression;
import fm.icelink.matroska.Element;

public class ContentEncoding
extends Element {
    private ContentCompression _contentCompression;
    private long _contentEncodingOrder;
    private static byte[] _contentEncodingOrderId = new byte[]{80, 49};
    private long _contentEncodingScope;
    private static byte[] _contentEncodingScopeId = new byte[]{80, 50};
    private long _contentEncodingType;
    private static byte[] _contentEncodingTypeId = new byte[]{80, 51};

    public ContentEncoding() {
    }

    public ContentEncoding(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _contentEncodingOrderId)) {
                this.setContentEncodingOrder(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _contentEncodingScopeId)) {
                this.setContentEncodingScope(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _contentEncodingTypeId)) {
                this.setContentEncodingType(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, ContentCompression.getEbmlId())) {
                this.setContentCompression(new ContentCompression(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaContentEncoding: ", BitAssistant.getHexString(buffer)));
        }
    }

    public ContentCompression getContentCompression() {
        return this._contentCompression;
    }

    public long getContentEncodingOrder() {
        return this._contentEncodingOrder;
    }

    public long getContentEncodingScope() {
        return this._contentEncodingScope;
    }

    public long getContentEncodingType() {
        return this._contentEncodingType;
    }

    public static long getDefaultContentEncodingOrder() {
        return 0L;
    }

    public static long getDefaultContentEncodingScope() {
        return 1L;
    }

    public static long getDefaultContentEncodingType() {
        return 0L;
    }

    public static byte[] getEbmlId() {
        return new byte[]{98, 64};
    }

    @Override
    public byte[] getId() {
        return ContentEncoding.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (super.getWriteDefaultValues() || this.getContentEncodingOrder() != ContentEncoding.getDefaultContentEncodingOrder()) {
            super.writeUnsignedInteger(this.getContentEncodingOrder(), _contentEncodingOrderId, stream);
        }
        if (super.getWriteDefaultValues() || this.getContentEncodingScope() != ContentEncoding.getDefaultContentEncodingScope()) {
            super.writeUnsignedInteger(this.getContentEncodingScope(), _contentEncodingScopeId, stream);
        }
        if (super.getWriteDefaultValues() || this.getContentEncodingType() != ContentEncoding.getDefaultContentEncodingType()) {
            super.writeUnsignedInteger(this.getContentEncodingType(), _contentEncodingTypeId, stream);
        }
        if (this.getContentCompression() != null) {
            stream.writeBuffer(this.getContentCompression().getBytes());
        }
        return stream.toArray();
    }

    public void setContentCompression(ContentCompression value) {
        this._contentCompression = value;
    }

    public void setContentEncodingOrder(long value) {
        this._contentEncodingOrder = value;
    }

    public void setContentEncodingScope(long value) {
        this._contentEncodingScope = value;
    }

    public void setContentEncodingType(long value) {
        this._contentEncodingType = value;
    }
}

