/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.bzip2;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.Crc32;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;
import fm.icelink.Global;
import fm.icelink.IAction2;
import fm.icelink.IntegerExtensions;
import fm.icelink.LongExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.bzip2.Constants;
import fm.icelink.bzip2.Context;
import fm.icelink.bzip2.DecompressionState;
import fm.icelink.bzip2.DecompressorState;
import fm.icelink.bzip2.Rand;

public class Decompressor {
    private boolean _blockRandomised;
    private int _blockSize100k;
    private int _bsBuff;
    private int _bsLive;
    private long _computedBlockCRC;
    private long _computedCombinedCRC;
    private ByteCollection _crcBytes;
    private int _currentChar = -1;
    private DecompressorState _currentState = DecompressorState.START_BLOCK;
    private DecompressionState _data;
    private DataBufferStream _input;
    private int _last;
    private int _nInUse;
    private int _origPtr;
    private long _storedBlockCRC;
    private long _storedCombinedCRC;
    private int _su_ch2;
    private int _su_chPrev;
    private int _su_count;
    private int _su_i2;
    private int _su_j2;
    private int _su_rNToGo;
    private int _su_rTPos;
    private int _su_tPos;
    private char _su_z;
    private long _totalBytesRead;

    private static int add(int i1, int i2) {
        return i1 + i2;
    }

    private boolean bsGetBit() {
        return this.getBits(1) != 0;
    }

    private long bsGetInt() {
        long bits = this.getBits(8);
        long num2 = this.getBits(8);
        long num3 = this.getBits(8);
        long num4 = this.getBits(8);
        return (BitAssistant.leftShiftLong(BitAssistant.leftShiftLong(BitAssistant.leftShiftLong(bits, 8) | num2, 8) | num3, 8) | num4) & 0xFFFFFFFFL;
    }

    private int bsGetUByte() {
        return this.getBits(8) & 0xFF;
    }

    private void checkMagicChar(char expected, int position) {
        int num = this._input.read8();
        if (num != expected) {
            char num2 = expected;
            throw new RuntimeException(new Exception(StringExtensions.format("Not a valid BZip2 stream. byte {0}, expected '{1}', got '{2}'", IntegerExtensions.toString(position), IntegerExtensions.toString(Integer.valueOf(num2)), IntegerExtensions.toString(num))));
        }
    }

    private void complete() {
        this._storedCombinedCRC = this.bsGetInt();
        this._currentState = DecompressorState.EOF;
        this._data = null;
        if (this._storedCombinedCRC != this._computedCombinedCRC) {
            throw new RuntimeException(new Exception(StringExtensions.format("BZip2 CRC error (expected {0:X8}, computed {1:X8})", LongExtensions.toString(this._storedCombinedCRC), LongExtensions.toString(this._computedCombinedCRC))));
        }
    }

    private void createHuffmanDecodingTables(int alphaSize, int nGroups) {
        DecompressionState data = this._data;
        char[][] chArray = data._temp_charArray2d;
        for (int i = 0; i < nGroups; ++i) {
            int minLen = 32;
            int maxLen = 0;
            char[] chArray2 = chArray[i];
            int index = alphaSize;
            while (--index >= 0) {
                int ch = chArray2[index];
                if (ch > maxLen) {
                    maxLen = ch;
                }
                if (ch >= minLen) continue;
                minLen = ch;
            }
            Decompressor.hbCreateDecodeTables(data._gLimit[i], data._gBase[i], data._gPerm[i], chArray[i], minLen, maxLen, alphaSize);
            data._gMinlen[i] = minLen;
        }
    }

    public Decompressor(DataBuffer input) {
        this._input = new DataBufferStream(input);
        this.initialize();
    }

    private void doRunAB(DecompressionState s, byte[] yy, int limitLast, Context context) {
        int num = -1;
        int num2 = 1;
        while (true) {
            int num4;
            if (context.getNextSym() == Constants.getRuna()) {
                num += num2;
            } else if (context.getNextSym() == Constants.getRunb()) {
                num += BitAssistant.leftShiftInteger(num2, 1);
            } else {
                int index = s._seqToUnseq[yy[0] & 0xFF] & 0xFF;
                s._unzftab[index] = s._unzftab[index] + (num + 1);
                while (num-- >= 0) {
                    s._ll8[Global.increment(context, (int)context.getLastShadow(), new IAction2<Context, Integer>(){

                        @Override
                        public void invoke(Context target, Integer value) {
                            target.setLastShadow(value);
                        }
                    }, (boolean)true)] = (byte)index;
                }
                if (context.getLastShadow() >= limitLast) {
                    throw new RuntimeException(new Exception("block overrun"));
                }
                return;
            }
            if (context.getGroupPos() == 0) {
                context.setGroupPos(Constants.getG_size() - 1);
                context.setZt(s._selector[Global.increment(context, context.getGroupNo(), new IAction2<Context, Integer>(){

                    @Override
                    public void invoke(Context target, Integer value) {
                        target.setGroupNo(value);
                    }
                }, true)] & 0xFF);
                context.setBase_zt(s._gBase[context.getZt()]);
                context.setLimit_zt(s._gLimit[context.getZt()]);
                context.setPerm_zt(s._gPerm[context.getZt()]);
                context.setMinLens_zt(s._gMinlen[context.getZt()]);
            } else {
                Global.decrement(context, context.getGroupPos(), new IAction2<Context, Integer>(){

                    @Override
                    public void invoke(Context target, Integer value) {
                        target.setGroupPos(value);
                    }
                }, false);
            }
            int count = context.getMinLens_zt();
            while (context.getBsLiveShadow() < count) {
                num4 = this._input.readByte();
                if (num4 < 0) {
                    throw new RuntimeException(new Exception("unexpected end of stream"));
                }
                context.setBsBuffShadow(BitAssistant.leftShiftInteger(context.getBsBuffShadow(), 8) | num4);
                context.setBsLiveShadow(context.getBsLiveShadow() + 8);
            }
            int num5 = BitAssistant.rightShiftInteger(context.getBsBuffShadow(), context.getBsLiveShadow() - count) & BitAssistant.leftShiftInteger(1, count) - 1;
            context.setBsLiveShadow(context.getBsLiveShadow() - count);
            while (num5 > context.getLimit_zt()[count]) {
                ++count;
                while (context.getBsLiveShadow() < 1) {
                    num4 = this._input.readByte();
                    if (num4 < 0) {
                        throw new RuntimeException(new Exception("unexpected end of stream"));
                    }
                    context.setBsBuffShadow(BitAssistant.leftShiftInteger(context.getBsBuffShadow(), 8) | num4);
                    context.setBsLiveShadow(context.getBsLiveShadow() + 8);
                }
                Global.decrement(context, context.getBsLiveShadow(), new IAction2<Context, Integer>(){

                    @Override
                    public void invoke(Context target, Integer value) {
                        target.setBsLiveShadow(value);
                    }
                }, false);
                num5 = BitAssistant.leftShiftInteger(num5, 1) | BitAssistant.rightShiftInteger(context.getBsBuffShadow(), context.getBsLiveShadow()) & 1;
            }
            context.setNextSym(context.getPerm_zt()[num5 - context.getBase_zt()[count]]);
            num2 = BitAssistant.leftShiftInteger(num2, 1);
        }
    }

    private void endBlock() {
        this._computedBlockCRC = new Crc32(Crc32.getCrc32Polynomial(), true).compute(this._crcBytes.toArray());
        if (this._computedBlockCRC != this._storedBlockCRC) {
            throw new RuntimeException(new Exception(StringExtensions.format("BZip2 CRC error (expected {0:X8}, computed {1:X8})", LongExtensions.toString(this._storedBlockCRC), LongExtensions.toString(this._computedBlockCRC))));
        }
        this._computedCombinedCRC = BitAssistant.leftShiftLong(this._computedCombinedCRC, 1) | BitAssistant.rightShiftLong(this._computedCombinedCRC, 31);
        this._computedCombinedCRC ^= this._computedBlockCRC;
    }

    private void getAndMoveToFrontDecode() {
        DecompressionState data = this._data;
        this._origPtr = this.getBits(24);
        if (this._origPtr < 0) {
            throw new RuntimeException(new Exception("BZ_DATA_ERROR"));
        }
        if (this._origPtr > 10 + Constants.getBlockSizeMultiple() * this._blockSize100k) {
            throw new RuntimeException(new Exception("BZ_DATA_ERROR"));
        }
        this.recvDecodingTables();
        byte[] yy = data._getAndMoveToFrontDecode_yy;
        int limitLast = this._blockSize100k * Constants.getBlockSizeMultiple();
        int index = 256;
        while (--index >= 0) {
            yy[index] = (byte)index;
            data._unzftab[index] = 0;
        }
        int num3 = data._selector[0] & 0xFF;
        Context context2 = new Context();
        context2.setGroupNo(0);
        context2.setGroupPos(Constants.getG_size() - 1);
        context2.setEob(this._nInUse + 1);
        context2.setNextSym(this.getAndMoveToFrontDecode0(0));
        context2.setBsBuffShadow(this._bsBuff);
        context2.setBsLiveShadow(this._bsLive);
        context2.setLastShadow(-1);
        context2.setZt(num3);
        context2.setBase_zt(data._gBase[num3]);
        context2.setLimit_zt(data._gLimit[num3]);
        context2.setPerm_zt(data._gPerm[num3]);
        context2.setMinLens_zt(data._gMinlen[num3]);
        Context context = context2;
        while (context.getNextSym() != context.getEob()) {
            int num8;
            if (context.getNextSym() == Constants.getRuna() || context.getNextSym() == Constants.getRunb()) {
                this.doRunAB(data, yy, limitLast, context);
                continue;
            }
            if (Global.increment(context, context.getLastShadow(), new IAction2<Context, Integer>(){

                @Override
                public void invoke(Context target, Integer value) {
                    target.setLastShadow(value);
                }
            }, true) >= limitLast) {
                throw new RuntimeException(new Exception("block overrun"));
            }
            int num4 = yy[context.getNextSym() - 1] & 0xFF;
            int num5 = data._seqToUnseq[num4] & 0xFF;
            data._unzftab[num5] = Decompressor.increment(data._unzftab[num5], 1);
            data._ll8[context.getLastShadow()] = data._seqToUnseq[num4];
            if (context.getNextSym() <= 16) {
                for (int i = context.getNextSym() - 1; i > 0; --i) {
                    yy[i] = yy[i - 1];
                }
            } else {
                BitAssistant.copy(yy, 0, yy, 1, context.getNextSym() - 1);
            }
            yy[0] = (byte)num4;
            if (context.getGroupPos() == 0) {
                context.setGroupPos(Constants.getG_size() - 1);
                context.setZt(data._selector[Global.increment(context, context.getGroupNo(), new IAction2<Context, Integer>(){

                    @Override
                    public void invoke(Context target, Integer value) {
                        target.setGroupNo(value);
                    }
                }, true)] & 0xFF);
                context.setBase_zt(data._gBase[context.getZt()]);
                context.setLimit_zt(data._gLimit[context.getZt()]);
                context.setPerm_zt(data._gPerm[context.getZt()]);
                context.setMinLens_zt(data._gMinlen[context.getZt()]);
            } else {
                Global.decrement(context, context.getGroupPos(), new IAction2<Context, Integer>(){

                    @Override
                    public void invoke(Context target, Integer value) {
                        target.setGroupPos(value);
                    }
                }, false);
            }
            int count = context.getMinLens_zt();
            while (context.getBsLiveShadow() < count) {
                num8 = this._input.readByte();
                if (num8 < 0) {
                    throw new RuntimeException(new Exception("unexpected end of stream"));
                }
                context.setBsBuffShadow(BitAssistant.leftShiftInteger(context.getBsBuffShadow(), 8) | num8);
                context.setBsLiveShadow(context.getBsLiveShadow() + 8);
            }
            int num9 = BitAssistant.rightShiftInteger(context.getBsBuffShadow(), context.getBsLiveShadow() - count) & BitAssistant.leftShiftInteger(1, count) - 1;
            context.setBsLiveShadow(context.getBsLiveShadow() - count);
            while (num9 > context.getLimit_zt()[count]) {
                ++count;
                while (context.getBsLiveShadow() < 1) {
                    num8 = this._input.readByte();
                    if (num8 < 0) {
                        throw new RuntimeException(new Exception("unexpected end of stream"));
                    }
                    context.setBsBuffShadow(BitAssistant.leftShiftInteger(context.getBsBuffShadow(), 8) | num8);
                    context.setBsLiveShadow(context.getBsLiveShadow() + 8);
                }
                Global.decrement(context, context.getBsLiveShadow(), new IAction2<Context, Integer>(){

                    @Override
                    public void invoke(Context target, Integer value) {
                        target.setBsLiveShadow(value);
                    }
                }, false);
                num9 = BitAssistant.leftShiftInteger(num9, 1) | BitAssistant.rightShiftInteger(context.getBsBuffShadow(), context.getBsLiveShadow()) & 1;
            }
            context.setNextSym(context.getPerm_zt()[num9 - context.getBase_zt()[count]]);
        }
        this._last = context.getLastShadow();
        this._bsLive = context.getBsLiveShadow();
        this._bsBuff = context.getBsBuffShadow();
    }

    private int getAndMoveToFrontDecode0(int groupNo) {
        DecompressionState data = this._data;
        int index = data._selector[groupNo] & 0xFF;
        int[] numArray = data._gLimit[index];
        int n = data._gMinlen[index];
        int bits = this.getBits(n);
        int bsLive = this._bsLive;
        int bsBuff = this._bsBuff;
        while (bits > numArray[n]) {
            ++n;
            while (bsLive < 1) {
                int num6 = this._input.readByte();
                if (num6 < 0) {
                    throw new RuntimeException(new Exception("unexpected end of stream"));
                }
                bsBuff = BitAssistant.leftShiftInteger(bsBuff, 8) | num6;
                bsLive += 8;
            }
            bits = BitAssistant.leftShiftInteger(bits, 1) | BitAssistant.rightShiftInteger(bsBuff, --bsLive) & 1;
        }
        this._bsLive = bsLive;
        this._bsBuff = bsBuff;
        return data._gPerm[index][bits - data._gBase[index][n]];
    }

    private int getBits(int n) {
        int bsLive = this._bsLive;
        int bsBuff = this._bsBuff;
        if (bsLive < n) {
            do {
                int num3;
                if ((num3 = this._input.read8()) < 0) {
                    throw new RuntimeException(new Exception("unexpected end of stream"));
                }
                bsBuff = BitAssistant.leftShiftInteger(bsBuff, 8) | num3;
            } while ((bsLive += 8) < n);
            this._bsBuff = bsBuff;
        }
        this._bsLive = bsLive - n;
        return BitAssistant.rightShiftInteger(bsBuff, bsLive - n) & BitAssistant.leftShiftInteger(1, n) - 1;
    }

    private static void hbCreateDecodeTables(int[] limit, int[] bbase, int[] perm, char[] length, int minLen, int maxLen, int alphaSize) {
        int index;
        int num2 = 0;
        for (index = minLen; index <= maxLen; ++index) {
            for (int i = 0; i < alphaSize; ++i) {
                if (length[i] != index) continue;
                perm[num2++] = i;
            }
        }
        index = Constants.getMaxCodeLength();
        while (--index > 0) {
            bbase[index] = 0;
            limit[index] = 0;
        }
        for (index = 0; index < alphaSize; ++index) {
            int num4 = length[index] + '\u0001';
            bbase[num4] = Decompressor.increment(bbase[num4], 1);
        }
        for (index = 1; index < Constants.getMaxCodeLength(); ++index) {
            bbase[index] = bbase[index] + bbase[index - 1];
        }
        int num5 = 0;
        int num6 = bbase[index];
        for (index = minLen; index <= maxLen; ++index) {
            int num7 = bbase[index + 1];
            num6 = num7;
            limit[index] = (num5 += num7 - num6) - 1;
            num5 = BitAssistant.leftShiftInteger(num5, 1);
        }
        for (index = minLen + 1; index <= maxLen; ++index) {
            bbase[index] = BitAssistant.leftShiftInteger(limit[index - 1] + 1, 1) - bbase[index];
        }
    }

    private static int increment(int s, int index) {
        return s + 1;
    }

    private void initBlock() {
        int num = this.bsGetUByte();
        int num2 = this.bsGetUByte();
        int num3 = this.bsGetUByte();
        int num4 = this.bsGetUByte();
        int num5 = this.bsGetUByte();
        int num6 = this.bsGetUByte();
        if (num == 23 && num2 == 114 && num3 == 69 && num4 == 56 && num5 == 80 && num6 == 144) {
            this.complete();
        } else {
            if (num != 49 || num2 != 65 || num3 != 89 || num4 != 38 || num5 != 83 || num6 != 89) {
                this._currentState = DecompressorState.EOF;
                throw new RuntimeException(new Exception(StringExtensions.format("bad block header at offset 0x{0:X}", IntegerExtensions.toString(this._input.getPosition()))));
            }
            this._storedBlockCRC = this.bsGetInt();
            boolean bl = this._blockRandomised = this.getBits(1) == 1;
            if (this._data == null) {
                this._data = new DecompressionState(this._blockSize100k);
            }
            this.getAndMoveToFrontDecode();
            this._crcBytes = new ByteCollection();
            this._currentState = DecompressorState.START_BLOCK;
        }
    }

    private void initialize() {
        if (null == this._input) {
            throw new RuntimeException(new Exception("No input Stream"));
        }
        this.checkMagicChar('B', 0);
        this.checkMagicChar('Z', 1);
        this.checkMagicChar('h', 2);
        int num = this._input.read8();
        if (num < 49 || num > 57) {
            throw new RuntimeException(new Exception(StringExtensions.format("Stream is not BZip2 formatted: illegal blocksize {0}", IntegerExtensions.toString(num))));
        }
        this._blockSize100k = num - 48;
        this.initBlock();
        this.setupBlock();
    }

    private void makeMaps() {
        boolean[] inUse = this._data._inUse;
        byte[] seqToUnseq = this._data._seqToUnseq;
        int num = 0;
        for (int i = 0; i < 256; ++i) {
            if (!inUse[i]) continue;
            seqToUnseq[num++] = (byte)i;
        }
        this._nInUse = num;
    }

    public int read(byte[] buffer, int offset, int count) {
        int num3;
        if (offset < 0) {
            throw new RuntimeException(new Exception(StringExtensions.format("offset ({0}) must be > 0", IntegerExtensions.toString(offset))));
        }
        if (count < 0) {
            throw new RuntimeException(new Exception(StringExtensions.format("count ({0}) must be > 0", IntegerExtensions.toString(count))));
        }
        if (offset + count > ArrayExtensions.getLength(buffer)) {
            int length = ArrayExtensions.getLength(buffer);
            throw new RuntimeException(new Exception(StringExtensions.format("offset({0}) count({1}) bLength({2})", IntegerExtensions.toString(offset), IntegerExtensions.toString(count), IntegerExtensions.toString(length))));
        }
        if (this._input == null) {
            throw new RuntimeException(new Exception("the stream is not open"));
        }
        int num = offset + count;
        int num2 = offset;
        while (num2 < num && (num3 = this.readByte()) >= 0) {
            buffer[num2++] = (byte)num3;
        }
        return num2 == offset ? -1 : num2 - offset;
    }

    public int readByte() {
        int currentChar = this._currentChar;
        ++this._totalBytesRead;
        DecompressorState _var0 = this._currentState;
        if (_var0 == DecompressorState.EOF) {
            return -1;
        }
        if (_var0 == DecompressorState.START_BLOCK) {
            throw new RuntimeException(new Exception("bad state"));
        }
        if (_var0 == DecompressorState.RAND_PART_A) {
            throw new RuntimeException(new Exception("bad state"));
        }
        if (_var0 == DecompressorState.RAND_PART_B) {
            this.setupRandPartB();
            return currentChar;
        }
        if (_var0 == DecompressorState.RAND_PART_C) {
            this.setupRandPartC();
            return currentChar;
        }
        if (_var0 == DecompressorState.NO_RAND_PART_A) {
            throw new RuntimeException(new Exception("bad state"));
        }
        if (_var0 == DecompressorState.NO_RAND_PART_B) {
            this.setupNoRandPartB();
            return currentChar;
        }
        if (_var0 == DecompressorState.NO_RAND_PART_C) {
            this.setupNoRandPartC();
            return currentChar;
        }
        throw new RuntimeException(new Exception("bad state"));
    }

    private void recvDecodingTables() {
        int num4;
        int num2;
        DecompressionState data = this._data;
        boolean[] inUse = data._inUse;
        byte[] buffer = data._recvDecodingTables_pos;
        int num = 0;
        for (num2 = 0; num2 < 16; ++num2) {
            if (!this.bsGetBit()) continue;
            num |= BitAssistant.leftShiftInteger(1, num2);
        }
        num2 = 256;
        while (--num2 >= 0) {
            inUse[num2] = false;
        }
        for (num2 = 0; num2 < 16; ++num2) {
            if ((num & BitAssistant.leftShiftInteger(1, num2)) == 0) continue;
            int num3 = BitAssistant.leftShiftInteger(num2, 4);
            for (num4 = 0; num4 < 16; ++num4) {
                if (!this.bsGetBit()) continue;
                inUse[num3 + num4] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this._nInUse + 2;
        int bits = this.getBits(3);
        int num7 = this.getBits(15);
        for (num2 = 0; num2 < num7; ++num2) {
            num4 = 0;
            while (this.bsGetBit()) {
                ++num4;
            }
            data._selectorMtf[num2] = (byte)num4;
        }
        int index = bits;
        while (--index >= 0) {
            buffer[index] = (byte)index;
        }
        for (num2 = 0; num2 < num7; ++num2) {
            byte num9 = buffer[index];
            for (index = data._selectorMtf[num2]; index > 0; --index) {
                buffer[index] = buffer[index - 1];
            }
            buffer[0] = num9;
            data._selector[num2] = num9;
        }
        char[][] chArray = data._temp_charArray2d;
        for (int i = 0; i < bits; ++i) {
            int num11 = this.getBits(5);
            char[] chArray2 = chArray[i];
            for (num2 = 0; num2 < alphaSize; ++num2) {
                while (this.bsGetBit()) {
                    num11 += this.bsGetBit() ? -1 : 1;
                }
                chArray2[num2] = (char)num11;
            }
        }
        this.createHuffmanDecodingTables(alphaSize, bits);
    }

    private void setupBlock() {
        if (this._data != null) {
            int num;
            DecompressionState data = this._data;
            int[] numArray = data.initTT(this._last + 1);
            for (num = 0; num <= 255; ++num) {
                if (data._unzftab[num] >= 0 && data._unzftab[num] <= this._last) continue;
                throw new RuntimeException(new Exception("BZ_DATA_ERROR"));
            }
            data._cftab[0] = 0;
            for (num = 1; num <= 256; ++num) {
                data._cftab[num] = data._unzftab[num - 1];
            }
            for (num = 1; num <= 256; ++num) {
                data._cftab[num] = data._cftab[num] + data._cftab[num - 1];
            }
            for (num = 0; num <= 256; ++num) {
                if (data._cftab[num] >= 0 && data._cftab[num] <= this._last + 1) continue;
                throw new RuntimeException(new Exception(StringExtensions.format("BZ_DATA_ERROR: cftab[{0}]={1} last={2}", IntegerExtensions.toString(num), IntegerExtensions.toString(data._cftab[num]), IntegerExtensions.toString(this._last))));
            }
            for (num = 1; num <= 256; ++num) {
                if (data._cftab[num - 1] <= data._cftab[num]) continue;
                throw new RuntimeException(new Exception("BZ_DATA_ERROR"));
            }
            num = 0;
            int last = this._last;
            while (num <= last) {
                int index = data._ll8[num] & 0xFF;
                numArray[data._cftab[index]] = num++;
                data._cftab[index] = Decompressor.increment(data._cftab[index], index);
            }
            if (this._origPtr < 0 || this._origPtr >= ArrayExtensions.getLength(numArray)) {
                throw new RuntimeException(new Exception("stream corrupted"));
            }
            this._su_tPos = numArray[this._origPtr];
            this._su_count = 0;
            this._su_i2 = 0;
            this._su_ch2 = 256;
            if (this._blockRandomised) {
                this._su_rNToGo = 0;
                this._su_rTPos = 0;
                this.setupRandPartA();
            } else {
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartA() {
        if (this._su_i2 <= this._last) {
            int num;
            this._su_chPrev = this._su_ch2;
            this._su_ch2 = num = this._data._ll8[this._su_tPos] & 0xFF;
            this._su_tPos = this._data._tt[this._su_tPos];
            ++this._su_i2;
            this._currentChar = num;
            this._currentState = DecompressorState.NO_RAND_PART_B;
            this._crcBytes.add((byte)num);
        } else {
            this._currentState = DecompressorState.NO_RAND_PART_A;
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this._su_ch2 != this._su_chPrev) {
            this._su_count = 1;
            this.setupNoRandPartA();
        } else if (++this._su_count >= 4) {
            this._su_z = (char)(this._data._ll8[this._su_tPos] & 0xFF);
            this._su_tPos = this._data._tt[this._su_tPos];
            this._su_j2 = 0;
            this.setupNoRandPartC();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartC() {
        if (this._su_j2 < this._su_z) {
            int num;
            this._currentChar = num = this._su_ch2;
            this._crcBytes.add((byte)num);
            ++this._su_j2;
            this._currentState = DecompressorState.NO_RAND_PART_C;
        } else {
            ++this._su_i2;
            this._su_count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this._su_i2 <= this._last) {
            this._su_chPrev = this._su_ch2;
            int num = this._data._ll8[this._su_tPos] & 0xFF;
            this._su_tPos = this._data._tt[this._su_tPos];
            if (this._su_rNToGo == 0) {
                this._su_rNToGo = Rand.rnums(this._su_rTPos) - 1;
                if (++this._su_rTPos == 512) {
                    this._su_rTPos = 0;
                }
            } else {
                --this._su_rNToGo;
            }
            this._su_ch2 = num ^= this._su_rNToGo == 1 ? 1 : 0;
            ++this._su_i2;
            this._currentChar = num;
            this._currentState = DecompressorState.RAND_PART_B;
            this._crcBytes.add((byte)num);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this._su_ch2 != this._su_chPrev) {
            this._currentState = DecompressorState.RAND_PART_A;
            this._su_count = 1;
            this.setupRandPartA();
        } else if (++this._su_count >= 4) {
            this._su_z = (char)(this._data._ll8[this._su_tPos] & 0xFF);
            this._su_tPos = this._data._tt[this._su_tPos];
            if (this._su_rNToGo == 0) {
                this._su_rNToGo = Rand.rnums(this._su_rTPos) - 1;
                if (++this._su_rTPos == 512) {
                    this._su_rTPos = 0;
                }
            } else {
                --this._su_rNToGo;
            }
            this._su_j2 = 0;
            this._currentState = DecompressorState.RAND_PART_C;
            if (this._su_rNToGo == 1) {
                this._su_z = (char)(this._su_z ^ '\u0001');
            }
            this.setupRandPartC();
        } else {
            this._currentState = DecompressorState.RAND_PART_A;
            this.setupRandPartA();
        }
    }

    private void setupRandPartC() {
        if (this._su_j2 < this._su_z) {
            this._currentChar = this._su_ch2;
            this._crcBytes.add((byte)this._su_ch2);
            ++this._su_j2;
        } else {
            this._currentState = DecompressorState.RAND_PART_A;
            ++this._su_i2;
            this._su_count = 0;
            this.setupRandPartA();
        }
    }
}

