/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecContext;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioDepacketizer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioSink;
import fm.icelink.AudioTrack;
import fm.icelink.Dynamic;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioOutput;
import fm.icelink.IVideoInput;
import fm.icelink.IViewSinkableMedia;
import fm.icelink.IViewableMedia;
import fm.icelink.Log;
import fm.icelink.MediaSink;
import fm.icelink.MediaTrack;
import fm.icelink.RemoteMedia;
import fm.icelink.SoundConverter;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoTrack;
import fm.icelink.ViewSink;
import fm.icelink.pcmu.Decoder;
import fm.icelink.vp8.Depacketizer;
import java.util.ArrayList;

public abstract class RtcRemoteMedia<TView>
extends RemoteMedia
implements IViewSinkableMedia<TView, ViewSink<TView>>,
IViewableMedia<TView> {
    private ArrayList<AudioSink> __audioRecorders;
    private AudioConfig __opusConfig = new AudioConfig(48000, 2);
    private AudioConfig __pcmaConfig;
    private AudioConfig __pcmuConfig = new AudioConfig(8000, 1);
    private ArrayList<VideoSink> __videoRecorders;
    private AecContext _aecContext;
    private boolean _audioDisabled;
    private Object _audioRecordingLock;
    private VideoDecoder _h264Decoder;
    private AudioDecoder _opusDecoder;
    private AudioDecoder _pcmaDecoder;
    private AudioDecoder _pcmuDecoder;
    private boolean _videoDisabled;
    private Object _videoRecordingLock;
    private ViewSink<TView> _viewSink;
    private VideoDecoder _vp8Decoder;
    private VideoDecoder _vp9Decoder;

    protected abstract AudioSink createAudioRecorder(AudioFormat var1);

    protected abstract AudioSink createAudioSink(AudioConfig var1);

    private AudioTrack createAudioTrack(AudioDecoder decoder, AudioDepacketizer depacketizer) {
        Dynamic input;
        AudioTrack track = new AudioTrack(depacketizer);
        if (this.getAecDisabled()) {
            input = this.createAudioSink(decoder.getOutputConfig());
        } else {
            SoundConverter converter = new SoundConverter(this.getAecContext().getConfig());
            input = converter;
            converter.addOutput(this.getAecContext().getOutputMixer());
        }
        AudioSink audioRecorder = this.getAudioRecorder((AudioFormat)depacketizer.getOutputFormat());
        if (audioRecorder == null) {
            return (AudioTrack)((AudioTrack)track.next(decoder)).next(input);
        }
        return (AudioTrack)track.next(new AudioTrack[]{new AudioTrack(audioRecorder), (AudioTrack)new AudioTrack(decoder).next(input)});
    }

    protected abstract VideoDecoder createH264Decoder();

    protected abstract VideoPipe createImageConverter(VideoFormat var1);

    protected abstract AudioDecoder createOpusDecoder(AudioConfig var1);

    protected AudioDecoder createPcmaDecoder(AudioConfig config) {
        return new fm.icelink.pcma.Decoder(config);
    }

    protected AudioDecoder createPcmuDecoder(AudioConfig config) {
        return new Decoder(config);
    }

    protected abstract VideoSink createVideoRecorder(VideoFormat var1);

    private VideoTrack createVideoTrack(VideoDecoder decoder, VideoPipe depacketizer) {
        VideoTrack track = new VideoTrack(depacketizer);
        VideoSink videoRecorder = this.getVideoRecorder((VideoFormat)depacketizer.getOutputFormat());
        if (videoRecorder == null) {
            return (VideoTrack)track.next(decoder);
        }
        return (VideoTrack)track.next(new VideoTrack[]{new VideoTrack(videoRecorder), new VideoTrack(decoder)});
    }

    protected abstract ViewSink<TView> createViewSink();

    protected abstract VideoDecoder createVp8Decoder();

    protected abstract VideoDecoder createVp9Decoder();

    @Override
    public void destroy() {
        if (!this.getAecDisabled()) {
            for (IAudioOutput output : (IAudioOutput[])((AudioTrack)super.getAudioTrack()).getOutputs()) {
                output.removeOutput(this.getAecContext().getOutputMixer());
            }
        }
        for (AudioSink sink : this.__audioRecorders) {
            sink.destroy();
        }
        for (VideoSink sink2 : this.__videoRecorders) {
            sink2.destroy();
        }
        super.destroy();
    }

    public AecContext getAecContext() {
        return this._aecContext;
    }

    public boolean getAecDisabled() {
        return this.getAecContext() == null || this.getAudioDisabled();
    }

    public boolean getAudioDisabled() {
        return this._audioDisabled;
    }

    public IAudioInput[] getAudioInputs() {
        return (IAudioInput[])((AudioTrack)super.getAudioTrack()).getInputs();
    }

    private AudioSink getAudioRecorder(AudioFormat inputFormat) {
        AudioSink item = this.createAudioRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__audioRecorders.add(item);
        }
        return item;
    }

    public VideoDecoder getH264Decoder() {
        return this._h264Decoder;
    }

    public AudioDecoder getOpusDecoder() {
        return this._opusDecoder;
    }

    public AudioDecoder getPcmaDecoder() {
        return this._pcmaDecoder;
    }

    public AudioDecoder getPcmuDecoder() {
        return this._pcmuDecoder;
    }

    public boolean getVideoDisabled() {
        return this._videoDisabled;
    }

    public IVideoInput[] getVideoInputs() {
        return (IVideoInput[])((VideoTrack)super.getVideoTrack()).getInputs();
    }

    private VideoSink getVideoRecorder(VideoFormat inputFormat) {
        VideoSink item = this.createVideoRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__videoRecorders.add(item);
        }
        return item;
    }

    @Override
    public TView getView() {
        return this.getViewSink() == null ? null : (TView)((ViewSink)this.getViewSink()).getView();
    }

    @Override
    public ViewSink<TView> getViewSink() {
        return this._viewSink;
    }

    public VideoDecoder getVp8Decoder() {
        return this._vp8Decoder;
    }

    public VideoDecoder getVp9Decoder() {
        return this._vp9Decoder;
    }

    public void initialize() {
        try {
            VideoTrack track2;
            AudioTrack track;
            if (this.getAudioDisabled()) {
                track = new AudioTrack();
            } else {
                track = new AudioTrack();
                ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
                this.setOpusDecoder(this.createOpusDecoder(this.__opusConfig));
                if (this.getOpusDecoder() != null) {
                    list.add(this.createAudioTrack(this.getOpusDecoder(), new fm.icelink.opus.Depacketizer(this.getOpusDecoder().getConfig())));
                }
                this.setPcmuDecoder(this.createPcmuDecoder(this.__pcmuConfig));
                if (this.getPcmuDecoder() != null) {
                    list.add(this.createAudioTrack(this.getPcmuDecoder(), new fm.icelink.pcmu.Depacketizer(this.getPcmuDecoder().getConfig())));
                }
                this.setPcmaDecoder(this.createPcmaDecoder(this.__pcmaConfig));
                if (this.getPcmaDecoder() != null) {
                    list.add(this.createAudioTrack(this.getPcmaDecoder(), new fm.icelink.pcma.Depacketizer(this.getPcmaDecoder().getConfig())));
                }
                if (ArrayListExtensions.getCount(list) > 0) {
                    track = (AudioTrack)track.next((MediaTrack[])list.toArray(new AudioTrack[0]));
                }
            }
            this.addAudioTrack(track);
            if (this.getVideoDisabled()) {
                track2 = new VideoTrack();
            } else {
                track2 = new VideoTrack();
                ArrayList list2 = new ArrayList();
                this.setViewSink(this.createViewSink());
                this.setVp8Decoder(this.createVp8Decoder());
                if (this.getVp8Decoder() != null) {
                    list2.add(this.createVideoTrack(this.getVp8Decoder(), new Depacketizer()).next(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat())));
                }
                this.setH264Decoder(this.createH264Decoder());
                if (this.getH264Decoder() != null) {
                    list2.add(this.createVideoTrack(this.getH264Decoder(), new fm.icelink.h264.Depacketizer()).next(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat())));
                }
                this.setVp9Decoder(this.createVp9Decoder());
                if (this.getVp9Decoder() != null) {
                    list2.add(this.createVideoTrack(this.getVp9Decoder(), new fm.icelink.vp9.Depacketizer()).next(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat())));
                }
                if (ArrayListExtensions.getCount(list2) > 0) {
                    track2 = (VideoTrack)track2.next((MediaTrack[])list2.toArray(new VideoTrack[0]));
                }
                if (this.getViewSink() != null) {
                    track2 = (VideoTrack)((VideoTrack)track2.next(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat()))).next(this.getViewSink());
                }
            }
            this.addVideoTrack(track2);
        }
        catch (Exception exception) {
            Log.error("Error occured while initializing remote media.", exception);
            throw new RuntimeException(exception);
        }
    }

    public RtcRemoteMedia(boolean disableAudio, boolean disableVideo) {
        this(disableAudio, disableVideo, null);
    }

    public RtcRemoteMedia(boolean disableAudio, boolean disableVideo, AecContext aecContext) {
        this.__pcmaConfig = new AudioConfig(8000, 1);
        this.__audioRecorders = new ArrayList();
        this.__videoRecorders = new ArrayList();
        this._audioRecordingLock = new Object();
        this._videoRecordingLock = new Object();
        this.setAudioDisabled(disableAudio);
        this.setVideoDisabled(disableVideo);
        this.setAecContext(aecContext);
    }

    private void setAecContext(AecContext value) {
        this._aecContext = value;
    }

    private void setAudioDisabled(boolean value) {
        this._audioDisabled = value;
    }

    private void setH264Decoder(VideoDecoder value) {
        this._h264Decoder = value;
    }

    private void setOpusDecoder(AudioDecoder value) {
        this._opusDecoder = value;
    }

    private void setPcmaDecoder(AudioDecoder value) {
        this._pcmaDecoder = value;
    }

    private void setPcmuDecoder(AudioDecoder value) {
        this._pcmuDecoder = value;
    }

    private void setVideoDisabled(boolean value) {
        this._videoDisabled = value;
    }

    private void setViewSink(ViewSink<TView> value) {
        this._viewSink = value;
    }

    private void setVp8Decoder(VideoDecoder value) {
        this._vp8Decoder = value;
    }

    private void setVp9Decoder(VideoDecoder value) {
        this._vp9Decoder = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAudioRecording() {
        Object object = this._audioRecordingLock;
        synchronized (object) {
            super.setIsRecordingAudio(!super.getIsRecordingAudio());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingVideo() || super.getIsRecordingAudio());
            }
            for (AudioSink sink : this.__audioRecorders) {
                sink.setDisabled(!super.getIsRecordingAudio());
            }
            return super.getIsRecordingAudio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleVideoRecording() {
        Object object = this._videoRecordingLock;
        synchronized (object) {
            super.setIsRecordingVideo(!super.getIsRecordingVideo());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingVideo() || super.getIsRecordingAudio());
            }
            for (VideoSink sink : this.__videoRecorders) {
                sink.setDisabled(!super.getIsRecordingVideo());
            }
            return super.getIsRecordingVideo();
        }
    }
}

