/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecContext;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioConfig;
import fm.icelink.AudioEncoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioPacketizer;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;
import fm.icelink.AudioSource;
import fm.icelink.AudioTrack;
import fm.icelink.Global;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.IViewSinkableMedia;
import fm.icelink.IViewableMedia;
import fm.icelink.LocalMedia;
import fm.icelink.Log;
import fm.icelink.MediaSink;
import fm.icelink.MediaTrack;
import fm.icelink.SoundConverter;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoPacketizer;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoSource;
import fm.icelink.VideoTrack;
import fm.icelink.ViewSink;
import fm.icelink.pcmu.Encoder;
import fm.icelink.vp8.Packetizer;
import java.util.ArrayList;

public abstract class RtcLocalMedia<TView>
extends LocalMedia
implements IViewSinkableMedia<TView, ViewSink<TView>>,
IViewableMedia<TView> {
    private ArrayList<AudioSink> __audioRecorders;
    private AudioConfig __opusConfig = new AudioConfig(48000, 2);
    private AudioConfig __pcmaConfig;
    private AudioConfig __pcmuConfig = new AudioConfig(8000, 1);
    private ArrayList<VideoSink> __videoRecorders;
    private AecContext _aecContext;
    private boolean _audioDisabled;
    private Object _audioRecordingLock;
    private VideoEncoder _h264Encoder;
    private AudioEncoder _opusEncoder;
    private AudioEncoder _pcmaEncoder;
    private AudioEncoder _pcmuEncoder;
    private boolean _videoDisabled;
    private Object _videoRecordingLock;
    private ViewSink<TView> _viewSink;
    private VideoEncoder _vp8Encoder;
    private VideoEncoder _vp9Encoder;

    private void audioRecorderSource_OnDisabledChange(AudioPipe recorderSource) {
        if (super.getIsRecordingAudio() && !recorderSource.getDisabled()) {
            for (AudioSink sink : this.__audioRecorders) {
                sink.setDisabled(!recorderSource.hasOutput(sink));
            }
        }
    }

    protected abstract AudioSink createAudioRecorder(AudioFormat var1);

    protected abstract AudioSource createAudioSource(AudioConfig var1);

    private AudioTrack createAudioTrack(AudioEncoder encoder, AudioPacketizer packetizer) {
        AudioTrack track = (AudioTrack)new AudioTrack(new SoundConverter(encoder.getInputConfig())).next(encoder);
        AudioSink audioRecorder = this.getAudioRecorder((AudioFormat)encoder.getOutputFormat());
        if (audioRecorder == null) {
            return (AudioTrack)track.next(packetizer);
        }
        return (AudioTrack)track.next(new AudioTrack[]{new AudioTrack(audioRecorder), new AudioTrack(packetizer)});
    }

    protected abstract VideoEncoder createH264Encoder();

    protected abstract VideoPipe createImageConverter(VideoFormat var1);

    protected abstract VideoPipe createImageScaler();

    protected abstract AudioEncoder createOpusEncoder(AudioConfig var1);

    protected AudioEncoder createPcmaEncoder(AudioConfig config) {
        return new fm.icelink.pcma.Encoder(config);
    }

    protected AudioEncoder createPcmuEncoder(AudioConfig config) {
        return new Encoder(config);
    }

    protected abstract VideoSink createVideoRecorder(VideoFormat var1);

    protected abstract VideoSource createVideoSource();

    private VideoTrack createVideoTrack(VideoEncoder encoder, VideoPacketizer packetizer) {
        VideoTrack track = (VideoTrack)new VideoTrack(this.createImageConverter((VideoFormat)encoder.getInputFormat())).next(encoder);
        VideoSink videoRecorder = this.getVideoRecorder((VideoFormat)encoder.getOutputFormat());
        if (videoRecorder == null) {
            return (VideoTrack)track.next(packetizer);
        }
        return (VideoTrack)track.next(new VideoTrack[]{new VideoTrack(videoRecorder), new VideoTrack(packetizer)});
    }

    protected abstract ViewSink<TView> createViewSink();

    protected abstract VideoEncoder createVp8Encoder();

    protected abstract VideoEncoder createVp9Encoder();

    @Override
    public void destroy() {
        if (!this.getAecDisabled()) {
            this.getAecContext().destroy();
        }
        for (AudioSink sink : this.__audioRecorders) {
            sink.destroy();
        }
        for (VideoSink sink2 : this.__videoRecorders) {
            sink2.destroy();
        }
        super.destroy();
    }

    public AecContext getAecContext() {
        return this._aecContext;
    }

    public boolean getAecDisabled() {
        return this.getAecContext() == null || this.getAudioDisabled();
    }

    public boolean getAudioDisabled() {
        return this._audioDisabled;
    }

    public IAudioOutput[] getAudioOutputs() {
        return (IAudioOutput[])((AudioTrack)super.getAudioTrack()).getOutputs();
    }

    private AudioSink getAudioRecorder(AudioFormat inputFormat) {
        AudioSink item = this.createAudioRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__audioRecorders.add(item);
        }
        return item;
    }

    public VideoEncoder getH264Encoder() {
        return this._h264Encoder;
    }

    public AudioEncoder getOpusEncoder() {
        return this._opusEncoder;
    }

    public AudioEncoder getPcmaEncoder() {
        return this._pcmaEncoder;
    }

    public AudioEncoder getPcmuEncoder() {
        return this._pcmuEncoder;
    }

    public boolean getVideoDisabled() {
        return this._videoDisabled;
    }

    public IVideoOutput[] getVideoOutputs() {
        return (IVideoOutput[])((VideoTrack)super.getVideoTrack()).getOutputs();
    }

    private VideoSink getVideoRecorder(VideoFormat inputFormat) {
        VideoSink item = this.createVideoRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__videoRecorders.add(item);
        }
        return item;
    }

    @Override
    public TView getView() {
        return this.getViewSink() == null ? null : (TView)((ViewSink)this.getViewSink()).getView();
    }

    @Override
    public ViewSink<TView> getViewSink() {
        return this._viewSink;
    }

    public VideoEncoder getVp8Encoder() {
        return this._vp8Encoder;
    }

    public VideoEncoder getVp9Encoder() {
        return this._vp9Encoder;
    }

    public void initialize() {
        try {
            VideoTrack track2;
            AudioTrack track;
            if (this.getAudioDisabled()) {
                track = new AudioTrack();
            } else {
                track = new AudioTrack(this.createAudioSource(this.__opusConfig));
                if (!this.getAecDisabled()) {
                    track = (AudioTrack)((AudioTrack)track.next(new SoundConverter(this.getAecContext().getProcessor().getConfig()))).next(this.getAecContext().getProcessor());
                }
                ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
                this.setOpusEncoder(this.createOpusEncoder(this.__opusConfig));
                if (this.getOpusEncoder() != null) {
                    list.add(this.createAudioTrack(this.getOpusEncoder(), new fm.icelink.opus.Packetizer(this.getOpusEncoder().getConfig())));
                }
                this.setPcmuEncoder(this.createPcmuEncoder(this.__pcmuConfig));
                if (this.getPcmuEncoder() != null) {
                    list.add(this.createAudioTrack(this.getPcmuEncoder(), new fm.icelink.pcmu.Packetizer(this.getPcmuEncoder().getConfig())));
                }
                this.setPcmaEncoder(this.createPcmaEncoder(this.__pcmaConfig));
                if (this.getPcmaEncoder() != null) {
                    list.add(this.createAudioTrack(this.getPcmaEncoder(), new fm.icelink.pcma.Packetizer(this.getPcmaEncoder().getConfig())));
                }
                if (ArrayListExtensions.getCount(list) > 0) {
                    track = (AudioTrack)track.next((MediaTrack[])list.toArray(new AudioTrack[0]));
                }
            }
            this.addAudioTrack(track);
            if (this.getVideoDisabled()) {
                track2 = new VideoTrack();
            } else {
                track2 = new VideoTrack(this.createVideoSource());
                ArrayList<Object> list2 = new ArrayList<Object>();
                this.setViewSink(this.createViewSink());
                if (this.getViewSink() != null) {
                    list2.add(new VideoTrack(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat())).next(this.getViewSink()));
                }
                this.setVp8Encoder(this.createVp8Encoder());
                if (this.getVp8Encoder() != null) {
                    list2.add(this.createVideoTrack(this.getVp8Encoder(), new Packetizer()));
                }
                this.setH264Encoder(this.createH264Encoder());
                if (this.getH264Encoder() != null) {
                    list2.add(this.createVideoTrack(this.getH264Encoder(), new fm.icelink.h264.Packetizer()));
                }
                this.setVp9Encoder(this.createVp9Encoder());
                if (this.getVp9Encoder() != null) {
                    list2.add(this.createVideoTrack(this.getVp9Encoder(), new fm.icelink.vp9.Packetizer()));
                }
                if (ArrayListExtensions.getCount(list2) > 0) {
                    track2 = (VideoTrack)track2.next((MediaTrack[])list2.toArray(new VideoTrack[0]));
                }
            }
            this.addVideoTrack(track2);
            for (AudioSink sink : this.__audioRecorders) {
                AudioPipe input = Global.tryCast(sink.getInput(), AudioPipe.class);
                if (input == null) continue;
                input.addOnDisabledChange(new IActionDelegate1<AudioPipe>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.RtcLocalMedia<TView>.audioRecorderSource_OnDisabledChange";
                    }

                    @Override
                    public void invoke(AudioPipe recorderSource) {
                        RtcLocalMedia.this.audioRecorderSource_OnDisabledChange(recorderSource);
                    }
                });
            }
            for (VideoSink sink2 : this.__videoRecorders) {
                VideoPipe pipe2 = Global.tryCast(sink2.getInput(), VideoPipe.class);
                if (pipe2 == null) continue;
                pipe2.addOnDisabledChange(new IActionDelegate1<VideoPipe>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.RtcLocalMedia<TView>.videoRecorderSource_OnDisabledChange";
                    }

                    @Override
                    public void invoke(VideoPipe recorderSource) {
                        RtcLocalMedia.this.videoRecorderSource_OnDisabledChange(recorderSource);
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.error("Error initializing local media.", exception);
            throw new RuntimeException(exception);
        }
    }

    public RtcLocalMedia(boolean disableAudio, boolean disableVideo) {
        this(disableAudio, disableVideo, null);
    }

    public RtcLocalMedia(boolean disableAudio, boolean disableVideo, AecContext aecContext) {
        this.__pcmaConfig = new AudioConfig(8000, 1);
        this.__audioRecorders = new ArrayList();
        this.__videoRecorders = new ArrayList();
        this._audioRecordingLock = new Object();
        this._videoRecordingLock = new Object();
        this.setAudioDisabled(disableAudio);
        this.setVideoDisabled(disableVideo);
        this.setAecContext(aecContext);
    }

    public RtcLocalMedia() {
        this(false, false);
    }

    private void setAecContext(AecContext value) {
        this._aecContext = value;
    }

    private void setAudioDisabled(boolean value) {
        this._audioDisabled = value;
    }

    private void setH264Encoder(VideoEncoder value) {
        this._h264Encoder = value;
    }

    private void setOpusEncoder(AudioEncoder value) {
        this._opusEncoder = value;
    }

    private void setPcmaEncoder(AudioEncoder value) {
        this._pcmaEncoder = value;
    }

    private void setPcmuEncoder(AudioEncoder value) {
        this._pcmuEncoder = value;
    }

    private void setVideoDisabled(boolean value) {
        this._videoDisabled = value;
    }

    private void setViewSink(ViewSink<TView> value) {
        this._viewSink = value;
    }

    private void setVp8Encoder(VideoEncoder value) {
        this._vp8Encoder = value;
    }

    private void setVp9Encoder(VideoEncoder value) {
        this._vp9Encoder = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAudioRecording() {
        Object object = this._audioRecordingLock;
        synchronized (object) {
            super.setIsRecordingAudio(!super.getIsRecordingAudio());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingAudio() || super.getIsRecordingVideo());
            }
            if (ArrayExtensions.getLength(((AudioTrack)super.getAudioTrack()).getOutputs()) > 0 && ((IAudioOutput[])((AudioTrack)super.getAudioTrack()).getOutputs())[0].getOutput() != null) {
                if (super.getIsRecordingAudio()) {
                    for (AudioSink sink : this.__audioRecorders) {
                        if (Global.tryCast(sink.getInput(), AudioPipe.class).getDisabled()) continue;
                        sink.setDisabled(false);
                        break;
                    }
                } else {
                    for (AudioSink sink : this.__audioRecorders) {
                        sink.setDisabled(true);
                    }
                }
            } else {
                ArrayListExtensions.getItem(this.__audioRecorders).get(0).setDisabled(!super.getIsRecordingAudio());
            }
            return super.getIsRecordingAudio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleVideoRecording() {
        Object object = this._videoRecordingLock;
        synchronized (object) {
            super.setIsRecordingVideo(!super.getIsRecordingVideo());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingAudio() || super.getIsRecordingVideo());
            }
            if (ArrayExtensions.getLength(((VideoTrack)super.getVideoTrack()).getOutputs()) > 0 && ((IVideoOutput[])((VideoTrack)super.getVideoTrack()).getOutputs())[0].getOutput() != null) {
                if (super.getIsRecordingVideo()) {
                    for (VideoSink sink : this.__videoRecorders) {
                        if (sink.getInput() == null || Global.tryCast(sink.getInput(), VideoPipe.class).getDisabled()) continue;
                        sink.setDisabled(false);
                        break;
                    }
                } else {
                    for (VideoSink sink : this.__videoRecorders) {
                        sink.setDisabled(true);
                    }
                }
            } else {
                ArrayListExtensions.getItem(this.__videoRecorders).get(0).setDisabled(!super.getIsRecordingVideo());
            }
            return super.getIsRecordingVideo();
        }
    }

    private void videoRecorderSource_OnDisabledChange(VideoPipe recorderSource) {
        if (super.getIsRecordingVideo() && !recorderSource.getDisabled()) {
            for (VideoSink sink : this.__videoRecorders) {
                sink.setDisabled(!recorderSource.hasOutput(sink));
            }
        }
    }
}

