/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.CoreTransport;
import fm.icelink.DateExtensions;
import fm.icelink.EncryptionMode;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaInputCollection;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaOutputCollection;
import fm.icelink.IMediaTransport;
import fm.icelink.IOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterConfig;
import fm.icelink.JsonSerializer;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaStreamBase;
import fm.icelink.MediaStreamStats;
import fm.icelink.MediaTrackStats;
import fm.icelink.MediaTransportState;
import fm.icelink.NackConfig;
import fm.icelink.NackPolicy;
import fm.icelink.PliControlFrame;
import fm.icelink.RedFecConfig;
import fm.icelink.RedFecPolicy;
import fm.icelink.RtpParameters;
import fm.icelink.RtpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.sdp.Bandwidth;
import fm.icelink.sdp.DirectionAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.rtcp.Attribute;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttributeType;
import fm.icelink.sdp.rtcp.MuxAttribute;
import fm.icelink.sdp.rtp.MapAttribute;
import fm.icelink.sdp.rtp.Media;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.rtp.SsrcAttributeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class MediaStream<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIOutputCollection extends IMediaOutputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIOutputCollection>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInputCollection extends IMediaInputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIInputCollection>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaStreamBase
implements IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private TIOutputCollection __inputs;
    private TFormatCollection __localFormatRegistry;
    private NackConfig __nackConfig;
    private NackPolicy __nackPolicy;
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private TIInputCollection __outputs;
    private ArrayList<TFormat> __payloadTypeRegistry;
    private ArrayList<String> __payloadTypesRegisteredByOtherStreams;
    private RedFecConfig __redFecConfig;
    private RedFecPolicy __redFecPolicy;
    private TFormatCollection __remoteFormatRegistry;
    private boolean __remoteSupportsFec = false;
    private boolean __remoteSupportsPli = false;
    private int __rtpPayloadTypeDynamicOffset = 96;
    private int __rtpPayloadTypeMaxOffset = 127;
    private RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> __rtpTransport;
    private boolean __startedOriginalNegotiation = false;
    private HashMap<String, TFormat> __wellKnownPayloadTypes;
    private boolean _disableAutomaticReports;
    private TFormat _inputFormat;
    private JitterConfig _jitterConfig;
    private boolean _multiplexingSupported;
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onProcessControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onProcessFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onProcessFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onRaiseControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onRaiseFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onRaiseFrame)) {
                action.invoke(p0);
            }
        }
    };
    private TFormat _outputFormat;
    private RtpParameters<TFormat, TFormatCollection> _rtpParameters;

    @Override
    public void addInput(TIOutput input) {
        ((Collection)this.__inputs).add(input);
    }

    @Override
    public void addInputs(TIOutput[] inputs) {
        ((Collection)this.__inputs).addMany(inputs);
    }

    private void addLocalFormat(TFormat format) {
        TFormat equivalent;
        int registeredPayloadType = ((MediaFormat)format).getRegisteredPayloadType();
        if (((Collection)this.__remoteFormatRegistry).getCount() > 0 && (equivalent = ((MediaFormatCollection)this.__remoteFormatRegistry).getEquivalent(format)) != null) {
            ((MediaFormat)format).setRegisteredPayloadType(((MediaFormat)equivalent).getRegisteredPayloadType());
            registeredPayloadType = ((MediaFormat)equivalent).getRegisteredPayloadType();
        }
        if (((MediaFormat)format).getRegisteredPayloadType() >= 0) {
            ((Collection)this.__localFormatRegistry).add(format);
            if (!this.payloadTypeIsRegistered(registeredPayloadType) && ((MediaFormat)format).getRegisteredPayloadType() >= 0) {
                this.__payloadTypeRegistry.add(format);
            }
        }
    }

    @Override
    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onProcessControlFrames.add(value);
    }

    @Override
    public void addOnProcessFrame(IAction1<TFrame> value) {
        this.__onProcessFrame.add(value);
    }

    @Override
    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onRaiseControlFrames.add(value);
    }

    @Override
    public void addOnRaiseFrame(IAction1<TFrame> value) {
        this.__onRaiseFrame.add(value);
    }

    @Override
    public void addOutput(TIInput output) {
        ((Collection)this.__outputs).add(output);
    }

    @Override
    public void addOutputs(TIInput[] outputs) {
        ((Collection)this.__outputs).addMany(outputs);
    }

    protected abstract TFormat createFormat(MapAttribute var1);

    protected abstract TFormat createFormat(String var1, int var2, String var3, int var4);

    protected abstract TIInputCollection createInputCollection(TIOutput var1);

    protected abstract TFormatCollection createMediaFormatCollection();

    protected abstract TIOutputCollection createOutputCollection(TIInput var1);

    @Override
    public MediaDescription createSdpMediaDescription(Message sdpMessage, boolean supportSdes, boolean isOffer, boolean renegotiation) {
        StreamDirection localDirection;
        this.getRtpParameters().setCanonicalName(super.getCanonicalName());
        MediaDescription description = super.createSdpMediaDescription(sdpMessage, supportSdes, isOffer, renegotiation);
        if (this.getMultiplexingSupported() && !Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.Inactive)) {
            CoreTransport coreTransport;
            description.addMediaAttribute(new MuxAttribute());
            String connectionAddress = "0.0.0.0";
            int port = 9;
            CoreTransport coreTransport2 = coreTransport = super.getCoreTransportRtcp() == null ? super.getCoreTransportRtp() : super.getCoreTransportRtcp();
            if (coreTransport != null) {
                TransportAddress address = super.obtainLikelyTransportAddress(coreTransport);
                connectionAddress = address.getIPAddress();
                port = address.getPort();
            } else {
                port = 0;
            }
            description.addMediaAttribute(new Attribute(super.getDisabled() ? 0 : port, connectionAddress));
        }
        StreamDirection streamDirection = localDirection = isOffer && super.getRenegotiationPending() ? super.getPendingLocalDirection() : this.getDirection();
        if (!renegotiation) {
            if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.Unset)) {
                this.setLocalDirection(this.getDirectionCapabilities());
            }
            localDirection = isOffer ? this.getLocalDirection() : this.getDirection();
        }
        StreamDirection direction2 = localDirection;
        DirectionAttribute attribute = DirectionAttribute.generateDirectionAttribute(direction2);
        description.addMediaAttribute(attribute);
        for (MediaDescription description2 : sdpMessage.getMediaDescriptions()) {
            fm.icelink.sdp.Attribute[] rtpMapAttributes;
            for (fm.icelink.sdp.Attribute attribute2 : rtpMapAttributes = description2.getRtpMapAttributes()) {
                MapAttribute attribute3 = (MapAttribute)attribute2;
                this.__payloadTypesRegisteredByOtherStreams.add(IntegerExtensions.toString(attribute3.getPayloadType()));
            }
        }
        this.registerPayloadTypes();
        description.getMedia().setMediaType(MediaType.fromStreamType(super.getType()));
        if (!Global.equals((Object)super.getEncryptionMode(), (Object)EncryptionMode.Null)) {
            if (super.getUseDtls()) {
                if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                    description.getMedia().setTransportProtocol(Media.getUdpTlsRtpSavpfTransportProtocol());
                } else if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                    description.getMedia().setTransportProtocol(Media.getUdpTlsRtpSavpfTransportProtocol());
                }
            } else if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                description.getMedia().setTransportProtocol(Media.getRtpSavpfTransportProtocol());
            } else if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                description.getMedia().setTransportProtocol(Media.getRtpSavpfTransportProtocol());
            }
        } else if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
            description.getMedia().setTransportProtocol(Media.getRtpAvpfTransportProtocol());
        } else if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
            description.getMedia().setTransportProtocol(Media.getRtpAvpfTransportProtocol());
        }
        description.getMedia().setFormatDescription(this.obtainFormatDescriptions());
        MapAttribute attribute4 = null;
        boolean flag = Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated);
        boolean flag2 = Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Negotiated);
        for (MediaFormat local : (MediaFormat[])((Collection)this.__localFormatRegistry).getValues()) {
            boolean flag3 = this.formatIsFec(local.getName());
            if (!this.payloadTypeIsRegistered(local.getRegisteredPayloadType()) || flag3 && (!flag3 || !flag)) continue;
            attribute4 = new MapAttribute(local.getRegisteredPayloadType(), local.getName(), local.getClockRate(), local.getParameters());
            description.addMediaAttribute(attribute4);
            if (!flag2 || flag3) continue;
            FeedbackAttribute attribute5 = new FeedbackAttribute(local.getRegisteredPayloadType(), FeedbackAttributeType.getNack());
            attribute4.addRelatedRtcpFeedbackAttribute(attribute5);
        }
        for (Bandwidth bandwidth : description.getBandwidths()) {
            description.removeBandwidth(bandwidth);
        }
        if (super.getLocalBandwidth() > 0) {
            description.addBandwidth(new Bandwidth("TIAS", super.getLocalBandwidth() * 1024));
            description.addBandwidth(new Bandwidth("AS", super.getLocalBandwidth()));
        }
        return description;
    }

    @Override
    public boolean destroy() {
        ((IMediaInputCollection)this.__outputs).destroy();
        ((IMediaOutputCollection)this.__inputs).destroy();
        return true;
    }

    private MediaControlFrame[] filterUnsupportedControlFrames(MediaControlFrame[] controlFrames) {
        ArrayList<MediaControlFrame> list = new ArrayList<MediaControlFrame>();
        for (MediaControlFrame frame : controlFrames) {
            if (!this.__remoteSupportsPli && frame instanceof PliControlFrame) continue;
            list.add(frame);
        }
        return list.toArray(new MediaControlFrame[0]);
    }

    private boolean formatIsFec(String formatName) {
        return Global.equals(formatName, MediaFormat.getRedName()) || Global.equals(formatName, MediaFormat.getUlpFecName());
    }

    @Override
    StreamDirection getDirectionCapabilities() {
        boolean flag2;
        boolean flag = ArrayExtensions.getLength(this.getInputs()) > 0;
        boolean bl = flag2 = ArrayExtensions.getLength(this.getOutputs()) > 0;
        if (flag && flag2) {
            return StreamDirection.SendReceive;
        }
        if (flag) {
            return StreamDirection.SendOnly;
        }
        if (flag2) {
            return StreamDirection.ReceiveOnly;
        }
        return StreamDirection.Inactive;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    @Override
    public TIOutput getInput() {
        return (TIOutput)((IMediaOutput)((Collection)this.__inputs).getValue());
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    @Override
    public TIOutput[] getInputs() {
        return (IMediaOutput[])((Collection)this.__inputs).getValues();
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public boolean getMultiplexed() {
        return super.getCoreTransportRtcp() == null;
    }

    public boolean getMultiplexingSupported() {
        return this._multiplexingSupported;
    }

    @Override
    public boolean getMuted() {
        return this.processGetMuteFromStream();
    }

    public NackConfig getNackConfig() {
        if (this.__nackConfig == null) {
            boolean flag = false;
            if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                flag = true;
            } else if (!this.__startedOriginalNegotiation) {
                flag = Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Disabled);
            }
            NackConfig config = new NackConfig();
            config.setDisableBuffering(flag);
            this.__nackConfig = config;
            if (flag) {
                this.__nackConfig.setReceiveBufferLength(0);
                this.__nackConfig.setSendBufferLength(0);
            }
        }
        return this.__nackConfig;
    }

    public boolean getNackEnabled() {
        return !this.getNackConfig().getDisableBuffering();
    }

    public NackPolicy getNackPolicy() {
        return this.__nackPolicy;
    }

    @Override
    public TIInput getOutput() {
        return (TIInput)((IMediaInput)((Collection)this.__outputs).getValue());
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public TIInput[] getOutputs() {
        return (IMediaInput[])((Collection)this.__outputs).getValues();
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput(), ", ", this.getPipelineJsonOutput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", super.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromInput() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), " }"});
    }

    @Override
    public String getPipelineJsonFromOutput() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"inputFormat\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    private String getPipelineJsonInputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaOutput local : this.getInputs()) {
            list.add(local.getPipelineJsonFromOutput());
        }
        return StringExtensions.concat("\"inputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"outputFormat\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    private String getPipelineJsonOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaInput local : this.getOutputs()) {
            list.add(local.getPipelineJsonFromInput());
        }
        return StringExtensions.concat("\"outputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    TFormat getPreferredFormat() {
        if (((Collection)this.getRtpParameters().getNegotiatedFormats()).getCount() == 0) {
            return null;
        }
        return (TFormat)((MediaFormat[])((Collection)this.getRtpParameters().getNegotiatedFormats()).getValues())[0];
    }

    public RedFecConfig getRedFecConfig() {
        if (this.__redFecConfig == null) {
            boolean flag = false;
            if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                flag = true;
            } else if (!this.__startedOriginalNegotiation) {
                flag = Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Disabled);
            }
            RedFecConfig config = new RedFecConfig();
            config.setDisabled(flag);
            this.__redFecConfig = config;
        }
        return this.__redFecConfig;
    }

    public boolean getRedFecEnabled() {
        return !this.getRedFecConfig().getDisabled();
    }

    public RedFecPolicy getRedFecPolicy() {
        return this.__redFecPolicy;
    }

    private TFormat getRegisteredFormat(int payloadType) {
        for (MediaFormat local : this.__payloadTypeRegistry) {
            if (local.getRegisteredPayloadType() != payloadType) continue;
            return (TFormat)local;
        }
        return null;
    }

    RtpParameters<TFormat, TFormatCollection> getRtpParameters() {
        return this._rtpParameters;
    }

    RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getRtpTransport() {
        return this.__rtpTransport;
    }

    MediaStreamStats getStats() {
        CoreTransport coreTransportRtp;
        MediaStreamStats stats5 = new MediaStreamStats();
        stats5.setId(super.getId());
        stats5.setTimestamp(DateExtensions.getUtcNow());
        stats5.setDirection(this.getDirection());
        stats5.setType(super.getType());
        MediaStreamStats stats = stats5;
        RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport = this.getRtpTransport();
        if (rtpTransport != null) {
            MediaTrackStats stats2;
            if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendOnly)) {
                stats.setSender(rtpTransport.getSenderStats());
                IOutput input = this.getInput();
                if (input != null) {
                    MediaTrackStats stats3 = new MediaTrackStats();
                    stats3.setId(input.getId());
                    stats3.setTimestamp(DateExtensions.getUtcNow());
                    stats3.setSynchronizationSources(rtpTransport.getLocalSynchronizationSources());
                    stats2 = stats3;
                    input.processStatsFromOutput(stats2);
                    stats.getSender().setTrack(stats2);
                }
            }
            if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
                stats.setReceiver(rtpTransport.getReceiverStats());
                IInput output = this.getOutput();
                if (output != null) {
                    MediaTrackStats stats4 = new MediaTrackStats();
                    stats4.setId(output.getId());
                    stats4.setTimestamp(DateExtensions.getUtcNow());
                    stats4.setSynchronizationSources(rtpTransport.getRemoteSynchronizationSources());
                    stats4.setDetached(false);
                    stats4.setStopped(false);
                    stats4.setFrameWidth(0);
                    stats4.setFrameHeight(0);
                    stats4.setFrameRate(0);
                    stats4.setFramesSent(0L);
                    stats4.setFramesReceived(0L);
                    stats4.setFramesDropped(0L);
                    stats4.setFramesCorrupted(0L);
                    stats4.setFramesDecoded(0L);
                    stats2 = stats4;
                    output.processStatsFromInput(stats2);
                    stats.getReceiver().setTrack(stats2);
                }
            }
        }
        if ((coreTransportRtp = super.getCoreTransportRtp()) != null) {
            stats.setTransport(coreTransportRtp.getStats());
            CoreTransport coreTransportRtcp = super.getCoreTransportRtcp();
            if (coreTransportRtcp != null && !Global.equals(coreTransportRtcp, coreTransportRtp)) {
                stats.getTransport().setRtcpTransport(coreTransportRtcp.getStats());
            }
        }
        return stats;
    }

    public MediaStream(StreamType type, JitterConfig jitterConfig) {
        super(type);
        this.__payloadTypeRegistry = new ArrayList();
        this.__redFecPolicy = RedFecPolicy.Negotiated;
        this.__nackPolicy = NackPolicy.Negotiated;
        this.__payloadTypesRegisteredByOtherStreams = new ArrayList();
        this.setMultiplexingSupported(true);
        this.setJitterConfig(jitterConfig);
        this.setRtpParameters(new RtpParameters(this.createMediaFormatCollection()));
        this.__outputs = this.createInputCollection(this);
        this.__inputs = this.createOutputCollection(this);
        this.__localFormatRegistry = this.createMediaFormatCollection();
        this.__remoteFormatRegistry = this.createMediaFormatCollection();
        HashMap dictionary = new HashMap();
        HashMapExtensions.add(dictionary, "0", this.createFormat("PCMU", 8000, null, 0));
        HashMapExtensions.add(dictionary, "3", this.createFormat("GSM", 8000, null, 3));
        HashMapExtensions.add(dictionary, "4", this.createFormat("G723", 8000, null, 4));
        HashMapExtensions.add(dictionary, "5", this.createFormat("DVI4", 8000, null, 5));
        HashMapExtensions.add(dictionary, "6", this.createFormat("DVI4", 16000, null, 6));
        HashMapExtensions.add(dictionary, "7", this.createFormat("LPC", 8000, null, 7));
        HashMapExtensions.add(dictionary, "8", this.createFormat("PCMA", 8000, null, 8));
        HashMapExtensions.add(dictionary, "9", this.createFormat("G722", 8000, null, 9));
        HashMapExtensions.add(dictionary, "10", this.createFormat("L16", 44100, null, 10));
        HashMapExtensions.add(dictionary, "11", this.createFormat("L16", 44100, null, 11));
        HashMapExtensions.add(dictionary, "12", this.createFormat("QCELP", 8000, null, 12));
        HashMapExtensions.add(dictionary, "13", this.createFormat("CN", 8000, null, 13));
        HashMapExtensions.add(dictionary, "14", this.createFormat("MPA", 90000, null, 14));
        HashMapExtensions.add(dictionary, "15", this.createFormat("G728", 8000, null, 15));
        HashMapExtensions.add(dictionary, "16", this.createFormat("DVI4", 11025, null, 16));
        HashMapExtensions.add(dictionary, "17", this.createFormat("DVI4", 22050, null, 17));
        HashMapExtensions.add(dictionary, "18", this.createFormat("G729", 8000, null, 18));
        HashMapExtensions.add(dictionary, "25", this.createFormat("CelB", 90000, null, 25));
        HashMapExtensions.add(dictionary, "26", this.createFormat("JPEG", 90000, null, 26));
        HashMapExtensions.add(dictionary, "28", this.createFormat("nv", 90000, null, 28));
        HashMapExtensions.add(dictionary, "31", this.createFormat("H261", 90000, null, 31));
        HashMapExtensions.add(dictionary, "32", this.createFormat("MPV", 90000, null, 32));
        HashMapExtensions.add(dictionary, "33", this.createFormat("MP2T", 90000, null, 33));
        HashMapExtensions.add(dictionary, "34", this.createFormat("H263", 90000, null, 34));
        this.__wellKnownPayloadTypes = dictionary;
    }

    private String obtainFormatDescriptions() {
        StringBuilder builder = new StringBuilder();
        for (MediaFormat local : this.__payloadTypeRegistry) {
            if (local.getRegisteredPayloadType() < 0) continue;
            StringBuilderExtensions.append(builder, IntegerExtensions.toString(local.getRegisteredPayloadType()));
            StringBuilderExtensions.append(builder, " ");
        }
        return builder.toString();
    }

    private TFormatCollection obtainInputFormats() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaOutput local2 : this.getInputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(local2.getOutputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)local2.getOutputFormat()).clone());
        }
        return local;
    }

    private TFormatCollection obtainInputOutputFormatsUnion() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaOutput iMediaOutput : this.getInputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(iMediaOutput.getOutputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)iMediaOutput.getOutputFormat()).clone());
        }
        for (IMediaElement iMediaElement : this.getOutputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(iMediaElement.getInputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)iMediaElement.getInputFormat()).clone());
        }
        return local;
    }

    private TFormatCollection obtainLocalRemoteFormatsUnion() {
        TFormatCollection local = this.createMediaFormatCollection();
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            for (MediaFormat local2 : (MediaFormat[])((Collection)this.__remoteFormatRegistry).getValues()) {
                ((Collection)local).add((MediaFormat)local2);
            }
            return local;
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendOnly)) {
            for (MediaFormat local2 : (MediaFormat[])((Collection)this.__localFormatRegistry).getValues()) {
                ((Collection)local).add((MediaFormat)local2);
            }
            return local;
        }
        for (MediaFormat local3 : (MediaFormat[])((Collection)this.__remoteFormatRegistry).getValues()) {
            if (!((MediaFormatCollection)this.__localFormatRegistry).hasEquivalent((MediaFormat)local3)) continue;
            ((Collection)local).add((MediaFormat)local3);
        }
        return local;
    }

    private TFormatCollection obtainOutputFormats() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaInput local2 : this.getOutputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(local2.getInputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)local2.getInputFormat()).clone());
        }
        return local;
    }

    private boolean payloadTypeIsRegistered(int payloadType) {
        return this.getRegisteredFormat(payloadType) != null;
    }

    @Override
    protected void processCachedSettings() {
        super.processCachedSettings();
        if (super.getRenegotiationPending()) {
            this.setLocalDirection(super.getPendingLocalDirection());
        }
    }

    @Override
    public void processControlFrames(MediaControlFrame[] controlFrames) {
        if (!this.__remoteSupportsPli) {
            controlFrames = this.filterUnsupportedControlFrames(controlFrames);
        }
        if (ArrayExtensions.getLength(controlFrames) > 0) {
            RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport;
            IAction1<MediaControlFrame[]> onProcessControlFrames = this._onProcessControlFrames;
            if (onProcessControlFrames != null) {
                onProcessControlFrames.invoke(controlFrames);
            }
            if ((rtpTransport = this.getRtpTransport()) != null) {
                rtpTransport.sendControlFrames(controlFrames);
            }
        }
    }

    @Override
    public boolean processFrame(TFrame frame) {
        RtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport;
        IAction1<TFrame> onProcessFrame = this._onProcessFrame;
        if (onProcessFrame != null) {
            onProcessFrame.invoke(frame);
        }
        if ((rtpTransport = this.getRtpTransport()) == null || !Global.equals((Object)rtpTransport.getState(), (Object)MediaTransportState.Started)) {
            return false;
        }
        Object local = ((MediaFrame)frame).clone();
        ((MediaFrame)local).setTimestamp(((MediaFrame)frame).getTimestamp());
        ((MediaFrame)local).setDuration(((MediaFrame)frame).getDuration());
        ((MediaFrame)local).removeBuffers();
        for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
            MediaBuffer buffer = frame.getBuffers()[i];
            if (!((MediaFormat)buffer.getFormat()).getIsPacketized()) continue;
            ((MediaFrame)local).addBuffer(buffer);
            break;
        }
        if (ArrayExtensions.getLength(local.getBuffers()) == 0) {
            Log.error("No packetized formats in frame for stream to send.");
        }
        rtpTransport.sendFrame(local);
        return true;
    }

    @Override
    public boolean processGetMuteFromStream() {
        for (IMediaOutput local : this.getInputs()) {
            if (!local.processGetMuteFromStream()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        Error error = super.processSdpMediaDescription(sdpMessage, sdpMediaDescription, isLocalDescription, isOffer, isRenegotiation);
        if (error == null) {
            StreamDirection direction2;
            void var15_45;
            fm.icelink.sdp.Attribute[] attributeArray;
            int n;
            Object[] ssrcAttributes;
            MediaFormat local3;
            fm.icelink.sdp.Attribute[] attributeArray2;
            boolean supportsRtcpMultiplexing;
            StreamDirection streamDirection = sdpMediaDescription.getStreamDirection();
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = sdpMessage.getSessionLevelDirection();
            }
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = StreamDirection.SendReceive;
            }
            if (!(supportsRtcpMultiplexing = sdpMediaDescription.getSupportsRtcpMultiplexing())) {
                supportsRtcpMultiplexing = sdpMessage.getSessionLevelRtcpMultiplexingSupport();
            }
            this.setMultiplexingSupported(this.getMultiplexingSupported() & supportsRtcpMultiplexing);
            if (isLocalDescription) {
                if (!Global.equals((Object)streamDirection, (Object)this.getDirection())) {
                    if (!isOffer) {
                        Log.debug("Local Stream direction was modified in outgoing SDP Answer message. This action may cause unintended consequences. Consider using Stream.ChangeDirection() interface instead.");
                    }
                    this.setLocalDirection(streamDirection);
                }
                for (IMediaOutput iMediaOutput : this.getInputs()) {
                    iMediaOutput.processSdpMediaDescriptionFromOutput(sdpMediaDescription, isOffer, isLocalDescription);
                }
                for (IMediaInput iMediaInput : this.getOutputs()) {
                    iMediaInput.processSdpMediaDescriptionFromInput(sdpMediaDescription, isOffer, isLocalDescription);
                }
                if (!isRenegotiation) {
                    for (fm.icelink.sdp.Attribute attribute : attributeArray2 = sdpMediaDescription.getRtpMapAttributes()) {
                        local3 = (MediaFormat)this.createFormat((MapAttribute)attribute);
                        if (this.validateMapAttribute(local3, isLocalDescription)) continue;
                        Log.error("Invalid local map attribute.");
                        return new Error(ErrorCode.LocalDescriptionError);
                    }
                }
                for (Object object : ssrcAttributes = sdpMediaDescription.getSsrcAttributes()) {
                    this.validateSsrcAttribute((SsrcAttribute)object, isLocalDescription);
                }
            } else {
                this.setRemoteDirection(streamDirection);
                if (!isRenegotiation) {
                    ((MediaFormatCollection)this.__remoteFormatRegistry).removeAll();
                    fm.icelink.sdp.Attribute[] attributeArray3 = attributeArray2 = sdpMediaDescription.getRtpMapAttributes();
                    int n2 = attributeArray3.length;
                    for (n = 0; n < n2; ++n) {
                        fm.icelink.sdp.Attribute attribute = attributeArray3[n];
                        local3 = (MediaFormat)this.createFormat((MapAttribute)attribute);
                        if (!this.validateMapAttribute(local3, isLocalDescription)) continue;
                        ((Collection)this.__remoteFormatRegistry).add(local3);
                    }
                    int[] nArray = Media.getPayloadTypes(sdpMediaDescription.getMedia().getFormatDescription());
                    if (nArray != null) {
                        void var15_39;
                        local3 = null;
                        int[] nArray2 = nArray;
                        n = nArray2.length;
                        boolean bl = false;
                        while (var15_39 < n) {
                            int num = nArray2[var15_39];
                            Holder<Object> _var0 = new Holder<Object>(local3);
                            boolean _var1 = HashMapExtensions.tryGetValue(this.__wellKnownPayloadTypes, IntegerExtensions.toString(num), _var0);
                            local3 = _var0.getValue();
                            if (_var1 && ((MediaFormatCollection)this.__remoteFormatRegistry).getEquivalent((MediaFormat)local3) == null && this.validateMapAttribute(local3, isLocalDescription)) {
                                ((Collection)this.__remoteFormatRegistry).add((MediaFormat)local3);
                            }
                            ++var15_39;
                        }
                    }
                }
                if (ArrayExtensions.getLength(ssrcAttributes = sdpMediaDescription.getSsrcAttributes()) > 0) {
                    Object[] objectArray = ssrcAttributes;
                    int n3 = objectArray.length;
                    for (n = 0; n < n3; ++n) {
                        Object object = objectArray[n];
                        if (this.validateSsrcAttribute((SsrcAttribute)object, isLocalDescription)) continue;
                        Log.error("Remote description contains an invalid SSRC.");
                        return new Error(ErrorCode.RemoteDescriptionError);
                    }
                } else {
                    this.getRtpTransport().getSrtpTransport().getListener().setBypassSsrcCheck(true);
                }
                super.setRemoteBandwidth(-1);
                for (Bandwidth bandwidth : sdpMediaDescription.getBandwidths()) {
                    if (!Global.equals(StringExtensions.toUpper(bandwidth.getBandwidthType()), "TIAS") || bandwidth.getValue() <= 0L) continue;
                    super.setRemoteBandwidth((int)(bandwidth.getValue() / 1024L));
                    break;
                }
                for (IMediaOutput iMediaOutput : this.getInputs()) {
                    iMediaOutput.processSdpMediaDescriptionFromOutput(sdpMediaDescription, isOffer, isLocalDescription);
                }
                for (IMediaInput iMediaInput : this.getOutputs()) {
                    iMediaInput.processSdpMediaDescriptionFromInput(sdpMediaDescription, isOffer, isLocalDescription);
                }
            }
            fm.icelink.sdp.Attribute[] attributeArray4 = attributeArray = sdpMediaDescription.getRtpMapAttributes();
            n = attributeArray4.length;
            boolean bl = false;
            while (var15_45 < n) {
                fm.icelink.sdp.Attribute attribute = attributeArray4[var15_45];
                MapAttribute attribute2 = (MapAttribute)attribute;
                if (isLocalDescription) {
                    FeedbackAttribute relatedNackPliFeedbackAttribute;
                    if (!isOffer) {
                        if (!(this.__remoteSupportsPli && this.getNackEnabled() || (relatedNackPliFeedbackAttribute = attribute2.getRelatedNackPliFeedbackAttribute()) == null)) {
                            attribute2.removeRelatedRtcpFeedbackAttribute(relatedNackPliFeedbackAttribute);
                        }
                        if (!(this.__remoteSupportsFec && this.getRedFecEnabled() || !this.formatIsFec(attribute2.getFormatName()))) {
                            sdpMediaDescription.removeMediaAttribute(attribute2);
                        }
                    } else {
                        if (!this.getNackEnabled() && (relatedNackPliFeedbackAttribute = attribute2.getRelatedNackPliFeedbackAttribute()) != null) {
                            attribute2.removeRelatedRtcpFeedbackAttribute(relatedNackPliFeedbackAttribute);
                        }
                        if (!this.getRedFecEnabled() && this.formatIsFec(attribute2.getFormatName())) {
                            sdpMediaDescription.removeMediaAttribute(attribute2);
                        }
                    }
                } else {
                    if (attribute2.getRelatedNackPliFeedbackAttribute() != null) {
                        this.__remoteSupportsPli = true;
                    }
                    if (this.formatIsFec(attribute2.getFormatName())) {
                        this.__remoteSupportsFec = true;
                    }
                }
                ++var15_45;
            }
            if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                this.setNackEnabled(false);
                this.setRedFecEnabled(false);
            } else if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                if (isLocalDescription && isOffer) {
                    this.setNackEnabled(Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Negotiated));
                    this.setRedFecEnabled(Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated));
                } else {
                    if (this.__remoteSupportsPli && Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Negotiated)) {
                        this.setNackEnabled(true);
                    } else {
                        this.setNackEnabled(false);
                    }
                    if (this.__remoteSupportsFec && Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated)) {
                        this.setRedFecEnabled(true);
                    } else {
                        this.setRedFecEnabled(false);
                    }
                }
            }
            if (!isRenegotiation) {
                fm.icelink.sdp.Attribute[] attributeArray42;
                for (fm.icelink.sdp.Attribute attribute5 : attributeArray42 = sdpMediaDescription.getSsrcAttributes()) {
                    if (isLocalDescription) {
                        this.getRtpParameters().addLocalSynchronizationSource(((SsrcAttribute)attribute5).getSynchronizationSource());
                    } else {
                        this.getRtpParameters().addRemoteSynchronizationSource(((SsrcAttribute)attribute5).getSynchronizationSource());
                    }
                    StreamDirection _var2 = streamDirection;
                    if (_var2 != StreamDirection.ReceiveOnly && _var2 != StreamDirection.ReceiveOnly) continue;
                    sdpMediaDescription.removeMediaAttribute(attribute5);
                }
            }
            StreamDirection streamDirection2 = direction2 = isOffer && isLocalDescription ? this.getLocalDirection() : this.getDirection();
            if (!isRenegotiation) {
                this.setNegotiatedFormats(sdpMediaDescription);
            }
            if (Global.equals((Object)direction2, (Object)StreamDirection.ReceiveOnly)) {
                this.setOutputFormat(this.getPreferredFormat());
            } else {
                if (Global.equals((Object)direction2, (Object)StreamDirection.SendOnly)) {
                    this.setOutputFormat(null);
                    return error;
                }
                if (Global.equals((Object)direction2, (Object)StreamDirection.SendReceive)) {
                    this.setOutputFormat(this.getPreferredFormat());
                } else {
                    this.setOutputFormat(null);
                }
            }
        }
        return error;
    }

    @Override
    public Error processSdpMediaDescriptionFromInput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    @Override
    public Error processSdpMediaDescriptionFromOutput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    @Override
    public void processSetMuteFromStream(boolean mute) {
        for (IMediaOutput local : this.getInputs()) {
            local.processSetMuteFromStream(mute);
        }
    }

    @Override
    public void processStatsFromInput(MediaTrackStats stats) {
    }

    @Override
    public void processStatsFromOutput(MediaTrackStats stats) {
    }

    private void raiseControlFrames(MediaControlFrame[] controlFrames) {
        IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
        if (onRaiseControlFrames != null) {
            onRaiseControlFrames.invoke(controlFrames);
        }
        for (IMediaOutput local : this.getInputs()) {
            if (local.getDisabled()) continue;
            local.processControlFrames(controlFrames);
        }
    }

    protected void raiseFrame(TFrame frame) {
        IAction1<TFrame> onRaiseFrame = this._onRaiseFrame;
        if (onRaiseFrame != null) {
            onRaiseFrame.invoke(frame);
        }
        boolean flag = false;
        for (IMediaInput local : this.getOutputs()) {
            if (local.getDisabled() || !((MediaFrame)frame).hasBuffer(local.getInputFormat()) || !local.processFrame(frame)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            Log.debug("Stream could not raise frame to any outputs.");
        }
    }

    void receiveControlFrames(MediaControlFrame[] controlFrames) {
        this.raiseControlFrames(controlFrames);
    }

    void receiveFrame(TFrame frame) {
        this.raiseFrame(frame);
    }

    private void registerPayloadTypes() {
        int staticPayloadType;
        if (((Collection)this.__remoteFormatRegistry).getCount() == 0) {
            this.__payloadTypeRegistry.clear();
        }
        ((MediaFormatCollection)this.__localFormatRegistry).removeAll();
        int clockRate = 0;
        StreamDirection directionCapabilities = this.getDirectionCapabilities();
        TFormatCollection local = Global.equals((Object)directionCapabilities, (Object)StreamDirection.SendOnly) ? this.obtainInputFormats() : (Global.equals((Object)directionCapabilities, (Object)StreamDirection.ReceiveOnly) ? this.obtainOutputFormats() : this.obtainInputOutputFormatsUnion());
        for (int i = 0; i < ((Collection)local).getCount(); ++i) {
            staticPayloadType = -1;
            MediaFormat format = ((MediaFormat[])((Collection)local).getValues())[i];
            if (((Collection)this.__remoteFormatRegistry).getCount() == 0) {
                if (format.getStaticPayloadType() >= 0) {
                    String item = IntegerExtensions.toString(format.getStaticPayloadType());
                    if (this.__payloadTypesRegisteredByOtherStreams.contains(item)) {
                        Log.error(StringExtensions.format("Payload type {0} for {1} is already registered by another stream.", item, format.getFullName()));
                    } else {
                        staticPayloadType = format.getStaticPayloadType();
                    }
                } else {
                    staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                    while (this.__payloadTypesRegisteredByOtherStreams.contains(IntegerExtensions.toString(staticPayloadType))) {
                        ++this.__rtpPayloadTypeDynamicOffset;
                    }
                    if (staticPayloadType > this.__rtpPayloadTypeMaxOffset) {
                        Log.error(StringExtensions.format("Cannot add format {0}. Maximum dynamic payload types exceeded.", format.toString()));
                        staticPayloadType = -1;
                    }
                }
            }
            format.setRegisteredPayloadType(staticPayloadType);
            this.addLocalFormat(format);
            if (format.getRegisteredPayloadType() < 0 || clockRate != 0) continue;
            clockRate = format.getClockRate();
        }
        if (Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated) && clockRate > 0) {
            if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                this.addLocalFormat(this.createFormat(MediaFormat.getRedName(), clockRate, null, staticPayloadType));
                staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                this.addLocalFormat(this.createFormat(MediaFormat.getUlpFecName(), clockRate, null, staticPayloadType));
            } else {
                Log.debug("FEC is only supported for video streams.");
            }
        }
    }

    @Override
    public boolean removeInput(TIOutput input) {
        return ((Collection)this.__inputs).remove(input);
    }

    @Override
    public void removeInputs() {
        ((Collection)this.__inputs).removeAll();
    }

    @Override
    public boolean removeInputs(TIOutput[] inputs) {
        return ((Collection)this.__inputs).removeMany(inputs);
    }

    @Override
    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
    }

    @Override
    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
    }

    @Override
    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
    }

    @Override
    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
    }

    @Override
    public boolean removeOutput(TIInput output) {
        return ((Collection)this.__outputs).remove(output);
    }

    @Override
    public boolean removeOutputs(TIInput[] outputs) {
        return ((Collection)this.__outputs).removeMany(outputs);
    }

    @Override
    public void removeOutputs() {
        ((Collection)this.__outputs).removeAll();
    }

    @Override
    void reset() {
        super.reset();
        this.setRtpTransport(null);
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    protected void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    private void setInputFormat() {
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            this.setInputFormat(null);
        } else if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendOnly)) {
            this.setInputFormat(this.getPreferredFormat());
        } else if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendReceive)) {
            this.setInputFormat(this.getPreferredFormat());
        } else {
            this.setInputFormat(null);
        }
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    void setMultiplexingSupported(boolean value) {
        this._multiplexingSupported = value;
    }

    @Override
    public void setMuted(boolean value) {
        this.processSetMuteFromStream(value);
    }

    private void setNackConfig(NackConfig value) {
        this.__nackConfig = value;
    }

    private void setNackEnabled(boolean value) {
        if (Global.equals((Object)super.getType(), (Object)StreamType.Audio) && value) {
            throw new RuntimeException(new Exception("Nack is not supported for Audio streams."));
        }
        this.getNackConfig().setDisableBuffering(!value);
    }

    public void setNackPolicy(NackPolicy value) {
        if (Global.equals((Object)this.__nackPolicy, (Object)NackPolicy.Disabled) && Global.equals((Object)value, (Object)NackPolicy.Negotiated)) {
            if (this.__startedOriginalNegotiation) {
                throw new RuntimeException(new Exception("Cannot set NACK policy to Negotiated after the original session description negotiation has commenced."));
            }
            this.__nackPolicy = NackPolicy.Negotiated;
        } else if (Global.equals((Object)this.__nackPolicy, (Object)NackPolicy.Negotiated) && Global.equals((Object)value, (Object)NackPolicy.Disabled)) {
            this.__nackPolicy = NackPolicy.Disabled;
            this.setNackEnabled(false);
        }
    }

    private void setNegotiatedFormats(MediaDescription mediaDescription) {
        int[] payloadTypes;
        String formatDescription = mediaDescription.getMedia().getFormatDescription();
        if (!StringExtensions.isNullOrEmpty(formatDescription) && (payloadTypes = Media.getPayloadTypes(formatDescription)) != null) {
            TFormatCollection local = this.obtainLocalRemoteFormatsUnion();
            for (int num : payloadTypes) {
                TFormat equivalent;
                TFormat registeredFormat = this.getRegisteredFormat(num);
                if (registeredFormat == null || (equivalent = ((MediaFormatCollection)local).getEquivalent(registeredFormat)) == null) continue;
                if (!this.getRtpParameters().getPayloadTypeRegistry().containsKey(num)) {
                    HashMapExtensions.add(this.getRtpParameters().getPayloadTypeRegistry(), num, equivalent);
                }
                ((Collection)this.getRtpParameters().getNegotiatedFormats()).add(equivalent);
            }
        }
    }

    protected void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    private void setRedFecConfig(RedFecConfig value) {
        this.__redFecConfig = value;
    }

    private void setRedFecEnabled(boolean value) {
        if (Global.equals((Object)super.getType(), (Object)StreamType.Audio) && value) {
            throw new RuntimeException(new Exception("RED FEC is not supported for Audio streams."));
        }
        this.getRedFecConfig().setDisabled(!value);
    }

    public void setRedFecPolicy(RedFecPolicy value) {
        if (Global.equals((Object)value, (Object)RedFecPolicy.Negotiated)) {
            Log.error("Red FEC Negotiated policy is currently not supported. Defaulting to Red FEC Disabled.");
        }
        this.__redFecPolicy = RedFecPolicy.Disabled;
        this.setRedFecEnabled(false);
    }

    private void setRtpParameters(RtpParameters<TFormat, TFormatCollection> value) {
        this._rtpParameters = value;
    }

    void setRtpTransport(RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        IAction1<IMediaTransport> action = null;
        this.__rtpTransport = value;
        if (this.__rtpTransport != null) {
            if (action == null) {
                action = new IAction1<IMediaTransport>(){

                    @Override
                    public void invoke(IMediaTransport transport) {
                        if (Global.equals((Object)transport.getState(), (Object)MediaTransportState.Started)) {
                            if (Global.equals((Object)MediaStream.this.getType(), (Object)StreamType.Video)) {
                                MediaStream.this.raiseControlFrames(new PliControlFrame[]{new PliControlFrame()});
                            }
                            MediaStream.this.setInputFormat();
                        }
                    }
                };
            }
            this.__rtpTransport.addOnStateChange(action);
        }
    }

    private boolean validateMapAttribute(TFormat mapAttributeFormat, boolean isLocalDescription) {
        if (mapAttributeFormat != null) {
            int registeredPayloadType = ((MediaFormat)mapAttributeFormat).getRegisteredPayloadType();
            TFormat registeredFormat = this.getRegisteredFormat(registeredPayloadType);
            if (registeredFormat == null || !((MediaFormat)registeredFormat).isEquivalent(mapAttributeFormat) || ((MediaFormat)registeredFormat).getRegisteredPayloadType() != registeredPayloadType) {
                if (((Collection)this.__localFormatRegistry).getCount() <= 0) {
                    return true;
                }
                registeredFormat = ((MediaFormatCollection)this.__localFormatRegistry).getEquivalent(mapAttributeFormat);
                if (registeredFormat == null) {
                    return false;
                }
                if (isLocalDescription) {
                    ((MediaFormat)registeredFormat).setRegisteredPayloadType(((MediaFormat)mapAttributeFormat).getRegisteredPayloadType());
                } else {
                    ((Collection)this.__remoteFormatRegistry).add(registeredFormat);
                }
            }
            return true;
        }
        return false;
    }

    private boolean validateSsrcAttribute(SsrcAttribute attribute, boolean isLocalDescription) {
        if (isLocalDescription) {
            if (Global.equals(attribute.getName(), SsrcAttributeName.getCName())) {
                if (attribute.getValue() == null) {
                    attribute.setValue(this.getRtpParameters().getCanonicalName());
                } else if (!Global.equals(attribute.getValue(), this.getRtpParameters().getCanonicalName())) {
                    Log.error("Canonical name of a stream must match Connection.Id");
                    return false;
                }
            }
            this.getRtpParameters().addLocalSynchronizationSource(attribute.getSynchronizationSource());
        } else if (Global.equals(attribute.getName(), SsrcAttributeName.getCName())) {
            this.getRtpParameters().addRemoteSynchronizationSource(attribute.getSynchronizationSource());
        }
        return true;
    }
}

