/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.JitterBuffer;

public class JitterAudioPipe
extends AudioPipe {
    private JitterBuffer<AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat> _buffer;
    private IAction1<AudioFrame> _callback;

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        AudioFrame frame2 = frame.clone();
        frame2.removeBuffers();
        frame2.addBuffer(inputBuffer.clone());
        ((AudioBuffer)frame2.getBuffer()).setSequenceNumber(((AudioBuffer)frame.getBuffer()).getSequenceNumber());
        ((AudioBuffer)frame2.getBuffer()).setDataBuffer(((AudioBuffer)frame.getBuffer()).getDataBuffer());
        this._buffer.push(frame2);
        this._buffer.pull(this._callback);
    }

    @Override
    public String getLabel() {
        return "Jitter Audio Pipe";
    }

    public JitterAudioPipe(AudioFormat format, int length) {
        super(format, format);
        if (!format.getIsPacketized()) {
            throw new RuntimeException(new Exception("Format must be packetized."));
        }
        this._buffer = new JitterBuffer(this.getLabel(), ((AudioFormat)super.getInputFormat()).getClockRate(), length);
        this._callback = new IActionDelegate1<AudioFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.JitterAudioPipe.onPull";
            }

            @Override
            public void invoke(AudioFrame frame) {
                JitterAudioPipe.this.onPull(frame);
            }
        };
    }

    public JitterAudioPipe(AudioFormat format) {
        this(format, 100);
    }

    private void onPull(AudioFrame frame) {
        this.raiseFrame(frame);
    }
}

