/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.FecContext;
import fm.icelink.FecReceivedPacket;
import fm.icelink.FecRecoveredPacket;
import fm.icelink.LinkedList;
import fm.icelink.Log;
import java.util.ArrayList;

class FecReceiver {
    private FecContext __fec = new FecContext();
    private boolean __lastPacketReceivedSoloFec;
    private int __numFecPackets;
    private int __numPackets;
    private int __numRecoveredPackets;
    private ArrayList<FecReceivedPacket> __receivedPackets = new ArrayList();
    private ArrayList<FecRecoveredPacket> __recoveredPackets = new ArrayList();

    public boolean addReceivedRedPacket(int incomingRtpHeaderLength, int incomingRtpSequenceNumber, DataBuffer incomingRtpPacket, int packetLength, int fecPayloadType) {
        this.__lastPacketReceivedSoloFec = false;
        int num = 1;
        int num2 = packetLength - incomingRtpHeaderLength;
        FecReceivedPacket item = new FecReceivedPacket();
        int num3 = incomingRtpPacket.read8(incomingRtpHeaderLength) & 0x7F;
        item.setIsFec(num3 == fecPayloadType);
        item.setSequenceNumber(incomingRtpSequenceNumber);
        int count = 0;
        if ((incomingRtpPacket.read8(incomingRtpHeaderLength) & 0x80) > 0) {
            num = 4;
            byte num5 = (byte)(BitAssistant.leftShift((byte)incomingRtpPacket.read8(incomingRtpHeaderLength + 1), 8) + (byte)incomingRtpPacket.read8(incomingRtpHeaderLength + 2));
            if (BitAssistant.rightShift(num5, 2) != 0) {
                Log.warn("Corrupt payload found.");
                return false;
            }
            count = (3 & incomingRtpPacket.read8(incomingRtpHeaderLength + 2)) << 8;
            count += incomingRtpPacket.read8(incomingRtpHeaderLength + 3);
            if ((incomingRtpPacket.read8(incomingRtpHeaderLength + 4) & 0x80) > 0) {
                throw new RuntimeException(new Exception("More than 2 blocks in packet not supported."));
            }
            if (count > num2 - num) {
                throw new RuntimeException(new Exception("Block length longer than packet."));
            }
        }
        ++this.__numPackets;
        FecReceivedPacket packet2 = null;
        if (count > 0) {
            num = 5;
            item.setRaw(DataBuffer.allocate(count));
            item.getRaw().write(incomingRtpPacket.subset(0, incomingRtpHeaderLength), 0);
            item.getRaw().write1(false, 1, 0);
            item.getRaw().write8((byte)(item.getRaw().read8(1) + num3), 1);
            item.getRaw().write(incomingRtpPacket.subset(incomingRtpHeaderLength + num, count), incomingRtpHeaderLength);
            packet2 = new FecReceivedPacket();
            packet2.setRaw(DataBuffer.allocate(num2 - num - count));
            packet2.setIsFec(true);
            packet2.setSequenceNumber(incomingRtpSequenceNumber);
            ++this.__numFecPackets;
            packet2.getRaw().write(incomingRtpPacket.subset(incomingRtpHeaderLength + num + count, num2 - num - count), 0);
        } else if (item.getIsFec()) {
            ++this.__numFecPackets;
            this.__lastPacketReceivedSoloFec = true;
            item.setRaw(DataBuffer.allocate(num2 - num));
            item.getRaw().write(incomingRtpPacket.subset(incomingRtpHeaderLength + num, num2 - num), 0);
            item.setSynchronizationSource(incomingRtpPacket.read32(8));
        } else {
            item.setRaw(DataBuffer.allocate(incomingRtpHeaderLength + num2 - num));
            item.getRaw().write(incomingRtpPacket.subset(0, incomingRtpHeaderLength), 0);
            item.getRaw().and(128, 1);
            item.getRaw().write8((byte)(item.getRaw().read8(1) + num3), 1);
            item.getRaw().write(incomingRtpPacket.subset(incomingRtpHeaderLength + num, num2 - num), incomingRtpHeaderLength);
        }
        if (item.getRaw().getLength() != 0) {
            this.__receivedPackets.add(item);
            if (packet2 != null) {
                this.__receivedPackets.add(packet2);
            }
        }
        return true;
    }

    public boolean getLastPacketReceivedSoloFec() {
        return this.__lastPacketReceivedSoloFec;
    }

    public int getNumFecPackets() {
        return this.__numFecPackets;
    }

    public int getNumPackets() {
        return this.__numPackets;
    }

    public int getNumRecoveredPackets() {
        return this.__numRecoveredPackets;
    }

    public boolean processReceivedFec(LinkedList<DataBuffer> list) {
        DataBuffer raw;
        if (ArrayListExtensions.getCount(this.__receivedPackets) != 0) {
            if (!ArrayListExtensions.getItem(this.__receivedPackets).get(0).getIsFec()) {
                raw = ArrayListExtensions.getItem(this.__receivedPackets).get(0).getRaw();
                list.addLast(raw);
            }
            if (!this.__fec.decode(this.__receivedPackets, this.__recoveredPackets)) {
                return false;
            }
            if (ArrayListExtensions.getCount(this.__receivedPackets) > 0) {
                throw new RuntimeException(new Exception("Received packet list must be empty."));
            }
        }
        for (int i = 0; i != ArrayListExtensions.getCount(this.__recoveredPackets); ++i) {
            FecRecoveredPacket packet = ArrayListExtensions.getItem(this.__recoveredPackets).get(i);
            if (packet.getReturned()) continue;
            raw = packet.getRaw();
            ++this.__numRecoveredPackets;
            list.addLast(raw);
            packet.setReturned(true);
        }
        return true;
    }
}

