/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum EventType {
    BeforeBinding(1),
    BeforeAllocate(2),
    BeforeRefresh(3),
    BeforeCreatePermission(4),
    BeforeSend(5),
    BeforeReceive(6),
    BeforeConnect(7),
    BeforeConnectionBind(8),
    BeforeChannelBind(9),
    AfterBinding(11),
    AfterAllocate(12),
    AfterRefresh(13),
    AfterCreatePermission(14),
    AfterSend(15),
    AfterReceive(16),
    AfterConnect(17),
    AfterConnectionBind(18),
    AfterChannelBind(19);

    private final int value;
    private static final Map<Integer, EventType> lookup;

    private EventType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static EventType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, EventType>();
        for (EventType s : EnumSet.allOf(EventType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

