/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.DataChannelState;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableLong;
import java.util.ArrayList;
import java.util.HashMap;

public class DataChannelStats
extends BaseStats {
    private long _bytesReceived;
    private long _bytesSent;
    private String _label;
    private long _messagesReceived;
    private long _messagesSent;
    private boolean _ordered;
    private String _protocol;
    private DataChannelState _state;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String _var0 = key;
        if (_var0.equals("label")) {
            this.setLabel(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("ordered")) {
            this.setOrdered(JsonSerializer.deserializeBoolean(valueJson).getValue());
        } else if (_var0.equals("protocol")) {
            this.setProtocol(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("state")) {
            this.setState(this.stateFromJson(valueJson));
        } else if (_var0.equals("messagesSent")) {
            this.setMessagesSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("bytesSent")) {
            this.setBytesSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("messagesReceived")) {
            this.setMessagesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("bytesReceived")) {
            this.setBytesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        }
    }

    public static DataChannelStats fromJson(String dataChannelJson) {
        return JsonSerializer.deserializeObject(dataChannelJson, new IFunction0<DataChannelStats>(){

            @Override
            public DataChannelStats invoke() {
                return new DataChannelStats();
            }
        }, new IAction3<DataChannelStats, String, String>(){

            @Override
            public void invoke(DataChannelStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public static DataChannelStats[] fromJsonArray(String dataChannelsJson) {
        ArrayList<DataChannelStats> list = JsonSerializer.deserializeObjectArray(dataChannelsJson, new IFunctionDelegate1<String, DataChannelStats>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelStats.fromJson";
            }

            @Override
            public DataChannelStats invoke(String dataChannelJson) {
                return DataChannelStats.fromJson(dataChannelJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new DataChannelStats[0]);
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public String getLabel() {
        return this._label;
    }

    public long getMessagesReceived() {
        return this._messagesReceived;
    }

    public long getMessagesSent() {
        return this._messagesSent;
    }

    public boolean getOrdered() {
        return this._ordered;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public DataChannelState getState() {
        return this._state;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        if (this.getLabel() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "label", JsonSerializer.serializeString(this.getLabel()));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "ordered", JsonSerializer.serializeBoolean(new NullableBoolean(this.getOrdered())));
        if (this.getProtocol() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "protocol", JsonSerializer.serializeString(this.getProtocol()));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "state", this.stateToJson(this.getState()));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "messagesSent", JsonSerializer.serializeLong(new NullableLong(this.getMessagesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesSent", JsonSerializer.serializeLong(new NullableLong(this.getBytesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "messagesReceived", JsonSerializer.serializeLong(new NullableLong(this.getMessagesReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesReceived", JsonSerializer.serializeLong(new NullableLong(this.getBytesReceived())));
    }

    void setBytesReceived(long value) {
        this._bytesReceived = value;
    }

    void setBytesSent(long value) {
        this._bytesSent = value;
    }

    void setLabel(String value) {
        this._label = value;
    }

    void setMessagesReceived(long value) {
        this._messagesReceived = value;
    }

    void setMessagesSent(long value) {
        this._messagesSent = value;
    }

    void setOrdered(boolean value) {
        this._ordered = value;
    }

    void setProtocol(String value) {
        this._protocol = value;
    }

    void setState(DataChannelState value) {
        this._state = value;
    }

    private DataChannelState stateFromJson(String stateJson) {
        String _var0 = stateJson;
        if (_var0.equals("new")) {
            return DataChannelState.New;
        }
        if (_var0.equals("connecting")) {
            return DataChannelState.Connecting;
        }
        if (_var0.equals("connected")) {
            return DataChannelState.Connected;
        }
        if (_var0.equals("failed")) {
            return DataChannelState.Failed;
        }
        if (_var0.equals("closing")) {
            return DataChannelState.Closing;
        }
        if (_var0.equals("closed")) {
            return DataChannelState.Closed;
        }
        return DataChannelState.New;
    }

    private String stateToJson(DataChannelState state) {
        DataChannelState _var0 = state;
        if (_var0 == DataChannelState.New) {
            return "new";
        }
        if (_var0 == DataChannelState.Connecting) {
            return "connecting";
        }
        if (_var0 == DataChannelState.Connected) {
            return "connected";
        }
        if (_var0 == DataChannelState.Closing) {
            return "closing";
        }
        if (_var0 == DataChannelState.Closed) {
            return "closed";
        }
        if (_var0 == DataChannelState.Failed) {
            return "failed";
        }
        return null;
    }

    public static String toJson(DataChannelStats dataChannel) {
        return JsonSerializer.serializeObject(dataChannel, new IAction2<DataChannelStats, HashMap<String, String>>(){

            @Override
            public void invoke(DataChannelStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public String toJson() {
        return DataChannelStats.toJson(this);
    }

    public static String toJsonArray(DataChannelStats[] dataChannels) {
        return JsonSerializer.serializeObjectArray(dataChannels, new IFunctionDelegate1<DataChannelStats, String>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelStats.toJson";
            }

            @Override
            public String invoke(DataChannelStats dataChannel) {
                return DataChannelStats.toJson(dataChannel);
            }
        });
    }
}

