/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.MediaTrackStats;

public abstract class AudioDecoder
extends AudioPipe {
    private long __decoderLastSequenceNumber = -1L;
    private AtomicLong __framesDecoded = new AtomicLong();
    private boolean _disablePlc;

    public AudioDecoder(AudioFormat inputFormat, AudioFormat outputFormat) {
        super(inputFormat, outputFormat);
        this.setDisablePlc(!Global.equals(outputFormat.getName(), AudioFormat.getPcmName()));
    }

    @Override
    protected void doProcessStatsFromInput(MediaTrackStats stats) {
        super.doProcessStatsFromInput(stats);
        stats.setFramesDecoded(this.getFramesDecoded());
    }

    public boolean getDisablePlc() {
        return this._disablePlc;
    }

    public long getFramesDecoded() {
        return this.__framesDecoded.getValue();
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        this.__framesDecoded.increment();
        if (!this.getDisablePlc() && frame.getSequenceNumber() != -1L) {
            long num;
            if (this.__decoderLastSequenceNumber != -1L && (num = frame.getSequenceNumber() - this.__decoderLastSequenceNumber) > 1L) {
                AudioBuffer lastBuffer = (AudioBuffer)frame.getLastBuffer();
                DataBuffer dataBuffer = lastBuffer.getDataBuffer();
                int i = 1;
                while ((long)i < num) {
                    AudioFrame frame2 = frame.clone();
                    frame2.removeBuffers();
                    frame2.addBuffer(new AudioBuffer(DataBuffer.allocate(dataBuffer.getLength(), dataBuffer.getLittleEndian()), (AudioFormat)lastBuffer.getFormat()));
                    super.raiseFrame(frame2);
                    ++i;
                }
            }
            this.__decoderLastSequenceNumber = frame.getSequenceNumber();
        }
        super.raiseFrame(frame);
    }

    public void setDisablePlc(boolean value) {
        this._disablePlc = value;
    }
}

