/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vpx;

import fm.icelink.Global;
import fm.icelink.MediaBuffer;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.vpx.Codec;
import fm.icelink.vpx.Native;

public abstract class Decoder
extends VideoDecoder {
    private Native __decoder = Global.equals((Object)((VideoFormat)super.getInputFormat()).getName(), (Object)VideoFormat.getVp9Name()) ? new Native(false) : new Native(false);

    public Decoder(VideoFormat inputFormat) {
        super(inputFormat, VideoFormat.getI420());
    }

    protected void doDestroy() {
        this.__decoder.destroy();
        this.__decoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        super.doProcessFrame(frame, inputBuffer);
        if (!super.getDelayDecode()) {
            VideoBuffer buffer = this.__decoder.decode(inputBuffer, (VideoFormat)super.getOutputFormat());
            if (buffer != null) {
                frame.addBuffer((MediaBuffer)buffer);
                this.raiseFrame(frame);
                buffer.getDataBuffer().free();
            }
            if (this.getNeedsKeyFrame()) {
                super.sendPli("VPX decoder needs a keyframe.");
            }
        }
    }

    public Codec getCodec() {
        return this.__decoder.getCodec();
    }

    public boolean getNeedsKeyFrame() {
        return this.__decoder.getNeedsKeyFrame();
    }

    public void setCodec(Codec value) {
        this.__decoder.setCodec(value);
    }

    private void setNeedsKeyFrame(boolean value) {
        this.__decoder.setNeedsKeyFrame(value);
    }
}

