/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.xirsys.v3;

import fm.icelink.Base64;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.HttpMethod;
import fm.icelink.HttpRequestArgs;
import fm.icelink.HttpResponseArgs;
import fm.icelink.HttpTransferFactory;
import fm.icelink.IAction1;
import fm.icelink.JsonSerializer;
import fm.icelink.Promise;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import fm.icelink.xirsys.v3.IceServer;
import fm.icelink.xirsys.v3.TurnResponse;
import fm.icelink.xirsys.v3.TurnResponseData;
import fm.icelink.xirsys.v3.TurnResponseStatus;
import java.util.ArrayList;
import java.util.HashMap;

public class Client {
    private static String __defaultEndpoint = "https://us.xirsys.com/_turn";
    private String _channel;
    private String _endpoint;
    private String _ident;
    private String _secret;
    private boolean _secure;

    public Client(String ident, String secret, String channel, boolean secure) {
        this.setIdent(ident);
        this.setSecret(secret);
        this.setChannel(channel);
        this.setSecure(secure);
        this.setEndpoint(Client.getDefaultEndpoint());
    }

    public Client(String ident, String secret, String channel) {
        this(ident, secret, channel, true);
    }

    private void doGetIceServers(final Promise<fm.icelink.IceServer[]> promise) {
        String str = this.getEndpoint().endsWith("/") ? StringExtensions.substring((String)this.getEndpoint(), (int)0, (int)(StringExtensions.getLength((String)this.getEndpoint()) - 1)) : this.getEndpoint();
        String str2 = StringExtensions.format((String)"{0}/{1}", (Object)str, (Object)this.getChannel());
        HttpRequestArgs args2 = new HttpRequestArgs();
        args2.setMethod(HttpMethod.Put);
        args2.setUrl(str2);
        HttpRequestArgs requestArgs = args2;
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem((HashMap)requestArgs.getHeaders()), (Object)"Authorization", (Object)StringExtensions.format((String)"Basic {0}", (Object)Base64.encode((byte[])Utf8.encode((String)StringExtensions.format((String)"{0}:{1}", (Object)this.getIdent(), (Object)this.getSecret())))));
        HttpTransferFactory.getHttpTransfer().sendTextAsync(requestArgs, (IAction1)new IAction1<HttpResponseArgs>(){

            public void invoke(HttpResponseArgs responseArgs) {
                TurnResponse response = TurnResponse.fromJson(responseArgs.getTextContent());
                if (response == null) {
                    promise.reject(new Exception("XirSys: null response"));
                } else if (!Global.equals((Object)response.getStatus(), (Object)TurnResponseStatus.getOK())) {
                    promise.reject(new Exception(StringExtensions.format((String)"XirSys: {0} {1}", (Object)response.getStatus(), (Object)JsonSerializer.deserializeString((String)response.getValueJson()))));
                } else {
                    TurnResponseData data = TurnResponseData.fromJson(response.getValueJson());
                    if (data == null) {
                        promise.reject(new Exception(StringExtensions.format((String)"XirSys: invalid value ({0})", (Object)response.getValueJson())));
                    } else {
                        ArrayList<fm.icelink.IceServer> list = new ArrayList<fm.icelink.IceServer>();
                        for (IceServer server : data.getIceServers()) {
                            if (server.getUsername() == null || server.getCredential() == null) {
                                list.add(new fm.icelink.IceServer(server.getUrl()));
                                continue;
                            }
                            list.add(new fm.icelink.IceServer(server.getUrl(), server.getUsername(), server.getCredential()));
                        }
                        promise.resolve((Object)list.toArray(new fm.icelink.IceServer[0]));
                    }
                }
            }
        });
    }

    public String getChannel() {
        return this._channel;
    }

    public static String getDefaultEndpoint() {
        return __defaultEndpoint;
    }

    public String getEndpoint() {
        return this._endpoint;
    }

    public Future<fm.icelink.IceServer[]> getIceServers() {
        Promise promise = new Promise();
        this.doGetIceServers((Promise<fm.icelink.IceServer[]>)promise);
        return promise;
    }

    public String getIdent() {
        return this._ident;
    }

    public String getSecret() {
        return this._secret;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setChannel(String value) {
        this._channel = value;
    }

    public static void setDefaultEndpoint(String value) {
        __defaultEndpoint = value;
    }

    public void setEndpoint(String value) {
        this._endpoint = value;
    }

    public void setIdent(String value) {
        this._ident = value;
    }

    public void setSecret(String value) {
        this._secret = value;
    }

    public void setSecure(boolean value) {
        this._secure = value;
    }
}

