/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

public class ManagedStopwatch {
    private long startTime = 0L;
    private long stopTime = 0L;

    public static long getFrequency() {
        return 1000000000L;
    }

    public static long getTimestamp() {
        return System.nanoTime();
    }

    public long getElapsedTicks() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.stopTime == 0L) {
            return System.nanoTime() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public long getElapsedMilliseconds() {
        return this.getElapsedTicks() * 1000L / ManagedStopwatch.getFrequency();
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.stopTime = 0L;
    }

    public void stop() {
        this.stopTime = System.nanoTime();
    }
}

