/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongHolder;
import fm.icelink.MediaControlFrame;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;

public class ByeControlFrame
extends MediaControlFrame {
    public ByeControlFrame(long[] synchronizationSources) {
        this(synchronizationSources, new long[0]);
    }

    public ByeControlFrame(long[] synchronizationSources, long[] contributingSources) {
        this(synchronizationSources, contributingSources, null);
    }

    public ByeControlFrame(long synchronizationSource) {
        this(new long[]{synchronizationSource});
    }

    public ByeControlFrame() {
        super(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + ByeControlFrame.getFixedPayloadHeaderLength()));
        super.setPayloadLengthWithPadding(ByeControlFrame.getFixedPayloadHeaderLength());
    }

    public ByeControlFrame(DataBuffer buffer) {
        super(buffer);
        if (buffer.getLength() < MediaControlFrame.getFixedHeaderLength() + ByeControlFrame.getFixedPayloadHeaderLength()) {
            int num = MediaControlFrame.getFixedHeaderLength() + ByeControlFrame.getFixedPayloadHeaderLength();
            throw new RuntimeException(new Exception(StringExtensions.concat("ByeControlFrame requires a Databuffer of minimum length ", IntegerExtensions.toString(num))));
        }
    }

    public ByeControlFrame(long[] synchronizationSources, long[] contributingSources, String reasonForLeaving) {
        int num5;
        if (synchronizationSources == null) {
            synchronizationSources = new long[]{};
        }
        if (contributingSources == null) {
            contributingSources = new long[]{};
        }
        int length = ArrayExtensions.getLength(synchronizationSources);
        int num2 = ArrayExtensions.getLength(contributingSources);
        int num3 = 0;
        byte[] data = null;
        if (reasonForLeaving != null) {
            data = Utf8.encode(reasonForLeaving);
            num3 = ArrayExtensions.getLength(data) + ByeControlFrame.getFixedReasonForLeavingPayloadHeaderLength();
        }
        super.setDataBuffer(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + (length + num2) * 4 + num3));
        super.setPayloadLengthWithPadding(ByeControlFrame.getFixedPayloadHeaderLength() + (length + num2) * 4 + num3);
        super.setPayloadType(ByeControlFrame.getRegisteredPayloadType());
        int num4 = 0;
        long[] numArray = new long[length + num2];
        for (num5 = 0; num5 < ArrayExtensions.getLength(synchronizationSources); ++num5) {
            numArray[num4++] = synchronizationSources[num5];
        }
        for (num5 = 0; num5 < ArrayExtensions.getLength(contributingSources); ++num5) {
            numArray[num4++] = contributingSources[num5];
        }
        this.setSources(numArray);
        if (this.getReason()) {
            this.setReasonForLeavingPayload(DataBuffer.wrap(data));
        }
    }

    public ByeControlFrame(long[] synchronizationSources, String reasonForLeaving) {
        this(synchronizationSources, new long[0], reasonForLeaving);
    }

    public ByeControlFrame(long synchronizationSource, String reasonForLeaving) {
        this(new long[]{synchronizationSource}, reasonForLeaving);
    }

    public static int getFixedPayloadHeaderLength() {
        return 0;
    }

    public static int getFixedReasonForLeavingPayloadHeaderLength() {
        return 1;
    }

    public boolean getReason() {
        return this.getReasonForLeavingOffset() < super.getDataBuffer().getLength();
    }

    public String getReasonForLeaving() {
        return this.getReason() ? Utf8.decode(this.getReasonForLeavingPayload().toArray()) : null;
    }

    public int getReasonForLeavingLength() {
        return this.getReason() ? super.getDataBuffer().read8(this.getReasonForLeavingOffset()) : 0;
    }

    public int getReasonForLeavingOffset() {
        return this.getSourcesPayloadOffset() + this.getSourcesLength();
    }

    public DataBuffer getReasonForLeavingPayload() {
        return this.getReason() ? super.getDataBuffer().subset(this.getReasonForLeavingOffset() + ByeControlFrame.getFixedReasonForLeavingPayloadHeaderLength(), this.getReasonForLeavingLength()) : null;
    }

    public static int getRegisteredPayloadType() {
        return 203;
    }

    public int getSourceCount() {
        return super.getByte1Last5Bits();
    }

    public long[] getSources() {
        int sourcesPayloadOffset = this.getSourcesPayloadOffset();
        long[] numArray = new long[this.getSourceCount()];
        for (int i = 0; i < ArrayExtensions.getLength(numArray); ++i) {
            long num3 = 0L;
            LongHolder _var0 = new LongHolder(num3);
            boolean _var1 = super.getDataBuffer().tryRead32(sourcesPayloadOffset, _var0);
            num3 = _var0.getValue();
            if (_var1) {
                sourcesPayloadOffset += 4;
            } else {
                return null;
            }
            numArray[i] = num3;
        }
        return numArray;
    }

    public int getSourcesLength() {
        return this.getSourceCount() * 4;
    }

    public int getSourcesPayloadOffset() {
        return MediaControlFrame.getFixedHeaderLength();
    }

    private void setReasonForLeavingLength(int value) {
        super.getDataBuffer().write8(value, this.getReasonForLeavingOffset());
    }

    private void setReasonForLeavingPayload(DataBuffer value) {
        super.getDataBuffer().write(value, this.getReasonForLeavingOffset() + ByeControlFrame.getFixedReasonForLeavingPayloadHeaderLength());
        this.setReasonForLeavingLength(value.getLength());
    }

    private void setSourceCount(int value) {
        super.setByte1Last5Bits(value);
    }

    public void setSources(long[] value) {
        if (value == null) {
            value = new long[]{};
        }
        int num = 0;
        int sourcesPayloadOffset = this.getSourcesPayloadOffset();
        for (int i = 0; i < ArrayExtensions.getLength(value); ++i) {
            if (super.getDataBuffer().write32(value[i], sourcesPayloadOffset)) {
                sourcesPayloadOffset += 4;
                ++num;
                continue;
            }
            Log.error("Could not write source to buffer.");
            return;
        }
        this.setSourceCount(num);
    }
}

