/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Holder;
import java.util.regex.Pattern;

public class Base64 {
    private static Pattern base64Regex = Pattern.compile("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static int[] toInt = new int[128];

    public static String encode(byte[] b) {
        if (b == null) {
            return null;
        }
        return Base64.toString(b, 0, b.length);
    }

    public static String encodeBuffer(DataBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return Base64.toString(buffer.getData(), buffer.getIndex(), buffer.getLength());
    }

    public static byte[] decode(String s) {
        if (s == null) {
            return null;
        }
        if (!base64Regex.matcher(s).matches()) {
            return null;
        }
        return Base64.fromString(s);
    }

    public static Boolean tryEncode(byte[] b, Holder<String> encoded) {
        try {
            String output = Base64.encode(b);
            if (output == null) {
                return false;
            }
            encoded.setValue(output);
            return true;
        }
        catch (Exception ex) {
            encoded.setValue(null);
            return false;
        }
    }

    public static Boolean tryEncodeBuffer(DataBuffer buffer, Holder<String> encoded) {
        try {
            String output = Base64.encodeBuffer(buffer);
            if (output == null) {
                return false;
            }
            encoded.setValue(output);
            return true;
        }
        catch (Exception ex) {
            encoded.setValue(null);
            return false;
        }
    }

    public static Boolean tryDecode(String s, Holder<byte[]> decoded) {
        try {
            byte[] output = Base64.decode(s);
            if (output == null) {
                return false;
            }
            decoded.setValue(output);
            return true;
        }
        catch (Exception ex) {
            decoded.setValue(null);
            return false;
        }
    }

    private static String toString(byte[] bytes, int index, int length) {
        int size = length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = bytes[index + i++];
            byte b1 = i < size ? bytes[index + i++] : (byte)0;
            byte b2 = i < size ? bytes[index + i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    private static byte[] fromString(String s) {
        int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[s.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < s.length(); i += 4) {
            int c0 = toInt[s.charAt(i)];
            int c1 = toInt[s.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = toInt[s.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = toInt[s.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    static {
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base64.toInt[Base64.ALPHABET[i]] = i;
        }
    }
}

