/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    private boolean confirmCheckSum(byte[] sessionInfo) {
        int check = 0;
        int i = 1;
        while (i != sessionInfo.length - 2) {
            check += sessionInfo[i] & 0xFF;
            ++i;
        }
        return sessionInfo[sessionInfo.length - 2] == (byte)(check >> 8) && sessionInfo[sessionInfo.length - 1] == (byte)check;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] plain = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        return plain[0];
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (!this.confirmCheckSum(sessionData)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        if (sessionData[0] != 0) {
            try {
                boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
                byte[] sessionKey = new byte[sessionData.length - 3];
                System.arraycopy(sessionData, 1, sessionKey, 0, sessionKey.length);
                PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionData[0] & 0xFF, sessionKey);
                this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(this.encData.getInputStream()));
                if (withIntegrityPacket) {
                    this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                    this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
                }
                byte[] iv = new byte[dataDecryptor.getBlockSize()];
                int i = 0;
                while (i != iv.length) {
                    int ch = this.encStream.read();
                    if (ch < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    iv[i] = (byte)ch;
                    ++i;
                }
                int v1 = this.encStream.read();
                int v2 = this.encStream.read();
                if (v1 < 0 || v2 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                return this.encStream;
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception starting decryption", e);
            }
        }
        return this.encData.getInputStream();
    }
}

