/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.NetworkTimeProtocol;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import java.util.Date;

public class SRControlFrame
extends ReportControlFrame {
    public static int _registeredPayloadType = 200;

    public static int getFixedSenderInfoPayloadLength() {
        return 20;
    }

    public long getNtpTimestamp() {
        return super.getDataBuffer().read64(8);
    }

    public long getOctetCount() {
        return super.getDataBuffer().read32(24);
    }

    public long getPacketCount() {
        return super.getDataBuffer().read32(20);
    }

    public static int getReportBlockOffset() {
        return MediaControlFrame.getFixedHeaderLength() + ReportControlFrame.getFixedPayloadHeaderLength() + SRControlFrame.getFixedSenderInfoPayloadLength();
    }

    public long getRtpTimestamp() {
        return super.getDataBuffer().read32(16);
    }

    public Date getTimestamp() {
        return NetworkTimeProtocol.ntpToDateTime(this.getNtpTimestamp());
    }

    public void setNtpTimestamp(long value) {
        super.getDataBuffer().write64(value, 8);
    }

    public void setOctetCount(long value) {
        super.getDataBuffer().write32(value, 24);
    }

    public void setPacketCount(long value) {
        super.getDataBuffer().write32(value, 20);
    }

    public void setRtpTimestamp(long value) {
        super.getDataBuffer().write32(value, 16);
    }

    public SRControlFrame(long synchronizationSource, long ntpTimestamp, long rtpTimestamp, long packetCount, long octetCount, ReportBlock reportBlock) {
        super(200, synchronizationSource, reportBlock, SRControlFrame.getReportBlockOffset());
        this.setNtpTimestamp(ntpTimestamp);
        this.setRtpTimestamp(rtpTimestamp);
        this.setPacketCount(packetCount);
        this.setOctetCount(octetCount);
    }

    public SRControlFrame(long synchronizationSource, long ntpTimestamp, long rtpTimestamp, long packetCount, long octetCount, ReportBlock[] reportBlocks) {
        super(200, synchronizationSource, reportBlocks, SRControlFrame.getReportBlockOffset());
        this.setNtpTimestamp(ntpTimestamp);
        this.setRtpTimestamp(rtpTimestamp);
        this.setPacketCount(packetCount);
        this.setOctetCount(octetCount);
    }

    public SRControlFrame(long synchronizationSource, long ntpTimestamp, long rtpTimestamp, long packetCount, long octetCount) {
        this(DataBuffer.allocate(SRControlFrame.getReportBlockOffset()));
        super.setPayloadType(200);
        super.setSynchronizationSource(synchronizationSource);
        this.setNtpTimestamp(ntpTimestamp);
        this.setRtpTimestamp(rtpTimestamp);
        this.setPacketCount(packetCount);
        this.setOctetCount(octetCount);
        super.setPayloadLengthWithPadding(ReportControlFrame.getFixedPayloadHeaderLength() + SRControlFrame.getFixedSenderInfoPayloadLength());
    }

    public SRControlFrame() {
        super(200, SRControlFrame.getReportBlockOffset(), DataBuffer.allocate(SRControlFrame.getReportBlockOffset()));
        super.setPayloadLengthWithPadding(ReportControlFrame.getFixedPayloadHeaderLength() + SRControlFrame.getFixedSenderInfoPayloadLength());
    }

    public SRControlFrame(DataBuffer buffer) {
        super(200, SRControlFrame.getReportBlockOffset(), buffer);
        super.setPayloadType(200);
    }
}

