/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.HashMapExtensions;
import fm.icelink.IFunction1;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import java.util.HashMap;

class RtpSendBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private TFrame[] __frameBuffer;
    private HashMap<Integer, int[]> __indexToSequenceMap;
    private Object __ioLock = new Object();
    private int __maxLength = 1;
    private HashMap<Integer, Integer> __sequenceToIndexMap;
    private long _highestFrameIndex = 0L;
    private int _highestSequenceNumber = -1;
    private String _name;

    public int getLength() {
        return this.__maxLength;
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFrame read(int rtpSequenceNumber) {
        Object object = this.__ioLock;
        synchronized (object) {
            if (this.__sequenceToIndexMap.containsKey(rtpSequenceNumber)) {
                return this.__frameBuffer[HashMapExtensions.getItem(this.__sequenceToIndexMap).get(rtpSequenceNumber)];
            }
            return null;
        }
    }

    public RtpSendBuffer(String name, int size, IFunction1<Integer, TFrame[]> createArrayCallback) {
        this.setName(name);
        this.setLength(size);
        this.__frameBuffer = (MediaFrame[])createArrayCallback.invoke(size);
        this.__sequenceToIndexMap = new HashMap();
        this.__indexToSequenceMap = new HashMap();
    }

    private void setLength(int value) {
        this.__maxLength = MathAssistant.max(this.getLength(), value);
    }

    private void setName(String value) {
        this._name = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(TFrame frame) {
        Object object = this.__ioLock;
        synchronized (object) {
            int index = (int)(((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() % (long)this.getLength());
            TFrame local = this.__frameBuffer[index];
            if (local != null && ((MediaBuffer)((MediaFrame)local).getBuffer()).getSequenceNumber() > ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber()) {
                return false;
            }
            this.__frameBuffer[index] = frame;
            if (this.__indexToSequenceMap.containsKey(index)) {
                for (int num2 : HashMapExtensions.getItem(this.__indexToSequenceMap).get(index)) {
                    HashMapExtensions.remove(this.__sequenceToIndexMap, num2);
                }
                HashMapExtensions.remove(this.__indexToSequenceMap, index);
            }
            int[] numArray = null;
            for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
                MediaBuffer local2 = frame.getBuffers()[ArrayExtensions.getLength(frame.getBuffers()) - 1];
                if (!((MediaFormat)local2.getFormat()).getIsPacketized()) continue;
                numArray = new int[ArrayExtensions.getLength(local2.getDataBuffers())];
                for (int j = 0; j < ArrayExtensions.getLength(local2.getRtpSequenceNumbers()); ++j) {
                    HashMapExtensions.add(this.__sequenceToIndexMap, local2.getRtpSequenceNumbers()[j], index);
                    numArray[j] = local2.getRtpSequenceNumbers()[j];
                }
                break;
            }
            if (numArray == null) {
                Log.error("Cannot write to SendBuffer. No rtp packets found in frame. Are you missing a packetizer?");
                return false;
            }
            HashMapExtensions.add(this.__indexToSequenceMap, index, numArray);
            this._highestSequenceNumber = numArray[ArrayExtensions.getLength(numArray) - 1];
            this._highestFrameIndex = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getLastSequenceNumber();
            return true;
        }
    }
}

