/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioSource;
import fm.icelink.AudioTrack;
import fm.icelink.Future;
import fm.icelink.IAction1;
import fm.icelink.ILocalMedia;
import fm.icelink.IMedia;
import fm.icelink.Media;
import fm.icelink.MediaSourceBase;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.VideoSource;
import fm.icelink.VideoTrack;
import java.util.ArrayList;

public class LocalMedia
extends Media<AudioTrack, VideoTrack>
implements ILocalMedia<LocalMedia, AudioTrack, VideoTrack>,
IMedia<AudioTrack, VideoTrack> {
    private void abortStart(final Promise<LocalMedia> promise, final Exception exception) {
        this.stop().then(new IAction1<LocalMedia>(){

            @Override
            public void invoke(LocalMedia result) {
                promise.reject(exception);
            }
        }, new IAction1<Exception>(){

            @Override
            public void invoke(Exception ex) {
                promise.reject(exception);
            }
        });
    }

    protected AudioTrack[] arrayFromAudioTracks(ArrayList<AudioTrack> tracks) {
        return tracks.toArray(new AudioTrack[0]);
    }

    protected VideoTrack[] arrayFromVideoTracks(ArrayList<VideoTrack> tracks) {
        return tracks.toArray(new VideoTrack[0]);
    }

    @Override
    public Future<Object> changeAudioSourceInput(SourceInput audioSourceInput) {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            return audioTrack.changeSourceInput(audioSourceInput);
        }
        return null;
    }

    @Override
    public Future<Object> changeVideoSourceInput(SourceInput videoSourceInput) {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.changeSourceInput(videoSourceInput);
        }
        return null;
    }

    @Override
    protected ArrayList<AudioTrack> createAudioTrackCollection() {
        return new ArrayList<AudioTrack>();
    }

    @Override
    protected ArrayList<VideoTrack> createVideoTrackCollection() {
        return new ArrayList<VideoTrack>();
    }

    private Future<LocalMedia> doStart(Promise<LocalMedia> promise) {
        Object[] mediaSources = this.getMediaSources();
        if (ArrayExtensions.getLength(mediaSources) > 0) {
            this.doStartSource(promise, (MediaSourceBase[])mediaSources, 0);
            return promise;
        }
        promise.resolve(this);
        return promise;
    }

    private void doStartSource(final Promise<LocalMedia> promise, final MediaSourceBase[] mediaSources, final int index) {
        IAction1<Object> resolveAction = null;
        IAction1<Exception> rejectAction = null;
        if (index < ArrayExtensions.getLength(mediaSources)) {
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object o) {
                        LocalMedia.this.doStartSource(promise, mediaSources, index + 1);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception ex) {
                        LocalMedia.this.abortStart(promise, ex);
                    }
                };
            }
            mediaSources[index].start().then(resolveAction, rejectAction);
        } else {
            promise.resolve(this);
        }
    }

    private Future<LocalMedia> doStop(Promise<LocalMedia> promise) {
        Object[] mediaSources = this.getMediaSources();
        if (ArrayExtensions.getLength(mediaSources) > 0) {
            this.doStopSource(promise, (MediaSourceBase[])mediaSources, 0);
            return promise;
        }
        promise.resolve(this);
        return promise;
    }

    private void doStopSource(final Promise<LocalMedia> promise, final MediaSourceBase[] mediaSources, final int index) {
        IAction1<Object> resolveAction = null;
        IAction1<Exception> rejectAction = null;
        if (index < ArrayExtensions.getLength(mediaSources)) {
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object result) {
                        LocalMedia.this.doStopSource(promise, mediaSources, index + 1);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception ex) {
                        promise.reject(ex);
                    }
                };
            }
            mediaSources[index].stop().then(resolveAction, rejectAction);
        } else {
            promise.resolve(this);
        }
    }

    public AudioSource getAudioSource() {
        Object[] audioSources = this.getAudioSources();
        if (audioSources == null || ArrayExtensions.getLength(audioSources) == 0) {
            return null;
        }
        return audioSources[0];
    }

    @Override
    public SourceInput getAudioSourceInput() {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            return audioTrack.getSourceInput();
        }
        return null;
    }

    @Override
    public Future<SourceInput[]> getAudioSourceInputs() {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            return audioTrack.getSourceInputs();
        }
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        promise.resolve(new SourceInput[0]);
        return promise;
    }

    public AudioSource[] getAudioSources() {
        ArrayList list = new ArrayList();
        for (AudioTrack track : this.getAudioTracks()) {
            if (track.getSource() == null) continue;
            list.add(track.getSource());
        }
        return list.toArray(new AudioSource[0]);
    }

    public MediaSourceBase[] getMediaSources() {
        ArrayList list = new ArrayList();
        ArrayListExtensions.addRange(list, this.getAudioSources());
        ArrayListExtensions.addRange(list, this.getVideoSources());
        return list.toArray(new MediaSourceBase[0]);
    }

    public VideoSource getVideoSource() {
        Object[] videoSources = this.getVideoSources();
        if (videoSources == null || ArrayExtensions.getLength(videoSources) == 0) {
            return null;
        }
        return videoSources[0];
    }

    @Override
    public SourceInput getVideoSourceInput() {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.getSourceInput();
        }
        return null;
    }

    @Override
    public Future<SourceInput[]> getVideoSourceInputs() {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.getSourceInputs();
        }
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        promise.resolve(new SourceInput[0]);
        return promise;
    }

    public VideoSource[] getVideoSources() {
        ArrayList list = new ArrayList();
        for (VideoTrack track : this.getVideoTracks()) {
            if (track.getSource() == null) continue;
            list.add(track.getSource());
        }
        return list.toArray(new VideoSource[0]);
    }

    @Override
    public void setAudioSourceInput(SourceInput value) {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            audioTrack.setSourceInput(value);
        }
    }

    @Override
    public void setVideoSourceInput(SourceInput value) {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            videoTrack.setSourceInput(value);
        }
    }

    @Override
    public Future<LocalMedia> start() {
        return this.doStart(new Promise<LocalMedia>());
    }

    @Override
    public Future<LocalMedia> stop() {
        return this.doStop(new Promise<LocalMedia>());
    }
}

