/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ConnectionState {
    New(1),
    Initializing(2),
    Connecting(3),
    Connected(4),
    Failing(5),
    Failed(6),
    Closing(7),
    Closed(8);

    private final int value;
    private static final Map<Integer, ConnectionState> lookup;

    private ConnectionState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static ConnectionState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, ConnectionState>();
        for (ConnectionState s : EnumSet.allOf(ConnectionState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

