/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AesCounterContext {
    private Cipher cipher;

    public AesCounterContext(DataBuffer key) {
        try {
            this.cipher = Cipher.getInstance("AES/ECB/NoPadding");
            this.cipher.init(1, new SecretKeySpec(key.getData(), key.getIndex(), key.getLength(), "AES"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void clear() {
    }

    public boolean generateKeystream(DataBuffer output, int length, byte[] counter) {
        try {
            for (int i = 0; i < length; i += 16) {
                this.cipher.update(counter, 0, 16, output.getData(), output.getIndex() + i);
                AesCounterContext.incrementCounter(counter);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void incrementCounter(byte[] counter) {
        int lowerByte = BitAssistant.castInteger(counter[15]);
        if (lowerByte == 255) {
            counter[15] = 0;
            int upperByte = BitAssistant.castInteger(counter[14]);
            counter[14] = upperByte == 255 ? (byte)0 : (byte)(upperByte + 1);
        } else {
            counter[15] = (byte)(lowerByte + 1);
        }
    }
}

