/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.LongExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.ice.CandidateType;
import java.util.HashMap;

public class CandidateAttribute
extends Attribute {
    private String __candidateType;
    private String __connectionAddress;
    private String __foundation = StringExtensions.empty;
    private int _componentId;
    private HashMap<String, String> _extensions;
    private int _port;
    private long _priority;
    private String _protocol;
    private String _relatedAddress;
    private int _relatedPort;

    private CandidateAttribute() {
        super.setAttributeType(AttributeType.IceCandidateAttribute);
    }

    public CandidateAttribute(String foundation, long priority, String connectionAddress, int port, String candidateType, int componentId) {
        this(foundation, priority, connectionAddress, port, candidateType, null, 0, "udp", componentId);
    }

    public CandidateAttribute(String foundation, long priority, String connectionAddress, int port, String candidateType, String relatedAddress, int relatedPort, String protocol, int componentId) {
        super.setAttributeType(AttributeType.IceCandidateAttribute);
        this.setFoundation(foundation);
        this.setProtocol(protocol);
        this.setPriority(priority);
        this.setConnectionAddress(connectionAddress);
        this.setPort(port);
        this.setCandidateType(candidateType);
        this.setRelatedAddress(relatedAddress);
        this.setRelatedPort(relatedPort);
        this.setComponentId(componentId);
        this.setExtensions(new HashMap<String, String>());
    }

    public static CandidateAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ");
        String str = StringExtensions.substring(value, 0, index);
        value = value.substring(index + 1);
        index = StringExtensions.indexOf(value, " ");
        int num2 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, index));
        value = value.substring(index + 1);
        index = StringExtensions.indexOf(value, " ");
        String str2 = StringExtensions.substring(value, 0, index);
        value = value.substring(index + 1);
        index = StringExtensions.indexOf(value, " ");
        long num3 = ParseAssistant.parseLongValue(StringExtensions.substring(value, 0, index));
        value = value.substring(index + 1);
        index = StringExtensions.indexOf(value, " ");
        String str3 = StringExtensions.substring(value, 0, index);
        value = value.substring(index + 1);
        index = StringExtensions.indexOf(value, " ");
        int num4 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, index));
        value = value.substring(index + 1);
        HashMap<String, String> dictionary = new HashMap<String, String>();
        Object[] strArray = StringExtensions.split(value, new char[]{' '});
        int length = ArrayExtensions.getLength(strArray);
        Object str4 = null;
        Object str5 = null;
        int num6 = 0;
        if (length % 2 == 1) {
            --length;
        }
        for (int i = 0; i < length; i += 2) {
            Object str6 = strArray[i];
            Object s = strArray[i + 1];
            if (Global.equals(str6, "typ")) {
                str4 = s;
                continue;
            }
            if (Global.equals(str6, "raddr")) {
                str5 = s;
                continue;
            }
            if (Global.equals(str6, "rport")) {
                num6 = ParseAssistant.parseIntegerValue((String)s);
                continue;
            }
            HashMapExtensions.set(HashMapExtensions.getItem(dictionary), str6, s);
        }
        CandidateAttribute attribute = new CandidateAttribute();
        attribute.setFoundation(str);
        attribute.setComponentId(num2);
        attribute.setProtocol(str2);
        attribute.setPriority(num3);
        attribute.setConnectionAddress(str3);
        attribute.setPort(num4);
        attribute.setExtensions(dictionary);
        attribute.setCandidateType((String)str4);
        attribute.setRelatedAddress((String)str5);
        attribute.setRelatedPort(num6);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, this.getFoundation());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getComponentId()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getProtocol());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, LongExtensions.toString(this.getPriority()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getConnectionAddress());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getPort()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, "typ");
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getCandidateType());
        if (!Global.equals(this.getCandidateType(), CandidateType.getHost()) && this.getRelatedAddress() != null) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, "raddr");
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, this.getRelatedAddress());
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, "rport");
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getRelatedPort()));
        }
        for (String str : HashMapExtensions.getKeys(this.getExtensions())) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, str);
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, HashMapExtensions.getItem(this.getExtensions()).get(str));
        }
        return builder.toString();
    }

    public String getCandidateType() {
        return this.__candidateType;
    }

    public int getComponentId() {
        return this._componentId;
    }

    public String getConnectionAddress() {
        return this.__connectionAddress;
    }

    public HashMap<String, String> getExtensions() {
        return this._extensions;
    }

    public String getFoundation() {
        return this.__foundation;
    }

    public int getPort() {
        return this._port;
    }

    public long getPriority() {
        return this._priority;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getRelatedAddress() {
        return this._relatedAddress;
    }

    public int getRelatedPort() {
        return this._relatedPort;
    }

    public void setCandidateType(String value) {
        if (value == null) {
            throw new RuntimeException(new Exception("Candidate type cannot be null."));
        }
        this.__candidateType = value;
    }

    public void setComponentId(int value) {
        this._componentId = value;
    }

    public void setConnectionAddress(String value) {
        if (value == null) {
            throw new RuntimeException(new Exception("Connection address cannot be null."));
        }
        this.__connectionAddress = value;
    }

    private void setExtensions(HashMap<String, String> value) {
        this._extensions = value;
    }

    public void setFoundation(String value) {
        if (value == null) {
            throw new RuntimeException(new Exception("Foundation cannot be null."));
        }
        this.__foundation = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    public void setPriority(long value) {
        this._priority = value;
    }

    public void setProtocol(String value) {
        this._protocol = value;
    }

    public void setRelatedAddress(String value) {
        this._relatedAddress = value;
    }

    public void setRelatedPort(int value) {
        this._relatedPort = value;
    }
}

