/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.StreamDirection;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeCollection;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.Bandwidth;
import fm.icelink.sdp.ConnectionData;
import fm.icelink.sdp.CryptoAttribute;
import fm.icelink.sdp.DirectionAttribute;
import fm.icelink.sdp.EncryptionKey;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MaxPacketTimeAttribute;
import fm.icelink.sdp.Media;
import fm.icelink.sdp.PacketTimeAttribute;
import fm.icelink.sdp.QualityAttribute;
import fm.icelink.sdp.SetupAttribute;
import fm.icelink.sdp.Utility;
import fm.icelink.sdp.ice.FingerprintAttribute;
import fm.icelink.sdp.ice.PasswordAttribute;
import fm.icelink.sdp.ice.UfragAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttributeSubType;
import fm.icelink.sdp.rtcp.FeedbackAttributeType;
import fm.icelink.sdp.rtp.MapAttribute;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.sctp.MaxMessageSizeAttribute;
import java.util.ArrayList;
import java.util.HashMap;

public class MediaDescription {
    private ArrayList<Bandwidth> __bandwidths = new ArrayList();
    private AttributeCollection __mediaAttributes = new AttributeCollection();
    private ArrayList<Attribute> __orphanedAttributes = new ArrayList();
    private ConnectionData _connectionData;
    private EncryptionKey _encryptionKey;
    private Media _media;
    private String _mediaTitle;

    public void addBandwidth(Bandwidth bandwidth) {
        this.__bandwidths.add(bandwidth);
    }

    public void addMediaAttribute(Attribute attribute) {
        FormatParametersAttribute attribute3;
        Class<?> type = attribute.getClass();
        boolean flag = Attribute.isMediaLevel(type);
        boolean flag2 = Attribute.isSessionLevel(type);
        if (!flag && !flag2) {
            throw new RuntimeException(new Exception("Attribute is not registered."));
        }
        if (flag2 && !flag) {
            throw new RuntimeException(new Exception("Attribute is session-only."));
        }
        if (Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtcpFeedbackAttribute) || Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.FormatParametersAttribute)) {
            int payloadType = -1;
            FeedbackAttribute attribute2 = null;
            attribute3 = null;
            if (Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtcpFeedbackAttribute)) {
                attribute2 = (FeedbackAttribute)attribute;
                payloadType = attribute2.getPayloadType();
            } else {
                attribute3 = (FormatParametersAttribute)attribute;
                payloadType = attribute3.getFormat();
            }
            boolean flag3 = false;
            if (payloadType > -1) {
                Attribute[] rtpMapAttributes;
                Attribute[] attributeArray = rtpMapAttributes = this.getRtpMapAttributes();
                int n = attributeArray.length;
                for (int i = 0; i < n; ++i) {
                    Attribute attribute4 = attributeArray[i];
                    MapAttribute attribute5 = (MapAttribute)attribute4;
                    if (payloadType != attribute5.getPayloadType()) continue;
                    flag3 = true;
                    if (attribute2 != null) {
                        attribute5.addRelatedRtcpFeedbackAttribute(attribute2);
                    }
                    if (attribute3 == null) continue;
                    attribute5.setRelatedFormatParametersAttribute(attribute3);
                }
            }
            if (!flag3) {
                this.__orphanedAttributes.add(attribute);
            }
        } else {
            this.__mediaAttributes.addAttribute(attribute);
        }
        if (Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtpMapAttribute)) {
            Attribute[] attributeArray2;
            MapAttribute attribute6 = (MapAttribute)attribute;
            int num2 = attribute6.getPayloadType();
            for (Attribute attribute7 : attributeArray2 = this.__orphanedAttributes.toArray(new Attribute[0])) {
                if (Global.equals((Object)attribute7.getAttributeType(), (Object)AttributeType.RtcpFeedbackAttribute)) {
                    FeedbackAttribute attribute8 = (FeedbackAttribute)attribute7;
                    if (attribute8.getPayloadType() != num2) continue;
                    attribute6.addRelatedRtcpFeedbackAttribute(attribute8);
                    this.__orphanedAttributes.remove(attribute7);
                    continue;
                }
                if (!Global.equals((Object)attribute7.getAttributeType(), (Object)AttributeType.FormatParametersAttribute) || (attribute3 = (FormatParametersAttribute)attribute7).getFormat() != num2) continue;
                attribute6.setRelatedFormatParametersAttribute(attribute3);
                this.__orphanedAttributes.remove(attribute7);
            }
        }
    }

    public Bandwidth[] getBandwidths() {
        return this.__bandwidths.toArray(new Bandwidth[0]);
    }

    public Attribute[] getCandidateAttributes() {
        Attribute[] attributes = null;
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.IceCandidateAttribute, _var0);
        attributes = _var0.getValue();
        if (_var1) {
            return attributes;
        }
        return new Attribute[0];
    }

    public FeedbackAttribute getCcmFirFeedbackAttribute(int payloadType) {
        return this.getRtcpFeedbackAttribute(payloadType, FeedbackAttributeType.getCcm(), FeedbackAttributeSubType.getFir());
    }

    public ConnectionData getConnectionData() {
        return this._connectionData;
    }

    public CryptoAttribute[] getCryptoAttributes() {
        return MediaDescription.getCryptoAttributes(this.__mediaAttributes);
    }

    static CryptoAttribute[] getCryptoAttributes(AttributeCollection attributes) {
        Object[] attributeArray = null;
        Holder<Object> _var0 = new Holder<Object>(attributeArray);
        boolean _var1 = attributes.tryGetAttributes(AttributeType.CryptoAttribute, _var0);
        attributeArray = _var0.getValue();
        if (_var1) {
            CryptoAttribute[] attributeArray2 = new CryptoAttribute[ArrayExtensions.getLength(attributeArray)];
            int index = 0;
            for (Object attribute : attributeArray) {
                attributeArray2[index] = (CryptoAttribute)attribute;
                ++index;
            }
            return attributeArray2;
        }
        return null;
    }

    public EncryptionKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public FingerprintAttribute getFingerprintAttribute() {
        return MediaDescription.getFingerprintAttribute(this.__mediaAttributes);
    }

    static FingerprintAttribute getFingerprintAttribute(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.IceFingerprintAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (FingerprintAttribute)attribute;
        }
        return null;
    }

    public FormatParametersAttribute getFormatParametersAttribute(int payloadType) {
        Attribute[] attributes = null;
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.RtpMapAttribute, _var0);
        attributes = _var0.getValue();
        if (_var1 && attributes != null) {
            for (Attribute attribute : attributes) {
                MapAttribute attribute2 = (MapAttribute)attribute;
                if (attribute2.getPayloadType() != payloadType) continue;
                return attribute2.getRelatedFormatParametersAttribute();
            }
        }
        return null;
    }

    public Attribute[] getIceOptionAttributes() {
        return MediaDescription.getIceOptionAttributes(this.__mediaAttributes);
    }

    static Attribute[] getIceOptionAttributes(AttributeCollection attributes) {
        Attribute[] attributeArray = null;
        Holder<Object> _var0 = new Holder<Object>(attributeArray);
        boolean _var1 = attributes.tryGetAttributes(AttributeType.IceOptionsAttribute, _var0);
        attributeArray = _var0.getValue();
        if (_var1) {
            return attributeArray;
        }
        return new Attribute[0];
    }

    static PasswordAttribute getIcePasswordAttribute(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.IcePasswordAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (PasswordAttribute)attribute;
        }
        return null;
    }

    public PasswordAttribute getIcePasswordAttribute() {
        return MediaDescription.getIcePasswordAttribute(this.__mediaAttributes);
    }

    public UfragAttribute getIceUfragAttribute() {
        return MediaDescription.getIceUfragAttribute(this.__mediaAttributes);
    }

    static UfragAttribute getIceUfragAttribute(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.IceUfragAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (UfragAttribute)attribute;
        }
        return null;
    }

    public MaxPacketTimeAttribute getMaxPacketTimeAttribute() {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = this.__mediaAttributes.tryGetAttribute(AttributeType.MaxPacketTimeAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (MaxPacketTimeAttribute)attribute;
        }
        return null;
    }

    public Media getMedia() {
        return this._media;
    }

    public Attribute[] getMediaAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Attribute attribute : this.__mediaAttributes.toArray()) {
            FormatParametersAttribute relatedFormatParametersAttribute;
            list.add(attribute);
            if (!Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtpMapAttribute)) continue;
            MapAttribute attribute2 = (MapAttribute)attribute;
            FeedbackAttribute[] relatedRtcpFeedbackAttributes = attribute2.getRelatedRtcpFeedbackAttributes();
            if (relatedRtcpFeedbackAttributes != null) {
                for (FeedbackAttribute attribute3 : relatedRtcpFeedbackAttributes) {
                    list.add(attribute3);
                }
            }
            if ((relatedFormatParametersAttribute = attribute2.getRelatedFormatParametersAttribute()) == null) continue;
            list.add(relatedFormatParametersAttribute);
        }
        return list.toArray(new Attribute[0]);
    }

    public String getMediaTitle() {
        return this._mediaTitle;
    }

    public FeedbackAttribute getNackFeedbackAttribute(int payloadType) {
        return this.getRtcpFeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), null);
    }

    public FeedbackAttribute getNackPliFeedbackAttribute(int payloadType) {
        return this.getRtcpFeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getPli());
    }

    public FeedbackAttribute getNackRpsiFeedbackAttribute(int payloadType) {
        return this.getRtcpFeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getRpsi());
    }

    public FeedbackAttribute getNackSliFeedbackAttribute(int payloadType) {
        return this.getRtcpFeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getSli());
    }

    public PacketTimeAttribute getPacketTimeAttribute() {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = this.__mediaAttributes.tryGetAttribute(AttributeType.PacketTimeAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (PacketTimeAttribute)attribute;
        }
        return null;
    }

    static QualityAttribute getQualityAttribute(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.QualityAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (QualityAttribute)attribute;
        }
        return null;
    }

    public QualityAttribute getQualityAttribute() {
        return MediaDescription.getQualityAttribute(this.__mediaAttributes);
    }

    public fm.icelink.sdp.rtcp.Attribute getRtcpAttribute() {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = this.__mediaAttributes.tryGetAttribute(AttributeType.RtcpAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (fm.icelink.sdp.rtcp.Attribute)attribute;
        }
        return null;
    }

    public FeedbackAttribute getRtcpFeedbackAttribute(int payloadType, String type, String subType) {
        Attribute[] attributes = null;
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.RtpMapAttribute, _var0);
        attributes = _var0.getValue();
        if (_var1) {
            for (Attribute attribute : attributes) {
                MapAttribute attribute2 = (MapAttribute)attribute;
                if (attribute2.getPayloadType() != payloadType) continue;
                return attribute2.getRelatedRtcpFeedbackAttribute(payloadType, type, subType);
            }
        }
        return null;
    }

    static boolean getRtcpMultiplexingSupport(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.RtcpMuxAttribute, _var0);
        attribute = _var0.getValue();
        Holder<Attribute> _var2 = new Holder<Attribute>(attribute);
        boolean _var3 = attributes.tryGetAttribute(AttributeType.RtcpAttribute, _var2);
        attribute = _var2.getValue();
        return _var1 || !_var3;
    }

    public boolean getRtcpMultiplexingSupported() {
        return MediaDescription.getRtcpMultiplexingSupport(this.__mediaAttributes);
    }

    public MapAttribute getRtpMapAttribute(String formatName, int clockRate, String formatParameters, IntegerHolder rtpMapAttributeIndex) {
        rtpMapAttributeIndex.setValue(-1);
        Object[] rtpMapAttributes = this.getRtpMapAttributes();
        MapAttribute attribute = null;
        for (int i = 0; i < ArrayExtensions.getLength(rtpMapAttributes); ++i) {
            attribute = (MapAttribute)rtpMapAttributes[i];
            if (!Global.equals(attribute.getFormatName(), formatName) || attribute.getClockRate() != clockRate || !Global.equals(attribute.getFormatParameters(), formatParameters)) continue;
            rtpMapAttributeIndex.setValue(i);
            return attribute;
        }
        return null;
    }

    public MapAttribute getRtpMapAttribute(String formatName, int clockRate, String formatParameters) {
        int rtpMapAttributeIndex = -1;
        IntegerHolder _var0 = new IntegerHolder(rtpMapAttributeIndex);
        MapAttribute _var1 = this.getRtpMapAttribute(formatName, clockRate, formatParameters, _var0);
        rtpMapAttributeIndex = _var0.getValue();
        return _var1;
    }

    public MapAttribute[] getRtpMapAttributes(String formatName, int clockRate, String formatParameters) {
        int[] rtpMapAttributeIndices = new int[]{};
        Holder<int[]> _var0 = new Holder<int[]>(rtpMapAttributeIndices);
        MapAttribute[] _var1 = this.getRtpMapAttributes(formatName, clockRate, formatParameters, _var0);
        rtpMapAttributeIndices = _var0.getValue();
        return _var1;
    }

    public Attribute[] getRtpMapAttributes() {
        Attribute[] attributes = null;
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.RtpMapAttribute, _var0);
        attributes = _var0.getValue();
        return attributes == null ? (Attribute[])new MapAttribute[0] : attributes;
    }

    public MapAttribute[] getRtpMapAttributes(String formatName, int clockRate, String formatParameters, Holder<int[]> rtpMapAttributeIndices) {
        int num;
        Object[] rtpMapAttributes = this.getRtpMapAttributes();
        MapAttribute item = null;
        ArrayList<MapAttribute> list = new ArrayList<MapAttribute>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        for (num = 0; num < ArrayExtensions.getLength(rtpMapAttributes); ++num) {
            item = (MapAttribute)rtpMapAttributes[num];
            if (!Global.equals(item.getFormatName(), formatName) || item.getClockRate() != clockRate || !Global.equals(item.getFormatParameters(), formatParameters)) continue;
            list.add(item);
            list2.add(num);
        }
        if (ArrayListExtensions.getCount(list2) == 0) {
            rtpMapAttributeIndices.setValue(new int[0]);
            return new MapAttribute[0];
        }
        rtpMapAttributeIndices.setValue(new int[ArrayListExtensions.getCount(list2)]);
        for (num = 0; num < ArrayListExtensions.getCount(list2); ++num) {
            rtpMapAttributeIndices.getValue()[num] = (Integer)ArrayListExtensions.getItem(list2).get(num);
        }
        return list.toArray(new MapAttribute[0]);
    }

    public fm.icelink.sdp.sctp.MapAttribute getSctpMapAttribute() {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = this.__mediaAttributes.tryGetAttribute(AttributeType.SctpMapAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (fm.icelink.sdp.sctp.MapAttribute)attribute;
        }
        return null;
    }

    public MaxMessageSizeAttribute getSctpMaxMessageSizeAttribute() {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = this.__mediaAttributes.tryGetAttribute(AttributeType.SctpMaxMessageSizeAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (MaxMessageSizeAttribute)attribute;
        }
        return null;
    }

    public SetupAttribute getSetupAttribute() {
        return MediaDescription.getSetupAttribute(this.__mediaAttributes);
    }

    static SetupAttribute getSetupAttribute(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.SetupAttribute, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            return (SetupAttribute)attribute;
        }
        return null;
    }

    public SsrcAttribute getSsrcAttribute(long ssrc, String name, String value) {
        Attribute[] attributes = null;
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.RtpSsrcAttribute, _var0);
        attributes = _var0.getValue();
        if (_var1) {
            for (Attribute attribute : attributes) {
                SsrcAttribute attribute2 = (SsrcAttribute)attribute;
                if (attribute2 == null || attribute2.getSynchronizationSource() != ssrc || !Global.equals(attribute2.getName(), name) || !Global.equals(attribute2.getValue(), value)) continue;
                return attribute2;
            }
        }
        return null;
    }

    public Attribute[] getSsrcAttributes() {
        Attribute[] attributes = null;
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.RtpSsrcAttribute, _var0);
        attributes = _var0.getValue();
        return attributes == null ? (Attribute[])new SsrcAttribute[0] : attributes;
    }

    public SsrcAttribute[] getSsrcAttributes(long ssrc, String name) {
        Attribute[] attributes = null;
        ArrayList<SsrcAttribute> list = new ArrayList<SsrcAttribute>();
        Holder<Object> _var0 = new Holder<Object>(attributes);
        boolean _var1 = this.__mediaAttributes.tryGetAttributes(AttributeType.RtpSsrcAttribute, _var0);
        attributes = _var0.getValue();
        if (_var1) {
            for (Attribute attribute : attributes) {
                SsrcAttribute item = (SsrcAttribute)attribute;
                if (item == null || item.getSynchronizationSource() != ssrc || !Global.equals(item.getName(), name)) continue;
                list.add(item);
            }
        }
        return list.toArray(new SsrcAttribute[0]);
    }

    public SsrcAttribute[] getSsrcAttributes(long ssrc) {
        Attribute[] ssrcAttributes = this.getSsrcAttributes();
        ArrayList<SsrcAttribute> list = new ArrayList<SsrcAttribute>();
        for (Attribute attribute : ssrcAttributes) {
            SsrcAttribute item = (SsrcAttribute)attribute;
            if (item == null || item.getSynchronizationSource() != ssrc) continue;
            list.add(item);
        }
        return list.toArray(new SsrcAttribute[0]);
    }

    static StreamDirection getStreamDirection(AttributeCollection attributes) {
        Attribute attribute = null;
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = attributes.tryGetAttribute(AttributeType.DirectionAttribute, _var0);
        attribute = _var0.getValue();
        if (attributes != null && _var1) {
            return ((DirectionAttribute)attribute).getStreamDirection();
        }
        return StreamDirection.Unset;
    }

    public StreamDirection getStreamDirection() {
        return MediaDescription.getStreamDirection(this.__mediaAttributes);
    }

    public boolean getSupportsRtcpMultiplexing() {
        return MediaDescription.getRtcpMultiplexingSupport(this.__mediaAttributes);
    }

    public void insertMediaAttribute(Attribute attribute, int index) {
        this.addMediaAttribute(attribute);
    }

    public boolean insertNackPliAttribute(String formatName, int clockRate, String formatParameters) {
        Object attribute;
        Object[] attributeArray = this.getRtpMapAttributes(formatName, clockRate, formatParameters);
        Object object = attribute = ArrayExtensions.getLength(attributeArray) > 0 ? attributeArray[0] : null;
        if (attribute != null) {
            FeedbackAttribute attribute2 = FeedbackAttribute.nackPliAttribute(((MapAttribute)attribute).getPayloadType());
            ((MapAttribute)attribute).addRelatedRtcpFeedbackAttribute(attribute2);
            return true;
        }
        return false;
    }

    public MediaDescription(Media media) {
        if (media == null) {
            throw new RuntimeException(new Exception("media cannot be null."));
        }
        this.setMedia(media);
    }

    public static MediaDescription parse(String s) {
        Object[] strArray = Utility.splitAndClean(s);
        if (strArray[0].charAt(0) != 'm') {
            return null;
        }
        MediaDescription description = new MediaDescription(Media.parse(strArray[0]));
        HashMap dictionary = new HashMap();
        HashMap dictionary2 = new HashMap();
        HashMap dictionary3 = new HashMap();
        for (int i = 1; i < ArrayExtensions.getLength(strArray); ++i) {
            Object str = strArray[i];
            if (((String)str).charAt(0) == 'a') {
                MapAttribute attribute5;
                String str2;
                Attribute attribute = Attribute.parse((String)str);
                if (!Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtcpFeedbackAttribute) && !Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.FormatParametersAttribute)) {
                    description.addMediaAttribute(attribute);
                    if (Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtpMapAttribute)) {
                        MapAttribute attribute2 = (MapAttribute)attribute;
                        str2 = IntegerExtensions.toString(attribute2.getPayloadType());
                        HashMapExtensions.set(HashMapExtensions.getItem(dictionary2), str2, attribute2);
                        FormatParametersAttribute attribute3 = null;
                        ArrayList list = null;
                        Holder<Object> _var0 = new Holder<Object>(attribute3);
                        boolean _var1 = HashMapExtensions.tryGetValue(dictionary, str2, _var0);
                        attribute3 = _var0.getValue();
                        if (_var1) {
                            attribute2.setRelatedFormatParametersAttribute(attribute3);
                        }
                        Holder<Object> _var2 = new Holder<Object>(list);
                        boolean _var3 = HashMapExtensions.tryGetValue(dictionary3, str2, _var2);
                        list = _var2.getValue();
                        if (_var3) {
                            attribute2.resetRtcpFeedbackAttributes(list.toArray(new FeedbackAttribute[0]));
                        }
                    }
                } else if (Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtcpFeedbackAttribute)) {
                    FeedbackAttribute item = (FeedbackAttribute)attribute;
                    str2 = IntegerExtensions.toString(item.getPayloadType());
                    ArrayList<FeedbackAttribute> list2 = null;
                    Holder<Object> _var4 = new Holder<Object>(list2);
                    boolean _var5 = HashMapExtensions.tryGetValue(dictionary3, str2, _var4);
                    list2 = _var4.getValue();
                    if (!_var5) {
                        list2 = new ArrayList<FeedbackAttribute>();
                    }
                    list2.add(item);
                    HashMapExtensions.set(HashMapExtensions.getItem(dictionary3), str2, list2);
                    attribute5 = null;
                    Holder<MapAttribute> _var6 = new Holder<MapAttribute>(attribute5);
                    boolean _var7 = HashMapExtensions.tryGetValue(dictionary2, str2, _var6);
                    attribute5 = _var6.getValue();
                    if (_var7) {
                        attribute5.resetRtcpFeedbackAttributes(list2.toArray(new FeedbackAttribute[0]));
                    }
                } else if (Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.FormatParametersAttribute)) {
                    FormatParametersAttribute attribute6 = (FormatParametersAttribute)attribute;
                    str2 = IntegerExtensions.toString(attribute6.getFormat());
                    HashMapExtensions.set(HashMapExtensions.getItem(dictionary), str2, attribute6);
                    attribute5 = null;
                    Holder<Object> _var8 = new Holder<Object>(attribute5);
                    boolean _var9 = HashMapExtensions.tryGetValue(dictionary2, str2, _var8);
                    attribute5 = _var8.getValue();
                    if (_var9) {
                        attribute5.setRelatedFormatParametersAttribute(attribute6);
                    }
                }
            }
            if (((String)str).charAt(0) == 'i') {
                description.setMediaTitle(((String)str).substring(2));
                continue;
            }
            if (((String)str).charAt(0) == 'c') {
                description.setConnectionData(ConnectionData.parse((String)str));
                continue;
            }
            if (((String)str).charAt(0) == 'b') {
                description.addBandwidth(Bandwidth.parse((String)str));
                continue;
            }
            if (((String)str).charAt(0) != 'k') continue;
            description.setEncryptionKey(EncryptionKey.parse((String)str));
        }
        return description;
    }

    public boolean removeBandwidth(Bandwidth bandwidth) {
        return this.__bandwidths.remove(bandwidth);
    }

    public boolean removeMediaAttribute(Attribute attribute) {
        AttributeType _var0 = attribute.getAttributeType();
        if (_var0 == AttributeType.FormatParametersAttribute) {
            Attribute[] rtpMapAttributes;
            FormatParametersAttribute attribute2 = (FormatParametersAttribute)attribute;
            for (Attribute attribute3 : rtpMapAttributes = this.getRtpMapAttributes()) {
                boolean flag;
                MapAttribute attribute4 = (MapAttribute)attribute3;
                if (attribute4.getRelatedFormatParametersAttribute() == null) continue;
                boolean bl = flag = attribute4.getRelatedFormatParametersAttribute().getFormat() == attribute2.getFormat();
                if (!flag) continue;
                attribute4.setRelatedFormatParametersAttribute(null);
                return flag;
            }
        } else if (_var0 == AttributeType.RtcpFeedbackAttribute) {
            Attribute[] rtpMapAttributes;
            FeedbackAttribute attribute5 = (FeedbackAttribute)attribute;
            for (Attribute attribute3 : rtpMapAttributes = this.getRtpMapAttributes()) {
                boolean flag;
                MapAttribute attribute4 = (MapAttribute)attribute3;
                if (attribute4.getRelatedRtcpFeedbackAttributes() == null || !(flag = attribute4.removeRelatedRtcpFeedbackAttribute(attribute5))) continue;
                return flag;
            }
        } else {
            return this.__mediaAttributes.remove(attribute);
        }
        return false;
    }

    public void setConnectionData(ConnectionData value) {
        this._connectionData = value;
    }

    public void setEncryptionKey(EncryptionKey value) {
        this._encryptionKey = value;
    }

    private void setMedia(Media value) {
        this._media = value;
    }

    public void setMediaTitle(String value) {
        this._mediaTitle = value;
    }

    public void setQualityAttribute(QualityAttribute value) {
        this.__mediaAttributes.replaceAttribute(value);
    }

    public void setRtcpAttribute(fm.icelink.sdp.rtcp.Attribute value) {
        this.__mediaAttributes.replaceAttribute(value);
    }

    public void setSetupAttribute(SetupAttribute value) {
        this.__mediaAttributes.replaceAttribute(value);
    }

    public void setStreamDirection(StreamDirection value) {
        DirectionAttribute attribute = DirectionAttribute.generateDirectionAttribute(value);
        this.__mediaAttributes.replaceAttribute(attribute);
    }

    static boolean supportsIce(AttributeCollection attributes) {
        return MediaDescription.getIceUfragAttribute(attributes) != null && MediaDescription.getIcePasswordAttribute(attributes) != null;
    }

    public boolean supportsIce() {
        return MediaDescription.supportsIce(this.__mediaAttributes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, StringExtensions.concat(this.getMedia().toString(), "\r\n"));
        if (this.getMediaTitle() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat("i=", this.getMediaTitle(), "\r\n"));
        }
        if (this.getConnectionData() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(this.getConnectionData().toString(), "\r\n"));
        }
        for (Bandwidth bandwidth : this.getBandwidths()) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(bandwidth.toString(), "\r\n"));
        }
        if (this.getEncryptionKey() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(this.getEncryptionKey().toString(), "\r\n"));
        }
        for (Attribute attribute : this.__mediaAttributes.toArray()) {
            FormatParametersAttribute relatedFormatParametersAttribute;
            StringBuilderExtensions.append(builder, StringExtensions.concat(attribute.toString(), "\r\n"));
            if (!Global.equals((Object)attribute.getAttributeType(), (Object)AttributeType.RtpMapAttribute)) continue;
            MapAttribute attribute2 = (MapAttribute)attribute;
            FeedbackAttribute[] relatedRtcpFeedbackAttributes = attribute2.getRelatedRtcpFeedbackAttributes();
            if (relatedRtcpFeedbackAttributes != null) {
                for (FeedbackAttribute attribute3 : relatedRtcpFeedbackAttributes) {
                    StringBuilderExtensions.append(builder, StringExtensions.concat(attribute3.toString(), "\r\n"));
                }
            }
            if ((relatedFormatParametersAttribute = attribute2.getRelatedFormatParametersAttribute()) == null) continue;
            StringBuilderExtensions.append(builder, StringExtensions.concat(relatedFormatParametersAttribute.toString(), "\r\n"));
        }
        return builder.toString();
    }

    public void updateQualityAttributeValue(int quality) {
        this.__mediaAttributes.replaceAttribute(new QualityAttribute((byte)quality));
    }
}

