/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Error;
import fm.icelink.Log;
import fm.icelink.MediaTrackStats;
import fm.icelink.PliControlFrame;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.sdp.MediaDescription;

public abstract class VideoDecoder
extends VideoPipe {
    private boolean __delayDecodeOnPendingKeyFrame = true;
    private AtomicLong __framesDecoded = new AtomicLong();
    private int _frameHeight;
    private long _frameRateStartTicks = -1L;
    private int _frameWidth;
    private volatile boolean _keyFrameReceived = false;

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        if (this.getDelayDecode()) {
            if (this.isKeyFrame(inputBuffer.getDataBuffer())) {
                this._keyFrameReceived = true;
            } else {
                this.sendPli("Decoder needs keyframe.");
            }
        }
    }

    @Override
    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription) {
            mediaDescription.insertNackPliAttribute(((VideoFormat)super.getInputFormat()).getName(), ((VideoFormat)super.getInputFormat()).getClockRate(), ((VideoFormat)super.getInputFormat()).getParameters());
        }
        return null;
    }

    @Override
    protected void doProcessStatsFromInput(MediaTrackStats stats) {
        super.doProcessStatsFromInput(stats);
        stats.setFrameWidth(this.getFrameWidth());
        stats.setFrameHeight(this.getFrameHeight());
        stats.setFrameRate(this.getFrameRate());
        stats.setFramesDecoded(this.getFramesDecoded());
    }

    protected boolean getDelayDecode() {
        return this.getDelayDecodeOnPendingKeyFrame() && !this._keyFrameReceived;
    }

    public boolean getDelayDecodeOnPendingKeyFrame() {
        return this.__delayDecodeOnPendingKeyFrame;
    }

    public int getFrameHeight() {
        return this._frameHeight;
    }

    public int getFrameRate() {
        long framesDecoded = this.getFramesDecoded();
        if (framesDecoded == 0L) {
            return -1;
        }
        long num2 = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this._frameRateStartTicks;
        if (num2 < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(framesDecoded * (long)Constants.getTicksPerSecond() / num2);
    }

    public long getFramesDecoded() {
        return this.__framesDecoded.getValue();
    }

    public int getFrameWidth() {
        return this._frameWidth;
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    @Override
    protected void raiseFrame(VideoFrame frame) {
        VideoBuffer lastBuffer = (VideoBuffer)frame.getLastBuffer();
        if (lastBuffer != null) {
            if (this._frameRateStartTicks == -1L) {
                this._frameRateStartTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            }
            this.setFrameWidth(lastBuffer.getWidth());
            this.setFrameHeight(lastBuffer.getHeight());
        }
        this.__framesDecoded.increment();
        super.raiseFrame(frame);
    }

    protected void sendPli(String reason) {
        Log.debug(StringExtensions.format("VideoDecoder raising PLI Control Frame. {0}", reason));
        super.raiseControlFrame(new PliControlFrame());
        this._keyFrameReceived = false;
    }

    public void setDelayDecodeOnPendingKeyFrame(boolean value) {
        this.__delayDecodeOnPendingKeyFrame = value;
    }

    private void setFrameHeight(int value) {
        this._frameHeight = value;
    }

    private void setFrameWidth(int value) {
        this._frameWidth = value;
    }

    public VideoDecoder(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
    }
}

