/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFormat;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBufferColor;
import fm.icelink.VideoFormat;

public class VideoBuffer
extends MediaBuffer<VideoFormat, VideoBuffer> {
    private int __height;
    private boolean __isMuted;
    private int __orientation = 0;
    private int __width;
    private int[] _strides;

    @Override
    public VideoBuffer clone() {
        VideoBuffer buffer = (VideoBuffer)super.clone();
        buffer.setStrides(this.getStrides());
        buffer.setWidth(this.getWidth());
        buffer.setHeight(this.getHeight());
        buffer.setOrientation(this.getOrientation());
        buffer.__isMuted = this.__isMuted;
        return buffer;
    }

    public static VideoBuffer createBlack(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 0, formatName);
    }

    public static VideoBuffer createBlue(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 255, formatName);
    }

    public static VideoBuffer createCustom(int width, int height, int red, int green, int blue, String formatName) {
        int num = width * height;
        if (Global.equals(formatName, VideoFormat.getBgrName()) || Global.equals(formatName, VideoFormat.getRgbName())) {
            DataBuffer buffer = DataBuffer.allocate(num * 3);
            if (red == green && red == blue) {
                buffer.set(BitAssistant.castByte(red));
            } else {
                int num2 = 0;
                if (Global.equals(formatName, VideoFormat.getBgrName())) {
                    for (int num3 = 0; num3 < num; ++num3) {
                        buffer.write8(blue, num2++);
                        buffer.write8(green, num2++);
                        buffer.write8(red, num2++);
                    }
                } else {
                    for (int num3 = 0; num3 < num; ++num3) {
                        buffer.write8(red, num2++);
                        buffer.write8(green, num2++);
                        buffer.write8(blue, num2++);
                    }
                }
            }
            return new VideoBuffer(width, height, buffer, new VideoFormat(formatName));
        }
        if (Global.equals(formatName, VideoFormat.getBgraName()) || Global.equals(formatName, VideoFormat.getRgbaName()) || Global.equals(formatName, VideoFormat.getAbgrName()) || Global.equals(formatName, VideoFormat.getArgbName())) {
            DataBuffer buffer = DataBuffer.allocate(num * 4);
            int num2 = 0;
            int num4 = 255;
            if (Global.equals(formatName, VideoFormat.getBgraName())) {
                for (int num3 = 0; num3 < num; ++num3) {
                    buffer.write8(blue, num2++);
                    buffer.write8(green, num2++);
                    buffer.write8(red, num2++);
                    buffer.write8(num4, num2++);
                }
            } else if (Global.equals(formatName, VideoFormat.getRgbaName())) {
                for (int num3 = 0; num3 < num; ++num3) {
                    buffer.write8(red, num2++);
                    buffer.write8(green, num2++);
                    buffer.write8(blue, num2++);
                    buffer.write8(num4, num2++);
                }
            } else if (Global.equals(formatName, VideoFormat.getAbgrName())) {
                for (int num3 = 0; num3 < num; ++num3) {
                    buffer.write8(num4, num2++);
                    buffer.write8(blue, num2++);
                    buffer.write8(green, num2++);
                    buffer.write8(red, num2++);
                }
            } else if (Global.equals(formatName, VideoFormat.getArgbName())) {
                for (int num3 = 0; num3 < num; ++num3) {
                    buffer.write8(num4, num2++);
                    buffer.write8(red, num2++);
                    buffer.write8(green, num2++);
                    buffer.write8(blue, num2++);
                }
            }
            return new VideoBuffer(width, height, buffer, new VideoFormat(formatName));
        }
        if (Global.equals(formatName, VideoFormat.getNv12Name()) || Global.equals(formatName, VideoFormat.getNv21Name()) || Global.equals(formatName, VideoFormat.getI420Name()) || Global.equals(formatName, VideoFormat.getYv12Name())) {
            int num3;
            DataBuffer buffer = DataBuffer.allocate((int)((double)num * 1.5));
            int num5 = (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
            int num6 = (int)(-0.147 * (double)red - 0.289 * (double)green + 0.436 * (double)blue);
            int num7 = (int)(0.615 * (double)red - 0.515 * (double)green - 0.1 * (double)blue);
            int num2 = 0;
            for (num3 = 0; num3 < num; ++num3) {
                buffer.write8(num5, num2++);
            }
            if (Global.equals(formatName, VideoFormat.getNv12Name())) {
                for (num3 = 0; num3 < num / 4; ++num3) {
                    buffer.write8(num6, num2++);
                    buffer.write8(num7, num2++);
                }
            } else if (Global.equals(formatName, VideoFormat.getNv21Name())) {
                for (num3 = 0; num3 < num / 4; ++num3) {
                    buffer.write8(num7, num2++);
                    buffer.write8(num6, num2++);
                }
            } else if (Global.equals(formatName, VideoFormat.getI420Name())) {
                for (num3 = 0; num3 < num / 4; ++num3) {
                    buffer.write8(num6, num2++);
                }
                for (num3 = 0; num3 < num / 4; ++num3) {
                    buffer.write8(num7, num2++);
                }
            } else if (Global.equals(formatName, VideoFormat.getYv12Name())) {
                for (num3 = 0; num3 < num / 4; ++num3) {
                    buffer.write8(num7, num2++);
                }
                for (num3 = 0; num3 < num / 4; ++num3) {
                    buffer.write8(num6, num2++);
                }
            }
            return new VideoBuffer(width, height, buffer, new VideoFormat(formatName));
        }
        Log.error(StringExtensions.concat("Format not supported: ", formatName));
        return null;
    }

    public static VideoBuffer createCyan(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 255, 255, formatName);
    }

    public static VideoBuffer createDarkBlue(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 128, formatName);
    }

    public static VideoBuffer createDarkGreen(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 128, 0, formatName);
    }

    public static VideoBuffer createDarkRed(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 0, 0, formatName);
    }

    public static VideoBuffer createGray(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 128, 128, formatName);
    }

    public static VideoBuffer createGreen(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 255, 0, formatName);
    }

    @Override
    protected VideoBuffer createInstance() {
        return new VideoBuffer();
    }

    public static VideoBuffer createMagenta(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 0, 255, formatName);
    }

    public static VideoBuffer createOlive(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 128, 0, formatName);
    }

    public static VideoBuffer createPurple(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 0, 128, formatName);
    }

    public static VideoBuffer createRed(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 0, 0, formatName);
    }

    public static VideoBuffer createTeal(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 128, 128, formatName);
    }

    public static VideoBuffer createWhite(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 255, 255, formatName);
    }

    public static VideoBuffer createYellow(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 255, 0, formatName);
    }

    private void drawAbgrPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(0, offset);
        dataBuffer.write8(color.getB(), offset + 1);
        dataBuffer.write8(color.getG(), offset + 2);
        dataBuffer.write8(color.getR(), offset + 3);
    }

    private void drawArgbPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(0, offset);
        dataBuffer.write8(color.getR(), offset + 1);
        dataBuffer.write8(color.getG(), offset + 2);
        dataBuffer.write8(color.getB(), offset + 3);
    }

    private void drawBgraPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(color.getB(), offset);
        dataBuffer.write8(color.getG(), offset + 1);
        dataBuffer.write8(color.getR(), offset + 2);
        dataBuffer.write8(0, offset + 3);
    }

    private void drawBgrPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 2 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        dataBuffer.write8(color.getB(), y * stride + x * 3);
        dataBuffer.write8(color.getG(), y * stride + x * 3 + 1);
        dataBuffer.write8(color.getR(), y * stride + x * 3 + 2);
    }

    public void drawEllipse(int x, int y, int width, int height, VideoBufferColor color, boolean fill) {
        this.sanityChecks(x, y, width, height);
        int num = height / 2;
        int num2 = x + width / 2;
        int num3 = y + height / 2;
        double num4 = 2.0 * MathAssistant.getPi() / (double)(width * height / 4);
        for (double i = 0.0; i < 2.0 * MathAssistant.getPi(); i += num4) {
            int num6 = num2 + (int)((double)num * MathAssistant.cos(i));
            int num7 = num3 - (int)((double)num * MathAssistant.sin(i));
            if (fill) {
                int num8;
                if (num2 < num6) {
                    for (num8 = num2; num8 < num6; ++num8) {
                        this.drawPixel(num8, num7, color);
                    }
                    continue;
                }
                for (num8 = num6; num8 < num2; ++num8) {
                    this.drawPixel(num8, num7, color);
                }
                continue;
            }
            this.drawPixel(num6, num7, color);
        }
    }

    private void drawI420Pixel(int x, int y, VideoBufferColor color) {
        int num3;
        int num2;
        int stride;
        DataBuffer buffer3;
        DataBuffer buffer2;
        DataBuffer dataBuffer;
        int yIndex = 0;
        int uIndex = 0;
        int vIndex = 0;
        if (ArrayExtensions.getLength(super.getDataBuffers()) == 1) {
            dataBuffer = super.getDataBuffer();
            buffer2 = super.getDataBuffer();
            buffer3 = super.getDataBuffer();
            stride = this.getStride();
            num2 = this.getStride() / 2;
            num3 = this.getStride() / 2;
            uIndex = this.getStride() * this.getHeight();
            vIndex = (int)((double)(this.getStride() * this.getHeight()) * 1.25);
        } else {
            dataBuffer = super.getDataBuffers()[0];
            buffer2 = super.getDataBuffers()[1];
            buffer3 = super.getDataBuffers()[2];
            stride = this.getStrides()[0];
            num2 = this.getStrides()[1];
            num3 = this.getStrides()[2];
        }
        this.drawYuv(color, dataBuffer, buffer2, buffer3, yIndex += y * stride + x, uIndex += y / 2 * num2 + x / 2, vIndex += y / 2 * num3 + x / 2);
    }

    private void drawNv12Pixel(int x, int y, VideoBufferColor color) {
        int num2;
        int stride;
        DataBuffer buffer2;
        DataBuffer dataBuffer;
        int yIndex = 0;
        int uIndex = 0;
        int vIndex = 0;
        if (ArrayExtensions.getLength(super.getDataBuffers()) == 1) {
            dataBuffer = super.getDataBuffer();
            buffer2 = super.getDataBuffer();
            stride = this.getStride();
            num2 = this.getStride();
            uIndex = this.getStride() * this.getHeight();
            vIndex = this.getStride() * this.getHeight();
        } else {
            dataBuffer = super.getDataBuffers()[0];
            buffer2 = super.getDataBuffers()[1];
            stride = this.getStrides()[0];
            num2 = this.getStrides()[1];
        }
        this.drawYuv(color, dataBuffer, buffer2, buffer2, yIndex += y * stride + x, uIndex += y / 2 * num2 + x * 2, vIndex += y / 2 * num2 + x * 2 + 1);
    }

    private void drawNv21Pixel(int x, int y, VideoBufferColor color) {
        int num2;
        int stride;
        DataBuffer buffer2;
        DataBuffer dataBuffer;
        int yIndex = 0;
        int uIndex = 0;
        int vIndex = 0;
        if (ArrayExtensions.getLength(super.getDataBuffers()) == 1) {
            dataBuffer = super.getDataBuffer();
            buffer2 = super.getDataBuffer();
            stride = this.getStride();
            num2 = this.getStride();
            uIndex = this.getStride() * this.getHeight();
            vIndex = this.getStride() * this.getHeight();
        } else {
            dataBuffer = super.getDataBuffers()[0];
            buffer2 = super.getDataBuffers()[1];
            stride = this.getStrides()[0];
            num2 = this.getStrides()[1];
        }
        this.drawYuv(color, dataBuffer, buffer2, buffer2, yIndex += y * stride + x, uIndex += y / 2 * num2 + x * 2 + 1, vIndex += y / 2 * num2 + x * 2);
    }

    private void drawPixel(int x, int y, VideoBufferColor color) {
        if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getI420Name())) {
            this.drawI420Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getYv12Name())) {
            this.drawYv12Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv12Name())) {
            this.drawNv12Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv21Name())) {
            this.drawNv21Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgrName())) {
            this.drawBgrPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbName())) {
            this.drawRgbPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbaName())) {
            this.drawRgbaPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getArgbName())) {
            this.drawArgbPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgraName())) {
            this.drawBgraPixel(x, y, color);
        } else {
            if (!Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getAbgrName())) {
                throw new RuntimeException(new Exception("Unsupported video format."));
            }
            this.drawAbgrPixel(x, y, color);
        }
    }

    public void drawRectangle(int x, int y, int width, int height, VideoBufferColor color, boolean fill) {
        this.sanityChecks(x, y, width, height);
        if (fill) {
            for (int num = y; num < y + height; ++num) {
                for (int num2 = x; num2 < x + width; ++num2) {
                    this.drawPixel(num2, num, color);
                }
            }
        } else {
            for (int num = y; num <= y + height; ++num) {
                if (num == y || num == y + height) {
                    for (int num2 = x; num2 <= x + width; ++num2) {
                        this.drawPixel(num2, num, color);
                    }
                    continue;
                }
                this.drawPixel(x, num, color);
                this.drawPixel(x + width, num, color);
            }
        }
    }

    private void drawRgbaPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(color.getR(), offset);
        dataBuffer.write8(color.getG(), offset + 1);
        dataBuffer.write8(color.getB(), offset + 2);
        dataBuffer.write8(0, offset + 3);
    }

    private void drawRgbPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 2 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 3;
        dataBuffer.write8(color.getR(), offset);
        dataBuffer.write8(color.getG(), offset + 1);
        dataBuffer.write8(color.getB(), offset + 2);
    }

    private void drawYuv(VideoBufferColor color, DataBuffer yBuffer, DataBuffer uBuffer, DataBuffer vBuffer, int yIndex, int uIndex, int vIndex) {
        if (yIndex >= yBuffer.getLength() || uIndex >= uBuffer.getLength() || vIndex >= vBuffer.getLength()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        yBuffer.write8(VideoBuffer.rgbToY(color.getR(), color.getG(), color.getB()), yIndex);
        uBuffer.write8(VideoBuffer.rgbToU(color.getR(), color.getG(), color.getB()), uIndex);
        vBuffer.write8(VideoBuffer.rgbToV(color.getR(), color.getG(), color.getB()), vIndex);
    }

    private void drawYv12Pixel(int x, int y, VideoBufferColor color) {
        int num3;
        int num2;
        int stride;
        DataBuffer buffer3;
        DataBuffer buffer2;
        DataBuffer dataBuffer;
        int yIndex = 0;
        int uIndex = 0;
        int vIndex = 0;
        if (ArrayExtensions.getLength(super.getDataBuffers()) == 1) {
            dataBuffer = super.getDataBuffer();
            buffer2 = super.getDataBuffer();
            buffer3 = super.getDataBuffer();
            stride = this.getStride();
            num2 = this.getStride() / 2;
            num3 = this.getStride() / 2;
            uIndex = (int)((double)(this.getStride() * this.getHeight()) * 1.25);
            vIndex = this.getStride() * this.getHeight();
        } else {
            dataBuffer = super.getDataBuffers()[0];
            buffer2 = super.getDataBuffers()[2];
            buffer3 = super.getDataBuffers()[1];
            stride = this.getStrides()[0];
            num2 = this.getStrides()[2];
            num3 = this.getStrides()[1];
        }
        this.drawYuv(color, dataBuffer, buffer2, buffer3, yIndex += y * stride + x, uIndex += y / 2 * num2 + x / 2, vIndex += y / 2 * num3 + x / 2);
    }

    private int[] getDefaultStrides(int width, VideoFormat format) {
        if (Global.equals(format.getName(), VideoFormat.getBgrName()) || Global.equals(format.getName(), VideoFormat.getRgbName())) {
            return new int[]{width * 3};
        }
        if (Global.equals(format.getName(), VideoFormat.getAbgrName()) || Global.equals(format.getName(), VideoFormat.getArgbName()) || Global.equals(format.getName(), VideoFormat.getBgraName()) || Global.equals(format.getName(), VideoFormat.getRgbaName())) {
            return new int[]{width * 4};
        }
        if (Global.equals(format.getName(), VideoFormat.getI420Name()) || Global.equals(format.getName(), VideoFormat.getYv12Name())) {
            return new int[]{width, width / 2, width / 2};
        }
        if (Global.equals(format.getName(), VideoFormat.getNv12Name()) || Global.equals(format.getName(), VideoFormat.getNv21Name())) {
            return new int[]{width, width};
        }
        if (!(Global.equals(format.getName(), VideoFormat.getVp8Name()) || Global.equals(format.getName(), VideoFormat.getVp9Name()) || Global.equals(format.getName(), VideoFormat.getH264Name()) || Global.equals(format.getName(), MediaFormat.getRedName()) || Global.equals(format.getName(), MediaFormat.getUlpFecName()))) {
            throw new RuntimeException(new Exception(StringExtensions.concat("Unsupported video format '", format.getName(), "'.")));
        }
        return new int[1];
    }

    public int getHeight() {
        return this.__height;
    }

    @Override
    public boolean getIsMuted() {
        return this.__isMuted;
    }

    public int getOrientation() {
        return this.__orientation;
    }

    public int getStride() {
        int[] strides = this.getStrides();
        if (strides == null) {
            return 0;
        }
        return strides[0];
    }

    public int[] getStrides() {
        return this._strides;
    }

    public int getWidth() {
        return this.__width;
    }

    @Override
    public boolean mute() {
        if (!this.__isMuted) {
            if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgrName()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbName())) {
                super.getDataBuffer().set((byte)0);
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgraName()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbaName())) {
                DataBuffer dataBuffer = super.getDataBuffer();
                for (int num = 0; num < dataBuffer.getLength(); num += 4) {
                    dataBuffer.set((byte)0, num, 3);
                    dataBuffer.set(BitAssistant.castByte(255), num + 3, 1);
                }
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getAbgrName()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getArgbName())) {
                DataBuffer dataBuffer = super.getDataBuffer();
                for (int num = 0; num < dataBuffer.getLength(); num += 4) {
                    dataBuffer.set(BitAssistant.castByte(255), num, 1);
                    dataBuffer.set((byte)0, num + 1, 3);
                }
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getI420Name()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getYv12Name())) {
                Object[] dataBuffers = super.getDataBuffers();
                if (ArrayExtensions.getLength(dataBuffers) > 0 && dataBuffers[0] != null) {
                    ((DataBuffer)dataBuffers[0]).set((byte)0);
                }
                if (ArrayExtensions.getLength(dataBuffers) > 1 && dataBuffers[1] != null) {
                    ((DataBuffer)dataBuffers[1]).set(BitAssistant.castByte(128));
                }
                if (ArrayExtensions.getLength(dataBuffers) > 2 && dataBuffers[2] != null) {
                    ((DataBuffer)dataBuffers[2]).set(BitAssistant.castByte(128));
                }
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv12Name()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv21Name())) {
                Object[] dataBuffers = super.getDataBuffers();
                if (ArrayExtensions.getLength(dataBuffers) > 0 && dataBuffers[0] != null) {
                    ((DataBuffer)dataBuffers[0]).set((byte)0);
                }
                if (ArrayExtensions.getLength(dataBuffers) > 1 && dataBuffers[1] != null) {
                    ((DataBuffer)dataBuffers[1]).set(BitAssistant.castByte(128));
                }
            } else {
                return false;
            }
            this.__isMuted = true;
        }
        return true;
    }

    private static byte rgbToU(int R, int G, int B) {
        return (byte)(-0.147 * (double)R - 0.289 * (double)G + 0.436 * (double)B);
    }

    private static byte rgbToV(int R, int G, int B) {
        return (byte)(0.615 * (double)R - 0.515 * (double)G - 0.1 * (double)B);
    }

    private static byte rgbToY(int R, int G, int B) {
        return (byte)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B);
    }

    private void sanityChecks(int x, int y, int width, int height) {
        if (x < 0 || x + width >= this.getWidth()) {
            throw new RuntimeException(new Exception("Invalid X"));
        }
        if (y < 0 || y + height >= this.getHeight()) {
            throw new RuntimeException(new Exception("Invalid Y"));
        }
    }

    public void setHeight(int value) {
        if (value != -1 && value % 2 > 0) {
            --value;
        }
        this.__height = value;
    }

    public void setOrientation(int value) {
        if (value != 0 && value != 90 && value != 180 && value != 270) {
            throw new RuntimeException(new Exception("Video orientation can only be 0, 90, 180 or 270."));
        }
        this.__orientation = value;
    }

    public void setStride(int value) {
        this.setStrides(new int[]{value});
    }

    public void setStrides(int[] value) {
        this._strides = value;
    }

    public void setWidth(int value) {
        if (value != -1 && value % 2 > 0) {
            --value;
        }
        this.__width = value;
    }

    public VideoBuffer(int width, int height, DataBuffer dataBuffer, VideoFormat format) {
        super(dataBuffer, format);
        this.setWidth(width);
        this.setHeight(height);
        this.setStrides(this.getDefaultStrides(width, format));
    }

    public VideoBuffer(int width, int height, DataBuffer[] dataBuffers, VideoFormat format) {
        super(dataBuffers, format);
        this.setWidth(width);
        this.setHeight(height);
        this.setStrides(this.getDefaultStrides(width, format));
    }

    private VideoBuffer() {
    }
}

