/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpErrorCause;
import fm.icelink.SctpTlvParameter;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class SctpUnrecognizedParameters
extends SctpErrorCause {
    private SctpTlvParameter[] _parameters;

    @Override
    public byte[] getBytes() {
        return SctpUnrecognizedParameters.getBytes(this);
    }

    public static byte[] getBytes(SctpUnrecognizedParameters cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        for (int i = 0; i < ArrayExtensions.getLength(cause.getParameters()); ++i) {
            bytes.addRange(cause.getParameters()[i].getBytes());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public SctpTlvParameter[] getParameters() {
        return this._parameters;
    }

    public static SctpUnrecognizedParameters parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex;
            int num = Binary.fromBytes16(bytes, 2, false);
            ArrayList<SctpTlvParameter> list = new ArrayList<SctpTlvParameter>();
            for (startIndex = 4; startIndex < num; startIndex += offsetPlus.getValue()) {
                SctpTlvParameter _var0;
                SctpTlvParameter item = _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
                Log.debug(StringExtensions.format("SCTP Error: unrecognized parameter {0}", IntegerExtensions.toString(item.getType())));
                list.add(item);
            }
            offsetPlus.setValue(startIndex);
            return new SctpUnrecognizedParameters(list.toArray(new SctpTlvParameter[0]));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpUnrecognizedParameters(SctpTlvParameter[] parameters) {
        super.setCauseCode(8);
        this.setParameters(parameters);
    }

    public void setParameters(SctpTlvParameter[] value) {
        this._parameters = value;
    }
}

