/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpChunk;
import fm.icelink.SctpChunkType;

class SctpPadChunk
extends SctpChunk {
    private int __length = 4;

    public static byte[] getBytes(SctpPadChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        bytes.addRange(Binary.toBytes16(chunk.__length, false));
        byte[] buffer = new byte[4];
        for (int num = chunk.__length - 4; num > 0; num -= 4) {
            bytes.addRange(buffer);
        }
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return SctpPadChunk.getBytes(this);
    }

    public static SctpPadChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int length = Binary.fromBytes16(bytes, 2, false);
            offsetPlus.setValue(length);
            return new SctpPadChunk(length);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpPadChunk(int length) {
        if (this.__length <= 3 || this.__length >= 65536 || this.__length % 4 != 0) {
            throw new RuntimeException(new Exception("Valid padding chunk size is between 4 and 65536 bytes"));
        }
        this.__length = length;
        super.setUnrecognized(false);
        super.setType(SctpChunkType.getPad());
    }
}

