/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AfbControlFrame;
import fm.icelink.AppControlFrame;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioFormat;
import fm.icelink.Binary;
import fm.icelink.ByeControlFrame;
import fm.icelink.CodecStats;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.DoubleExtensions;
import fm.icelink.FecContext;
import fm.icelink.FecProducer;
import fm.icelink.FecReceiver;
import fm.icelink.FecRedPacket;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.GenericNack;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.ILog;
import fm.icelink.IceTransport;
import fm.icelink.IceTransportState;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterBuffer;
import fm.icelink.JitterConfig;
import fm.icelink.LinkedList;
import fm.icelink.LinkedListEnumerator;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LogLevel;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaReceiverStats;
import fm.icelink.MediaSenderStats;
import fm.icelink.MediaTransport;
import fm.icelink.NackBuffer;
import fm.icelink.NackConfig;
import fm.icelink.NetworkTimeProtocol;
import fm.icelink.PliControlFrame;
import fm.icelink.RRControlFrame;
import fm.icelink.RedFecConfig;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import fm.icelink.RpsiControlFrame;
import fm.icelink.RtpPacket;
import fm.icelink.RtpSendBuffer;
import fm.icelink.SRControlFrame;
import fm.icelink.SdesChunk;
import fm.icelink.SdesControlFrame;
import fm.icelink.SdesItem;
import fm.icelink.SdesItemType;
import fm.icelink.SliControlFrame;
import fm.icelink.SrtpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import java.util.ArrayList;
import java.util.Date;

abstract class RtpTransport<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> {
    private long __baseFrameTimestamp = -1L;
    private int __currentFecSequenceNumber;
    private long __currentLocalSynchronizationSource = 0L;
    private int __currentMediaSequenceNumber = 0;
    private int __currentReceivePayloadType = -1;
    private long __currentRemoteSynchronizationSource = 0L;
    private int __currentRtpSequenceNumber;
    private int __currentSendPayloadType = -1;
    private StreamDirection __direction;
    private LinkedList<DataBuffer> __fecBuffer;
    private long __firstSendRtpTimestamp = -1L;
    private long __firstSendTicks = -1L;
    private long __frameCount = 0L;
    private long __lastExpectedPacketCount = 0L;
    private long __lastNackNetworkConditionReportTicks = -1L;
    private long __lastNackReportTicks = -1L;
    private long __lastPliTimestamp = 0L;
    private long __lastReceivedPacketCount = 0L;
    private long __lastReceiveTransit = 0L;
    private long __lastReportSent = -1L;
    private long __lastSenderReportNtpTimestamp = 0L;
    private long __lastSenderReportTicks = 0L;
    private int __maxPliRate = 1;
    private long __maxReceivedPacketIndex = -1L;
    private long __minReceivedPacketIndex = -1L;
    private long __minReceivedRtpTimestamp = -1L;
    private long __minReceivedTicks = -1L;
    private int __nackNetworkConditionReportingInterval = 10000;
    private int __nackReportingInterval = 1000;
    private int __nacksReceivedDuringInterval = 0;
    private int __nacksReceivedDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksReceivedDuringIntervalPoorNetworkWarning = 200;
    private int __nacksReceivedDuringNetworkConditionInterval = 0;
    private int __nacksSentDuringInterval = 0;
    private int __nacksSentDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksSentDuringIntervalPoorNetworkWarning = 200;
    private int __nacksSentDuringNetworkConditionInterval = 0;
    private int __nextNackBufferRtpSequenceNumber = -1;
    private long __nextNackBufferSequenceNumber = -1L;
    private Object __receiveCountsLock;
    private double __receiveJitter = 0.0;
    private double __receiveRtpCyclesPerTick = -1.0;
    private int __reportIntervalInTicks;
    private int __reportsReceived = 0;
    private double __roundTripTime = 0.0;
    private static double __roundTripTimeAlpha = 0.75;
    private int __roundTripTimeCriticalWarning = 750;
    private int __roundTripTimePoorWarning = 300;
    private double __sendRtpCyclesPerTick = -1.0;
    private Object __sentCountsLock;
    private long __startTicks = -1L;
    private int __startTimeOffset;
    private boolean __videoBridgeMode = false;
    private boolean _disableAutomaticReports;
    private FecProducer _fecProducer;
    private FecReceiver _fecReceiver;
    private long _firsReceived;
    private long _firsSent;
    private int _inboundPacketsLostRtp;
    private JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _jitterBuffer;
    private JitterConfig _jitterConfig;
    private ILog _log = Log.getLogger("Rtp.Transport", LogLevel.Debug);
    private NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _nackBuffer;
    private NackConfig _nackConfig;
    private long _nacksReceived;
    private long _nacksSent;
    private long _octetsReceivedRtcp;
    private long _octetsReceivedRtp;
    private long _octetsSentRtcp;
    private long _octetsSentRtp;
    private int _outboundPacketsLostRtp;
    private long _packetsDiscarded;
    private long _packetsReceivedRtcp;
    private long _packetsReceivedRtp;
    private long _packetsSentRtcp;
    private long _packetsSentRtp;
    private long _plisReceived;
    private long _plisSent;
    private boolean _redFecActivated;
    private RedFecConfig _redFecConfig;
    private RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _sendBuffer;
    private SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> _srtpTransport;
    private StreamType _type;

    private void attachTransportEvents() {
        this.getSrtpTransport().addOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().addOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    public abstract TFrame[] createFormatArray(int var1);

    private void detachTransportEvents() {
        this.getSrtpTransport().removeOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().removeOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    @Override
    public void doReceiveControlFrames(MediaControlFrame[] controlFrames) {
        this.updateRtcpReceiverStatistics(controlFrames);
        for (MediaControlFrame frame : controlFrames) {
            if (frame instanceof ByeControlFrame) {
                if (!this._log.getIsDebugEnabled()) continue;
                this._log.debug(StringExtensions.format("Received RTCP goodbye for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SRControlFrame) {
                if (this._log.getIsDebugEnabled()) {
                    this._log.debug(StringExtensions.format("Received RTCP sender report for {0} stream.", this.getType().toString()));
                }
                SRControlFrame frame2 = (SRControlFrame)frame;
                this.__lastSenderReportNtpTimestamp = frame2.getNtpTimestamp();
                this.__lastSenderReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                ReportBlock reportBlock = frame2.getReportBlock();
                if (reportBlock == null) continue;
                this.processReportBlock(reportBlock);
                continue;
            }
            if (frame instanceof RRControlFrame) {
                RRControlFrame frame3;
                ReportBlock block;
                if (this._log.getIsDebugEnabled()) {
                    this._log.debug(StringExtensions.format("Received RTCP receiver report for {0} stream.", this.getType().toString()));
                }
                if ((block = (frame3 = (RRControlFrame)frame).getReportBlock()) == null) continue;
                this.processReportBlock(block);
                continue;
            }
            if (frame instanceof AppControlFrame) {
                if (!this._log.getIsDebugEnabled()) continue;
                this._log.debug(StringExtensions.format("Received RTCP application-specific message for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SdesControlFrame) {
                if (!this._log.getIsDebugEnabled()) continue;
                this._log.debug(StringExtensions.format("Received RTCP source description for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof AfbControlFrame) {
                if (!this._log.getIsDebugEnabled()) continue;
                this._log.debug(StringExtensions.format("Received RTCP application feedback for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof PliControlFrame) {
                long num;
                if (this._log.getIsDebugEnabled()) {
                    this._log.debug(StringExtensions.format("Received RTCP picture loss indication for {0} stream.", this.getType().toString()));
                }
                if ((num = this.getPlisReceived() + 1L) >= 0x100000000L) {
                    num -= 0x100000000L;
                }
                this.setPlisReceived(num);
                continue;
            }
            if (frame instanceof SliControlFrame) {
                if (!this._log.getIsDebugEnabled()) continue;
                this._log.debug(StringExtensions.format("Received RTCP slice loss indication for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof RpsiControlFrame) {
                if (!this._log.getIsDebugEnabled()) continue;
                this._log.debug(StringExtensions.format("Received RTCP reference picture selection indication for {0} stream.", this.getType().toString()));
                continue;
            }
            if (!(frame instanceof GenericNackControlFrame)) continue;
            this.processGenericNack((GenericNackControlFrame)frame);
            if (this._log.getIsDebugEnabled()) {
                this._log.debug(StringExtensions.format("Received Generic NACK for {0} stream.", this.getType().toString()));
            }
            this.updateNackReceiverStatistics();
        }
        this.raiseReceiveControlFrames(controlFrames);
    }

    @Override
    public void doReceiveFrame(TFrame frame) {
        RtpPacket packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer());
        this.updateRtpReceiverStatistics(packet, ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber(), ((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getClockRate());
        if (this.getNackEnabled()) {
            if (this.__nextNackBufferSequenceNumber == -1L) {
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
                this.__nextNackBufferRtpSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber();
            }
            if (((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() - this.__nextNackBufferSequenceNumber > (long)this.getNackBuffer().getLength()) {
                long sequenceNumber = this.__nextNackBufferSequenceNumber;
                int rtpSequenceNumber = this.__nextNackBufferRtpSequenceNumber;
                while (rtpSequenceNumber < ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber()) {
                    this.getNackBuffer().read(sequenceNumber, rtpSequenceNumber, -1L, new IActionDelegate1<TFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveFec";
                        }

                        @Override
                        public void invoke(TFrame frame) {
                            RtpTransport.this.processReceiveFec(frame);
                        }
                    }, null);
                    ++rtpSequenceNumber;
                    ++sequenceNumber;
                }
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
            }
            if (!this.getNackBuffer().write(frame)) {
                long num3 = this.getPacketsDiscarded() + 1L;
                if (num3 >= 0x100000000L) {
                    num3 -= 0x100000000L;
                }
                this.setPacketsDiscarded(num3);
                if (this._log.getIsDebugEnabled()) {
                    this._log.debug("NACK buffer is discarding stale/duplicate packet for video stream.");
                }
            }
            while (this.getNackBuffer().read(this.__nextNackBufferSequenceNumber, this.__nextNackBufferRtpSequenceNumber, ((MediaFrame)frame).getTimestamp(), new IActionDelegate1<TFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.nackBufferReadFrameCallback";
                }

                @Override
                public void invoke(TFrame frame) {
                    RtpTransport.this.nackBufferReadFrameCallback(frame);
                }
            }, (IAction1<GenericNackControlFrame>)new IActionDelegate1<GenericNackControlFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.nackBufferReadNackCallback";
                }

                @Override
                public void invoke(GenericNackControlFrame nack) {
                    RtpTransport.this.nackBufferReadNackCallback(nack);
                }
            })) {
            }
            return;
        }
        this.processReceiveFec(frame);
    }

    @Override
    public void doSendControlFrames(MediaControlFrame[] controlFrames) {
        SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport;
        long[] localSynchronizationSources;
        if (this.__currentLocalSynchronizationSource == 0L && (localSynchronizationSources = super.getLocalSynchronizationSources()) != null && ArrayExtensions.getLength(localSynchronizationSources) > 0) {
            this.__currentLocalSynchronizationSource = localSynchronizationSources[0];
        }
        if (ArrayExtensions.getLength(controlFrames) > 0) {
            SdesControlFrame sdes;
            int n;
            ArrayList<MediaControlFrame> list;
            ReportControlFrame report;
            for (MediaControlFrame frame : controlFrames) {
                int num2;
                if (!(frame instanceof PliControlFrame)) continue;
                if (this.__maxPliRate == 0) {
                    return;
                }
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (ticks - this.__lastPliTimestamp < (long)(num2 = Constants.getMillisecondsPerSecond() / this.__maxPliRate * Constants.getTicksPerMillisecond())) {
                    return;
                }
                this.__lastPliTimestamp = ticks;
                long num3 = this.getPlisSent() + 1L;
                if (num3 >= 0x100000000L) {
                    num3 -= 0x100000000L;
                }
                this.setPlisSent(num3);
                this._log.debug("Sending RTCP picture loss indication");
            }
            if ((ArrayExtensions.getLength(controlFrames) < 1 || !(controlFrames[0] instanceof SRControlFrame) && !(controlFrames[0] instanceof RRControlFrame)) && (report = this.getReport()) != null) {
                list = new ArrayList<MediaControlFrame>();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 0, report);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            if (!(ArrayExtensions.getLength(controlFrames) >= 2 && controlFrames[1] instanceof SdesControlFrame || (sdes = this.getSdes()) == null)) {
                list = new ArrayList();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 1, sdes);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            for (MediaControlFrame frame3 : controlFrames) {
                if (frame3 instanceof SRControlFrame) {
                    this.validateSRControlFrame((SRControlFrame)frame3);
                } else if (frame3 instanceof RRControlFrame) {
                    this.validateRRControlFrame((RRControlFrame)frame3);
                } else if (frame3 instanceof SdesControlFrame) {
                    this.validateSdesControlFrame((SdesControlFrame)frame3);
                } else if (frame3 instanceof FeedbackControlFrame) {
                    this.validateFeedbackControlFrame((FeedbackControlFrame)frame3);
                } else if (frame3 instanceof ByeControlFrame) {
                    this.validateByeControlFrame((ByeControlFrame)frame3);
                } else if (frame3 instanceof AppControlFrame) {
                    this.validateAppControlFrame((AppControlFrame)frame3);
                }
                this.updateRtcpSenderStatistics(frame3);
            }
        }
        if ((srtpTransport = this.getSrtpTransport()) != null) {
            srtpTransport.sendControlFrames(controlFrames);
        }
    }

    @Override
    public boolean doSendFrame(TFrame frame) {
        if (ArrayExtensions.getLength(frame.getBuffers()) == 0) {
            this._log.error("Frame has no buffers to send!");
        }
        for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
            MediaBuffer buffer = frame.getBuffers()[i];
            if (!((MediaFormat)buffer.getFormat()).getIsPacketized()) continue;
            if (this.prepareBufferForSend(buffer, frame)) {
                if (this.getNackEnabled()) {
                    this.getSendBuffer().write(frame);
                }
                this.processSendFec(frame);
            }
            return true;
        }
        this._log.error("Frame has no packetized buffers to send. Are you missing a packetizer?");
        return false;
    }

    @Override
    public boolean doStart() {
        if (super.getParameters() == null) {
            this._log.error("Cannot start RTP transport. Rtp.Parameters must be set.");
            return false;
        }
        if (this.getSrtpTransport() == null) {
            this._log.error("Cannot start RTP transport. Srtp.Transport must be set.");
            return false;
        }
        this.attachTransportEvents();
        return true;
    }

    @Override
    public boolean doStop() {
        this.detachTransportEvents();
        return true;
    }

    public int getAverageFrameRate() {
        if (this.__frameCount == 0L) {
            return -1;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__startTicks;
        if (num < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(this.__frameCount * (long)Constants.getTicksPerSecond() / num);
    }

    private CodecStats getCodecStats(boolean receiver) {
        AudioFormat format;
        int payloadType;
        int n = payloadType = receiver ? this.__currentReceivePayloadType : this.__currentSendPayloadType;
        if (payloadType == -1) {
            return null;
        }
        Object local = super.getFormat(payloadType);
        if (local == null) {
            return null;
        }
        CodecStats stats2 = new CodecStats();
        stats2.setId(super.getId());
        stats2.setTimestamp(DateExtensions.getUtcNow());
        stats2.setName(((MediaFormat)local).getName());
        stats2.setClockRate(((MediaFormat)local).getClockRate());
        stats2.setParameters(((MediaFormat)local).getParameters());
        stats2.setPayloadType(payloadType);
        CodecStats stats = stats2;
        if (Global.equals((Object)this.getType(), (Object)StreamType.Audio) && (format = Global.tryCast(local, AudioFormat.class)) != null) {
            stats.setChannelCount(format.getChannelCount());
        }
        return stats;
    }

    public StreamDirection getDirection() {
        return this.__direction;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    public boolean getFecEnabled() {
        RedFecConfig redFecConfig = this.getRedFecConfig();
        return redFecConfig != null && !redFecConfig.getDisabled();
    }

    public long getFirsReceived() {
        return this._firsReceived;
    }

    public long getFirsSent() {
        return this._firsSent;
    }

    public int getInboundPacketsLostRtp() {
        return this._inboundPacketsLostRtp;
    }

    public JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getJitterBuffer() {
        return this._jitterBuffer;
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public int getMaxPliRate() {
        return this.__maxPliRate;
    }

    public NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getNackBuffer() {
        return this._nackBuffer;
    }

    public NackConfig getNackConfig() {
        return this._nackConfig;
    }

    public boolean getNackEnabled() {
        NackConfig nackConfig = this.getNackConfig();
        return nackConfig != null && !nackConfig.getDisableBuffering();
    }

    public long getNacksReceived() {
        return this._nacksReceived;
    }

    public long getNacksSent() {
        return this._nacksSent;
    }

    private int getNextRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        int _var0 = this.incrementRtpSequenceNumber(nextMediaSequenceNumber);
        return _var0;
    }

    private long getNextTimestamp(long frameTimestamp) {
        long num;
        if (this.__baseFrameTimestamp == -1L) {
            this.__baseFrameTimestamp = frameTimestamp;
        }
        if ((num = (frameTimestamp - this.__baseFrameTimestamp + (long)this.__startTimeOffset) % 0x80000000L) < 0L) {
            num += 0xFFFFFFFFL;
        }
        return num;
    }

    public long getOctetsReceivedRtcp() {
        return this._octetsReceivedRtcp;
    }

    public long getOctetsReceivedRtp() {
        return this._octetsReceivedRtp;
    }

    public long getOctetsSentRtcp() {
        return this._octetsSentRtcp;
    }

    public long getOctetsSentRtp() {
        return this._octetsSentRtp;
    }

    public int getOutboundPacketsLostRtp() {
        return this._outboundPacketsLostRtp;
    }

    public long getPacketsDiscarded() {
        return this._packetsDiscarded;
    }

    public long getPacketsReceivedRtcp() {
        return this._packetsReceivedRtcp;
    }

    public long getPacketsReceivedRtp() {
        return this._packetsReceivedRtp;
    }

    public long getPacketsSentRtcp() {
        return this._packetsSentRtcp;
    }

    public long getPacketsSentRtp() {
        return this._packetsSentRtp;
    }

    public long getPlisReceived() {
        return this._plisReceived;
    }

    public long getPlisSent() {
        return this._plisSent;
    }

    public MediaReceiverStats getReceiverStats() {
        MediaReceiverStats stats = new MediaReceiverStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
        stats.setCodec(this.getCodecStats(true));
        stats.setNackCount(this.getNacksReceived());
        stats.setPliCount(this.getPlisReceived());
        stats.setFirCount(this.getFirsReceived());
        stats.setBytesReceived(this.getOctetsReceivedRtp());
        stats.setPacketsReceived(this.getPacketsReceivedRtp());
        stats.setPacketsLost(this.getInboundPacketsLostRtp());
        stats.setPacketsDiscarded(this.getPacketsDiscarded());
        stats.setJitter((int)this.__receiveJitter);
        return stats;
    }

    public boolean getRedFecActivated() {
        return this._redFecActivated;
    }

    public RedFecConfig getRedFecConfig() {
        return this._redFecConfig;
    }

    private ReportControlFrame getReport() {
        ReportBlock reportBlock = null;
        if (this.__maxReceivedPacketIndex > -1L) {
            reportBlock = new ReportBlock();
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            this._log.debug("Generating RTCP receiver report.");
            if (reportBlock != null) {
                return new RRControlFrame(this.__currentRemoteSynchronizationSource, reportBlock);
            }
            return new RRControlFrame();
        }
        this._log.debug("Generating RTCP sender report.");
        if (reportBlock != null) {
            return new SRControlFrame(this.__currentLocalSynchronizationSource, 0L, 0L, 0L, 0L, reportBlock);
        }
        return new SRControlFrame();
    }

    public double getRoundTripTime() {
        return this.__roundTripTime;
    }

    private SdesControlFrame getSdes() {
        return new SdesControlFrame(new SdesChunk(this.__currentLocalSynchronizationSource, new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName())));
    }

    public RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getSendBuffer() {
        return this._sendBuffer;
    }

    public MediaSenderStats getSenderStats() {
        MediaSenderStats stats = new MediaSenderStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        stats.setCodec(this.getCodecStats(false));
        stats.setNackCount(this.getNacksSent());
        stats.setPliCount(this.getPlisSent());
        stats.setFirCount(this.getFirsSent());
        stats.setBytesSent(this.getOctetsSentRtp());
        stats.setPacketsSent(this.getPacketsSentRtp());
        stats.setRoundTripTime((int)(this.getRoundTripTime() * 1000.0));
        return stats;
    }

    public SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getSrtpTransport() {
        return this._srtpTransport;
    }

    public StreamType getType() {
        return this._type;
    }

    private int incrementFecSequenceNumber() {
        int num = this.__currentFecSequenceNumber++;
        if (this.__currentFecSequenceNumber == 65536) {
            this.__currentFecSequenceNumber = 0;
        }
        return num;
    }

    private int incrementRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        nextMediaSequenceNumber.setValue(this.__currentMediaSequenceNumber++);
        int num = this.__currentRtpSequenceNumber++;
        if (this.__currentRtpSequenceNumber == 65536) {
            this.__currentRtpSequenceNumber = 0;
        }
        return num;
    }

    private void nackBufferReadFrameCallback(TFrame frame) {
        this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() + 1L;
        this.__nextNackBufferRtpSequenceNumber = (((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber() + 1) % 65536;
        this.processReceiveFec(frame);
    }

    private void nackBufferReadNackCallback(GenericNackControlFrame nack) {
        super.sendControlFrames(new MediaControlFrame[]{nack});
        if (this._log.getIsDebugEnabled()) {
            this.updateNackSenderStatistics();
        }
    }

    private boolean prepareBufferForSend(TBuffer buffer, TFrame frame) {
        if (((MediaFrame)frame).getSynchronizationSource() == -1L) {
            this._log.error("RTP Transport cannot process frame. SynchronizationSource not set.");
            return false;
        }
        ((MediaBuffer)buffer).setSequenceNumbers(new long[ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers())]);
        for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers()); ++i) {
            RtpPacket rtpPacket = RtpPacket.wrap(((MediaBuffer)buffer).getDataBuffers()[i]);
            if (this.__currentLocalSynchronizationSource == 0L) {
                this.__currentLocalSynchronizationSource = ((MediaFrame)frame).getSynchronizationSource();
            }
            if (!this.__videoBridgeMode) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                rtpPacket.setSequenceNumber(_var1);
                ((MediaBuffer)buffer).getSequenceNumbers()[i] = nextMediaSequenceNumber;
                rtpPacket.setTimestamp(this.getNextTimestamp(((MediaFrame)frame).getTimestamp()));
            }
            rtpPacket.setSynchronizationSource(this.__currentLocalSynchronizationSource);
            rtpPacket.setContributingSources(((MediaFrame)frame).getContributingSources());
            rtpPacket.setPayloadType(super.getPayloadType(((MediaFormat)((MediaBuffer)buffer).getFormat()).getName()));
            this.updateRtpSenderStatistics(rtpPacket);
        }
        return true;
    }

    private void processGenericNack(GenericNackControlFrame genericNack) {
        for (GenericNack nack : genericNack.getGenericNacks()) {
            this.resendRtpPacket(nack.getPacketId());
            int packetId = nack.getPacketId();
            for (int i = 1; i <= nack.getLostPacketIdPlusLength(); ++i) {
                if (!nack.getLostPacketIdPlus(i)) continue;
                this.resendRtpPacket((packetId + i) % 65536);
            }
        }
    }

    private void processJitterBuffer(TFrame frame) {
        if (this.getJitterConfig().getDisableBuffering()) {
            this.raiseReceiveFrame(frame);
        } else {
            if (this.getJitterBuffer() == null) {
                RtpPacket packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer());
                this.setJitterBuffer(new JitterBuffer(this.getType().toString(), ((MediaFormat)super.getFormat(packet.getPayloadType())).getClockRate(), this.getJitterConfig().getBufferLength()));
            }
            if (!this.getJitterBuffer().push(frame)) {
                long num = this.getPacketsDiscarded() + 1L;
                if (num >= 0x100000000L) {
                    num -= 0x100000000L;
                }
                this.setPacketsDiscarded(num);
                if (this._log.getIsDebugEnabled()) {
                    this._log.debug("Jitter buffer is discarding late packet for stream.");
                }
            }
            this.getJitterBuffer().pull(new IActionDelegate1<TFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.raiseReceiveFrame";
                }

                @Override
                public void invoke(TFrame frame) {
                    RtpTransport.this.raiseReceiveFrame(frame);
                }
            });
        }
    }

    private void processReceiveFec(TFrame frame) {
        if (!this.getFecEnabled()) {
            this.processJitterBuffer(frame);
        } else if (Global.equals(((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getName(), MediaFormat.getRedName())) {
            RtpPacket packet;
            if (this._fecReceiver == null) {
                this._fecReceiver = new FecReceiver();
            }
            if (this._fecReceiver.addReceivedRedPacket((packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer())).getHeaderLength(), packet.getSequenceNumber(), ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getDataBuffer(), ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getDataBuffer().getLength(), super.getPayloadType(MediaFormat.getUlpFecName()))) {
                this.__fecBuffer.clear();
                if (!this._fecReceiver.processReceivedFec(this.__fecBuffer)) {
                    // empty if block
                }
                LinkedListEnumerator<DataBuffer> enumerator = this.__fecBuffer.getEnumerator();
                while (enumerator.moveNext()) {
                    RtpPacket packet2 = RtpPacket.wrap(enumerator.getCurrent());
                    Object format = super.getFormat(packet2.getPayloadType());
                    if (format == null) {
                        this._log.warn(StringExtensions.format("Unknown packet type of {0} received from Fec.", IntegerExtensions.toString(packet2.getPayloadType())));
                        continue;
                    }
                    TFrame local2 = this.getSrtpTransport().generateFrame(packet2, format);
                    if (local2 == null) continue;
                    this.processJitterBuffer(local2);
                }
            }
        } else {
            this.processJitterBuffer(frame);
        }
    }

    private void processReportBlock(ReportBlock block) {
        ++this.__reportsReceived;
        if (block.getLastSenderReportTimestamp() > 0L) {
            long ticks;
            long num6;
            long num = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(block.getLastSenderReportTimestamp())) / (long)Constants.getTicksPerMillisecond();
            long num2 = block.getDelaySinceLastSenderReport() * 1000L / 65536L;
            long num3 = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(NetworkTimeProtocol.dateTimeToCompactNtp(DateExtensions.getUtcNow()))) / (long)Constants.getTicksPerMillisecond();
            double num4 = (double)(num3 - num - num2) / 1000.0;
            if (this.getRoundTripTime() == 0.0) {
                this.setRoundTripTime(num4);
            } else {
                this.setRoundTripTime(__roundTripTimeAlpha * this.getRoundTripTime() + (1.0 - __roundTripTimeAlpha) * num4);
            }
            if (this.getNackEnabled()) {
                this.getNackBuffer().setRetransmissionTimeout((int)(this.getRoundTripTime() * (double)Constants.getMillisecondsPerSecond()));
            }
            if ((num6 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
                if (this.getRoundTripTime() * 1000.0 > (double)this.__roundTripTimeCriticalWarning) {
                    this._log.warn(StringExtensions.format("Critical network condition detected! Round trip time exceeding {0}s.", DoubleExtensions.toString(this.getRoundTripTime())));
                } else if (this.getRoundTripTime() * 1000.0 > (double)this.__roundTripTimePoorWarning) {
                    this._log.warn(StringExtensions.format("Poor network condition detected! Round trip time exceeding {0}s.", DoubleExtensions.toString(this.getRoundTripTime())));
                }
                this.__lastNackNetworkConditionReportTicks = ticks;
            }
        }
        if (this.__reportsReceived > this.getRedFecConfig().getMinimumReportsBeforeFec() && this.getFecEnabled()) {
            if (!this.getRedFecActivated() && block.getPercentLost() * 100.0 >= (double)this.getRedFecConfig().getActivationThreshold()) {
                Log.info(StringExtensions.format("Activating FEC for RTP Transport '{0}'.", super.getId()));
                this.setRedFecActivated(true);
            }
            if (this.getRedFecActivated() && block.getPercentLost() * 100.0 < (double)this.getRedFecConfig().getActivationThreshold()) {
                Log.info(StringExtensions.format("Deactivating FEC for RTP Transport '{0}'.", super.getId()));
                this.setRedFecActivated(false);
            }
        }
        this.setOutboundPacketsLostRtp(block.getCumulativeNumberOfPacketsLost());
    }

    private void processSendFec(TFrame frame) {
        SrtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport = this.getSrtpTransport();
        if (srtpTransport != null) {
            FecRedPacket packet2;
            RtpPacket packet = null;
            if (this.getRedFecActivated()) {
                if (this._fecProducer == null) {
                    this._fecProducer = new FecProducer(new FecContext());
                }
                Object lastBuffer = ((MediaFrame)frame).getLastBuffer();
                Object local2 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local2).setDataBuffers(new DataBuffer[ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers())]);
                for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers()); ++i) {
                    DataBuffer buffer = ((MediaBuffer)lastBuffer).getDataBuffers()[i];
                    packet = RtpPacket.wrap(buffer);
                    packet2 = this._fecProducer.buildRedPacket(buffer, buffer.getLength() - packet.getHeaderLength(), packet.getHeaderLength(), super.getPayloadType(MediaFormat.getRedName()));
                    ((MediaBuffer)local2).getDataBuffers()[i] = packet2.getData();
                    if (this._fecProducer.addRtpPacketAndGenerateFec(buffer, buffer.getLength() - packet.getHeaderLength(), packet.getHeaderLength())) continue;
                    this._log.warn("Could not add RTP packet to outbound FEC context.");
                    return;
                }
                ((MediaBuffer)local2).setFormat(super.getFormat(MediaFormat.getRedName()));
                ((MediaFrame)frame).addBuffer((Object)local2);
            }
            srtpTransport.sendFrame(frame);
            while (this.getRedFecActivated() && this._fecProducer != null && this._fecProducer.getFecAvailable()) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                packet2 = this._fecProducer.getFecPacket(super.getPayloadType(MediaFormat.getRedName()), super.getPayloadType(MediaFormat.getUlpFecName()), _var1, packet.getHeaderLength());
                Object local3 = ((MediaFrame)frame).clone();
                ((MediaFrame)local3).removeBuffers();
                Object local4 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local4).setFormat(super.getFormat(MediaFormat.getRedName()));
                ((MediaBuffer)local4).setDataBuffer(packet2.getData().subset(0, packet2.getLength()));
                ((MediaBuffer)local4).setSequenceNumber(nextMediaSequenceNumber);
                ((MediaFrame)local3).addBuffer(local4);
                srtpTransport.sendFrame(local3);
                ((MediaBuffer)local4).getDataBuffer().free();
            }
        }
    }

    public void resendRtpPacket(int sequenceNumber) {
        if (this.getNackEnabled()) {
            TFrame local = this.getSendBuffer().read(sequenceNumber);
            if (local != null) {
                for (int i = ArrayExtensions.getLength(local.getBuffers()) - 1; i > 0; --i) {
                    MediaBuffer local2 = local.getBuffers()[ArrayExtensions.getLength(local.getBuffers()) - 1];
                    if (!((MediaFormat)local2.getFormat()).getIsPacketized()) continue;
                    for (DataBuffer buffer : local2.getDataBuffers()) {
                        RtpPacket packet = RtpPacket.wrap(buffer);
                        if (packet.getSequenceNumber() != sequenceNumber) continue;
                        if (((MediaFormat)local2.getFormat()).getIsEncrypted()) {
                            IceTransport rtpTransport = (IceTransport)this.getSrtpTransport().getRtpTransport();
                            if (rtpTransport == null || Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.New) && Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.Disconnected) && Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.Closed)) continue;
                            rtpTransport.send(packet.getBuffer());
                            continue;
                        }
                        Object frame = ((MediaFrame)local).clone();
                        if (ArrayExtensions.getLength(frame.getBuffers()) > 1) {
                            ((MediaFrame)frame).setBuffer(local2.clone());
                        }
                        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) > 1) {
                            ((MediaBuffer)((MediaFrame)frame).getBuffer()).setDataBuffer(buffer);
                        }
                        this.getSrtpTransport().sendFrame(frame);
                    }
                    break;
                }
            } else {
                this._log.info("Unable to recover packet in response to Generic NACK.");
            }
        }
    }

    public RtpTransport(Object lockObject, StreamType streamType, NackConfig nackConfig, RedFecConfig redFecConfig, JitterConfig jitterConfig, boolean disableAutomaticReports) {
        super(lockObject);
        this.__direction = StreamDirection.Inactive;
        this.__reportIntervalInTicks = Constants.getTicksPerSecond();
        this.__sentCountsLock = new Object();
        this.__receiveCountsLock = new Object();
        this.__startTimeOffset = LockedRandomizer.next(65535, Integer.MAX_VALUE);
        this.__currentRtpSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__currentFecSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__fecBuffer = new LinkedList();
        this.setType(streamType);
        this.setNackConfig(nackConfig);
        this.setRedFecConfig(redFecConfig);
        this.setJitterConfig(jitterConfig);
        if (!nackConfig.getDisableBuffering()) {
            this.setSendBuffer(new RtpSendBuffer(this.getType().toString(), this.getNackConfig().getSendBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
            this.setNackBuffer(new NackBuffer(this.getType().toString(), this.getNackConfig().getReceiveBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
        }
    }

    private void sendBye(String reason) {
        super.sendControlFrames(new MediaControlFrame[]{this.getReport(), new ByeControlFrame(this.__currentLocalSynchronizationSource, reason)});
    }

    private void sendReport() {
        try {
            if (!this.getDisableAutomaticReports()) {
                super.sendControlFrames(new MediaControlFrame[]{this.getReport()});
            }
        }
        catch (Exception exception) {
            this._log.debug("Could not send RTCP report.", exception);
        }
    }

    private void sendReportIfNeeded() {
        long ticks;
        if (this.__lastReportSent == -1L) {
            this.__lastReportSent = DateExtensions.getTicks(DateExtensions.getUtcNow());
        } else if (this.__currentLocalSynchronizationSource != 0L && (ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
            boolean flag = false;
            if (ticks - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
                flag = true;
                this.__lastReportSent = ticks;
            }
            if (flag) {
                this.sendReport();
            }
        }
    }

    public void setDirection(StreamDirection value) {
        this.__direction = value;
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    private void setFirsReceived(long value) {
        this._firsReceived = value;
    }

    private void setFirsSent(long value) {
        this._firsSent = value;
    }

    private void setInboundPacketsLostRtp(int value) {
        this._inboundPacketsLostRtp = value;
    }

    private void setJitterBuffer(JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._jitterBuffer = value;
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    public void setMaxPliRate(int value) {
        this.__maxPliRate = MathAssistant.max(MathAssistant.min(value, Constants.getMillisecondsPerSecond()), 0);
    }

    private void setNackBuffer(NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._nackBuffer = value;
    }

    private void setNackConfig(NackConfig value) {
        this._nackConfig = value;
    }

    private void setNacksReceived(long value) {
        this._nacksReceived = value;
    }

    private void setNacksSent(long value) {
        this._nacksSent = value;
    }

    private void setOctetsReceivedRtcp(long value) {
        this._octetsReceivedRtcp = value;
    }

    private void setOctetsReceivedRtp(long value) {
        this._octetsReceivedRtp = value;
    }

    private void setOctetsSentRtcp(long value) {
        this._octetsSentRtcp = value;
    }

    private void setOctetsSentRtp(long value) {
        this._octetsSentRtp = value;
    }

    private void setOutboundPacketsLostRtp(int value) {
        this._outboundPacketsLostRtp = value;
    }

    private void setPacketsDiscarded(long value) {
        this._packetsDiscarded = value;
    }

    private void setPacketsReceivedRtcp(long value) {
        this._packetsReceivedRtcp = value;
    }

    private void setPacketsReceivedRtp(long value) {
        this._packetsReceivedRtp = value;
    }

    private void setPacketsSentRtcp(long value) {
        this._packetsSentRtcp = value;
    }

    private void setPacketsSentRtp(long value) {
        this._packetsSentRtp = value;
    }

    private void setPlisReceived(long value) {
        this._plisReceived = value;
    }

    private void setPlisSent(long value) {
        this._plisSent = value;
    }

    private void setRedFecActivated(boolean value) {
        this._redFecActivated = value;
    }

    private void setRedFecConfig(RedFecConfig value) {
        this._redFecConfig = value;
    }

    public void setRoundTripTime(double value) {
        this.__roundTripTime = value;
    }

    private void setSendBuffer(RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._sendBuffer = value;
    }

    public void setSrtpTransport(SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        this._srtpTransport = value;
    }

    private void setType(StreamType value) {
        this._type = value;
    }

    private void updateNackReceiverStatistics() {
        long num4;
        long ticks;
        long num3;
        ++this.__nacksReceivedDuringInterval;
        ++this.__nacksReceivedDuringNetworkConditionInterval;
        long num = this.getNacksReceived() + 1L;
        if (num >= 0x100000000L) {
            num -= 0x100000000L;
        }
        this.setNacksReceived(num);
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if ((num3 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackReportTicks) / (long)Constants.getTicksPerSecond()) > (long)this.__nackReportingInterval) {
            this._log.debug(StringExtensions.format("Received {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksReceivedDuringInterval), LongExtensions.toString(num3)));
            this.__nacksReceivedDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if ((num4 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalCriticalNetworkWarning) {
                this._log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}:{1}).", LongExtensions.toString(num4), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalPoorNetworkWarning) {
                this._log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}:{1}).", LongExtensions.toString(num4), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateNackSenderStatistics() {
        ++this.__nacksSentDuringInterval;
        ++this.__nacksSentDuringNetworkConditionInterval;
        long num = this.getNacksSent() + 1L;
        if (num >= 0x100000000L) {
            num -= 0x100000000L;
        }
        this.setNacksSent(num);
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if (this.__lastNackNetworkConditionReportTicks == -1L) {
            this.__lastNackNetworkConditionReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        long num3 = (ticks - this.__lastNackReportTicks) / (long)Constants.getTicksPerMillisecond();
        long num4 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond();
        if (num3 > (long)this.__nackReportingInterval) {
            this._log.debug(StringExtensions.format("Sent {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksSentDuringInterval), LongExtensions.toString(num3)));
            this.__nacksSentDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if (num4 > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalCriticalNetworkWarning) {
                this._log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}ms {1}).", LongExtensions.toString(num4), IntegerExtensions.toString(this.__nacksSentDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalPoorNetworkWarning) {
                this._log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}ms {1}).", LongExtensions.toString(num4), IntegerExtensions.toString(this.__nacksSentDuringIntervalPoorNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateRtcpReceiverStatistics(MediaControlFrame[] frames) {
        if (frames != null) {
            int num = 0;
            for (MediaControlFrame frame : frames) {
                num += frame.getDataBuffer().getLength();
            }
            long num2 = this.getOctetsReceivedRtcp() + (long)num;
            if (num2 >= 0x100000000L) {
                num2 -= 0x100000000L;
            }
            this.setOctetsReceivedRtcp(num2);
            long num3 = this.getPacketsReceivedRtcp() + 1L;
            if (num3 >= 0x100000000L) {
                num3 -= 0x100000000L;
            }
            this.setPacketsReceivedRtcp(num3);
        }
    }

    private void updateRtcpSenderStatistics(MediaControlFrame frame) {
        long num = this.getOctetsSentRtcp() + (long)frame.getDataBuffer().getLength();
        if (num >= 0x100000000L) {
            num -= 0x100000000L;
        }
        this.setOctetsSentRtcp(num);
        long num2 = this.getPacketsSentRtcp() + 1L;
        if (num2 >= 0x100000000L) {
            num2 -= 0x100000000L;
        }
        this.setPacketsSentRtcp(num2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRtpReceiverStatistics(RtpPacket packet, long sequenceNumber, int clockRate) {
        Object object = this.__receiveCountsLock;
        synchronized (object) {
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (this.__currentRemoteSynchronizationSource == 0L) {
                this.__currentRemoteSynchronizationSource = packet.getSynchronizationSource();
                this.__minReceivedRtpTimestamp = packet.getTimestamp();
                this.__minReceivedTicks = ticks;
                this.__minReceivedPacketIndex = sequenceNumber;
                this.__maxReceivedPacketIndex = sequenceNumber;
                this.__receiveRtpCyclesPerTick = clockRate / Constants.getTicksPerSecond();
            }
            this.__currentReceivePayloadType = packet.getPayloadType();
            this.__minReceivedRtpTimestamp = MathAssistant.min(packet.getTimestamp(), this.__minReceivedRtpTimestamp);
            this.__minReceivedTicks = MathAssistant.min(ticks, this.__minReceivedTicks);
            this.__minReceivedPacketIndex = MathAssistant.min(sequenceNumber, this.__minReceivedPacketIndex);
            this.__maxReceivedPacketIndex = MathAssistant.max(sequenceNumber, this.__maxReceivedPacketIndex);
            this.setOctetsReceivedRtp(this.getOctetsReceivedRtp() + (long)packet.getBuffer().getLength());
            this.setPacketsReceivedRtp(this.getPacketsReceivedRtp() + 1L);
            long num2 = (long)((double)(ticks - this.__minReceivedTicks) * this.__receiveRtpCyclesPerTick) + this.__minReceivedRtpTimestamp;
            long num3 = num2 - packet.getTimestamp();
            long num4 = num3 - this.__lastReceiveTransit;
            this.__lastReceiveTransit = num3;
            if (num4 < 0L) {
                num4 = -num4;
            }
            this.__receiveJitter += ((double)num4 - this.__receiveJitter) / 16.0;
        }
        this.sendReportIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRtpSenderStatistics(RtpPacket rtpPacket) {
        if (rtpPacket == null) {
            this._log.error("Transport cannot process RTP. Malformed RTP packet in frame.");
            return false;
        }
        if (this.__firstSendRtpTimestamp == -1L) {
            Object format = super.getFormat(rtpPacket.getPayloadType());
            this.__firstSendRtpTimestamp = rtpPacket.getTimestamp();
            this.__firstSendTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            this.__sendRtpCyclesPerTick = (double)((MediaFormat)format).getClockRate() / 1.0E7;
        }
        this.__currentSendPayloadType = rtpPacket.getPayloadType();
        int length = rtpPacket.getPayload().getLength();
        Object object = this.__sentCountsLock;
        synchronized (object) {
            long num2 = this.getPacketsSentRtp() + 1L;
            if (num2 >= 0x100000000L) {
                num2 -= 0x100000000L;
            }
            this.setPacketsSentRtp(num2);
            long num3 = this.getOctetsSentRtp() + (long)length;
            if (num3 >= 0x100000000L) {
                num3 -= 0x100000000L;
            }
            this.setOctetsSentRtp(num3);
        }
        this.sendReportIfNeeded();
        return true;
    }

    private void validateAppControlFrame(AppControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
    }

    private void validateByeControlFrame(ByeControlFrame frame) {
        if (frame.getSourceCount() == 0) {
            frame = new ByeControlFrame(this.__currentLocalSynchronizationSource);
        }
    }

    private void validateFeedbackControlFrame(FeedbackControlFrame frame) {
        frame.setPacketSenderSynchronizationSource(this.__currentLocalSynchronizationSource);
        frame.setMediaSourceSynchronizationSource(this.__currentRemoteSynchronizationSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateReportControlFrame(ReportControlFrame frame) {
        if (ArrayExtensions.getLength(frame.getReportBlocks()) > 0) {
            if (this.__maxReceivedPacketIndex == -1L) {
                frame.setReportBlock(null);
            } else {
                for (ReportBlock block : frame.getReportBlocks()) {
                    long num9;
                    long num8;
                    long num7;
                    long packetsReceivedRtp;
                    long num5;
                    long num3;
                    block.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
                    long num = 0L;
                    long num2 = 0L;
                    Object object = this.__receiveCountsLock;
                    synchronized (object) {
                        num = this.__lastSenderReportNtpTimestamp;
                        num2 = this.__lastSenderReportTicks;
                        num3 = this.__maxReceivedPacketIndex;
                        long num4 = this.__minReceivedPacketIndex;
                        num5 = num3 - num4 + 1L;
                        packetsReceivedRtp = this.getPacketsReceivedRtp();
                        num7 = num5 - this.__lastExpectedPacketCount;
                        this.__lastExpectedPacketCount = num5;
                        num8 = packetsReceivedRtp - this.__lastReceivedPacketCount;
                        this.__lastReceivedPacketCount = packetsReceivedRtp;
                        num9 = (long)this.__receiveJitter;
                    }
                    int num10 = (int)(num5 - packetsReceivedRtp);
                    int num11 = (int)(num7 - num8);
                    short num12 = 0;
                    if (num7 != 0L && num11 > 0) {
                        num12 = (short)((long)(num11 << 8) / num7);
                    }
                    long num13 = Binary.fromBytes32(Binary.toBytes64(num, false), 2, false);
                    long num14 = 0L;
                    if (num2 > 0L) {
                        num14 = (long)((double)(DateExtensions.getTicks(DateExtensions.getUtcNow()) - num2) * (65536.0 / (double)Constants.getTicksPerSecond()));
                    }
                    if (block.getFractionLost() == 0) {
                        block.setFractionLost(num12);
                    }
                    if (block.getCumulativeNumberOfPacketsLost() == 0) {
                        block.setCumulativeNumberOfPacketsLost(num10);
                        this.setInboundPacketsLostRtp(num10);
                    }
                    if (block.getExtendedHighestSequenceNumberReceived() == 0L) {
                        block.setExtendedHighestSequenceNumberReceived(num3);
                    }
                    if (block.getInterarrivalJitter() == 0L) {
                        block.setInterarrivalJitter(num9);
                    }
                    if (block.getLastSenderReportTimestamp() == 0L) {
                        block.setLastSenderReportTimestamp(num13);
                    }
                    if (block.getDelaySinceLastSenderReport() != 0L) continue;
                    block.setDelaySinceLastSenderReport(num14);
                }
            }
        }
    }

    private void validateRRControlFrame(RRControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        this.validateReportControlFrame(frame);
    }

    private void validateSdesControlFrame(SdesControlFrame frame) {
        if (frame.getChunks() != null) {
            for (SdesChunk chunk : frame.getChunks()) {
                chunk.setSynchronizationSource(this.__currentLocalSynchronizationSource);
                if (chunk.getSourceDescriptionItems() == null) continue;
                for (int i = 0; i < ArrayExtensions.getLength(chunk.getSourceDescriptionItems()); ++i) {
                    SdesItem item = chunk.getSourceDescriptionItems()[i];
                    if (item.getType() != SdesItemType.getCanonicalName() || Global.equals(item.getText(), super.getParameters().getCanonicalName())) continue;
                    item = new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName());
                }
            }
        }
    }

    private void validateSRControlFrame(SRControlFrame frame) {
        Date utcNow = DateExtensions.getUtcNow();
        long packetsSentRtp = this.getPacketsSentRtp();
        long octetsSentRtp = this.getOctetsSentRtp();
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        if (frame.getNtpTimestamp() == 0L) {
            frame.setNtpTimestamp(NetworkTimeProtocol.dateTimeToNtp(utcNow));
        }
        if (frame.getRtpTimestamp() == 0L) {
            frame.setRtpTimestamp(packetsSentRtp == 0L ? 0L : (long)((double)(DateExtensions.getTicks(utcNow) - this.__firstSendTicks) * this.__sendRtpCyclesPerTick) + (long)this.__startTimeOffset);
        }
        if (frame.getPacketCount() == 0L) {
            frame.setPacketCount(packetsSentRtp);
        }
        if (frame.getOctetCount() == 0L) {
            frame.setOctetCount(octetsSentRtp);
        }
        this.validateReportControlFrame(frame);
    }
}

