/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.MediaTrackStats;
import fm.icelink.Utility;
import java.util.HashMap;

public class MediaStats
extends BaseStats {
    private MediaTrackStats[] _tracks;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null && Global.equals(str, "tracks")) {
            this.setTracks(MediaTrackStats.fromJsonArray(valueJson));
        }
    }

    public static MediaStats fromJson(String mediaJson) {
        return JsonSerializer.deserializeObject(mediaJson, new IFunction0<MediaStats>(){

            @Override
            public MediaStats invoke() {
                return new MediaStats();
            }
        }, new IAction3<MediaStats, String, String>(){

            @Override
            public void invoke(MediaStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public MediaTrackStats getTrack() {
        return Utility.firstOrDefault(this.getTracks());
    }

    public MediaTrackStats getTrack(String trackId) {
        for (MediaTrackStats stats : this.getTracks()) {
            if (!Global.equals(stats.getId(), trackId)) continue;
            return stats;
        }
        return null;
    }

    public MediaTrackStats[] getTracks() {
        return this._tracks;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        if (this.getTracks() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "tracks", MediaTrackStats.toJsonArray(this.getTracks()));
        }
    }

    void setTracks(MediaTrackStats[] value) {
        this._tracks = value;
    }

    public String toJson() {
        return MediaStats.toJson(this);
    }

    public static String toJson(MediaStats media) {
        return JsonSerializer.serializeObject(media, new IAction2<MediaStats, HashMap<String, String>>(){

            @Override
            public void invoke(MediaStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }
}

