/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum MacType {
    HmacMd5(1),
    HmacSha1(2),
    HmacSha256(3);

    private final int value;
    private static final Map<Integer, MacType> lookup;

    private MacType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static MacType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, MacType>();
        for (MacType s : EnumSet.allOf(MacType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

