/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DataChannelState {
    New(1),
    Connecting(2),
    Connected(3),
    Closing(4),
    Closed(5),
    Failed(6);

    private final int value;
    private static final Map<Integer, DataChannelState> lookup;

    private DataChannelState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static DataChannelState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, DataChannelState>();
        for (DataChannelState s : EnumSet.allOf(DataChannelState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

