/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.ArrayExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Error;
import fm.icelink.Holder;
import fm.icelink.IAudioOutput;
import fm.icelink.IMediaOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.ParseAssistant;
import fm.icelink.StringExtensions;
import fm.icelink.opus.Format;
import fm.icelink.opus.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MaxPacketTimeAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.PacketTimeAttribute;
import fm.icelink.sdp.rtp.MapAttribute;

public class Decoder
extends AudioDecoder {
    private int __currentChannelCount = -1;
    private int __currentClockRate = -1;
    private double __currentPacketTime = 20.0;
    private long __currentSequenceNumber = -1L;
    private Native __decoder;
    private long __lastSequenceNumber = -1L;

    private AudioBuffer decode(AudioBuffer encodedFrame, AudioFormat outputFormat, boolean fec) {
        AudioBuffer buffer = this.__decoder.decode(encodedFrame, outputFormat, fec);
        if (buffer != null) {
            buffer.getDataBuffer().setLittleEndian(outputFormat.getLittleEndian());
            return buffer;
        }
        return null;
    }

    private AudioBuffer[] decode(AudioBuffer buffer, AudioFormat outputFormat) {
        if (buffer == null) {
            return null;
        }
        if (this.__decoder == null) {
            this.__currentClockRate = ((AudioFormat)buffer.getFormat()).getClockRate();
            this.__currentChannelCount = ((AudioFormat)buffer.getFormat()).getChannelCount();
            this.__decoder = new Native(false, this.__currentClockRate, this.__currentChannelCount, this.__currentPacketTime);
            super.setDisablePlc(true);
        }
        if (this.__lastSequenceNumber == -1L) {
            this.__lastSequenceNumber = this.__currentSequenceNumber;
            return new AudioBuffer[]{this.decodeNormal(buffer, outputFormat)};
        }
        int num = (int)(this.__currentSequenceNumber - this.__lastSequenceNumber);
        if (num <= 0) {
            return null;
        }
        this.__lastSequenceNumber = this.__currentSequenceNumber;
        Object[] bufferArray = new AudioBuffer[num];
        int num2 = num - 1;
        if (num2 > 0) {
            Log.warn((String)StringExtensions.format((String)"Audio Packet sequence violated with {0} missing packets. Will do FEC/PLC.", (Object)IntegerExtensions.toString((Integer)num2)));
            int num3 = num2 - 1;
            if (num3 > 0) {
                for (int i = 0; i < num3; ++i) {
                    bufferArray[i] = this.decodePLC(outputFormat);
                }
            }
            AudioBuffer buffer2 = this.decodeFEC(buffer, outputFormat);
            bufferArray[num2 - 1] = buffer2;
        }
        bufferArray[ArrayExtensions.getLength((Object[])bufferArray) - 1] = this.decodeNormal(buffer, outputFormat);
        return bufferArray;
    }

    private AudioBuffer decodeFEC(AudioBuffer encodedFrame, AudioFormat outputFormat) {
        AudioBuffer buffer = this.decode(encodedFrame, outputFormat, true);
        if (buffer != null) {
            buffer.setRecoveredByFec(true);
        }
        return buffer;
    }

    private AudioBuffer decodeNormal(AudioBuffer encodedFrame, AudioFormat outputFormat) {
        return this.decode(encodedFrame, outputFormat, false);
    }

    private AudioBuffer decodePLC(AudioFormat outputFormat) {
        AudioBuffer buffer = this.decode(null, outputFormat, false);
        if (buffer != null) {
            buffer.setGeneratedByPlc(true);
        }
        return buffer;
    }

    public Decoder() {
        this(new Format().getConfig());
    }

    public Decoder(AudioConfig config) {
        super((AudioFormat)new Format(config), (AudioFormat)new fm.icelink.pcm.Format(config));
    }

    public Decoder(IAudioOutput input) {
        this(input.getConfig());
        super.addInput((IMediaOutput)input);
    }

    protected void doDestroy() {
        if (this.__decoder != null) {
            this.__decoder.destroy();
            this.__decoder = null;
        }
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        for (AudioBuffer buffer : (AudioBuffer[])frame.getBuffers()) {
            if (!((AudioFormat)buffer.getFormat()).isEquivalent((AudioFormat)super.getInputFormat(), true) || !((AudioFormat)buffer.getFormat()).getIsPacketized()) continue;
            this.__currentSequenceNumber = buffer.getSequenceNumber();
        }
        Object[] bufferArray = this.decode(inputBuffer, (AudioFormat)super.getOutputFormat());
        if (bufferArray != null) {
            for (AudioBuffer audioBuffer : bufferArray) {
                if (audioBuffer == null) continue;
                AudioFrame frame2 = ArrayExtensions.getLength((Object[])bufferArray) == 1 ? frame : frame.clone();
                frame2.addBuffer((MediaBuffer)audioBuffer);
                this.raiseFrame(frame2);
            }
            for (Object object : bufferArray) {
                if (object == null) continue;
                object.getDataBuffer().free();
            }
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        MapAttribute attribute = mediaDescription.getRtpMapAttribute(((AudioFormat)super.getInputFormat()).getName(), ((AudioFormat)super.getInputFormat()).getClockRate(), ((AudioFormat)super.getInputFormat()).getParameters());
        if (attribute != null) {
            FormatParametersAttribute relatedFormatParametersAttribute = attribute.getRelatedFormatParametersAttribute();
            if (isLocalDescription) {
                if (relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(attribute.getPayloadType());
                    attribute.setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                relatedFormatParametersAttribute.setFormatSpecificParameter("useinbandfec", "1");
            } else {
                int intResult = 10;
                if (relatedFormatParametersAttribute != null) {
                    String str = null;
                    Holder _var0 = new Holder(str);
                    boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("minptime", _var0);
                    str = (String)_var0.getValue();
                    IntegerHolder _var2 = new IntegerHolder(intResult);
                    boolean _var3 = ParseAssistant.tryParseIntegerValue((String)str, (IntegerHolder)_var2);
                    intResult = _var2.getValue();
                    if (_var1 && !_var3) {
                        intResult = 10;
                    }
                }
                int packetTime = 20;
                PacketTimeAttribute packetTimeAttribute = mediaDescription.getPacketTimeAttribute();
                if (packetTimeAttribute != null) {
                    packetTime = packetTimeAttribute.getPacketTime();
                }
                int maxPacketTime = 60;
                MaxPacketTimeAttribute maxPacketTimeAttribute = mediaDescription.getMaxPacketTimeAttribute();
                if (maxPacketTimeAttribute != null) {
                    maxPacketTime = maxPacketTimeAttribute.getMaxPacketTime();
                }
                this.__currentPacketTime = packetTime;
            }
        }
        return null;
    }

    public String getLabel() {
        return "Opus Decoder";
    }
}

