/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.BooleanHolder;
import fm.SingleAction;
import fm.TcpAcceptArgs;
import fm.TcpAcceptCompleteArgs;
import fm.TcpAcceptFailureArgs;
import fm.TcpAcceptSuccessArgs;
import fm.TcpConnectArgs;
import fm.TcpConnectCompleteArgs;
import fm.TcpConnectFailureArgs;
import fm.TcpConnectSuccessArgs;
import fm.TcpReceiveArgs;
import fm.TcpReceiveCompleteArgs;
import fm.TcpReceiveFailureArgs;
import fm.TcpReceiveSuccessArgs;
import fm.TcpSendArgs;
import fm.TcpSendCompleteArgs;
import fm.TcpSendFailureArgs;
import fm.TcpSendSuccessArgs;
import fm.TcpSocketCipherSuites;
import fm.TimeoutTimer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TcpSocket {
    private ExecutorService _execAccept = Executors.newFixedThreadPool(1);
    private ExecutorService _execConnect = Executors.newFixedThreadPool(1);
    private ExecutorService _execIn = Executors.newFixedThreadPool(1);
    private ExecutorService _execOut = Executors.newFixedThreadPool(1);
    private Socket _socket;
    private ServerSocket _serverSocket;
    private OutputStream _out;
    private InputStream _in;
    private boolean _isServer;
    private boolean _isSecure;
    private boolean _ipv6;
    private boolean _isClosed;
    private TimeoutTimer _connectTimer;
    private TimeoutTimer _sendTimer;
    private TimeoutTimer _receiveTimer;
    private static TcpSocketCipherSuites _cipherSuites = TcpSocketCipherSuites.Default;
    private byte[] _receiveBuffer = new byte[1024];

    public static TcpSocketCipherSuites getCipherSuites() {
        return _cipherSuites;
    }

    public static void setCipherSuites(TcpSocketCipherSuites cipherSuites) {
        _cipherSuites = cipherSuites;
    }

    public TcpSocket(boolean server, boolean ipv6, boolean secure) throws Exception {
        this._isServer = server;
        this._ipv6 = ipv6;
        this._isSecure = secure;
        if (this._isServer) {
            if (this._isSecure) {
                this._serverSocket = SSLServerSocketFactory.getDefault().createServerSocket();
                if (_cipherSuites == TcpSocketCipherSuites.All) {
                    SSLServerSocket sslServerSocket = (SSLServerSocket)this._serverSocket;
                    sslServerSocket.setEnabledCipherSuites(sslServerSocket.getSupportedCipherSuites());
                }
            } else {
                this._serverSocket = ServerSocketFactory.getDefault().createServerSocket();
            }
        } else if (this._isSecure) {
            this._socket = SSLSocketFactory.getDefault().createSocket();
            if (_cipherSuites == TcpSocketCipherSuites.All) {
                SSLSocket sslSocket = (SSLSocket)this._socket;
                sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
            }
        } else {
            this._socket = SocketFactory.getDefault().createSocket();
        }
    }

    public TcpSocket(Socket socket) {
        this._isServer = false;
        this._ipv6 = socket.getLocalAddress() instanceof Inet6Address;
        this._socket = socket;
    }

    public boolean getIsServer() {
        return this._isServer;
    }

    public boolean getIsSecure() {
        return this._isSecure;
    }

    public boolean getIPv6() {
        return this._ipv6;
    }

    public boolean getIsClosed() {
        return this._isClosed;
    }

    public String getLocalIPAddress() {
        return this._socket.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public String getRemoteIPAddress() {
        return this._socket.getInetAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this._socket.getPort();
    }

    public void bind(String ipAddress, int port, BooleanHolder addressInUse) throws Exception {
        try {
            InetAddress localAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
            if (this._socket != null) {
                this._socket.bind(new InetSocketAddress(localAddress, port));
            } else {
                this._serverSocket.bind(new InetSocketAddress(localAddress, port));
            }
            addressInUse.setValue(false);
        }
        catch (BindException e) {
            if (e.getMessage().contains("in use")) {
                addressInUse.setValue(true);
            }
            throw e;
        }
    }

    public TcpSocket accept() throws Exception {
        if (this._socket != null) {
            throw new Exception("Client TCP sockets cannot 'accept'.");
        }
        Socket acceptSocket = this._serverSocket.accept();
        return new TcpSocket(acceptSocket);
    }

    public void acceptAsync(final TcpAcceptArgs acceptArgs) {
        try {
            this._execAccept.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TcpSocket acceptSocket = TcpSocket.this.accept();
                        TcpSocket.this.raiseAcceptSuccess(acceptArgs, acceptSocket);
                        TcpSocket.this.raiseAcceptComplete(acceptArgs);
                    }
                    catch (Exception e) {
                        TcpSocket.this.raiseAcceptFailure(acceptArgs, new Exception("Socket accept failed.", e));
                        TcpSocket.this.raiseAcceptComplete(acceptArgs);
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseAcceptFailure(acceptArgs, new Exception("Socket accept failed.", e));
            this.raiseAcceptComplete(acceptArgs);
        }
    }

    public void connect(String ipAddress, int port) throws Exception {
        if (this._socket == null) {
            throw new Exception("Server TCP sockets cannot 'connect'.");
        }
        InetAddress remoteAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
        this._socket.connect(new InetSocketAddress(remoteAddress, port));
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
    }

    public void connectAsync(final TcpConnectArgs connectArgs) {
        try {
            if (connectArgs.getWillTimeout()) {
                this._connectTimer = new TimeoutTimer(new SingleAction<Object>(){

                    @Override
                    public void invoke(Object state) {
                        TcpSocket.this.raiseConnectFailure(connectArgs, new Exception("Socket connect timed out."), true);
                        TcpSocket.this.raiseConnectComplete(connectArgs);
                    }
                }, null);
                this._connectTimer.start(connectArgs.getTimeout());
            }
            this._execConnect.submit(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            TcpSocket.this.connect(connectArgs.getIPAddress(), connectArgs.getPort());
                            if (!connectArgs.getWillTimeout() || TcpSocket.this._connectTimer != null && TcpSocket.this._connectTimer.stop()) {
                                TcpSocket.this.raiseConnectSuccess(connectArgs);
                                TcpSocket.this.raiseConnectComplete(connectArgs);
                            }
                        }
                        catch (Exception e) {
                            if (connectArgs.getWillTimeout() && (TcpSocket.this._connectTimer == null || !TcpSocket.this._connectTimer.stop())) break block3;
                            TcpSocket.this.raiseConnectFailure(connectArgs, new Exception("Socket connect failed.", e), false);
                            TcpSocket.this.raiseConnectComplete(connectArgs);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseConnectFailure(connectArgs, new Exception("Socket connect failed.", e), false);
            this.raiseConnectComplete(connectArgs);
        }
    }

    public void send(byte[] buffer) throws Exception {
        this._out.write(buffer);
    }

    public void sendAsync(final TcpSendArgs sendArgs) {
        try {
            if (sendArgs.getWillTimeout()) {
                this._sendTimer = new TimeoutTimer(new SingleAction<Object>(){

                    @Override
                    public void invoke(Object state) {
                        TcpSocket.this.raiseSendFailure(sendArgs, new Exception("Socket send timed out."), true);
                        TcpSocket.this.raiseSendComplete(sendArgs);
                    }
                }, null);
                this._sendTimer.start(sendArgs.getTimeout());
            }
            this._execOut.submit(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            TcpSocket.this.send(sendArgs.getBuffer());
                            if (!sendArgs.getWillTimeout() || TcpSocket.this._sendTimer != null && TcpSocket.this._sendTimer.stop()) {
                                TcpSocket.this.raiseSendSuccess(sendArgs);
                                TcpSocket.this.raiseSendComplete(sendArgs);
                            }
                        }
                        catch (Exception e) {
                            if (sendArgs.getWillTimeout() && (TcpSocket.this._sendTimer == null || !TcpSocket.this._sendTimer.stop())) break block3;
                            TcpSocket.this.raiseSendFailure(sendArgs, new Exception("Socket send failed.", e), false);
                            TcpSocket.this.raiseSendComplete(sendArgs);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseSendFailure(sendArgs, new Exception("Socket send failed.", e), false);
            this.raiseSendComplete(sendArgs);
        }
    }

    public void receiveAsync(final TcpReceiveArgs receiveArgs) {
        try {
            if (receiveArgs.getWillTimeout()) {
                this._receiveTimer = new TimeoutTimer(new SingleAction<Object>(){

                    @Override
                    public void invoke(Object state) {
                        TcpSocket.this.raiseReceiveFailure(receiveArgs, new Exception("Socket receive timed out."), true);
                        TcpSocket.this.raiseReceiveComplete(receiveArgs);
                    }
                }, null);
                this._receiveTimer.start(receiveArgs.getTimeout());
            }
            this._execIn.submit(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            int read = TcpSocket.this._in.read(TcpSocket.this._receiveBuffer);
                            if (!receiveArgs.getWillTimeout() || TcpSocket.this._receiveTimer != null && TcpSocket.this._receiveTimer.stop()) {
                                byte[] buffer = new byte[read];
                                for (int i = 0; i < read; ++i) {
                                    buffer[i] = TcpSocket.this._receiveBuffer[i];
                                }
                                TcpSocket.this.raiseReceiveSuccess(receiveArgs, buffer);
                                TcpSocket.this.raiseReceiveComplete(receiveArgs);
                            }
                        }
                        catch (Exception e) {
                            if (receiveArgs.getWillTimeout() && (TcpSocket.this._receiveTimer == null || !TcpSocket.this._receiveTimer.stop())) break block4;
                            TcpSocket.this.raiseReceiveFailure(receiveArgs, new Exception("Socket receive failed.", e), false);
                            TcpSocket.this.raiseReceiveComplete(receiveArgs);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseReceiveFailure(receiveArgs, new Exception("Socket receive failed.", e), false);
            this.raiseReceiveComplete(receiveArgs);
        }
    }

    public void close() {
        try {
            this._in.close();
            this._out.close();
            if (this._socket != null) {
                this._socket.close();
            }
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            this._execAccept.shutdown();
            this._execConnect.shutdown();
            this._execIn.shutdown();
            this._execOut.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._isClosed = true;
    }

    private void raiseAcceptSuccess(final TcpAcceptArgs acceptArgs, final TcpSocket acceptSocket) {
        final TcpSocket self = this;
        if (acceptArgs.getOnSuccess() != null) {
            acceptArgs.getOnSuccess().invoke(new TcpAcceptSuccessArgs(){
                {
                    this.setDynamicProperties(acceptArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(acceptArgs.getState());
                    this.setAcceptSocket(acceptSocket);
                }
            });
        }
    }

    private void raiseAcceptFailure(final TcpAcceptArgs acceptArgs, final Exception exception) {
        final TcpSocket self = this;
        if (acceptArgs.getOnFailure() != null) {
            acceptArgs.getOnFailure().invoke(new TcpAcceptFailureArgs(){
                {
                    this.setDynamicProperties(acceptArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(acceptArgs.getState());
                    this.setException(exception);
                }
            });
        }
    }

    private void raiseAcceptComplete(final TcpAcceptArgs acceptArgs) {
        final TcpSocket self = this;
        if (acceptArgs.getOnComplete() != null) {
            acceptArgs.getOnComplete().invoke(new TcpAcceptCompleteArgs(){
                {
                    this.setDynamicProperties(acceptArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(acceptArgs.getState());
                }
            });
        }
    }

    private void raiseConnectSuccess(final TcpConnectArgs connectArgs) {
        final TcpSocket self = this;
        if (connectArgs.getOnSuccess() != null) {
            connectArgs.getOnSuccess().invoke(new TcpConnectSuccessArgs(){
                {
                    this.setDynamicProperties(connectArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(connectArgs.getState());
                    this.setTimeout(connectArgs.getTimeout());
                }
            });
        }
    }

    private void raiseConnectFailure(final TcpConnectArgs connectArgs, final Exception exception, final boolean timedOut) {
        final TcpSocket self = this;
        if (connectArgs.getOnFailure() != null) {
            connectArgs.getOnFailure().invoke(new TcpConnectFailureArgs(){
                {
                    this.setDynamicProperties(connectArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(connectArgs.getState());
                    this.setTimeout(connectArgs.getTimeout());
                    this.setException(exception);
                    this.setTimedOut(timedOut);
                }
            });
        }
    }

    private void raiseConnectComplete(final TcpConnectArgs connectArgs) {
        final TcpSocket self = this;
        if (connectArgs.getOnComplete() != null) {
            connectArgs.getOnComplete().invoke(new TcpConnectCompleteArgs(){
                {
                    this.setDynamicProperties(connectArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(connectArgs.getState());
                    this.setTimeout(connectArgs.getTimeout());
                }
            });
        }
    }

    private void raiseSendSuccess(final TcpSendArgs sendArgs) {
        final TcpSocket self = this;
        if (sendArgs.getOnSuccess() != null) {
            sendArgs.getOnSuccess().invoke(new TcpSendSuccessArgs(){
                {
                    this.setDynamicProperties(sendArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(sendArgs.getState());
                    this.setBuffer(sendArgs.getBuffer());
                    this.setTimeout(sendArgs.getTimeout());
                }
            });
        }
    }

    private void raiseSendFailure(final TcpSendArgs sendArgs, final Exception exception, final boolean timedOut) {
        final TcpSocket self = this;
        if (sendArgs.getOnFailure() != null) {
            sendArgs.getOnFailure().invoke(new TcpSendFailureArgs(){
                {
                    this.setDynamicProperties(sendArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(sendArgs.getState());
                    this.setBuffer(sendArgs.getBuffer());
                    this.setTimeout(sendArgs.getTimeout());
                    this.setTimedOut(timedOut);
                    this.setException(exception);
                }
            });
        }
    }

    private void raiseSendComplete(final TcpSendArgs sendArgs) {
        final TcpSocket self = this;
        if (sendArgs.getOnComplete() != null) {
            sendArgs.getOnComplete().invoke(new TcpSendCompleteArgs(){
                {
                    this.setDynamicProperties(sendArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(sendArgs.getState());
                    this.setBuffer(sendArgs.getBuffer());
                    this.setTimeout(sendArgs.getTimeout());
                }
            });
        }
    }

    private void raiseReceiveSuccess(final TcpReceiveArgs receiveArgs, final byte[] buffer) {
        final TcpSocket self = this;
        if (receiveArgs.getOnSuccess() != null) {
            receiveArgs.getOnSuccess().invoke(new TcpReceiveSuccessArgs(){
                {
                    this.setDynamicProperties(receiveArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(receiveArgs.getState());
                    this.setBuffer(buffer);
                    this.setTimeout(receiveArgs.getTimeout());
                }
            });
        }
    }

    private void raiseReceiveFailure(final TcpReceiveArgs receiveArgs, final Exception exception, final boolean timedOut) {
        final TcpSocket self = this;
        if (receiveArgs.getOnFailure() != null) {
            receiveArgs.getOnFailure().invoke(new TcpReceiveFailureArgs(){
                {
                    this.setDynamicProperties(receiveArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(receiveArgs.getState());
                    this.setTimeout(receiveArgs.getTimeout());
                    this.setTimedOut(timedOut);
                    this.setException(exception);
                }
            });
        }
    }

    private void raiseReceiveComplete(final TcpReceiveArgs receiveArgs) {
        final TcpSocket self = this;
        if (receiveArgs.getOnComplete() != null) {
            receiveArgs.getOnComplete().invoke(new TcpReceiveCompleteArgs(){
                {
                    this.setDynamicProperties(receiveArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(receiveArgs.getState());
                    this.setTimeout(receiveArgs.getTimeout());
                }
            });
        }
    }
}

