/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.ArrayListExtensions;
import fm.AsyncException;
import fm.DateExtensions;
import fm.Deferrer;
import fm.Delegate;
import fm.DoubleAction;
import fm.Global;
import fm.Guid;
import fm.HashMapExtensions;
import fm.Holder;
import fm.HttpRequestCreatedArgs;
import fm.HttpResponseReceivedArgs;
import fm.HttpTransfer;
import fm.HttpWebRequestTransfer;
import fm.IntegerExtensions;
import fm.IntegerMap;
import fm.Log;
import fm.LongExtensions;
import fm.ManagedThread;
import fm.NullableBoolean;
import fm.NullableDate;
import fm.NullableGuid;
import fm.ParseAssistant;
import fm.SingleAction;
import fm.SingleFunction;
import fm.StringExtensions;
import fm.WebSocketOpenFailureArgs;
import fm.WebSocketOpenSuccessArgs;
import fm.WebSocketStreamFailureArgs;
import fm.websync.Advice;
import fm.websync.BackoffArgs;
import fm.websync.BaseAdvice;
import fm.websync.BaseClient;
import fm.websync.BaseClientEndEventArgs;
import fm.websync.BaseClientEventArgs;
import fm.websync.BaseClientRequestEventArgs;
import fm.websync.BaseClientResponseEventArgs;
import fm.websync.BaseFailureArgs;
import fm.websync.BaseInputArgs;
import fm.websync.BindArgs;
import fm.websync.BindCompleteArgs;
import fm.websync.BindFailureArgs;
import fm.websync.BindSuccessArgs;
import fm.websync.ClientBindEndArgs;
import fm.websync.ClientBindRequestArgs;
import fm.websync.ClientBindResponseArgs;
import fm.websync.ClientConnectEndArgs;
import fm.websync.ClientConnectRequestArgs;
import fm.websync.ClientConnectResponseArgs;
import fm.websync.ClientDisconnectEndArgs;
import fm.websync.ClientDisconnectRequestArgs;
import fm.websync.ClientDisconnectResponseArgs;
import fm.websync.ClientNotifyEndArgs;
import fm.websync.ClientNotifyRequestArgs;
import fm.websync.ClientNotifyResponseArgs;
import fm.websync.ClientPublishEndArgs;
import fm.websync.ClientPublishRequestArgs;
import fm.websync.ClientPublishResponseArgs;
import fm.websync.ClientRequest;
import fm.websync.ClientResponseArgs;
import fm.websync.ClientSendState;
import fm.websync.ClientServiceEndArgs;
import fm.websync.ClientServiceRequestArgs;
import fm.websync.ClientServiceResponseArgs;
import fm.websync.ClientSubscribeEndArgs;
import fm.websync.ClientSubscribeRequestArgs;
import fm.websync.ClientSubscribeResponseArgs;
import fm.websync.ClientUnbindEndArgs;
import fm.websync.ClientUnbindRequestArgs;
import fm.websync.ClientUnbindResponseArgs;
import fm.websync.ClientUnsubscribeEndArgs;
import fm.websync.ClientUnsubscribeRequestArgs;
import fm.websync.ClientUnsubscribeResponseArgs;
import fm.websync.ConcurrencyMode;
import fm.websync.ConnectArgs;
import fm.websync.ConnectCompleteArgs;
import fm.websync.ConnectFailureArgs;
import fm.websync.ConnectRetryMode;
import fm.websync.ConnectSuccessArgs;
import fm.websync.ConnectionType;
import fm.websync.DeferredRetryConnectState;
import fm.websync.DeferredStreamState;
import fm.websync.DisconnectArgs;
import fm.websync.DisconnectCompleteArgs;
import fm.websync.Extensible;
import fm.websync.Extensions;
import fm.websync.Message;
import fm.websync.MessageRequestArgs;
import fm.websync.MessageRequestCreatedArgs;
import fm.websync.MessageResponseArgs;
import fm.websync.MessageResponseReceivedArgs;
import fm.websync.MessageTransfer;
import fm.websync.MessageTransferFactory;
import fm.websync.MetaChannels;
import fm.websync.NotifyArgs;
import fm.websync.NotifyCompleteArgs;
import fm.websync.NotifyFailureArgs;
import fm.websync.NotifyReceiveArgs;
import fm.websync.NotifySuccessArgs;
import fm.websync.NullableConnectionType;
import fm.websync.NullableReconnect;
import fm.websync.PublishArgs;
import fm.websync.PublishCompleteArgs;
import fm.websync.PublishFailureArgs;
import fm.websync.PublishSuccessArgs;
import fm.websync.Reconnect;
import fm.websync.Record;
import fm.websync.ServerBindArgs;
import fm.websync.ServerSubscribeArgs;
import fm.websync.ServerUnbindArgs;
import fm.websync.ServerUnsubscribeArgs;
import fm.websync.ServiceArgs;
import fm.websync.ServiceCompleteArgs;
import fm.websync.ServiceFailureArgs;
import fm.websync.ServiceSuccessArgs;
import fm.websync.StateRestoredArgs;
import fm.websync.StreamFailureArgs;
import fm.websync.SubscribeArgs;
import fm.websync.SubscribeCompleteArgs;
import fm.websync.SubscribeFailureArgs;
import fm.websync.SubscribeReceiveArgs;
import fm.websync.SubscribeSuccessArgs;
import fm.websync.UnbindArgs;
import fm.websync.UnbindCompleteArgs;
import fm.websync.UnbindFailureArgs;
import fm.websync.UnbindSuccessArgs;
import fm.websync.UnsubscribeArgs;
import fm.websync.UnsubscribeCompleteArgs;
import fm.websync.UnsubscribeFailureArgs;
import fm.websync.UnsubscribeSuccessArgs;
import fm.websync.WebSocketMessageTransfer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class Client
extends BaseClient {
    private String __streamRequestUrl;
    private static String _argsKey;
    private int _batchCounter = 0;
    private Object _batchCounterLock;
    private static String _bayeuxMinimumVersion;
    private static String _bayeuxVersion;
    private HashMap<String, Record> _boundRecords;
    private Object _boundRecordsLock;
    private Guid _clientId;
    private ConnectArgs _connectArgs = null;
    private ConnectionType _connectionType = ConnectionType.LongPolling;
    private int _counter = 0;
    private Object _counterLock;
    private HashMap<String, HashMap<String, SingleAction<SubscribeReceiveArgs>>> _customOnReceives;
    private Object _customOnReceivesLock;
    private boolean _disableWebSockets;
    private volatile boolean _disconnectCalled = false;
    private Guid _instanceId;
    private boolean _isConnected;
    private boolean _isConnecting;
    private boolean _isDisconnecting;
    private int _lastBackoffIndex = -1;
    private int _lastBackoffTimeout = 0;
    private int _lastInterval = 0;
    private NullableReconnect _lastReconnect = new NullableReconnect();
    private SingleAction<BindCompleteArgs> _onBindComplete;
    private static DoubleAction<Client, ClientBindEndArgs> _onBindEnd;
    private SingleAction<BindFailureArgs> _onBindFailure;
    private static DoubleAction<Client, ClientBindRequestArgs> _onBindRequest;
    private static DoubleAction<Client, ClientBindResponseArgs> _onBindResponse;
    private SingleAction<BindSuccessArgs> _onBindSuccess;
    private SingleAction<ConnectCompleteArgs> _onConnectComplete;
    private static DoubleAction<Client, ClientConnectEndArgs> _onConnectEnd;
    private SingleAction<ConnectFailureArgs> _onConnectFailure;
    private static DoubleAction<Client, ClientConnectRequestArgs> _onConnectRequest;
    private static DoubleAction<Client, ClientConnectResponseArgs> _onConnectResponse;
    private SingleAction<ConnectSuccessArgs> _onConnectSuccess;
    private SingleAction<DisconnectCompleteArgs> _onDisconnectComplete;
    private static DoubleAction<Client, ClientDisconnectEndArgs> _onDisconnectEnd;
    private static DoubleAction<Client, ClientDisconnectRequestArgs> _onDisconnectRequest;
    private static DoubleAction<Client, ClientDisconnectResponseArgs> _onDisconnectResponse;
    private SingleAction<NotifyReceiveArgs> _onNotify;
    private SingleAction<NotifyCompleteArgs> _onNotifyComplete;
    private static DoubleAction<Client, ClientNotifyEndArgs> _onNotifyEnd;
    private SingleAction<NotifyFailureArgs> _onNotifyFailure;
    private static DoubleAction<Client, ClientNotifyRequestArgs> _onNotifyRequest;
    private static DoubleAction<Client, ClientNotifyResponseArgs> _onNotifyResponse;
    private SingleAction<NotifySuccessArgs> _onNotifySuccess;
    private SingleAction<PublishCompleteArgs> _onPublishComplete;
    private static DoubleAction<Client, ClientPublishEndArgs> _onPublishEnd;
    private SingleAction<PublishFailureArgs> _onPublishFailure;
    private static DoubleAction<Client, ClientPublishRequestArgs> _onPublishRequest;
    private static DoubleAction<Client, ClientPublishResponseArgs> _onPublishResponse;
    private SingleAction<PublishSuccessArgs> _onPublishSuccess;
    private SingleAction<ServerBindArgs> _onServerBind;
    private SingleFunction<ServerSubscribeArgs, SingleAction<SubscribeReceiveArgs>> _onServerSubscribe;
    private SingleAction<ServerUnbindArgs> _onServerUnbind;
    private SingleAction<ServerUnsubscribeArgs> _onServerUnsubscribe;
    private SingleAction<ServiceCompleteArgs> _onServiceComplete;
    private static DoubleAction<Client, ClientServiceEndArgs> _onServiceEnd;
    private SingleAction<ServiceFailureArgs> _onServiceFailure;
    private static DoubleAction<Client, ClientServiceRequestArgs> _onServiceRequest;
    private static DoubleAction<Client, ClientServiceResponseArgs> _onServiceResponse;
    private SingleAction<ServiceSuccessArgs> _onServiceSuccess;
    private SingleAction<StateRestoredArgs> _onStateRestored;
    private SingleAction<StreamFailureArgs> _onStreamFailure;
    private SingleAction<SubscribeCompleteArgs> _onSubscribeComplete;
    private static DoubleAction<Client, ClientSubscribeEndArgs> _onSubscribeEnd;
    private SingleAction<SubscribeFailureArgs> _onSubscribeFailure;
    private static DoubleAction<Client, ClientSubscribeRequestArgs> _onSubscribeRequest;
    private static DoubleAction<Client, ClientSubscribeResponseArgs> _onSubscribeResponse;
    private SingleAction<SubscribeSuccessArgs> _onSubscribeSuccess;
    private SingleAction<UnbindCompleteArgs> _onUnbindComplete;
    private static DoubleAction<Client, ClientUnbindEndArgs> _onUnbindEnd;
    private SingleAction<UnbindFailureArgs> _onUnbindFailure;
    private static DoubleAction<Client, ClientUnbindRequestArgs> _onUnbindRequest;
    private static DoubleAction<Client, ClientUnbindResponseArgs> _onUnbindResponse;
    private SingleAction<UnbindSuccessArgs> _onUnbindSuccess;
    private SingleAction<UnsubscribeCompleteArgs> _onUnsubscribeComplete;
    private static DoubleAction<Client, ClientUnsubscribeEndArgs> _onUnsubscribeEnd;
    private SingleAction<UnsubscribeFailureArgs> _onUnsubscribeFailure;
    private static DoubleAction<Client, ClientUnsubscribeRequestArgs> _onUnsubscribeRequest;
    private static DoubleAction<Client, ClientUnsubscribeResponseArgs> _onUnsubscribeResponse;
    private SingleAction<UnsubscribeSuccessArgs> _onUnsubscribeSuccess;
    private HashMap<String, ArrayList<Message>> _pendingReceives;
    private int _pendingRestoreStateCalls = 0;
    private Object _pendingRestoreStateCallsLock;
    private boolean _queueActivated = false;
    private Object _queueLock;
    private HashMap<String, BindArgs> _rebindCache;
    private ArrayList<Extensible> _reconnectCache;
    private Object _reconnectCacheLock;
    private HashMap<String, ArrayList<ClientRequest>> _requestQueue;
    private MessageTransfer _requestTransfer;
    private static HashMap<String, String> _requestUrlCache;
    private static Object _requestUrlCacheLock;
    private ClientResponseArgs _responseArgs = null;
    private HashMap<String, SubscribeArgs> _resubscribeCache;
    private int _serverTimeout;
    private Guid _sessionId;
    private static String _stateKey;
    private Object _stateLock;
    private MessageTransfer _streamRequestTransfer;
    private HashMap<String, HashMap<String, Object>> _subscribedChannels;
    private Object _subscribedChannelsLock;
    private HashMap<String, HashMap<String, Object>> _subscribedDynamicProperties;
    private HashMap<String, HashMap<String, SingleAction<SubscribeReceiveArgs>>> _subscribedOnReceives;
    private Object _subscribedOnReceivesLock;
    private ConnectionType[] _supportedConnectionTypes;
    private NullableBoolean _synchronous = new NullableBoolean();
    private IntegerMap _threadCounters = new IntegerMap();
    private Object _threadCountersLock = new Object();
    private String _token;
    private boolean _webSocketOpened = false;

    private void activateStream(ConnectArgs connectArgs, ClientResponseArgs responseArgs) throws Exception {
        this.raiseConnectSuccess(this._connectArgs, this._responseArgs);
        this.raiseConnectComplete(this._connectArgs, this._responseArgs);
        ClientConnectEndArgs args = new ClientConnectEndArgs();
        args.setMethodArgs(connectArgs);
        this.raiseCompleteEvent(_onConnectEnd, args, "OnConnectEnd", responseArgs);
        this.processQueue(true);
        this.stream(this._connectArgs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBoundRecords(Record[] records) {
        Object object = this._boundRecordsLock;
        synchronized (object) {
            for (Record record : records) {
                HashMapExtensions.getItem(this._boundRecords).put(record.getKey(), record);
            }
        }
    }

    public SingleAction<BindCompleteArgs> addOnBindComplete(SingleAction<BindCompleteArgs> value) {
        this._onBindComplete = (SingleAction)Delegate.combine(this._onBindComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientBindEndArgs> addOnBindEnd(DoubleAction<Client, ClientBindEndArgs> value) {
        _onBindEnd = (DoubleAction)Delegate.combine(_onBindEnd, value);
        return value;
    }

    public SingleAction<BindFailureArgs> addOnBindFailure(SingleAction<BindFailureArgs> value) {
        this._onBindFailure = (SingleAction)Delegate.combine(this._onBindFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientBindRequestArgs> addOnBindRequest(DoubleAction<Client, ClientBindRequestArgs> value) {
        _onBindRequest = (DoubleAction)Delegate.combine(_onBindRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientBindResponseArgs> addOnBindResponse(DoubleAction<Client, ClientBindResponseArgs> value) {
        _onBindResponse = (DoubleAction)Delegate.combine(_onBindResponse, value);
        return value;
    }

    public SingleAction<BindSuccessArgs> addOnBindSuccess(SingleAction<BindSuccessArgs> value) {
        this._onBindSuccess = (SingleAction)Delegate.combine(this._onBindSuccess, value);
        return value;
    }

    public SingleAction<ConnectCompleteArgs> addOnConnectComplete(SingleAction<ConnectCompleteArgs> value) {
        this._onConnectComplete = (SingleAction)Delegate.combine(this._onConnectComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientConnectEndArgs> addOnConnectEnd(DoubleAction<Client, ClientConnectEndArgs> value) {
        _onConnectEnd = (DoubleAction)Delegate.combine(_onConnectEnd, value);
        return value;
    }

    public SingleAction<ConnectFailureArgs> addOnConnectFailure(SingleAction<ConnectFailureArgs> value) {
        this._onConnectFailure = (SingleAction)Delegate.combine(this._onConnectFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientConnectRequestArgs> addOnConnectRequest(DoubleAction<Client, ClientConnectRequestArgs> value) {
        _onConnectRequest = (DoubleAction)Delegate.combine(_onConnectRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientConnectResponseArgs> addOnConnectResponse(DoubleAction<Client, ClientConnectResponseArgs> value) {
        _onConnectResponse = (DoubleAction)Delegate.combine(_onConnectResponse, value);
        return value;
    }

    public SingleAction<ConnectSuccessArgs> addOnConnectSuccess(SingleAction<ConnectSuccessArgs> value) {
        this._onConnectSuccess = (SingleAction)Delegate.combine(this._onConnectSuccess, value);
        return value;
    }

    public SingleAction<DisconnectCompleteArgs> addOnDisconnectComplete(SingleAction<DisconnectCompleteArgs> value) {
        this._onDisconnectComplete = (SingleAction)Delegate.combine(this._onDisconnectComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientDisconnectEndArgs> addOnDisconnectEnd(DoubleAction<Client, ClientDisconnectEndArgs> value) {
        _onDisconnectEnd = (DoubleAction)Delegate.combine(_onDisconnectEnd, value);
        return value;
    }

    public static DoubleAction<Client, ClientDisconnectRequestArgs> addOnDisconnectRequest(DoubleAction<Client, ClientDisconnectRequestArgs> value) {
        _onDisconnectRequest = (DoubleAction)Delegate.combine(_onDisconnectRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientDisconnectResponseArgs> addOnDisconnectResponse(DoubleAction<Client, ClientDisconnectResponseArgs> value) {
        _onDisconnectResponse = (DoubleAction)Delegate.combine(_onDisconnectResponse, value);
        return value;
    }

    public SingleAction<NotifyReceiveArgs> addOnNotify(SingleAction<NotifyReceiveArgs> value) {
        this._onNotify = (SingleAction)Delegate.combine(this._onNotify, value);
        return value;
    }

    public SingleAction<NotifyCompleteArgs> addOnNotifyComplete(SingleAction<NotifyCompleteArgs> value) {
        this._onNotifyComplete = (SingleAction)Delegate.combine(this._onNotifyComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientNotifyEndArgs> addOnNotifyEnd(DoubleAction<Client, ClientNotifyEndArgs> value) {
        _onNotifyEnd = (DoubleAction)Delegate.combine(_onNotifyEnd, value);
        return value;
    }

    public SingleAction<NotifyFailureArgs> addOnNotifyFailure(SingleAction<NotifyFailureArgs> value) {
        this._onNotifyFailure = (SingleAction)Delegate.combine(this._onNotifyFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientNotifyRequestArgs> addOnNotifyRequest(DoubleAction<Client, ClientNotifyRequestArgs> value) {
        _onNotifyRequest = (DoubleAction)Delegate.combine(_onNotifyRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientNotifyResponseArgs> addOnNotifyResponse(DoubleAction<Client, ClientNotifyResponseArgs> value) {
        _onNotifyResponse = (DoubleAction)Delegate.combine(_onNotifyResponse, value);
        return value;
    }

    public SingleAction<NotifySuccessArgs> addOnNotifySuccess(SingleAction<NotifySuccessArgs> value) {
        this._onNotifySuccess = (SingleAction)Delegate.combine(this._onNotifySuccess, value);
        return value;
    }

    public SingleAction<PublishCompleteArgs> addOnPublishComplete(SingleAction<PublishCompleteArgs> value) {
        this._onPublishComplete = (SingleAction)Delegate.combine(this._onPublishComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientPublishEndArgs> addOnPublishEnd(DoubleAction<Client, ClientPublishEndArgs> value) {
        _onPublishEnd = (DoubleAction)Delegate.combine(_onPublishEnd, value);
        return value;
    }

    public SingleAction<PublishFailureArgs> addOnPublishFailure(SingleAction<PublishFailureArgs> value) {
        this._onPublishFailure = (SingleAction)Delegate.combine(this._onPublishFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientPublishRequestArgs> addOnPublishRequest(DoubleAction<Client, ClientPublishRequestArgs> value) {
        _onPublishRequest = (DoubleAction)Delegate.combine(_onPublishRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientPublishResponseArgs> addOnPublishResponse(DoubleAction<Client, ClientPublishResponseArgs> value) {
        _onPublishResponse = (DoubleAction)Delegate.combine(_onPublishResponse, value);
        return value;
    }

    public SingleAction<PublishSuccessArgs> addOnPublishSuccess(SingleAction<PublishSuccessArgs> value) {
        this._onPublishSuccess = (SingleAction)Delegate.combine(this._onPublishSuccess, value);
        return value;
    }

    public SingleAction<ServerBindArgs> addOnServerBind(SingleAction<ServerBindArgs> value) {
        this._onServerBind = (SingleAction)Delegate.combine(this._onServerBind, value);
        return value;
    }

    public SingleFunction<ServerSubscribeArgs, SingleAction<SubscribeReceiveArgs>> addOnServerSubscribe(SingleFunction<ServerSubscribeArgs, SingleAction<SubscribeReceiveArgs>> value) {
        this._onServerSubscribe = (SingleFunction)Delegate.combine(this._onServerSubscribe, value);
        return value;
    }

    public SingleAction<ServerUnbindArgs> addOnServerUnbind(SingleAction<ServerUnbindArgs> value) {
        this._onServerUnbind = (SingleAction)Delegate.combine(this._onServerUnbind, value);
        return value;
    }

    public SingleAction<ServerUnsubscribeArgs> addOnServerUnsubscribe(SingleAction<ServerUnsubscribeArgs> value) {
        this._onServerUnsubscribe = (SingleAction)Delegate.combine(this._onServerUnsubscribe, value);
        return value;
    }

    public SingleAction<ServiceCompleteArgs> addOnServiceComplete(SingleAction<ServiceCompleteArgs> value) {
        this._onServiceComplete = (SingleAction)Delegate.combine(this._onServiceComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientServiceEndArgs> addOnServiceEnd(DoubleAction<Client, ClientServiceEndArgs> value) {
        _onServiceEnd = (DoubleAction)Delegate.combine(_onServiceEnd, value);
        return value;
    }

    public SingleAction<ServiceFailureArgs> addOnServiceFailure(SingleAction<ServiceFailureArgs> value) {
        this._onServiceFailure = (SingleAction)Delegate.combine(this._onServiceFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientServiceRequestArgs> addOnServiceRequest(DoubleAction<Client, ClientServiceRequestArgs> value) {
        _onServiceRequest = (DoubleAction)Delegate.combine(_onServiceRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientServiceResponseArgs> addOnServiceResponse(DoubleAction<Client, ClientServiceResponseArgs> value) {
        _onServiceResponse = (DoubleAction)Delegate.combine(_onServiceResponse, value);
        return value;
    }

    public SingleAction<ServiceSuccessArgs> addOnServiceSuccess(SingleAction<ServiceSuccessArgs> value) {
        this._onServiceSuccess = (SingleAction)Delegate.combine(this._onServiceSuccess, value);
        return value;
    }

    public SingleAction<StateRestoredArgs> addOnStateRestored(SingleAction<StateRestoredArgs> value) {
        this._onStateRestored = (SingleAction)Delegate.combine(this._onStateRestored, value);
        return value;
    }

    public SingleAction<StreamFailureArgs> addOnStreamFailure(SingleAction<StreamFailureArgs> value) {
        this._onStreamFailure = (SingleAction)Delegate.combine(this._onStreamFailure, value);
        return value;
    }

    public SingleAction<SubscribeCompleteArgs> addOnSubscribeComplete(SingleAction<SubscribeCompleteArgs> value) {
        this._onSubscribeComplete = (SingleAction)Delegate.combine(this._onSubscribeComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientSubscribeEndArgs> addOnSubscribeEnd(DoubleAction<Client, ClientSubscribeEndArgs> value) {
        _onSubscribeEnd = (DoubleAction)Delegate.combine(_onSubscribeEnd, value);
        return value;
    }

    public SingleAction<SubscribeFailureArgs> addOnSubscribeFailure(SingleAction<SubscribeFailureArgs> value) {
        this._onSubscribeFailure = (SingleAction)Delegate.combine(this._onSubscribeFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientSubscribeRequestArgs> addOnSubscribeRequest(DoubleAction<Client, ClientSubscribeRequestArgs> value) {
        _onSubscribeRequest = (DoubleAction)Delegate.combine(_onSubscribeRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientSubscribeResponseArgs> addOnSubscribeResponse(DoubleAction<Client, ClientSubscribeResponseArgs> value) {
        _onSubscribeResponse = (DoubleAction)Delegate.combine(_onSubscribeResponse, value);
        return value;
    }

    public SingleAction<SubscribeSuccessArgs> addOnSubscribeSuccess(SingleAction<SubscribeSuccessArgs> value) {
        this._onSubscribeSuccess = (SingleAction)Delegate.combine(this._onSubscribeSuccess, value);
        return value;
    }

    public SingleAction<UnbindCompleteArgs> addOnUnbindComplete(SingleAction<UnbindCompleteArgs> value) {
        this._onUnbindComplete = (SingleAction)Delegate.combine(this._onUnbindComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientUnbindEndArgs> addOnUnbindEnd(DoubleAction<Client, ClientUnbindEndArgs> value) {
        _onUnbindEnd = (DoubleAction)Delegate.combine(_onUnbindEnd, value);
        return value;
    }

    public SingleAction<UnbindFailureArgs> addOnUnbindFailure(SingleAction<UnbindFailureArgs> value) {
        this._onUnbindFailure = (SingleAction)Delegate.combine(this._onUnbindFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientUnbindRequestArgs> addOnUnbindRequest(DoubleAction<Client, ClientUnbindRequestArgs> value) {
        _onUnbindRequest = (DoubleAction)Delegate.combine(_onUnbindRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientUnbindResponseArgs> addOnUnbindResponse(DoubleAction<Client, ClientUnbindResponseArgs> value) {
        _onUnbindResponse = (DoubleAction)Delegate.combine(_onUnbindResponse, value);
        return value;
    }

    public SingleAction<UnbindSuccessArgs> addOnUnbindSuccess(SingleAction<UnbindSuccessArgs> value) {
        this._onUnbindSuccess = (SingleAction)Delegate.combine(this._onUnbindSuccess, value);
        return value;
    }

    public SingleAction<UnsubscribeCompleteArgs> addOnUnsubscribeComplete(SingleAction<UnsubscribeCompleteArgs> value) {
        this._onUnsubscribeComplete = (SingleAction)Delegate.combine(this._onUnsubscribeComplete, value);
        return value;
    }

    public static DoubleAction<Client, ClientUnsubscribeEndArgs> addOnUnsubscribeEnd(DoubleAction<Client, ClientUnsubscribeEndArgs> value) {
        _onUnsubscribeEnd = (DoubleAction)Delegate.combine(_onUnsubscribeEnd, value);
        return value;
    }

    public SingleAction<UnsubscribeFailureArgs> addOnUnsubscribeFailure(SingleAction<UnsubscribeFailureArgs> value) {
        this._onUnsubscribeFailure = (SingleAction)Delegate.combine(this._onUnsubscribeFailure, value);
        return value;
    }

    public static DoubleAction<Client, ClientUnsubscribeRequestArgs> addOnUnsubscribeRequest(DoubleAction<Client, ClientUnsubscribeRequestArgs> value) {
        _onUnsubscribeRequest = (DoubleAction)Delegate.combine(_onUnsubscribeRequest, value);
        return value;
    }

    public static DoubleAction<Client, ClientUnsubscribeResponseArgs> addOnUnsubscribeResponse(DoubleAction<Client, ClientUnsubscribeResponseArgs> value) {
        _onUnsubscribeResponse = (DoubleAction)Delegate.combine(_onUnsubscribeResponse, value);
        return value;
    }

    public SingleAction<UnsubscribeSuccessArgs> addOnUnsubscribeSuccess(SingleAction<UnsubscribeSuccessArgs> value) {
        this._onUnsubscribeSuccess = (SingleAction)Delegate.combine(this._onUnsubscribeSuccess, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubscribedChannels(String tag, String[] channels) {
        Object object = this._subscribedChannelsLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._subscribedChannels, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (!_var1) {
                dictionary = new HashMap();
                HashMapExtensions.getItem(this._subscribedChannels).put(tag, dictionary);
            }
            for (String str : channels) {
                if (dictionary.containsKey(str)) continue;
                HashMapExtensions.getItem(dictionary).put(str, new Object());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addSubscribedOnReceive(String tag, String[] channels, SingleAction<SubscribeReceiveArgs> onReceive, HashMap<String, Object> dynamicProperties, int reconnectAfter) throws Exception {
        Object object = this._subscribedOnReceivesLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._subscribedOnReceives, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (!_var1) {
                dictionary = new HashMap();
                HashMapExtensions.getItem(this._subscribedOnReceives).put(tag, dictionary);
            }
            for (String str : channels) {
                HashMapExtensions.getItem(dictionary).put(str, onReceive);
                HashMapExtensions.getItem(this._subscribedDynamicProperties).put(Client.getSubscribeKey(str, tag), dynamicProperties);
            }
            reconnectAfter = this.processPendingReceives(channels, reconnectAfter);
        }
        return reconnectAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(ClientRequest request, String url, boolean synchronous, int timeout) {
        url = url != null ? url : super.getRequestUrl();
        String key = StringExtensions.format((String)"{0}|{1}{2}", (Object)IntegerExtensions.toString((Integer)timeout), (Object)(synchronous ? "1" : "0"), (Object)url);
        Object object = this._queueLock;
        synchronized (object) {
            if (!this._requestQueue.containsKey(key)) {
                HashMapExtensions.getItem(this._requestQueue).put(key, new ArrayList());
            }
            ((ArrayList)HashMapExtensions.getItem(this._requestQueue).get(key)).add(request);
        }
    }

    public Client bind(BindArgs bindArgs) throws Exception {
        if (bindArgs.getRecords() == null || ArrayExtensions.getLength((Object[])bindArgs.getRecords()) == 0) {
            throw new Exception("records cannot be null.");
        }
        for (Record record : bindArgs.getRecords()) {
            if (record.getKey() == null) {
                throw new Exception("key cannot be null.");
            }
            if (record.getValueJson() != null) continue;
            throw new Exception("valueJson cannot be null.");
        }
        this.performBind(bindArgs);
        return this;
    }

    boolean checkSynchronous(NullableBoolean synchronous) {
        if (synchronous.getHasValue()) {
            return synchronous.getValue();
        }
        if (this.getSynchronous().getHasValue()) {
            return this.getSynchronous().getValue();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBoundRecords() {
        Object object = this._boundRecordsLock;
        synchronized (object) {
            this._boundRecords.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubscribedChannels() {
        Object obj2;
        Object object = obj2 = this._subscribedChannelsLock;
        synchronized (object) {
            this._subscribedChannels.clear();
        }
        object = obj2 = this._customOnReceivesLock;
        synchronized (object) {
            this._customOnReceives.clear();
        }
    }

    private Client() {
        this._lastReconnect = new NullableReconnect(null);
        this._reconnectCacheLock = new Object();
        this._reconnectCache = new ArrayList();
        this._rebindCache = new HashMap();
        this._resubscribeCache = new HashMap();
        this._boundRecordsLock = new Object();
        this._boundRecords = new HashMap();
        this._subscribedChannelsLock = new Object();
        this._subscribedChannels = new HashMap();
        this._subscribedOnReceivesLock = new Object();
        this._subscribedOnReceives = new HashMap();
        this._subscribedDynamicProperties = new HashMap();
        this._pendingReceives = new HashMap();
        this._customOnReceivesLock = new Object();
        this._customOnReceives = new HashMap();
        this._stateLock = new Object();
        this._queueLock = new Object();
        this._requestQueue = new HashMap();
        this._supportedConnectionTypes = new ConnectionType[0];
        this._connectionType = ConnectionType.LongPolling;
        this._batchCounterLock = new Object();
        this._pendingRestoreStateCallsLock = new Object();
        this._counterLock = new Object();
        this.setSynchronous(new NullableBoolean(false));
        this.setToken(Client.generateToken());
        this.setInstanceId(Guid.newGuid());
        this.setDisableWebSockets(true);
        this._requestTransfer = MessageTransferFactory.getHttpMessageTransfer();
    }

    public Client(String requestUrl, String streamRequestUrl) throws Exception {
        this();
        super.setRequestUrl(requestUrl);
        this.setStreamRequestUrl(streamRequestUrl);
    }

    public Client(String requestUrl) throws Exception {
        this(requestUrl, requestUrl);
    }

    public Client connect() throws Exception {
        return this.connect(new ConnectArgs());
    }

    public Client connect(ConnectArgs connectArgs) throws Exception {
        this.performConnect(connectArgs);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementPendingRestoreStateCalls() {
        Object object = this._pendingRestoreStateCallsLock;
        synchronized (object) {
            --this._pendingRestoreStateCalls;
            return this._pendingRestoreStateCalls;
        }
    }

    public Client disconnect() throws Exception {
        return this.disconnect(new DisconnectArgs());
    }

    public Client disconnect(DisconnectArgs disconnectArgs) throws Exception {
        this.performDisconnect(disconnectArgs);
        return this;
    }

    private void doLongPolling() throws Exception {
        this._connectionType = ConnectionType.LongPolling;
        this._streamRequestTransfer = MessageTransferFactory.getHttpMessageTransfer();
        this.activateStream(this._connectArgs, this._responseArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client endBatch() throws Exception {
        boolean flag = false;
        Object object = this._batchCounterLock;
        synchronized (object) {
            --this._batchCounter;
            if (this._batchCounter <= 0) {
                this._batchCounter = 0;
                flag = true;
            }
        }
        if (flag) {
            this.processQueue(false);
        }
        return this;
    }

    public static String generateToken() {
        String str = LongExtensions.toString((Long)DateExtensions.getTicks((Date)DateExtensions.getUtcNow()));
        return StringExtensions.substring((String)str, (int)(StringExtensions.getLength((String)str) - 12), (int)8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Record> getBoundRecords() throws Exception {
        HashMap<String, Record> dictionary = new HashMap<String, Record>();
        Object object = this._boundRecordsLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._boundRecords)) {
                HashMapExtensions.getItem(dictionary).put(str, ((Record)((Object)HashMapExtensions.getItem(this._boundRecords).get(str))).duplicate());
            }
        }
        return dictionary;
    }

    private static String getChannelForPublish(Message response, PublishArgs publishArgs) {
        if (response == null) {
            return publishArgs.__channel;
        }
        if (response.getChannel() == null) {
            return publishArgs.__channel;
        }
        return response.getChannel();
    }

    private static String getChannelForService(Message response, ServiceArgs serviceArgs) {
        if (response == null) {
            return serviceArgs.__channel;
        }
        if (response.getChannel() == null) {
            return serviceArgs.__channel;
        }
        return response.getChannel();
    }

    private static String[] getChannelsForSubscribe(Message response, SubscribeArgs subscribeArgs) {
        if (response == null) {
            return subscribeArgs.__channels;
        }
        if (response.getChannels() == null) {
            return subscribeArgs.__channels;
        }
        return response.getChannels();
    }

    private static String[] getChannelsForUnsubscribe(Message response, UnsubscribeArgs unsubscribeArgs) {
        if (response == null) {
            return unsubscribeArgs.__channels;
        }
        if (response.getChannels() == null) {
            return unsubscribeArgs.__channels;
        }
        return response.getChannels();
    }

    public Guid getClientId() {
        return this._clientId;
    }

    public SingleAction<SubscribeReceiveArgs> getCustomOnReceive(String channel) throws Exception {
        return this.getCustomOnReceiveWithTag(channel, StringExtensions.empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleAction<SubscribeReceiveArgs> getCustomOnReceiveWithTag(String channel, String tag) throws Exception {
        if (channel == null) {
            throw new Exception("channel cannot be null.");
        }
        if (tag == null) {
            tag = StringExtensions.empty;
        }
        SingleAction action = null;
        Object object = this._customOnReceivesLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._customOnReceives, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (!_var1) {
                return action;
            }
            Holder _var2 = new Holder(action);
            boolean _var3 = HashMapExtensions.tryGetValue((HashMap)dictionary, (Object)channel, (Holder)_var2);
            action = (SingleAction)_var2.getValue();
            if (!_var3) {
                action = null;
            }
        }
        return action;
    }

    private static byte[] getDataBytesForNotify(Message response, NotifyArgs notifyArgs) throws Exception {
        if (response == null) {
            return notifyArgs.__dataBytes;
        }
        if (response.getDataBytes() == null) {
            return notifyArgs.__dataBytes;
        }
        return response.getDataBytes();
    }

    private static byte[] getDataBytesForPublish(Message response, PublishArgs publishArgs) throws Exception {
        if (response == null) {
            return publishArgs.__dataBytes;
        }
        if (response.getDataBytes() == null) {
            return publishArgs.__dataBytes;
        }
        return response.getDataBytes();
    }

    private static byte[] getDataBytesForService(Message response, ServiceArgs serviceArgs) throws Exception {
        if (response == null) {
            return serviceArgs.__dataBytes;
        }
        if (response.getDataBytes() == null) {
            return serviceArgs.__dataBytes;
        }
        return response.getDataBytes();
    }

    private static String getDataJsonForNotify(Message response, NotifyArgs notifyArgs) {
        if (response == null) {
            return notifyArgs.__dataJson;
        }
        if (response.getDataJson() == null) {
            return notifyArgs.__dataJson;
        }
        return response.getDataJson();
    }

    private static String getDataJsonForPublish(Message response, PublishArgs publishArgs) {
        if (response == null) {
            return publishArgs.__dataJson;
        }
        if (response.getDataJson() == null) {
            return publishArgs.__dataJson;
        }
        return response.getDataJson();
    }

    private static String getDataJsonForService(Message response, ServiceArgs serviceArgs) {
        if (response == null) {
            return serviceArgs.__dataJson;
        }
        if (response.getDataJson() == null) {
            return serviceArgs.__dataJson;
        }
        return response.getDataJson();
    }

    public boolean getDisableWebSockets() {
        return this._disableWebSockets;
    }

    private static Extensions getExtensions(Message response, Extensible methodArgs) {
        if (response != null) {
            return response.getExtensions();
        }
        return methodArgs.getExtensions();
    }

    public Guid getInstanceId() {
        return this._instanceId;
    }

    public boolean getIsConnected() {
        return this._isConnected;
    }

    public boolean getIsConnecting() {
        return this._isConnecting;
    }

    public boolean getIsDisconnecting() {
        return this._isDisconnecting;
    }

    private static Record[] getRecordsForBind(Message response, BindArgs bindArgs) {
        if (response == null) {
            return bindArgs.__records;
        }
        if (response.getRecords() == null) {
            return bindArgs.__records;
        }
        return response.getRecords();
    }

    private static Record[] getRecordsForUnbind(Message response, UnbindArgs unbindArgs) {
        if (response == null) {
            return unbindArgs.__records;
        }
        if (response.getRecords() == null) {
            return unbindArgs.__records;
        }
        return response.getRecords();
    }

    public int getServerTimeout() {
        return this._serverTimeout;
    }

    public Guid getSessionId() {
        return this._sessionId;
    }

    public int getStreamRequestTimeout() {
        return super.getRequestTimeout() + this.getServerTimeout();
    }

    public String getStreamRequestUrl() {
        return this.__streamRequestUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubscribedChannels(String tag) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap dictionary = null;
        Object object = this._subscribedChannelsLock;
        synchronized (object) {
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._subscribedChannels, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (!_var1) {
                dictionary = null;
            }
        }
        if (dictionary != null) {
            for (String str : HashMapExtensions.getKeys((HashMap)dictionary)) {
                list.add(str);
            }
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubscribedChannels() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this._subscribedChannelsLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._subscribedChannels)) {
                for (String str2 : HashMapExtensions.getKeys((HashMap)((HashMap)HashMapExtensions.getItem(this._subscribedChannels).get(str)))) {
                    list.add(str2);
                }
            }
        }
        return list.toArray(new String[0]);
    }

    private static String getSubscribeKey(String channel, String tag) {
        if (tag == null) {
            return StringExtensions.format((String)"-1|{0}", (Object)channel);
        }
        return StringExtensions.format((String)"{0}|{1}{2}", (Object)IntegerExtensions.toString((Integer)StringExtensions.getLength((String)tag)), (Object)tag, (Object)channel);
    }

    public NullableBoolean getSynchronous() {
        return this._synchronous;
    }

    private String getThreadId() {
        return ManagedThread.currentThreadId();
    }

    private static NullableDate getTimestamp(Message response) {
        if (response != null) {
            return response.getTimestamp();
        }
        return new NullableDate(null);
    }

    public String getToken() {
        return this._token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inBatch() {
        Object object = this._batchCounterLock;
        synchronized (object) {
            return this._batchCounter > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inCallback() {
        String threadId = this.getThreadId();
        Object object = this._threadCountersLock;
        synchronized (object) {
            return this._threadCounters.containsKey((Object)threadId) && (Integer)HashMapExtensions.getItem((HashMap)this._threadCounters).get(threadId) > 0;
        }
    }

    private void maybeRaiseStateRestored() throws Exception {
        ConnectArgs connectArgs;
        if (this.decrementPendingRestoreStateCalls() == 0 && (connectArgs = this._connectArgs) != null) {
            this.raiseStateRestored(connectArgs);
        }
    }

    public Client notify(NotifyArgs notifyArgs) throws Exception {
        if (StringExtensions.isNullOrEmpty((String)notifyArgs.getDataJson())) {
            throw new Exception("dataJson cannot be null.");
        }
        this.performNotify(notifyArgs);
        return this;
    }

    private void performBind(BindArgs bindArgs) throws Exception {
        if (!bindArgs.getAutoRebind().getHasValue()) {
            bindArgs.setAutoRebind(new NullableBoolean(!this.inCallback()));
        }
        ClientBindRequestArgs args = new ClientBindRequestArgs();
        args.setMethodArgs(bindArgs);
        if (this.raiseRequestEvent(_onBindRequest, args, "OnBindRequest")) {
            boolean synchronous = this.checkSynchronous(bindArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message("/meta/bind");
            message.setValidate(false);
            message.setRecords(bindArgs.getRecords());
            message.setExtensions(bindArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performBindCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)bindArgs);
            this.addToQueue(request, bindArgs.getRequestUrl(), synchronous, bindArgs.getRequestTimeout().getHasValue() ? bindArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBindCallback(ClientResponseArgs responseArgs) throws Exception {
        BindArgs dynamicValue = (BindArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientBindResponseArgs args = new ClientBindResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onBindResponse, args, "OnBindResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raiseBindFailure(dynamicValue, responseArgs, false);
            this.raiseBindComplete(dynamicValue, responseArgs);
            ClientBindEndArgs args2 = new ClientBindEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onBindEnd, args2, "OnBindEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.bind(dynamicValue);
            } else if (dynamicValue.getIsRebind()) {
                this.maybeRaiseStateRestored();
            }
        } else {
            if (dynamicValue.getAutoRebind().hasValue() && dynamicValue.getAutoRebind().getValue()) {
                Object flag = this._reconnectCacheLock;
                synchronized (flag) {
                    this._reconnectCache.add(dynamicValue);
                    for (Record record : responseArgs.getResponse().getRecords()) {
                        HashMapExtensions.getItem(this._rebindCache).put(record.getKey(), dynamicValue);
                    }
                }
            }
            this.addBoundRecords(responseArgs.getResponse().getRecords());
            this.raiseBindSuccess(dynamicValue, responseArgs);
            this.raiseBindComplete(dynamicValue, responseArgs);
            ClientBindEndArgs args3 = new ClientBindEndArgs();
            args3.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onBindEnd, args3, "OnBindEnd", responseArgs);
            if (dynamicValue.getIsRebind()) {
                this.maybeRaiseStateRestored();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConnect(ConnectArgs connectArgs) throws Exception {
        ClientConnectRequestArgs args5 = new ClientConnectRequestArgs();
        args5.setMethodArgs(connectArgs);
        if (this.raiseRequestEvent(_onConnectRequest, args5, "OnConnectRequest")) {
            Object object = this._stateLock;
            synchronized (object) {
                if (this._disconnectCalled && (connectArgs.getIsRetry() || connectArgs.getIsReconnect())) {
                    return;
                }
                this._disconnectCalled = false;
                if (this.getIsConnecting() || this.getIsConnected()) {
                    String str = this.getIsConnecting() ? "Client is already connecting." : "Client is already connected.";
                    ClientResponseArgs args2 = new ClientResponseArgs();
                    args2.setDynamicProperties(connectArgs.getDynamicProperties());
                    Message message = new Message("/meta/handshake");
                    message.setExtensions(connectArgs.getExtensions());
                    message.setTimestamp(new NullableDate(DateExtensions.getUtcNow()));
                    message.setSuccessful(false);
                    message.setError(str);
                    args2.setResponse(message);
                    args2.setException(new Exception(str));
                    ClientResponseArgs responseArgs = args2;
                    ClientConnectResponseArgs args = new ClientConnectResponseArgs();
                    args.setMethodArgs(connectArgs);
                    this.raiseResponseEvent(_onConnectResponse, args, "OnConnectResponse", responseArgs);
                    this.raiseConnectFailure(connectArgs, responseArgs, false);
                    this.raiseConnectComplete(connectArgs, responseArgs);
                    ClientConnectEndArgs args4 = new ClientConnectEndArgs();
                    args4.setMethodArgs(connectArgs);
                    this.raiseCompleteEvent(_onConnectEnd, args4, "OnConnectEnd", responseArgs);
                    return;
                }
                this.setIsConnecting(true);
            }
            this._connectArgs = connectArgs;
            ArrayList<ConnectionType> list = new ArrayList<ConnectionType>();
            if (!this.getDisableWebSockets()) {
                list.add(ConnectionType.WebSocket);
            }
            list.add(ConnectionType.LongPolling);
            this._supportedConnectionTypes = list.toArray(new ConnectionType[0]);
            boolean synchronous = this.checkSynchronous(connectArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message2 = new Message("/meta/handshake");
            message2.setVersion(_bayeuxVersion);
            message2.setMinimumVersion(_bayeuxMinimumVersion);
            message2.setSupportedConnectionTypes(this._supportedConnectionTypes);
            message2.setExtensions(connectArgs.getExtensions());
            request2.setMessage(message2);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performConnectCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            if (connectArgs.getLastClientId().getHasValue() && connectArgs.getLastSessionId().getHasValue()) {
                request.getMessage().setLastClientId(connectArgs.getLastClientId());
                request.getMessage().setLastSessionId(connectArgs.getLastSessionId());
            }
            request.setDynamicValue(_argsKey, (Object)connectArgs);
            this.send(request, connectArgs.getRequestUrl(), synchronous, connectArgs.getRequestTimeout().getHasValue() ? connectArgs.getRequestTimeout().getValue() : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConnectCallback(ClientResponseArgs responseArgs) throws Exception {
        ArrayList list;
        Object serverTimeout;
        ConnectArgs dynamicValue = (ConnectArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientConnectResponseArgs args = new ClientConnectResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onConnectResponse, args, "OnConnectResponse", responseArgs);
        if (responseArgs.getException() == null) {
            this.setClientId(responseArgs.getResponse().getClientId().getValue());
            NullableGuid sessionId = responseArgs.getResponse().getSessionId();
            if (sessionId.getHasValue()) {
                this.setSessionId(sessionId.getValue());
            }
            if ((serverTimeout = responseArgs.getResponse().getServerTimeout()).getHasValue()) {
                this.setServerTimeout(serverTimeout.getValue());
            } else {
                this.setServerTimeout(25000);
            }
            int index = Integer.MAX_VALUE;
            block9: for (ConnectionType type : responseArgs.getResponse().getSupportedConnectionTypes()) {
                for (int i = 0; i < ArrayExtensions.getLength((Object[])this._supportedConnectionTypes); ++i) {
                    if (!Global.equals((Object)((Object)this._supportedConnectionTypes[i]), (Object)((Object)type))) continue;
                    if (i >= index) continue block9;
                    index = i;
                    continue block9;
                }
            }
            if (index < 0 || index > ArrayExtensions.getLength((Object[])this._supportedConnectionTypes)) {
                responseArgs.setException(new Exception("Could not negotiate a connection type with the server."));
            } else {
                this._connectionType = this._supportedConnectionTypes[index];
            }
        }
        if (responseArgs.getException() == null) {
            this._lastBackoffIndex = -1;
            this._lastBackoffTimeout = 0;
            list = new ArrayList();
            Object obj2 = this._reconnectCacheLock;
            serverTimeout = obj2;
            synchronized (serverTimeout) {
                ArrayListExtensions.addRange(list, this._reconnectCache);
                this._reconnectCache.clear();
                this._rebindCache.clear();
                this._resubscribeCache.clear();
            }
            this._pendingRestoreStateCalls = ArrayListExtensions.getCount(list);
            for (Extensible extensible : list) {
                BindArgs bindArgs = (BindArgs)((Object)Global.tryCast((Object)((Object)extensible), BindArgs.class));
                if (bindArgs != null) {
                    bindArgs.setIsRetry(false);
                    bindArgs.setIsRebind(true);
                    this.bind(bindArgs);
                    continue;
                }
                SubscribeArgs subscribeArgs = (SubscribeArgs)((Object)Global.tryCast((Object)((Object)extensible), SubscribeArgs.class));
                if (subscribeArgs == null) continue;
                subscribeArgs.setIsRetry(false);
                subscribeArgs.setIsResubscribe(true);
                this.subscribe(subscribeArgs);
            }
            Object i$ = obj2 = this._stateLock;
            synchronized (i$) {
                this.setIsConnecting(false);
                this.setIsConnected(true);
                if (this._disconnectCalled) {
                    this.disconnect();
                    if (!dynamicValue.getIsRetry() && !dynamicValue.getIsReconnect()) {
                        String str = "Client was disconnected while connecting.";
                        ClientResponseArgs args6 = new ClientResponseArgs();
                        args6.setDynamicProperties(dynamicValue.getDynamicProperties());
                        Message message = new Message("/meta/handshake");
                        message.setExtensions(dynamicValue.getExtensions());
                        message.setTimestamp(new NullableDate(DateExtensions.getUtcNow()));
                        message.setSuccessful(false);
                        message.setError(str);
                        args6.setResponse(message);
                        args6.setException(new Exception(str));
                        responseArgs = args6;
                        ClientConnectResponseArgs args7 = new ClientConnectResponseArgs();
                        args7.setMethodArgs(dynamicValue);
                        this.raiseResponseEvent(_onConnectResponse, args7, "OnConnectResponse", responseArgs);
                        this.raiseConnectFailure(dynamicValue, responseArgs, false);
                        this.raiseConnectComplete(dynamicValue, responseArgs);
                        ClientConnectEndArgs args8 = new ClientConnectEndArgs();
                        args8.setMethodArgs(dynamicValue);
                        this.raiseCompleteEvent(_onConnectEnd, args8, "OnConnectEnd", responseArgs);
                    }
                    return;
                }
            }
            this._responseArgs = responseArgs;
            if (Global.equals((Object)((Object)this._connectionType), (Object)((Object)ConnectionType.WebSocket)) && !this.getDisableWebSockets()) {
                if (!this.tryWebSocket()) {
                    this.doLongPolling();
                }
            } else {
                this.doLongPolling();
            }
        } else {
            ArrayList obj2;
            list = obj2 = this._stateLock;
            synchronized (list) {
                this.setIsConnecting(false);
                if (this._disconnectCalled && (dynamicValue.getIsRetry() || dynamicValue.getIsReconnect())) {
                    return;
                }
            }
            boolean retry = false;
            ConnectRetryMode _var0 = dynamicValue.getRetryMode();
            if (_var0 == ConnectRetryMode.Aggressive) {
                retry = true;
            } else if (_var0 == ConnectRetryMode.Intelligent) {
                retry = responseArgs.getErrorCode() < 800 || responseArgs.getErrorCode() > 899;
            }
            retry = this.raiseConnectFailure(dynamicValue, responseArgs, retry);
            this.raiseConnectComplete(dynamicValue, responseArgs);
            ClientConnectEndArgs args3 = new ClientConnectEndArgs();
            args3.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onConnectEnd, args3, "OnConnectEnd", responseArgs);
            if (retry) {
                int timeout = 0;
                if (dynamicValue.getRetryBackoff() != null) {
                    BackoffArgs args2 = new BackoffArgs();
                    args2.setIndex(this._lastBackoffIndex + 1);
                    args2.setLastTimeout(this._lastBackoffTimeout);
                    timeout = dynamicValue.getRetryBackoff().invoke(args2);
                }
                if (timeout > 0) {
                    DeferredRetryConnectState state = new DeferredRetryConnectState();
                    state.setConnectArgs(dynamicValue);
                    state.setBackoffTimeout(timeout);
                    final Client _var1 = this;
                    Deferrer.defer((SingleAction)new SingleAction<Object>(){

                        public void invoke(Object s) {
                            try {
                                _var1.retryConnectDeferred(s);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }, (int)timeout, (Object)state);
                } else {
                    this.retryConnect(dynamicValue, timeout);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDisconnect(DisconnectArgs disconnectArgs) throws Exception {
        ClientDisconnectRequestArgs args8 = new ClientDisconnectRequestArgs();
        args8.setMethodArgs(disconnectArgs);
        if (this.raiseRequestEvent(_onDisconnectRequest, args8, "OnDisconnectRequest")) {
            Object object = this._stateLock;
            synchronized (object) {
                this._disconnectCalled = true;
                if (!this.getIsConnected() || this.getIsConnecting()) {
                    ClientResponseArgs args2 = new ClientResponseArgs();
                    args2.setDynamicProperties(disconnectArgs.getDynamicProperties());
                    Message message = new Message("/meta/handshake");
                    message.setExtensions(disconnectArgs.getExtensions());
                    message.setTimestamp(new NullableDate(DateExtensions.getUtcNow()));
                    message.setSuccessful(true);
                    args2.setResponse(message);
                    ClientResponseArgs args = args2;
                    ClientDisconnectResponseArgs args3 = new ClientDisconnectResponseArgs();
                    args3.setMethodArgs(disconnectArgs);
                    this.raiseResponseEvent(_onDisconnectResponse, args3, "OnDisconnectResponse", args);
                    this.raiseDisconnectComplete(disconnectArgs, args);
                    ClientDisconnectEndArgs args4 = new ClientDisconnectEndArgs();
                    args4.setMethodArgs(disconnectArgs);
                    this.raiseCompleteEvent(_onDisconnectEnd, args4, "OnDisconnectEnd", args);
                    return;
                }
                if (this.getIsDisconnecting()) {
                    String str = "Client is already disconnecting.";
                    ClientResponseArgs args5 = new ClientResponseArgs();
                    args5.setDynamicProperties(disconnectArgs.getDynamicProperties());
                    Message message2 = new Message("/meta/handshake");
                    message2.setExtensions(disconnectArgs.getExtensions());
                    message2.setTimestamp(new NullableDate(DateExtensions.getUtcNow()));
                    message2.setSuccessful(false);
                    message2.setError(str);
                    args5.setResponse(message2);
                    args5.setException(new Exception(str));
                    ClientResponseArgs args = args5;
                    ClientDisconnectResponseArgs args6 = new ClientDisconnectResponseArgs();
                    args6.setMethodArgs(disconnectArgs);
                    this.raiseResponseEvent(_onDisconnectResponse, args6, "OnDisconnectResponse", args);
                    this.raiseDisconnectComplete(disconnectArgs, args);
                    ClientDisconnectEndArgs args7 = new ClientDisconnectEndArgs();
                    args7.setMethodArgs(disconnectArgs);
                    this.raiseCompleteEvent(_onDisconnectEnd, args7, "OnDisconnectEnd", args);
                    return;
                }
                this.setIsDisconnecting(true);
            }
            boolean synchronous = this.checkSynchronous(disconnectArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message3 = new Message("/meta/disconnect");
            message3.setExtensions(disconnectArgs.getExtensions());
            request2.setMessage(message3);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performDisconnectCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)disconnectArgs);
            this.addToQueue(request, disconnectArgs.getRequestUrl(), synchronous, disconnectArgs.getRequestTimeout().getHasValue() ? disconnectArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDisconnectCallback(ClientResponseArgs responseArgs) throws Exception {
        Object obj2;
        DisconnectArgs dynamicValue = (DisconnectArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientDisconnectResponseArgs args = new ClientDisconnectResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onDisconnectResponse, args, "OnDisconnectResponse", responseArgs);
        this.raiseForcedUnsubscribes(dynamicValue, responseArgs);
        this.raiseForcedUnbinds(dynamicValue, responseArgs);
        Object object = obj2 = this._stateLock;
        synchronized (object) {
            this.clearBoundRecords();
            this.clearSubscribedChannels();
            this.setIsDisconnecting(false);
            this.setIsConnected(false);
            this._webSocketOpened = false;
        }
        try {
            if (this._requestTransfer != null) {
                this._requestTransfer.shutdown();
            }
            if (this._streamRequestTransfer != null) {
                this._streamRequestTransfer.shutdown();
            }
        }
        catch (Exception exception1) {
            // empty catch block
        }
        this.raiseDisconnectComplete(dynamicValue, responseArgs);
        Object exception1 = obj2 = this._queueLock;
        synchronized (exception1) {
            this._queueActivated = false;
        }
        ClientDisconnectEndArgs args3 = new ClientDisconnectEndArgs();
        args3.setMethodArgs(dynamicValue);
        this.raiseCompleteEvent(_onDisconnectEnd, args3, "OnDisconnectEnd", responseArgs);
    }

    private void performNotify(NotifyArgs notifyArgs) throws Exception {
        ClientNotifyRequestArgs args = new ClientNotifyRequestArgs();
        args.setMethodArgs(notifyArgs);
        if (this.raiseRequestEvent(_onNotifyRequest, args, "OnNotifyRequest")) {
            boolean synchronous = this.checkSynchronous(notifyArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message("/meta/notify");
            message.setValidate(false);
            message.setDataJson(notifyArgs.getDataJson());
            message.setExtensions(notifyArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performNotifyCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)notifyArgs);
            this.addToQueue(request, notifyArgs.getRequestUrl(), synchronous, notifyArgs.getRequestTimeout().getHasValue() ? notifyArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    private void performNotifyCallback(ClientResponseArgs responseArgs) throws Exception {
        NotifyArgs dynamicValue = (NotifyArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientNotifyResponseArgs args = new ClientNotifyResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onNotifyResponse, args, "OnNotifyResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raiseNotifyFailure(dynamicValue, responseArgs, false);
            this.raiseNotifyComplete(dynamicValue, responseArgs);
            ClientNotifyEndArgs args2 = new ClientNotifyEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onNotifyEnd, args2, "OnNotifyEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.notify(dynamicValue);
            }
        } else {
            this.raiseNotifySuccess(dynamicValue, responseArgs);
            this.raiseNotifyComplete(dynamicValue, responseArgs);
            ClientNotifyEndArgs args3 = new ClientNotifyEndArgs();
            args3.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onNotifyEnd, args3, "OnNotifyEnd", responseArgs);
        }
    }

    private void performPublish(PublishArgs publishArgs) throws Exception {
        ClientPublishRequestArgs args = new ClientPublishRequestArgs();
        args.setMethodArgs(publishArgs);
        if (this.raiseRequestEvent(_onPublishRequest, args, "OnPublishRequest")) {
            boolean synchronous = this.checkSynchronous(publishArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message(publishArgs.getChannel());
            message.setValidate(false);
            message.setDataJson(publishArgs.getDataJson());
            message.setExtensions(publishArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performPublishCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)publishArgs);
            this.addToQueue(request, publishArgs.getRequestUrl(), synchronous, publishArgs.getRequestTimeout().getHasValue() ? publishArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    private void performPublishCallback(ClientResponseArgs responseArgs) throws Exception {
        PublishArgs dynamicValue = (PublishArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientPublishResponseArgs args = new ClientPublishResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onPublishResponse, args, "OnPublishResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raisePublishFailure(dynamicValue, responseArgs, false);
            this.raisePublishComplete(dynamicValue, responseArgs);
            ClientPublishEndArgs args2 = new ClientPublishEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onPublishEnd, args2, "OnPublishEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.publish(dynamicValue);
            }
        } else {
            this.raisePublishSuccess(dynamicValue, responseArgs);
            this.raisePublishComplete(dynamicValue, responseArgs);
            ClientPublishEndArgs args3 = new ClientPublishEndArgs();
            args3.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onPublishEnd, args3, "OnPublishEnd", responseArgs);
        }
    }

    private void performService(ServiceArgs serviceArgs) throws Exception {
        ClientServiceRequestArgs args = new ClientServiceRequestArgs();
        args.setMethodArgs(serviceArgs);
        if (this.raiseRequestEvent(_onServiceRequest, args, "OnServiceRequest")) {
            boolean synchronous = this.checkSynchronous(serviceArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message(MetaChannels.convertChannelToServiced(serviceArgs.getChannel()));
            message.setValidate(false);
            message.setDataJson(serviceArgs.getDataJson());
            message.setExtensions(serviceArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performServiceCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)serviceArgs);
            this.addToQueue(request, serviceArgs.getRequestUrl(), synchronous, serviceArgs.getRequestTimeout().getHasValue() ? serviceArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    private void performServiceCallback(ClientResponseArgs responseArgs) throws Exception {
        ServiceArgs dynamicValue = (ServiceArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientServiceResponseArgs args = new ClientServiceResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onServiceResponse, args, "OnServiceResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raiseServiceFailure(dynamicValue, responseArgs, false);
            this.raiseServiceComplete(dynamicValue, responseArgs);
            ClientServiceEndArgs args2 = new ClientServiceEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onServiceEnd, args2, "OnServiceEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.service(dynamicValue);
            }
        } else {
            this.raiseServiceSuccess(dynamicValue, responseArgs);
            this.raiseServiceComplete(dynamicValue, responseArgs);
            ClientServiceEndArgs args3 = new ClientServiceEndArgs();
            args3.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onServiceEnd, args3, "OnServiceEnd", responseArgs);
        }
    }

    private void performSubscribe(SubscribeArgs subscribeArgs) throws Exception {
        if (!subscribeArgs.getAutoResubscribe().getHasValue()) {
            subscribeArgs.setAutoResubscribe(new NullableBoolean(!this.inCallback()));
        }
        ClientSubscribeRequestArgs args = new ClientSubscribeRequestArgs();
        args.setMethodArgs(subscribeArgs);
        if (this.raiseRequestEvent(_onSubscribeRequest, args, "OnSubscribeRequest")) {
            boolean synchronous = this.checkSynchronous(subscribeArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message("/meta/subscribe");
            message.setValidate(false);
            message.setChannels(subscribeArgs.getChannels());
            message.setExtensions(subscribeArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performSubscribeCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)subscribeArgs);
            this.addToQueue(request, subscribeArgs.getRequestUrl(), synchronous, subscribeArgs.getRequestTimeout().getHasValue() ? subscribeArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSubscribeCallback(ClientResponseArgs responseArgs) throws Exception {
        SubscribeArgs dynamicValue = (SubscribeArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientSubscribeResponseArgs args = new ClientSubscribeResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onSubscribeResponse, args, "OnSubscribeResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raiseSubscribeFailure(dynamicValue, responseArgs, false);
            this.raiseSubscribeComplete(dynamicValue, responseArgs);
            ClientSubscribeEndArgs args2 = new ClientSubscribeEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onSubscribeEnd, args2, "OnSubscribeEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.subscribe(dynamicValue);
            } else if (dynamicValue.getIsResubscribe()) {
                this.maybeRaiseStateRestored();
            }
        } else {
            Object args2;
            Object obj2;
            if (dynamicValue.getAutoResubscribe().hasValue() && dynamicValue.getAutoResubscribe().getValue()) {
                args2 = obj2 = this._reconnectCacheLock;
                synchronized (args2) {
                    this._reconnectCache.add(dynamicValue);
                    for (String str : responseArgs.getResponse().getChannels()) {
                        HashMapExtensions.getItem(this._resubscribeCache).put(Client.getSubscribeKey(str, dynamicValue.getTag()), dynamicValue);
                    }
                }
            }
            args2 = obj2 = this._subscribedOnReceivesLock;
            synchronized (args2) {
                for (String str : responseArgs.getResponse().getChannels()) {
                    HashMapExtensions.getItem(this._subscribedDynamicProperties).put(Client.getSubscribeKey(str, dynamicValue.getTag()), dynamicValue.getDynamicProperties());
                }
            }
            this.addSubscribedChannels(responseArgs.getResponse().getTag(), responseArgs.getResponse().getChannels());
            this.raiseSubscribeSuccess(dynamicValue, responseArgs);
            this.raiseSubscribeComplete(dynamicValue, responseArgs);
            this.addSubscribedOnReceive(responseArgs.getResponse().getTag(), responseArgs.getResponse().getChannels(), dynamicValue.getOnReceive(), dynamicValue.getDynamicProperties(), this._lastInterval);
            ClientSubscribeEndArgs args3 = new ClientSubscribeEndArgs();
            args3.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onSubscribeEnd, args3, "OnSubscribeEnd", responseArgs);
            if (dynamicValue.getIsResubscribe()) {
                this.maybeRaiseStateRestored();
            }
        }
    }

    private void performUnbind(UnbindArgs unbindArgs) throws Exception {
        ClientUnbindRequestArgs args = new ClientUnbindRequestArgs();
        args.setMethodArgs(unbindArgs);
        if (this.raiseRequestEvent(_onUnbindRequest, args, "OnUnbindRequest")) {
            boolean synchronous = this.checkSynchronous(unbindArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message("/meta/unbind");
            message.setValidate(false);
            message.setRecords(unbindArgs.getRecords());
            message.setExtensions(unbindArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performUnbindCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)unbindArgs);
            this.addToQueue(request, unbindArgs.getRequestUrl(), synchronous, unbindArgs.getRequestTimeout().getHasValue() ? unbindArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUnbindCallback(ClientResponseArgs responseArgs) throws Exception {
        UnbindArgs dynamicValue = (UnbindArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientUnbindResponseArgs args = new ClientUnbindResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onUnbindResponse, args, "OnUnbindResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raiseUnbindFailure(dynamicValue, responseArgs, false);
            this.raiseUnbindComplete(dynamicValue, responseArgs, false);
            ClientUnbindEndArgs args2 = new ClientUnbindEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onUnbindEnd, args2, "OnUnbindEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.unbind(dynamicValue);
            }
        } else {
            Object flag = this._reconnectCacheLock;
            synchronized (flag) {
                for (Record record : responseArgs.getResponse().getRecords()) {
                    BindArgs args3 = null;
                    Holder _var0 = new Holder(args3);
                    boolean _var1 = HashMapExtensions.tryGetValue(this._rebindCache, (Object)record.getKey(), (Holder)_var0);
                    args3 = (BindArgs)((Object)_var0.getValue());
                    if (!_var1) {
                        args3 = null;
                    }
                    if (args3 == null) continue;
                    ArrayList list = ArrayListExtensions.createArray((Object[])args3.getRecords());
                    for (int i = 0; i < ArrayListExtensions.getCount((ArrayList)list); ++i) {
                        if (!Global.equals((Object)((Record)((Object)ArrayListExtensions.getItem((ArrayList)list).get(i))).getKey(), (Object)record.getKey())) continue;
                        ArrayListExtensions.removeAt((ArrayList)list, (int)i);
                        --i;
                    }
                    args3.setRecords(list.toArray(new Record[0]));
                    HashMapExtensions.remove(this._rebindCache, (Object)record.getKey());
                    if (this._rebindCache.containsValue((Object)args3)) continue;
                    this._reconnectCache.remove((Object)args3);
                }
            }
            this.removeBoundRecords(responseArgs.getResponse().getRecords());
            this.raiseUnbindSuccess(dynamicValue, responseArgs, false);
            this.raiseUnbindComplete(dynamicValue, responseArgs, false);
            ClientUnbindEndArgs args4 = new ClientUnbindEndArgs();
            args4.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onUnbindEnd, args4, "OnUnbindEnd", responseArgs);
        }
    }

    private void performUnsubscribe(UnsubscribeArgs unsubscribeArgs) throws Exception {
        ClientUnsubscribeRequestArgs args = new ClientUnsubscribeRequestArgs();
        args.setMethodArgs(unsubscribeArgs);
        if (this.raiseRequestEvent(_onUnsubscribeRequest, args, "OnUnsubscribeRequest")) {
            boolean synchronous = this.checkSynchronous(unsubscribeArgs.getSynchronous());
            ClientRequest request2 = new ClientRequest();
            Message message = new Message("/meta/unsubscribe");
            message.setValidate(false);
            message.setChannels(unsubscribeArgs.getChannels());
            message.setExtensions(unsubscribeArgs.getExtensions());
            request2.setMessage(message);
            final Client _var0 = this;
            request2.setCallback(new SingleAction<ClientResponseArgs>(){

                public void invoke(ClientResponseArgs responseArgs) {
                    try {
                        _var0.performUnsubscribeCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ClientRequest request = request2;
            request.setDynamicValue(_argsKey, (Object)unsubscribeArgs);
            this.addToQueue(request, unsubscribeArgs.getRequestUrl(), synchronous, unsubscribeArgs.getRequestTimeout().getHasValue() ? unsubscribeArgs.getRequestTimeout().getValue() : 0);
            this.processQueue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUnsubscribeCallback(ClientResponseArgs responseArgs) throws Exception {
        UnsubscribeArgs dynamicValue = (UnsubscribeArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        ClientUnsubscribeResponseArgs args = new ClientUnsubscribeResponseArgs();
        args.setMethodArgs(dynamicValue);
        this.raiseResponseEvent(_onUnsubscribeResponse, args, "OnUnsubscribeResponse", responseArgs);
        if (responseArgs.getException() != null) {
            boolean flag = this.raiseUnsubscribeFailure(dynamicValue, responseArgs, false);
            this.raiseUnsubscribeComplete(dynamicValue, responseArgs, false);
            ClientUnsubscribeEndArgs args2 = new ClientUnsubscribeEndArgs();
            args2.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onUnsubscribeEnd, args2, "OnUnsubscribeEnd", responseArgs);
            if (flag) {
                dynamicValue.setIsRetry(true);
                this.unsubscribe(dynamicValue);
            }
        } else {
            Object flag = this._reconnectCacheLock;
            synchronized (flag) {
                for (String str : responseArgs.getResponse().getChannels()) {
                    SubscribeArgs args3 = null;
                    String subscribeKey = Client.getSubscribeKey(str, dynamicValue.getTag());
                    Holder _var0 = new Holder(args3);
                    boolean _var1 = HashMapExtensions.tryGetValue(this._resubscribeCache, (Object)subscribeKey, (Holder)_var0);
                    args3 = (SubscribeArgs)((Object)_var0.getValue());
                    if (!_var1) {
                        args3 = null;
                    }
                    if (args3 == null) continue;
                    ArrayList list = ArrayListExtensions.createArray((Object[])args3.getChannels());
                    list.remove(str);
                    args3.setChannels(list.toArray(new String[0]));
                    HashMapExtensions.remove(this._resubscribeCache, (Object)subscribeKey);
                    if (this._resubscribeCache.containsValue((Object)args3)) continue;
                    this._reconnectCache.remove((Object)args3);
                }
            }
            this.removeSubscribedChannels(responseArgs.getResponse().getTag(), responseArgs.getResponse().getChannels());
            this.removeSubscribedOnReceive(responseArgs.getResponse().getTag(), responseArgs.getResponse().getChannels());
            this.raiseUnsubscribeSuccess(dynamicValue, responseArgs, false);
            this.raiseUnsubscribeComplete(dynamicValue, responseArgs, false);
            ClientUnsubscribeEndArgs args4 = new ClientUnsubscribeEndArgs();
            args4.setMethodArgs(dynamicValue);
            this.raiseCompleteEvent(_onUnsubscribeEnd, args4, "OnUnsubscribeEnd", responseArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRaise(String threadId) {
        Object obj2;
        if (Global.equals((Object)((Object)super.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.Low))) {
            Object obj22;
            Object object = obj22 = this._threadCountersLock;
            synchronized (object) {
                int num = (Integer)HashMapExtensions.getItem((HashMap)this._threadCounters).get(threadId);
                if (num == 1) {
                    HashMapExtensions.remove((HashMap)this._threadCounters, (Object)threadId);
                } else {
                    HashMapExtensions.getItem((HashMap)this._threadCounters).put(threadId, num - 1);
                }
            }
        }
        Object object = obj2 = this._threadCountersLock;
        synchronized (object) {
            int num = (Integer)HashMapExtensions.getItem((HashMap)this._threadCounters).get(threadId);
            HashMapExtensions.getItem((HashMap)this._threadCounters).put(threadId, num - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preRaise(String threadId) {
        Object object = this._threadCountersLock;
        synchronized (object) {
            int num = 0;
            if (this._threadCounters.containsKey((Object)threadId)) {
                num = (Integer)HashMapExtensions.getItem((HashMap)this._threadCounters).get(threadId);
            }
            HashMapExtensions.getItem((HashMap)this._threadCounters).put(threadId, num + 1);
        }
    }

    private void processAdvice(BaseAdvice advice) {
        if (advice.getInterval().getHasValue()) {
            this._lastInterval = advice.getInterval().getValue();
        }
        if (advice.getReconnect().getHasValue()) {
            this._lastReconnect = advice.getReconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processPendingReceives(String[] channels, int reconnectAfter) throws Exception {
        Object object = this._subscribedOnReceivesLock;
        synchronized (object) {
            for (String str : channels) {
                ArrayList list = null;
                Holder _var0 = new Holder(list);
                boolean _var1 = HashMapExtensions.tryGetValue(this._pendingReceives, (Object)str, (Holder)_var0);
                list = (ArrayList)_var0.getValue();
                if (_var1) {
                    HashMapExtensions.remove(this._pendingReceives, (Object)str);
                }
                if (list == null) continue;
                for (Message message : list) {
                    reconnectAfter = this.receiveMessage(message, reconnectAfter);
                }
            }
        }
        return reconnectAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue(boolean activate) throws Exception {
        Object object = this._queueLock;
        synchronized (object) {
            if (activate) {
                this._queueActivated = true;
            }
            if (this._queueActivated && !this.inBatch()) {
                HashMap<String, ArrayList<ClientRequest>> requestQueue = this._requestQueue;
                this._requestQueue = new HashMap();
                for (String str : HashMapExtensions.getKeys(requestQueue)) {
                    int index = StringExtensions.indexOf((String)str, (String)"|");
                    String s = StringExtensions.substring((String)str, (int)0, (int)index);
                    String str3 = str.substring(index + 1);
                    int timeout = ParseAssistant.parseIntegerValue((String)s);
                    boolean synchronous = Global.equals((Object)StringExtensions.substring((String)str3, (int)0, (int)1), (Object)"1");
                    String url = str3.substring(1);
                    ClientRequest[] requests = ((ArrayList)HashMapExtensions.getItem(requestQueue).get(str)).toArray(new ClientRequest[0]);
                    this.sendMany(requests, url, synchronous, timeout);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processRequestUrl(String requestUrl) {
        HashMap<String, String> hashMap;
        if (StringExtensions.isNullOrEmpty((String)requestUrl)) {
            requestUrl = super.getRequestUrl();
        }
        boolean flag = false;
        String str = null;
        if (Global.equals((Object)((Object)super.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.High))) {
            hashMap = _requestUrlCacheLock;
            synchronized (hashMap) {
                Holder _var0 = new Holder((Object)str);
                boolean _var1 = HashMapExtensions.tryGetValue(_requestUrlCache, (Object)requestUrl, (Holder)_var0);
                str = (String)_var0.getValue();
                flag = _var1;
            }
        }
        if (!flag) {
            str = requestUrl;
            str = HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)str, (String)"token", (String)this.getToken()), (String)"src", (String)HttpWebRequestTransfer.getPlatformCode()), (String)"AspxAutoDetectCookieSupport", (String)"1");
            if (!Global.equals((Object)((Object)super.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.High))) {
                return str;
            }
            hashMap = _requestUrlCache;
            synchronized (hashMap) {
                HashMapExtensions.getItem(_requestUrlCache).put(requestUrl, str);
            }
        }
        return str;
    }

    private int processServerAction(Message serverAction, int reconnectAfter) throws Exception {
        if (Global.equals((Object)serverAction.getBayeuxChannel(), (Object)"/meta/bind")) {
            this.addBoundRecords(serverAction.getRecords());
            this.raiseServerBind(serverAction);
            return reconnectAfter;
        }
        if (Global.equals((Object)serverAction.getBayeuxChannel(), (Object)"/meta/unbind")) {
            this.removeBoundRecords(serverAction.getRecords());
            this.raiseServerUnbind(serverAction);
            return reconnectAfter;
        }
        if (Global.equals((Object)serverAction.getBayeuxChannel(), (Object)"/meta/subscribe")) {
            this.addSubscribedChannels(serverAction.getTag(), serverAction.getChannels());
            SingleAction<SubscribeReceiveArgs> onReceive = this.raiseServerSubscribe(serverAction);
            if (onReceive == null) {
                throw new Exception(StringExtensions.format((String)"The server subscribed the client to [{0}], but the client did not supply a callback to handle received messages. A callback must be specified in the client's OnServerSubscribe event.", (Object)StringExtensions.join((String)", ", (String[])serverAction.getChannels())));
            }
            reconnectAfter = this.addSubscribedOnReceive(serverAction.getTag(), serverAction.getChannels(), onReceive, serverAction.getDynamicProperties(), reconnectAfter);
            return reconnectAfter;
        }
        if (Global.equals((Object)serverAction.getBayeuxChannel(), (Object)"/meta/unsubscribe")) {
            this.removeSubscribedChannels(serverAction.getTag(), serverAction.getChannels());
            this.raiseServerUnsubscribe(serverAction);
            this.removeSubscribedOnReceive(serverAction.getTag(), serverAction.getChannels());
        }
        return reconnectAfter;
    }

    public Client publish(PublishArgs publishArgs) throws Exception {
        if (StringExtensions.isNullOrEmpty((String)publishArgs.getChannel())) {
            throw new Exception("channel cannot be null.");
        }
        if (StringExtensions.isNullOrEmpty((String)publishArgs.getDataJson())) {
            throw new Exception("dataJson cannot be null.");
        }
        this.performPublish(publishArgs);
        return this;
    }

    private <T> void raiseAction(SingleAction<T> callback, T args, String source) throws Exception {
        this.raiseActionManual(callback, args, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void raiseActionManual(SingleAction<T> callback, T args, String source, boolean manualThreadManagement) throws Exception {
        block10: {
            if (manualThreadManagement) {
                try {
                    callback.invoke(args);
                }
                catch (Exception exception1) {
                    Exception exception = exception1;
                    if (!super.raiseUnhandledException(exception)) {
                        AsyncException.asyncThrow((Exception)exception, (String)source);
                    }
                    break block10;
                }
            }
            String threadId = this.getThreadId();
            this.preRaise(threadId);
            try {
                callback.invoke(args);
            }
            catch (Exception exception2) {
                Exception exception = exception2;
                if (!super.raiseUnhandledException(exception)) {
                    AsyncException.asyncThrow((Exception)exception, (String)source);
                }
            }
            finally {
                this.postRaise(threadId);
            }
        }
    }

    private void raiseBindComplete(BindArgs bindArgs, ClientResponseArgs responseArgs) throws Exception {
        BindCompleteArgs args2 = new BindCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), bindArgs));
        args2.setIsRebind(bindArgs.getIsRebind());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(bindArgs.getDynamicProperties());
        BindCompleteArgs args = args2;
        SingleAction<BindCompleteArgs> onBindComplete = this._onBindComplete;
        if (onBindComplete != null) {
            this.raiseAction(onBindComplete, args, "Client -> OnBindComplete");
        }
        if (bindArgs.getOnComplete() != null) {
            this.raiseAction(bindArgs.getOnComplete(), args, "Client -> Bind -> OnComplete");
        }
    }

    private boolean raiseBindFailure(BindArgs bindArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        BindFailureArgs args2 = new BindFailureArgs();
        args2.__records = Client.getRecordsForBind(responseArgs.getResponse(), bindArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), bindArgs));
        args2.setIsRebind(bindArgs.getIsRebind());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(bindArgs.getDynamicProperties());
        BindFailureArgs args = args2;
        SingleAction<BindFailureArgs> onBindFailure = this._onBindFailure;
        if (onBindFailure != null) {
            this.raiseAction(onBindFailure, args, "Client -> OnBindFailure");
        }
        if (bindArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(bindArgs.getOnFailure(), retry, args, "Client -> Bind -> OnFailure");
        }
        return retry;
    }

    private void raiseBindSuccess(BindArgs bindArgs, ClientResponseArgs responseArgs) throws Exception {
        BindSuccessArgs args2 = new BindSuccessArgs();
        args2.__records = Client.getRecordsForBind(responseArgs.getResponse(), bindArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), bindArgs));
        args2.setIsRebind(bindArgs.getIsRebind());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(bindArgs.getDynamicProperties());
        BindSuccessArgs args = args2;
        SingleAction<BindSuccessArgs> onBindSuccess = this._onBindSuccess;
        if (onBindSuccess != null) {
            this.raiseAction(onBindSuccess, args, "Client -> OnBindSuccess");
        }
        if (bindArgs.getOnSuccess() != null) {
            this.raiseAction(bindArgs.getOnSuccess(), args, "Client -> Bind -> OnSuccess");
        }
    }

    private <T extends BaseClientEndEventArgs> void raiseCompleteEvent(DoubleAction<Client, T> eventMethod, T args, String eventName, ClientResponseArgs responseArgs) throws Exception {
        args.setException(responseArgs.getException());
        args.setResponse(responseArgs.getResponse());
        this.raiseEvent(eventMethod, args, eventName);
    }

    private void raiseConnectComplete(ConnectArgs connectArgs, ClientResponseArgs responseArgs) throws Exception {
        ConnectCompleteArgs args2 = new ConnectCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), connectArgs));
        args2.setIsReconnect(connectArgs.getIsReconnect());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(connectArgs.getDynamicProperties());
        ConnectCompleteArgs args = args2;
        SingleAction<ConnectCompleteArgs> onConnectComplete = this._onConnectComplete;
        if (onConnectComplete != null) {
            this.raiseAction(onConnectComplete, args, "Client -> OnConnectComplete");
        }
        if (connectArgs.getOnComplete() != null) {
            this.raiseAction(connectArgs.getOnComplete(), args, "Client -> Connect -> OnComplete");
        }
    }

    private boolean raiseConnectFailure(ConnectArgs connectArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        ConnectFailureArgs args2 = new ConnectFailureArgs();
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), connectArgs));
        args2.setIsReconnect(connectArgs.getIsReconnect());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(connectArgs.getDynamicProperties());
        ConnectFailureArgs args = args2;
        SingleAction<ConnectFailureArgs> onConnectFailure = this._onConnectFailure;
        if (onConnectFailure != null) {
            this.raiseAction(onConnectFailure, args, "Client -> OnConnectFailure");
        }
        if (connectArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(connectArgs.getOnFailure(), retry, args, "Client -> Connect -> OnFailure");
        }
        return retry;
    }

    private void raiseConnectSuccess(ConnectArgs connectArgs, ClientResponseArgs responseArgs) throws Exception {
        ConnectSuccessArgs args2 = new ConnectSuccessArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), connectArgs));
        args2.setConnectionType(this._connectionType);
        args2.setIsReconnect(connectArgs.getIsReconnect());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(connectArgs.getDynamicProperties());
        ConnectSuccessArgs args = args2;
        SingleAction<ConnectSuccessArgs> onConnectSuccess = this._onConnectSuccess;
        if (onConnectSuccess != null) {
            this.raiseAction(onConnectSuccess, args, "Client -> OnConnectSuccess");
        }
        if (connectArgs.getOnSuccess() != null) {
            this.raiseAction(connectArgs.getOnSuccess(), args, "Client -> Connect -> OnSuccess");
        }
    }

    private void raiseDisconnectComplete(DisconnectArgs disconnectArgs, ClientResponseArgs responseArgs) throws Exception {
        DisconnectCompleteArgs args2 = new DisconnectCompleteArgs();
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), disconnectArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(disconnectArgs.getDynamicProperties());
        DisconnectCompleteArgs args = args2;
        SingleAction<DisconnectCompleteArgs> onDisconnectComplete = this._onDisconnectComplete;
        if (onDisconnectComplete != null) {
            this.raiseAction(onDisconnectComplete, args, "Client -> OnDisconnectComplete");
        }
        if (disconnectArgs.getOnComplete() != null) {
            this.raiseAction(disconnectArgs.getOnComplete(), args, "Client -> Disconnect -> OnComplete");
        }
    }

    private <T extends BaseClientEventArgs> void raiseEvent(DoubleAction<Client, T> eventMethod, T args, String eventName) throws Exception {
        block3: {
            args.setClient(this);
            if (eventMethod != null) {
                try {
                    eventMethod.invoke((Object)this, args);
                }
                catch (Exception exception) {
                    if (super.raiseUnhandledException(exception)) break block3;
                    AsyncException.asyncThrow((Exception)exception, (String)StringExtensions.format((String)"Client -> {0}", (Object)eventName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseForcedUnbinds(BaseInputArgs inputArgs, ClientResponseArgs responseArgs) throws Exception {
        ArrayList<UnbindArgs> list = new ArrayList<UnbindArgs>();
        Object object = this._boundRecordsLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._boundRecords)) {
                UnbindArgs item = new UnbindArgs(new Record[]{(Record)((Object)HashMapExtensions.getItem(this._boundRecords).get(str))});
                item.setRequestUrl(inputArgs.getRequestUrl());
                item.setSynchronous(inputArgs.getSynchronous());
                item.setIsRetry(inputArgs.getIsRetry());
                item.setExtensions(Client.getExtensions(responseArgs.getResponse(), inputArgs));
                item.setDynamicProperties(inputArgs.getDynamicProperties());
                list.add(item);
            }
        }
        for (UnbindArgs args2 : list) {
            this.raiseUnbindSuccess(args2, responseArgs, true);
            this.raiseUnbindComplete(args2, responseArgs, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseForcedUnsubscribes(BaseInputArgs inputArgs, ClientResponseArgs responseArgs) throws Exception {
        ArrayList<UnsubscribeArgs> list = new ArrayList<UnsubscribeArgs>();
        Object object = this._subscribedChannelsLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._subscribedChannels)) {
                for (String str2 : HashMapExtensions.getKeys((HashMap)((HashMap)HashMapExtensions.getItem(this._subscribedChannels).get(str)))) {
                    UnsubscribeArgs item = new UnsubscribeArgs(new String[]{str2}, str);
                    item.setRequestUrl(inputArgs.getRequestUrl());
                    item.setSynchronous(inputArgs.getSynchronous());
                    item.setIsRetry(inputArgs.getIsRetry());
                    item.setExtensions(Client.getExtensions(responseArgs.getResponse(), inputArgs));
                    item.setDynamicProperties(inputArgs.getDynamicProperties());
                    list.add(item);
                }
            }
        }
        for (UnsubscribeArgs args2 : list) {
            this.raiseUnsubscribeSuccess(args2, responseArgs, true);
            this.raiseUnsubscribeComplete(args2, responseArgs, true);
        }
    }

    private <T, R> R raiseFunction(SingleFunction<T, R> callback, T args, String source) throws Exception {
        return this.raiseFunctionManual(callback, args, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> R raiseFunctionManual(SingleFunction<T, R> callback, T args, String source, boolean manualThreadManagement) throws Exception {
        Object local;
        if (manualThreadManagement) {
            try {
                return (R)callback.invoke(args);
            }
            catch (Exception exception1) {
                Exception exception = exception1;
                if (!super.raiseUnhandledException(exception)) {
                    AsyncException.asyncThrow((Exception)exception, (String)source);
                }
                return null;
            }
        }
        String threadId = this.getThreadId();
        this.preRaise(threadId);
        try {
            local = callback.invoke(args);
        }
        catch (Exception exception2) {
            Exception exception = exception2;
            if (!super.raiseUnhandledException(exception)) {
                AsyncException.asyncThrow((Exception)exception, (String)source);
            }
            local = null;
        }
        finally {
            this.postRaise(threadId);
        }
        return (R)local;
    }

    private void raiseNotifyComplete(NotifyArgs notifyArgs, ClientResponseArgs responseArgs) throws Exception {
        NotifyCompleteArgs args2 = new NotifyCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), notifyArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(notifyArgs.getDynamicProperties());
        NotifyCompleteArgs args = args2;
        SingleAction<NotifyCompleteArgs> onNotifyComplete = this._onNotifyComplete;
        if (onNotifyComplete != null) {
            this.raiseAction(onNotifyComplete, args, "Client -> OnNotifyComplete");
        }
        if (notifyArgs.getOnComplete() != null) {
            this.raiseAction(notifyArgs.getOnComplete(), args, "Client -> Notify -> OnComplete");
        }
    }

    private int raiseNotifyDelivery(SingleAction<NotifyReceiveArgs> onReceive, Message response, int reconnectAfter) throws Exception {
        NotifyReceiveArgs args2 = new NotifyReceiveArgs(response.__dataJson, response.__dataBytes, this._connectionType, reconnectAfter);
        args2.setExtensions(response.getExtensions());
        args2.setTimestamp(Client.getTimestamp(response));
        args2.setClient(this);
        NotifyReceiveArgs args = args2;
        if (onReceive != null) {
            this.raiseActionManual(onReceive, args, "Client -> OnNotify", true);
        }
        return args.getReconnectAfter();
    }

    private boolean raiseNotifyFailure(NotifyArgs notifyArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        NotifyFailureArgs args2 = new NotifyFailureArgs();
        args2.__dataJson = Client.getDataJsonForNotify(responseArgs.getResponse(), notifyArgs);
        args2.__dataBytes = Client.getDataBytesForNotify(responseArgs.getResponse(), notifyArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), notifyArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(notifyArgs.getDynamicProperties());
        NotifyFailureArgs args = args2;
        SingleAction<NotifyFailureArgs> onNotifyFailure = this._onNotifyFailure;
        if (onNotifyFailure != null) {
            this.raiseAction(onNotifyFailure, args, "Client -> OnNotifyFailure");
        }
        if (notifyArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(notifyArgs.getOnFailure(), retry, args, "Client -> Notify -> OnFailure");
        }
        return retry;
    }

    private void raiseNotifySuccess(NotifyArgs notifyArgs, ClientResponseArgs responseArgs) throws Exception {
        NotifySuccessArgs args2 = new NotifySuccessArgs();
        args2.__dataJson = Client.getDataJsonForNotify(responseArgs.getResponse(), notifyArgs);
        args2.__dataBytes = Client.getDataBytesForNotify(responseArgs.getResponse(), notifyArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), notifyArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(notifyArgs.getDynamicProperties());
        NotifySuccessArgs args = args2;
        SingleAction<NotifySuccessArgs> onNotifySuccess = this._onNotifySuccess;
        if (onNotifySuccess != null) {
            this.raiseAction(onNotifySuccess, args, "Client -> OnNotifySuccess");
        }
        if (notifyArgs.getOnSuccess() != null) {
            this.raiseAction(notifyArgs.getOnSuccess(), args, "Client -> Notify -> OnSuccess");
        }
    }

    private void raisePublishComplete(PublishArgs publishArgs, ClientResponseArgs responseArgs) throws Exception {
        PublishCompleteArgs args2 = new PublishCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), publishArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(publishArgs.getDynamicProperties());
        PublishCompleteArgs args = args2;
        SingleAction<PublishCompleteArgs> onPublishComplete = this._onPublishComplete;
        if (onPublishComplete != null) {
            this.raiseAction(onPublishComplete, args, "Client -> OnPublishComplete");
        }
        if (publishArgs.getOnComplete() != null) {
            this.raiseAction(publishArgs.getOnComplete(), args, "Client -> Publish -> OnComplete");
        }
    }

    private boolean raisePublishFailure(PublishArgs publishArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        PublishFailureArgs args2 = new PublishFailureArgs();
        args2.__channel = Client.getChannelForPublish(responseArgs.getResponse(), publishArgs);
        args2.__dataJson = Client.getDataJsonForPublish(responseArgs.getResponse(), publishArgs);
        args2.__dataBytes = Client.getDataBytesForPublish(responseArgs.getResponse(), publishArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), publishArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(publishArgs.getDynamicProperties());
        PublishFailureArgs args = args2;
        SingleAction<PublishFailureArgs> onPublishFailure = this._onPublishFailure;
        if (onPublishFailure != null) {
            this.raiseAction(onPublishFailure, args, "Client -> OnPublishFailure");
        }
        if (publishArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(publishArgs.getOnFailure(), retry, args, "Client -> Publish -> OnFailure");
        }
        return retry;
    }

    private void raisePublishSuccess(PublishArgs publishArgs, ClientResponseArgs responseArgs) throws Exception {
        PublishSuccessArgs args2 = new PublishSuccessArgs();
        args2.__channel = Client.getChannelForPublish(responseArgs.getResponse(), publishArgs);
        args2.__dataJson = Client.getDataJsonForPublish(responseArgs.getResponse(), publishArgs);
        args2.__dataBytes = Client.getDataBytesForPublish(responseArgs.getResponse(), publishArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), publishArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(publishArgs.getDynamicProperties());
        PublishSuccessArgs args = args2;
        SingleAction<PublishSuccessArgs> onPublishSuccess = this._onPublishSuccess;
        if (onPublishSuccess != null) {
            this.raiseAction(onPublishSuccess, args, "Client -> OnPublishSuccess");
        }
        if (publishArgs.getOnSuccess() != null) {
            this.raiseAction(publishArgs.getOnSuccess(), args, "Client -> Publish -> OnSuccess");
        }
    }

    private <T extends BaseClientRequestEventArgs> boolean raiseRequestEvent(DoubleAction<Client, T> eventMethod, T args, String eventName) throws Exception {
        this.raiseEvent(eventMethod, args, eventName);
        return !args.getCancel();
    }

    private <T extends BaseClientResponseEventArgs> void raiseResponseEvent(DoubleAction<Client, T> eventMethod, T args, String eventName, ClientResponseArgs responseArgs) throws Exception {
        args.setException(responseArgs.getException());
        args.setResponse(responseArgs.getResponse());
        this.raiseEvent(eventMethod, args, eventName);
    }

    private <T extends BaseFailureArgs> boolean raiseRetriable(SingleAction<T> callback, boolean retry, T args, String source) throws Exception {
        args.setRetry(retry);
        this.raiseAction(callback, args, source);
        return args.getRetry();
    }

    private void raiseSendException(ClientSendState state, Exception exception) {
        for (ClientRequest request : state.getRequests()) {
            ClientResponseArgs p = new ClientResponseArgs();
            p.setDynamicProperties(request.getDynamicProperties());
            p.setException(exception);
            request.getCallback().invoke((Object)p);
        }
    }

    private void raiseServerBind(Message serverAction) throws Exception {
        SingleAction<ServerBindArgs> onServerBind = this._onServerBind;
        if (onServerBind != null) {
            ServerBindArgs args = new ServerBindArgs();
            args.__records = serverAction.getRecords();
            args.setExtensions(serverAction.getExtensions());
            args.setTimestamp(serverAction.getTimestamp());
            args.setClient(this);
            this.raiseAction(onServerBind, args, "Client -> OnServerBind");
        }
    }

    private SingleAction<SubscribeReceiveArgs> raiseServerSubscribe(Message serverAction) throws Exception {
        SingleFunction<ServerSubscribeArgs, SingleAction<SubscribeReceiveArgs>> onServerSubscribe = this._onServerSubscribe;
        if (onServerSubscribe != null) {
            ServerSubscribeArgs args = new ServerSubscribeArgs();
            args.__channels = serverAction.getChannels();
            args.setExtensions(serverAction.getExtensions());
            args.setTimestamp(serverAction.getTimestamp());
            args.setClient(this);
            return this.raiseFunction(onServerSubscribe, args, "Client -> OnServerSubscribe");
        }
        return null;
    }

    private void raiseServerUnbind(Message serverAction) throws Exception {
        SingleAction<ServerUnbindArgs> onServerUnbind = this._onServerUnbind;
        if (onServerUnbind != null) {
            ServerUnbindArgs args = new ServerUnbindArgs();
            args.__records = serverAction.getRecords();
            args.setExtensions(serverAction.getExtensions());
            args.setTimestamp(serverAction.getTimestamp());
            args.setClient(this);
            this.raiseAction(onServerUnbind, args, "Client -> OnServerUnbind");
        }
    }

    private void raiseServerUnsubscribe(Message serverAction) throws Exception {
        SingleAction<ServerUnsubscribeArgs> onServerUnsubscribe = this._onServerUnsubscribe;
        if (onServerUnsubscribe != null) {
            ServerUnsubscribeArgs args = new ServerUnsubscribeArgs();
            args.__channels = serverAction.getChannels();
            args.setExtensions(serverAction.getExtensions());
            args.setTimestamp(serverAction.getTimestamp());
            args.setClient(this);
            this.raiseAction(onServerUnsubscribe, args, "Client -> OnServerUnsubscribe");
        }
    }

    private void raiseServiceComplete(ServiceArgs serviceArgs, ClientResponseArgs responseArgs) throws Exception {
        ServiceCompleteArgs args2 = new ServiceCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), serviceArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(serviceArgs.getDynamicProperties());
        ServiceCompleteArgs args = args2;
        SingleAction<ServiceCompleteArgs> onServiceComplete = this._onServiceComplete;
        if (onServiceComplete != null) {
            this.raiseAction(onServiceComplete, args, "Client -> OnServiceComplete");
        }
        if (serviceArgs.getOnComplete() != null) {
            this.raiseAction(serviceArgs.getOnComplete(), args, "Client -> Service -> OnComplete");
        }
    }

    private boolean raiseServiceFailure(ServiceArgs serviceArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        ServiceFailureArgs args2 = new ServiceFailureArgs();
        args2.__channel = Client.getChannelForService(responseArgs.getResponse(), serviceArgs);
        args2.__dataJson = Client.getDataJsonForService(responseArgs.getResponse(), serviceArgs);
        args2.__dataBytes = Client.getDataBytesForService(responseArgs.getResponse(), serviceArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), serviceArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(serviceArgs.getDynamicProperties());
        ServiceFailureArgs args = args2;
        SingleAction<ServiceFailureArgs> onServiceFailure = this._onServiceFailure;
        if (onServiceFailure != null) {
            this.raiseAction(onServiceFailure, args, "Client -> OnServiceFailure");
        }
        if (serviceArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(serviceArgs.getOnFailure(), retry, args, "Client -> Service -> OnFailure");
        }
        return retry;
    }

    private void raiseServiceSuccess(ServiceArgs serviceArgs, ClientResponseArgs responseArgs) throws Exception {
        ServiceSuccessArgs args2 = new ServiceSuccessArgs();
        args2.__channel = Client.getChannelForService(responseArgs.getResponse(), serviceArgs);
        args2.__dataJson = Client.getDataJsonForService(responseArgs.getResponse(), serviceArgs);
        args2.__dataBytes = Client.getDataBytesForService(responseArgs.getResponse(), serviceArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), serviceArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(serviceArgs.getDynamicProperties());
        ServiceSuccessArgs args = args2;
        SingleAction<ServiceSuccessArgs> onServiceSuccess = this._onServiceSuccess;
        if (onServiceSuccess != null) {
            this.raiseAction(onServiceSuccess, args, "Client -> OnServiceSuccess");
        }
        if (serviceArgs.getOnSuccess() != null) {
            this.raiseAction(serviceArgs.getOnSuccess(), args, "Client -> Service -> OnSuccess");
        }
    }

    private void raiseStateRestored(ConnectArgs connectArgs) throws Exception {
        StateRestoredArgs args2 = new StateRestoredArgs();
        args2.setExtensions(connectArgs.getExtensions());
        args2.setClient(this);
        args2.setDynamicProperties(connectArgs.getDynamicProperties());
        StateRestoredArgs args = args2;
        SingleAction<StateRestoredArgs> onStateRestored = this._onStateRestored;
        if (onStateRestored != null) {
            this.raiseAction(onStateRestored, args, "Client -> OnStateRestored");
        }
        if (connectArgs.getOnStateRestored() != null) {
            this.raiseAction(connectArgs.getOnStateRestored(), args, "Client -> Connect -> OnStateRestored");
        }
    }

    private boolean raiseStreamFailure(ConnectArgs connectArgs, ClientResponseArgs responseArgs, boolean retry, Holder<ConnectArgs> connectArgsOut) throws Exception {
        StreamFailureArgs args2 = new StreamFailureArgs();
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), connectArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setConnectArgs(connectArgs);
        args2.setDynamicProperties(connectArgs.getDynamicProperties());
        StreamFailureArgs args = args2;
        SingleAction<StreamFailureArgs> onStreamFailure = this._onStreamFailure;
        if (onStreamFailure != null) {
            this.raiseAction(onStreamFailure, args, "Client -> OnStreamFailure");
        }
        if (connectArgs.getOnStreamFailure() != null) {
            retry = this.raiseRetriable(connectArgs.getOnStreamFailure(), retry, args, "Client -> Connect -> OnStreamFailure");
        }
        connectArgsOut.setValue((Object)args.getConnectArgs());
        return retry;
    }

    private void raiseSubscribeComplete(SubscribeArgs subscribeArgs, ClientResponseArgs responseArgs) throws Exception {
        SubscribeCompleteArgs args2 = new SubscribeCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), subscribeArgs));
        args2.setIsResubscribe(subscribeArgs.getIsResubscribe());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(subscribeArgs.getDynamicProperties());
        SubscribeCompleteArgs args = args2;
        SingleAction<SubscribeCompleteArgs> onSubscribeComplete = this._onSubscribeComplete;
        if (onSubscribeComplete != null) {
            this.raiseAction(onSubscribeComplete, args, "Client -> OnSubscribeComplete");
        }
        if (subscribeArgs.getOnComplete() != null) {
            this.raiseAction(subscribeArgs.getOnComplete(), args, "Client -> Subscribe -> OnComplete");
        }
    }

    private int raiseSubscribeDelivery(SingleAction<SubscribeReceiveArgs> onReceive, HashMap<String, Object> dynamicProperties, Message response, int reconnectAfter) throws Exception {
        SubscribeReceiveArgs args2 = new SubscribeReceiveArgs(response.getBayeuxChannel(), response.__dataJson, response.__dataBytes, this._connectionType, reconnectAfter);
        args2.setExtensions(response.getExtensions());
        args2.setTimestamp(Client.getTimestamp(response));
        args2.setClient(this);
        args2.setDynamicProperties(dynamicProperties);
        SubscribeReceiveArgs args = args2;
        if (onReceive != null) {
            this.raiseActionManual(onReceive, args, "Client -> Subscribe -> OnReceive", true);
        }
        return args.getReconnectAfter();
    }

    private boolean raiseSubscribeFailure(SubscribeArgs subscribeArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        SubscribeFailureArgs args2 = new SubscribeFailureArgs();
        args2.__channels = Client.getChannelsForSubscribe(responseArgs.getResponse(), subscribeArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), subscribeArgs));
        args2.setIsResubscribe(subscribeArgs.getIsResubscribe());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(subscribeArgs.getDynamicProperties());
        SubscribeFailureArgs args = args2;
        SingleAction<SubscribeFailureArgs> onSubscribeFailure = this._onSubscribeFailure;
        if (onSubscribeFailure != null) {
            this.raiseAction(onSubscribeFailure, args, "Client -> OnSubscribeFailure");
        }
        if (subscribeArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(subscribeArgs.getOnFailure(), retry, args, "Client -> Subscribe -> OnFailure");
        }
        return retry;
    }

    private void raiseSubscribeSuccess(SubscribeArgs subscribeArgs, ClientResponseArgs responseArgs) throws Exception {
        SubscribeSuccessArgs args2 = new SubscribeSuccessArgs();
        args2.__channels = Client.getChannelsForSubscribe(responseArgs.getResponse(), subscribeArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), subscribeArgs));
        args2.setIsResubscribe(subscribeArgs.getIsResubscribe());
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(subscribeArgs.getDynamicProperties());
        SubscribeSuccessArgs args = args2;
        SingleAction<SubscribeSuccessArgs> onSubscribeSuccess = this._onSubscribeSuccess;
        if (onSubscribeSuccess != null) {
            this.raiseAction(onSubscribeSuccess, args, "Client -> OnSubscribeSuccess");
        }
        if (subscribeArgs.getOnSuccess() != null) {
            this.raiseAction(subscribeArgs.getOnSuccess(), args, "Client -> Subscribe -> OnSuccess");
        }
    }

    private void raiseUnbindComplete(UnbindArgs unbindArgs, ClientResponseArgs responseArgs, boolean forced) throws Exception {
        UnbindCompleteArgs args2 = new UnbindCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), unbindArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(unbindArgs.getDynamicProperties());
        args2.__forced = forced;
        UnbindCompleteArgs args = args2;
        SingleAction<UnbindCompleteArgs> onUnbindComplete = this._onUnbindComplete;
        if (onUnbindComplete != null) {
            this.raiseAction(onUnbindComplete, args, "Client -> OnUnbindComplete");
        }
        if (unbindArgs.getOnComplete() != null) {
            this.raiseAction(unbindArgs.getOnComplete(), args, "Client -> Unbind -> OnComplete");
        }
    }

    private boolean raiseUnbindFailure(UnbindArgs unbindArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        UnbindFailureArgs args2 = new UnbindFailureArgs();
        args2.__records = Client.getRecordsForUnbind(responseArgs.getResponse(), unbindArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), unbindArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(unbindArgs.getDynamicProperties());
        UnbindFailureArgs args = args2;
        SingleAction<UnbindFailureArgs> onUnbindFailure = this._onUnbindFailure;
        if (onUnbindFailure != null) {
            this.raiseAction(onUnbindFailure, args, "Client -> OnUnbindFailure");
        }
        if (unbindArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(unbindArgs.getOnFailure(), retry, args, "Client -> Unbind -> OnFailure");
        }
        return retry;
    }

    private void raiseUnbindSuccess(UnbindArgs unbindArgs, ClientResponseArgs responseArgs, boolean forced) throws Exception {
        UnbindSuccessArgs args2 = new UnbindSuccessArgs();
        args2.__records = Client.getRecordsForUnbind(responseArgs.getResponse(), unbindArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), unbindArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(unbindArgs.getDynamicProperties());
        args2.__forced = forced;
        UnbindSuccessArgs args = args2;
        SingleAction<UnbindSuccessArgs> onUnbindSuccess = this._onUnbindSuccess;
        if (onUnbindSuccess != null) {
            this.raiseAction(onUnbindSuccess, args, "Client -> OnUnbindSuccess");
        }
        if (unbindArgs.getOnSuccess() != null) {
            this.raiseAction(unbindArgs.getOnSuccess(), args, "Client -> Unbind -> OnSuccess");
        }
    }

    private void raiseUnsubscribeComplete(UnsubscribeArgs unsubscribeArgs, ClientResponseArgs responseArgs, boolean forced) throws Exception {
        UnsubscribeCompleteArgs args2 = new UnsubscribeCompleteArgs();
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), unsubscribeArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(unsubscribeArgs.getDynamicProperties());
        args2.__forced = forced;
        UnsubscribeCompleteArgs args = args2;
        SingleAction<UnsubscribeCompleteArgs> onUnsubscribeComplete = this._onUnsubscribeComplete;
        if (onUnsubscribeComplete != null) {
            this.raiseAction(onUnsubscribeComplete, args, "Client -> OnUnsubscribeComplete");
        }
        if (unsubscribeArgs.getOnComplete() != null) {
            this.raiseAction(unsubscribeArgs.getOnComplete(), args, "Client -> Unsubscribe -> OnComplete");
        }
    }

    private boolean raiseUnsubscribeFailure(UnsubscribeArgs unsubscribeArgs, ClientResponseArgs responseArgs, boolean retry) throws Exception {
        UnsubscribeFailureArgs args2 = new UnsubscribeFailureArgs();
        args2.__channels = Client.getChannelsForUnsubscribe(responseArgs.getResponse(), unsubscribeArgs);
        args2.setException(responseArgs.getException());
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), unsubscribeArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(unsubscribeArgs.getDynamicProperties());
        UnsubscribeFailureArgs args = args2;
        SingleAction<UnsubscribeFailureArgs> onUnsubscribeFailure = this._onUnsubscribeFailure;
        if (onUnsubscribeFailure != null) {
            this.raiseAction(onUnsubscribeFailure, args, "Client -> OnUnsubscribeFailure");
        }
        if (unsubscribeArgs.getOnFailure() != null) {
            retry = this.raiseRetriable(unsubscribeArgs.getOnFailure(), retry, args, "Client -> Unsubscribe -> OnFailure");
        }
        return retry;
    }

    private void raiseUnsubscribeSuccess(UnsubscribeArgs unsubscribeArgs, ClientResponseArgs responseArgs, boolean forced) throws Exception {
        UnsubscribeSuccessArgs args2 = new UnsubscribeSuccessArgs();
        args2.__channels = Client.getChannelsForUnsubscribe(responseArgs.getResponse(), unsubscribeArgs);
        args2.setExtensions(Client.getExtensions(responseArgs.getResponse(), unsubscribeArgs));
        args2.setTimestamp(Client.getTimestamp(responseArgs.getResponse()));
        args2.setClient(this);
        args2.setDynamicProperties(unsubscribeArgs.getDynamicProperties());
        args2.__forced = forced;
        UnsubscribeSuccessArgs args = args2;
        SingleAction<UnsubscribeSuccessArgs> onUnsubscribeSuccess = this._onUnsubscribeSuccess;
        if (onUnsubscribeSuccess != null) {
            this.raiseAction(onUnsubscribeSuccess, args, "Client -> OnUnsubscribeSuccess");
        }
        if (unsubscribeArgs.getOnSuccess() != null) {
            this.raiseAction(unsubscribeArgs.getOnSuccess(), args, "Client -> Unsubscribe -> OnSuccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveMessage(Message message, int reconnectAfter) throws Exception {
        HashMap dictionary3;
        Object obj2;
        if (Global.equals((Object)message.getBayeuxChannel(), (Object)"/meta/notify")) {
            if (Global.equals((Object)message.getTag(), (Object)"fm.server")) {
                Message serverAction = Message.fromJson(message.getDataJson());
                reconnectAfter = this.processServerAction(serverAction, reconnectAfter);
            } else {
                SingleAction<NotifyReceiveArgs> onNotify = this._onNotify;
                if (onNotify != null) {
                    reconnectAfter = this.raiseNotifyDelivery(onNotify, message, reconnectAfter);
                }
            }
            return reconnectAfter;
        }
        ArrayList list = new ArrayList();
        ArrayList list2 = new ArrayList();
        Object object = obj2 = this._customOnReceivesLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._customOnReceives)) {
                HashMap dictionary = (HashMap)HashMapExtensions.getItem(this._customOnReceives).get(str);
                for (String str2 : HashMapExtensions.getKeys((HashMap)dictionary)) {
                    if (!Global.equals((Object)str2, (Object)message.getChannel())) continue;
                    list.add(HashMapExtensions.getItem((HashMap)dictionary).get(str2));
                    list2.add(new HashMap());
                }
            }
        }
        object = obj2 = this._subscribedOnReceivesLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._subscribedOnReceives)) {
                HashMap dictionary2 = (HashMap)HashMapExtensions.getItem(this._subscribedOnReceives).get(str);
                for (String str2 : HashMapExtensions.getKeys((HashMap)dictionary2)) {
                    if (!Global.equals((Object)str2, (Object)message.getChannel())) continue;
                    list.add(HashMapExtensions.getItem((HashMap)dictionary2).get(str2));
                    dictionary3 = null;
                    Holder _var0 = new Holder((Object)dictionary3);
                    boolean _var1 = HashMapExtensions.tryGetValue(this._subscribedDynamicProperties, (Object)Client.getSubscribeKey(str2, str), (Holder)_var0);
                    dictionary3 = (HashMap)_var0.getValue();
                    if (!_var1) {
                        dictionary3 = new HashMap();
                    }
                    list2.add(dictionary3);
                }
            }
            if (ArrayListExtensions.getCount(list) == 0) {
                ArrayList<Message> list3 = null;
                Holder _var2 = new Holder(list3);
                boolean _var3 = HashMapExtensions.tryGetValue(this._pendingReceives, (Object)message.getChannel(), (Holder)_var2);
                list3 = (ArrayList<Message>)_var2.getValue();
                if (!_var3) {
                    list3 = new ArrayList<Message>();
                    HashMapExtensions.getItem(this._pendingReceives).put(message.getChannel(), list3);
                }
                list3.add(message);
                return reconnectAfter;
            }
        }
        for (int i = 0; i < ArrayListExtensions.getCount(list); ++i) {
            SingleAction onReceive = (SingleAction)ArrayListExtensions.getItem(list).get(i);
            dictionary3 = null;
            if (i < ArrayListExtensions.getCount(list2)) {
                dictionary3 = (HashMap)ArrayListExtensions.getItem(list2).get(i);
            }
            reconnectAfter = this.raiseSubscribeDelivery((SingleAction<SubscribeReceiveArgs>)onReceive, dictionary3, message, reconnectAfter);
        }
        return reconnectAfter;
    }

    private void receiveSink(SubscribeReceiveArgs e) {
        Log.warn((String)"Received message on channel with no receive handler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(ConnectArgs connectArgs, ClientResponseArgs responseArgs) throws Exception {
        Object obj2;
        ConnectArgs connectArgsOut = null;
        Holder _var0 = new Holder(connectArgsOut);
        boolean _var1 = this.raiseStreamFailure(connectArgs, responseArgs, true, (Holder<ConnectArgs>)_var0);
        connectArgsOut = (ConnectArgs)((Object)_var0.getValue());
        boolean flag = _var1;
        if (connectArgsOut == null) {
            connectArgsOut = connectArgs;
        }
        this.raiseForcedUnsubscribes(connectArgs, responseArgs);
        this.raiseForcedUnbinds(connectArgs, responseArgs);
        Object object = obj2 = this._stateLock;
        synchronized (object) {
            this.clearBoundRecords();
            this.clearSubscribedChannels();
            this.setIsConnected(false);
        }
        object = obj2 = this._queueLock;
        synchronized (object) {
            this._queueActivated = false;
        }
        if (flag) {
            connectArgs.setIsReconnect(true);
            connectArgs.setLastClientId(new NullableGuid(this.getClientId()));
            connectArgs.setLastSessionId(new NullableGuid(this.getSessionId()));
            this.connect(connectArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBoundRecords(Record[] records) {
        Object object = this._boundRecordsLock;
        synchronized (object) {
            for (Record record : records) {
                HashMapExtensions.remove(this._boundRecords, (Object)record.getKey());
            }
        }
    }

    public void removeOnBindComplete(SingleAction<BindCompleteArgs> value) {
        this._onBindComplete = (SingleAction)Delegate.remove(this._onBindComplete, value);
    }

    public static void removeOnBindEnd(DoubleAction<Client, ClientBindEndArgs> value) {
        _onBindEnd = (DoubleAction)Delegate.remove(_onBindEnd, value);
    }

    public void removeOnBindFailure(SingleAction<BindFailureArgs> value) {
        this._onBindFailure = (SingleAction)Delegate.remove(this._onBindFailure, value);
    }

    public static void removeOnBindRequest(DoubleAction<Client, ClientBindRequestArgs> value) {
        _onBindRequest = (DoubleAction)Delegate.remove(_onBindRequest, value);
    }

    public static void removeOnBindResponse(DoubleAction<Client, ClientBindResponseArgs> value) {
        _onBindResponse = (DoubleAction)Delegate.remove(_onBindResponse, value);
    }

    public void removeOnBindSuccess(SingleAction<BindSuccessArgs> value) {
        this._onBindSuccess = (SingleAction)Delegate.remove(this._onBindSuccess, value);
    }

    public void removeOnConnectComplete(SingleAction<ConnectCompleteArgs> value) {
        this._onConnectComplete = (SingleAction)Delegate.remove(this._onConnectComplete, value);
    }

    public static void removeOnConnectEnd(DoubleAction<Client, ClientConnectEndArgs> value) {
        _onConnectEnd = (DoubleAction)Delegate.remove(_onConnectEnd, value);
    }

    public void removeOnConnectFailure(SingleAction<ConnectFailureArgs> value) {
        this._onConnectFailure = (SingleAction)Delegate.remove(this._onConnectFailure, value);
    }

    public static void removeOnConnectRequest(DoubleAction<Client, ClientConnectRequestArgs> value) {
        _onConnectRequest = (DoubleAction)Delegate.remove(_onConnectRequest, value);
    }

    public static void removeOnConnectResponse(DoubleAction<Client, ClientConnectResponseArgs> value) {
        _onConnectResponse = (DoubleAction)Delegate.remove(_onConnectResponse, value);
    }

    public void removeOnConnectSuccess(SingleAction<ConnectSuccessArgs> value) {
        this._onConnectSuccess = (SingleAction)Delegate.remove(this._onConnectSuccess, value);
    }

    public void removeOnDisconnectComplete(SingleAction<DisconnectCompleteArgs> value) {
        this._onDisconnectComplete = (SingleAction)Delegate.remove(this._onDisconnectComplete, value);
    }

    public static void removeOnDisconnectEnd(DoubleAction<Client, ClientDisconnectEndArgs> value) {
        _onDisconnectEnd = (DoubleAction)Delegate.remove(_onDisconnectEnd, value);
    }

    public static void removeOnDisconnectRequest(DoubleAction<Client, ClientDisconnectRequestArgs> value) {
        _onDisconnectRequest = (DoubleAction)Delegate.remove(_onDisconnectRequest, value);
    }

    public static void removeOnDisconnectResponse(DoubleAction<Client, ClientDisconnectResponseArgs> value) {
        _onDisconnectResponse = (DoubleAction)Delegate.remove(_onDisconnectResponse, value);
    }

    public void removeOnNotify(SingleAction<NotifyReceiveArgs> value) {
        this._onNotify = (SingleAction)Delegate.remove(this._onNotify, value);
    }

    public void removeOnNotifyComplete(SingleAction<NotifyCompleteArgs> value) {
        this._onNotifyComplete = (SingleAction)Delegate.remove(this._onNotifyComplete, value);
    }

    public static void removeOnNotifyEnd(DoubleAction<Client, ClientNotifyEndArgs> value) {
        _onNotifyEnd = (DoubleAction)Delegate.remove(_onNotifyEnd, value);
    }

    public void removeOnNotifyFailure(SingleAction<NotifyFailureArgs> value) {
        this._onNotifyFailure = (SingleAction)Delegate.remove(this._onNotifyFailure, value);
    }

    public static void removeOnNotifyRequest(DoubleAction<Client, ClientNotifyRequestArgs> value) {
        _onNotifyRequest = (DoubleAction)Delegate.remove(_onNotifyRequest, value);
    }

    public static void removeOnNotifyResponse(DoubleAction<Client, ClientNotifyResponseArgs> value) {
        _onNotifyResponse = (DoubleAction)Delegate.remove(_onNotifyResponse, value);
    }

    public void removeOnNotifySuccess(SingleAction<NotifySuccessArgs> value) {
        this._onNotifySuccess = (SingleAction)Delegate.remove(this._onNotifySuccess, value);
    }

    public void removeOnPublishComplete(SingleAction<PublishCompleteArgs> value) {
        this._onPublishComplete = (SingleAction)Delegate.remove(this._onPublishComplete, value);
    }

    public static void removeOnPublishEnd(DoubleAction<Client, ClientPublishEndArgs> value) {
        _onPublishEnd = (DoubleAction)Delegate.remove(_onPublishEnd, value);
    }

    public void removeOnPublishFailure(SingleAction<PublishFailureArgs> value) {
        this._onPublishFailure = (SingleAction)Delegate.remove(this._onPublishFailure, value);
    }

    public static void removeOnPublishRequest(DoubleAction<Client, ClientPublishRequestArgs> value) {
        _onPublishRequest = (DoubleAction)Delegate.remove(_onPublishRequest, value);
    }

    public static void removeOnPublishResponse(DoubleAction<Client, ClientPublishResponseArgs> value) {
        _onPublishResponse = (DoubleAction)Delegate.remove(_onPublishResponse, value);
    }

    public void removeOnPublishSuccess(SingleAction<PublishSuccessArgs> value) {
        this._onPublishSuccess = (SingleAction)Delegate.remove(this._onPublishSuccess, value);
    }

    public void removeOnServerBind(SingleAction<ServerBindArgs> value) {
        this._onServerBind = (SingleAction)Delegate.remove(this._onServerBind, value);
    }

    public void removeOnServerSubscribe(SingleFunction<ServerSubscribeArgs, SingleAction<SubscribeReceiveArgs>> value) {
        this._onServerSubscribe = (SingleFunction)Delegate.remove(this._onServerSubscribe, value);
    }

    public void removeOnServerUnbind(SingleAction<ServerUnbindArgs> value) {
        this._onServerUnbind = (SingleAction)Delegate.remove(this._onServerUnbind, value);
    }

    public void removeOnServerUnsubscribe(SingleAction<ServerUnsubscribeArgs> value) {
        this._onServerUnsubscribe = (SingleAction)Delegate.remove(this._onServerUnsubscribe, value);
    }

    public void removeOnServiceComplete(SingleAction<ServiceCompleteArgs> value) {
        this._onServiceComplete = (SingleAction)Delegate.remove(this._onServiceComplete, value);
    }

    public static void removeOnServiceEnd(DoubleAction<Client, ClientServiceEndArgs> value) {
        _onServiceEnd = (DoubleAction)Delegate.remove(_onServiceEnd, value);
    }

    public void removeOnServiceFailure(SingleAction<ServiceFailureArgs> value) {
        this._onServiceFailure = (SingleAction)Delegate.remove(this._onServiceFailure, value);
    }

    public static void removeOnServiceRequest(DoubleAction<Client, ClientServiceRequestArgs> value) {
        _onServiceRequest = (DoubleAction)Delegate.remove(_onServiceRequest, value);
    }

    public static void removeOnServiceResponse(DoubleAction<Client, ClientServiceResponseArgs> value) {
        _onServiceResponse = (DoubleAction)Delegate.remove(_onServiceResponse, value);
    }

    public void removeOnServiceSuccess(SingleAction<ServiceSuccessArgs> value) {
        this._onServiceSuccess = (SingleAction)Delegate.remove(this._onServiceSuccess, value);
    }

    public void removeOnStateRestored(SingleAction<StateRestoredArgs> value) {
        this._onStateRestored = (SingleAction)Delegate.remove(this._onStateRestored, value);
    }

    public void removeOnStreamFailure(SingleAction<StreamFailureArgs> value) {
        this._onStreamFailure = (SingleAction)Delegate.remove(this._onStreamFailure, value);
    }

    public void removeOnSubscribeComplete(SingleAction<SubscribeCompleteArgs> value) {
        this._onSubscribeComplete = (SingleAction)Delegate.remove(this._onSubscribeComplete, value);
    }

    public static void removeOnSubscribeEnd(DoubleAction<Client, ClientSubscribeEndArgs> value) {
        _onSubscribeEnd = (DoubleAction)Delegate.remove(_onSubscribeEnd, value);
    }

    public void removeOnSubscribeFailure(SingleAction<SubscribeFailureArgs> value) {
        this._onSubscribeFailure = (SingleAction)Delegate.remove(this._onSubscribeFailure, value);
    }

    public static void removeOnSubscribeRequest(DoubleAction<Client, ClientSubscribeRequestArgs> value) {
        _onSubscribeRequest = (DoubleAction)Delegate.remove(_onSubscribeRequest, value);
    }

    public static void removeOnSubscribeResponse(DoubleAction<Client, ClientSubscribeResponseArgs> value) {
        _onSubscribeResponse = (DoubleAction)Delegate.remove(_onSubscribeResponse, value);
    }

    public void removeOnSubscribeSuccess(SingleAction<SubscribeSuccessArgs> value) {
        this._onSubscribeSuccess = (SingleAction)Delegate.remove(this._onSubscribeSuccess, value);
    }

    public void removeOnUnbindComplete(SingleAction<UnbindCompleteArgs> value) {
        this._onUnbindComplete = (SingleAction)Delegate.remove(this._onUnbindComplete, value);
    }

    public static void removeOnUnbindEnd(DoubleAction<Client, ClientUnbindEndArgs> value) {
        _onUnbindEnd = (DoubleAction)Delegate.remove(_onUnbindEnd, value);
    }

    public void removeOnUnbindFailure(SingleAction<UnbindFailureArgs> value) {
        this._onUnbindFailure = (SingleAction)Delegate.remove(this._onUnbindFailure, value);
    }

    public static void removeOnUnbindRequest(DoubleAction<Client, ClientUnbindRequestArgs> value) {
        _onUnbindRequest = (DoubleAction)Delegate.remove(_onUnbindRequest, value);
    }

    public static void removeOnUnbindResponse(DoubleAction<Client, ClientUnbindResponseArgs> value) {
        _onUnbindResponse = (DoubleAction)Delegate.remove(_onUnbindResponse, value);
    }

    public void removeOnUnbindSuccess(SingleAction<UnbindSuccessArgs> value) {
        this._onUnbindSuccess = (SingleAction)Delegate.remove(this._onUnbindSuccess, value);
    }

    public void removeOnUnsubscribeComplete(SingleAction<UnsubscribeCompleteArgs> value) {
        this._onUnsubscribeComplete = (SingleAction)Delegate.remove(this._onUnsubscribeComplete, value);
    }

    public static void removeOnUnsubscribeEnd(DoubleAction<Client, ClientUnsubscribeEndArgs> value) {
        _onUnsubscribeEnd = (DoubleAction)Delegate.remove(_onUnsubscribeEnd, value);
    }

    public void removeOnUnsubscribeFailure(SingleAction<UnsubscribeFailureArgs> value) {
        this._onUnsubscribeFailure = (SingleAction)Delegate.remove(this._onUnsubscribeFailure, value);
    }

    public static void removeOnUnsubscribeRequest(DoubleAction<Client, ClientUnsubscribeRequestArgs> value) {
        _onUnsubscribeRequest = (DoubleAction)Delegate.remove(_onUnsubscribeRequest, value);
    }

    public static void removeOnUnsubscribeResponse(DoubleAction<Client, ClientUnsubscribeResponseArgs> value) {
        _onUnsubscribeResponse = (DoubleAction)Delegate.remove(_onUnsubscribeResponse, value);
    }

    public void removeOnUnsubscribeSuccess(SingleAction<UnsubscribeSuccessArgs> value) {
        this._onUnsubscribeSuccess = (SingleAction)Delegate.remove(this._onUnsubscribeSuccess, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscribedChannels(String tag, String[] channels) {
        Object object = this._subscribedChannelsLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._subscribedChannels, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (_var1) {
                for (String str : channels) {
                    HashMapExtensions.remove((HashMap)dictionary, (Object)str);
                }
                if (HashMapExtensions.getCount((HashMap)dictionary) == 0) {
                    HashMapExtensions.remove(this._subscribedChannels, (Object)tag);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscribedOnReceive(String tag, String[] channels) {
        Object object = this._subscribedOnReceivesLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._subscribedOnReceives, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (_var1) {
                for (String str : channels) {
                    HashMapExtensions.remove((HashMap)dictionary, (Object)str);
                    HashMapExtensions.remove(this._subscribedDynamicProperties, (Object)Client.getSubscribeKey(str, tag));
                }
                if (HashMapExtensions.getCount((HashMap)dictionary) == 0) {
                    HashMapExtensions.remove(this._subscribedOnReceives, (Object)tag);
                }
            }
        }
    }

    private void restream(ConnectArgs connectArgs, boolean receivedMessages, int reconnectAfter) throws Exception {
        if (reconnectAfter < this._lastInterval) {
            reconnectAfter = this._lastInterval;
        }
        if (Global.equals((Object)((Object)super.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.Low)) && reconnectAfter > 0) {
            DeferredStreamState state = new DeferredStreamState();
            state.setConnectArgs(connectArgs);
            state.setReceivedMessages(receivedMessages);
            final Client _var0 = this;
            Deferrer.defer((SingleAction)new SingleAction<Object>(){

                public void invoke(Object s) {
                    try {
                        _var0.streamDeferred(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, (int)reconnectAfter, (Object)state);
        } else {
            this.stream(connectArgs, receivedMessages);
        }
    }

    private void retryConnect(ConnectArgs connectArgs, int backoffTimeout) throws Exception {
        ++this._lastBackoffIndex;
        this._lastBackoffTimeout = backoffTimeout;
        connectArgs.setIsRetry(true);
        this.connect(connectArgs);
    }

    private void retryConnectDeferred(Object s) throws Exception {
        DeferredRetryConnectState state = (DeferredRetryConnectState)s;
        this.retryConnect(state.getConnectArgs(), state.getBackoffTimeout());
    }

    private void send(ClientRequest request, String url, boolean synchronous, int timeout) throws Exception {
        this.sendMany(new ClientRequest[]{request}, url, synchronous, timeout);
    }

    private void sendCallback(MessageResponseArgs responseArgs) throws Exception {
        ClientSendState dynamicValue = (ClientSendState)responseArgs.getRequestArgs().getDynamicValue(_stateKey);
        responseArgs.getRequestArgs().unsetDynamicValue(_stateKey);
        if (responseArgs.getException() != null) {
            this.raiseSendException(dynamicValue, responseArgs.getException());
        } else if (responseArgs.getMessages() == null || ArrayExtensions.getLength((Object[])responseArgs.getMessages()) == 0) {
            this.raiseSendException(dynamicValue, new Exception("Invalid response received from server."));
        } else {
            ArrayList<Message> list = new ArrayList<Message>();
            for (Message message : responseArgs.getMessages()) {
                Advice advice = message.getAdvice();
                if (advice != null) {
                    this.processAdvice(advice);
                    ConnectionType _var0 = this._connectionType;
                    if (_var0 == ConnectionType.WebSocket) {
                        if (advice.getWebSocket() != null) {
                            this.processAdvice(advice.getWebSocket());
                        }
                    } else if (_var0 == ConnectionType.LongPolling) {
                        if (advice.getLongPolling() != null) {
                            this.processAdvice(advice.getLongPolling());
                        }
                    } else if (_var0 == ConnectionType.CallbackPolling && advice.getCallbackPolling() != null) {
                        this.processAdvice(advice.getCallbackPolling());
                    }
                }
                if (!dynamicValue.getIsStream() || Global.equals((Object)message.getBayeuxChannel(), (Object)"/meta/connect")) {
                    if (StringExtensions.isNullOrEmpty((String)message.getId())) {
                        this.raiseSendException(dynamicValue, new Exception(message.getError()));
                        return;
                    }
                    ClientRequest request = null;
                    Holder _var1 = new Holder(request);
                    boolean _var2 = HashMapExtensions.tryGetValue(dynamicValue.getRequestMapping(), (Object)message.getId(), (Holder)_var1);
                    request = (ClientRequest)((Object)_var1.getValue());
                    if (!_var2) {
                        this.raiseSendException(dynamicValue, new Exception(message.getError()));
                        return;
                    }
                    ClientResponseArgs p = new ClientResponseArgs();
                    p.setDynamicProperties(request.getDynamicProperties());
                    p.setResponse(message);
                    p.setException(message.getSuccessful() ? null : new Exception(message.getError()));
                    request.getCallback().invoke((Object)p);
                    continue;
                }
                list.add(message);
            }
            if (ArrayListExtensions.getCount(list) > 0) {
                ClientResponseArgs args2 = new ClientResponseArgs();
                args2.setDynamicProperties(dynamicValue.getRequests()[0].getDynamicProperties());
                args2.setResponses(list.toArray(new Message[0]));
                dynamicValue.getRequests()[0].getCallback().invoke((Object)args2);
            }
            for (Message message : responseArgs.getMessages()) {
                Message[] serverActions = message.getServerActions();
                if (serverActions == null) continue;
                for (Message message2 : serverActions) {
                    this.processServerAction(message2, this._lastInterval);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMany(ClientRequest[] requests, String url, boolean synchronous, int timeout) throws Exception {
        boolean flag = false;
        if (ArrayExtensions.getLength((Object[])requests) == 1) {
            flag = Global.equals((Object)requests[0].getMessage().getBayeuxChannel(), (Object)"/meta/connect");
        }
        HashMap<String, ClientRequest> dictionary = new HashMap<String, ClientRequest>();
        ArrayList<Message> list = new ArrayList<Message>();
        for (ClientRequest request : requests) {
            if (!Global.equals((Object)this.getClientId(), (Object)Guid.empty) && !request.getMessage().isConnect()) {
                request.getMessage().setClientId(new NullableGuid(this.getClientId()));
                request.getMessage().setSessionId(new NullableGuid(this.getSessionId()));
            }
            if (super.getDisableBinary()) {
                request.getMessage().setDisableBinary(new NullableBoolean(super.getDisableBinary()));
            }
            Object object = this._counterLock;
            synchronized (object) {
                ++this._counter;
                request.getMessage().setId(IntegerExtensions.toString((Integer)this._counter));
            }
            list.add(request.getMessage());
            HashMapExtensions.getItem(dictionary).put(request.getMessage().getId(), request);
        }
        String str = this.processRequestUrl(url);
        url = this.processRequestUrl(url);
        if (flag) {
            timeout = this.getStreamRequestTimeout();
        } else if (timeout == 0) {
            timeout = super.getRequestTimeout();
        }
        MessageTransfer transfer = flag ? this._streamRequestTransfer : this._requestTransfer;
        MessageRequestArgs args3 = new MessageRequestArgs(super.createHeaders());
        args3.setMessages(list.toArray(new Message[0]));
        final Client _var0 = this;
        args3.setOnRequestCreated(new SingleAction<MessageRequestCreatedArgs>(){

            public void invoke(MessageRequestCreatedArgs e) {
                try {
                    _var0.internalOnRequestCreated(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Client _var2 = this;
        args3.setOnResponseReceived(new SingleAction<MessageResponseReceivedArgs>(){

            public void invoke(MessageResponseReceivedArgs e) {
                try {
                    _var2.internalOnResponseReceived(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Client _var4 = this;
        args3.setOnHttpRequestCreated(new SingleAction<HttpRequestCreatedArgs>(){

            public void invoke(HttpRequestCreatedArgs e) {
                try {
                    _var4.internalOnHttpRequestCreated(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Client _var6 = this;
        args3.setOnHttpResponseReceived(new SingleAction<HttpResponseReceivedArgs>(){

            public void invoke(HttpResponseReceivedArgs e) {
                try {
                    _var6.internalOnHttpResponseReceived(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args3.setSender((Object)this);
        args3.setTimeout(timeout);
        args3.setUrl(url);
        MessageRequestArgs requestArgs = args3;
        requestArgs.setDynamicValue("frameUrl", str);
        ClientSendState state = new ClientSendState();
        state.setRequests(requests);
        state.setRequestMapping(dictionary);
        state.setIsStream(flag);
        requestArgs.setDynamicValue(_stateKey, state);
        if (synchronous) {
            MessageResponseArgs responseArgs = transfer.send(requestArgs);
            this.sendCallback(responseArgs);
        } else {
            final Client _var8 = this;
            transfer.sendAsync(requestArgs, new SingleAction<MessageResponseArgs>(){

                public void invoke(MessageResponseArgs responseArgs) {
                    try {
                        _var8.sendCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public Client service(ServiceArgs serviceArgs) throws Exception {
        if (StringExtensions.isNullOrEmpty((String)serviceArgs.getChannel())) {
            throw new Exception("channel cannot be null.");
        }
        this.performService(serviceArgs);
        return this;
    }

    private void setClientId(Guid value) {
        this._clientId = value;
    }

    public void setCustomOnReceive(String channel, SingleAction<SubscribeReceiveArgs> onReceive) throws Exception {
        this.setCustomOnReceiveWithTag(channel, StringExtensions.empty, onReceive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomOnReceiveWithTag(String channel, String tag, SingleAction<SubscribeReceiveArgs> onReceive) throws Exception {
        if (channel == null) {
            throw new Exception("channel cannot be null.");
        }
        if (onReceive == null) {
            throw new Exception("onReceive cannot be null.");
        }
        if (tag == null) {
            tag = StringExtensions.empty;
        }
        Object object = this._customOnReceivesLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._customOnReceives, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (!_var1) {
                dictionary = new HashMap();
                HashMapExtensions.getItem(this._customOnReceives).put(tag, dictionary);
            }
            HashMapExtensions.getItem((HashMap)dictionary).put(channel, onReceive);
        }
        this.processPendingReceives(new String[]{channel}, this._lastInterval);
    }

    public void setDisableWebSockets(boolean value) {
        this._disableWebSockets = value;
    }

    public void setInstanceId(Guid value) {
        this._instanceId = value;
    }

    private void setIsConnected(boolean value) {
        this._isConnected = value;
    }

    private void setIsConnecting(boolean value) {
        this._isConnecting = value;
    }

    private void setIsDisconnecting(boolean value) {
        this._isDisconnecting = value;
    }

    private void setServerTimeout(int value) {
        this._serverTimeout = value;
    }

    private void setSessionId(Guid value) {
        this._sessionId = value;
    }

    public void setStreamRequestUrl(String value) throws Exception {
        if (value == null) {
            throw new Exception("Stream request URL cannot be null.");
        }
        this.__streamRequestUrl = HttpTransfer.replaceWildcards((String)value);
    }

    public void setSynchronous(NullableBoolean value) {
        this._synchronous = value;
    }

    public void setToken(String value) {
        this._token = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client startBatch() {
        Object object = this._batchCounterLock;
        synchronized (object) {
            ++this._batchCounter;
        }
        return this;
    }

    private void stream(ConnectArgs connectArgs, boolean receivedMessages) throws Exception {
        ClientRequest request2 = new ClientRequest();
        Message message = new Message("/meta/connect");
        message.setConnectionType(new NullableConnectionType(this._connectionType));
        message.setAcknowledgement(new NullableBoolean(receivedMessages));
        request2.setMessage(message);
        final Client _var0 = this;
        request2.setCallback(new SingleAction<ClientResponseArgs>(){

            public void invoke(ClientResponseArgs responseArgs) {
                try {
                    _var0.streamCallback(responseArgs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ClientRequest request = request2;
        request.setDynamicValue(_argsKey, (Object)connectArgs);
        this.send(request, this.getStreamRequestUrl(), false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamCallback(ClientResponseArgs responseArgs) throws Exception {
        ConnectArgs dynamicValue = (ConnectArgs)((Object)responseArgs.getDynamicValue(_argsKey));
        if (this.getIsConnected() && !this.getIsConnecting() && !this.getIsDisconnecting() && !this._disconnectCalled) {
            if (responseArgs.getException() != null) {
                if (responseArgs.getResponses() != null) {
                    if (this._lastReconnect.getHasValue() && Global.equals((Object)((Object)this._lastReconnect.getValue()), (Object)((Object)Reconnect.Retry))) {
                        this.restream(dynamicValue, false, this._lastInterval);
                    } else {
                        this.reconnect(dynamicValue, responseArgs);
                    }
                } else {
                    this.reconnect(dynamicValue, responseArgs);
                }
            } else if (ArrayExtensions.getLength((Object[])responseArgs.getResponses()) == 1 && Global.equals((Object)responseArgs.getResponses()[0].getBayeuxChannel(), (Object)"/meta/connect")) {
                this.restream(dynamicValue, false, this._lastInterval);
            } else {
                int lastInterval = this._lastInterval;
                String threadId = this.getThreadId();
                this.preRaise(threadId);
                try {
                    for (Message message : responseArgs.getResponses()) {
                        lastInterval = this.receiveMessage(message, lastInterval);
                    }
                }
                finally {
                    this.postRaise(threadId);
                }
                this.restream(dynamicValue, true, lastInterval);
            }
        }
    }

    private void streamDeferred(Object s) throws Exception {
        DeferredStreamState state = (DeferredStreamState)s;
        this.stream(state.getConnectArgs(), state.getReceivedMessages());
    }

    public Client subscribe(SubscribeArgs subscribeArgs) throws Exception {
        if (subscribeArgs.getChannels() == null || ArrayExtensions.getLength((Object[])subscribeArgs.getChannels()) == 0) {
            throw new Exception("channels cannot be null.");
        }
        if (subscribeArgs.getOnReceive() == null) {
            final Client _var0 = this;
            subscribeArgs.setOnReceive(new SingleAction<SubscribeReceiveArgs>(){

                public void invoke(SubscribeReceiveArgs e) {
                    try {
                        _var0.receiveSink(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if (subscribeArgs.getTag() == null) {
            subscribeArgs.setTag(StringExtensions.empty);
        }
        this.performSubscribe(subscribeArgs);
        return this;
    }

    private boolean tryWebSocket() throws Exception {
        try {
            WebSocketMessageTransfer webSocketMessageTransfer = MessageTransferFactory.getWebSocketMessageTransfer(this.processRequestUrl(this.getStreamRequestUrl()));
            webSocketMessageTransfer.setHandshakeTimeout(super.getRequestTimeout());
            webSocketMessageTransfer.setStreamTimeout(this.getStreamRequestTimeout());
            final Client _var0 = this;
            webSocketMessageTransfer.setOnRequestCreated(new SingleAction<HttpRequestCreatedArgs>(){

                public void invoke(HttpRequestCreatedArgs e) {
                    try {
                        _var0.internalOnHttpRequestCreated(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            final Client _var2 = this;
            webSocketMessageTransfer.setOnResponseReceived(new SingleAction<HttpResponseReceivedArgs>(){

                public void invoke(HttpResponseReceivedArgs e) {
                    try {
                        _var2.internalOnHttpResponseReceived(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            final Client _var4 = this;
            webSocketMessageTransfer.setOnOpenSuccess(new SingleAction<WebSocketOpenSuccessArgs>(){

                public void invoke(WebSocketOpenSuccessArgs e) {
                    try {
                        _var4.webSocketOpenSuccess(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            final Client _var6 = this;
            webSocketMessageTransfer.setOnOpenFailure(new SingleAction<WebSocketOpenFailureArgs>(){

                public void invoke(WebSocketOpenFailureArgs e) {
                    try {
                        _var6.webSocketOpenFailure(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            final Client _var8 = this;
            webSocketMessageTransfer.setOnStreamFailure(new SingleAction<WebSocketStreamFailureArgs>(){

                public void invoke(WebSocketStreamFailureArgs e) {
                    try {
                        _var8.webSocketStreamFailure(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            webSocketMessageTransfer.setSender((Object)this);
            this._connectionType = ConnectionType.WebSocket;
            this._streamRequestTransfer = webSocketMessageTransfer;
            webSocketMessageTransfer.open(super.createHeaders());
            return true;
        }
        catch (Exception exception1) {
            return false;
        }
    }

    public Client unbind(UnbindArgs unbindArgs) throws Exception {
        if (unbindArgs.getRecords() == null || ArrayExtensions.getLength((Object[])unbindArgs.getRecords()) == 0) {
            throw new Exception("records cannot be null.");
        }
        for (Record record : unbindArgs.getRecords()) {
            if (record.getKey() != null) continue;
            throw new Exception("key cannot be null.");
        }
        this.performUnbind(unbindArgs);
        return this;
    }

    public boolean unsetCustomOnReceive(String channel) throws Exception {
        return this.unsetCustomOnReceiveWithTag(channel, StringExtensions.empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetCustomOnReceiveWithTag(String channel, String tag) throws Exception {
        if (channel == null) {
            throw new Exception("channel cannot be null.");
        }
        if (tag == null) {
            tag = StringExtensions.empty;
        }
        Object object = this._customOnReceivesLock;
        synchronized (object) {
            HashMap dictionary = null;
            Holder _var0 = new Holder(dictionary);
            boolean _var1 = HashMapExtensions.tryGetValue(this._customOnReceives, (Object)tag, (Holder)_var0);
            dictionary = (HashMap)_var0.getValue();
            if (_var1) {
                if (HashMapExtensions.remove((HashMap)dictionary, (Object)channel)) {
                    if (HashMapExtensions.getCount((HashMap)dictionary) == 0) {
                        HashMapExtensions.remove(this._customOnReceives, (Object)tag);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public Client unsubscribe(UnsubscribeArgs unsubscribeArgs) throws Exception {
        if (unsubscribeArgs.getChannels() == null || ArrayExtensions.getLength((Object[])unsubscribeArgs.getChannels()) == 0) {
            throw new Exception("channels cannot be null.");
        }
        if (unsubscribeArgs.getTag() == null) {
            unsubscribeArgs.setTag(StringExtensions.empty);
        }
        this.performUnsubscribe(unsubscribeArgs);
        return this;
    }

    private void webSocketOpenFailure(WebSocketOpenFailureArgs e) throws Exception {
        if (this._webSocketOpened) {
            if (!this.tryWebSocket()) {
                this.doLongPolling();
            }
        } else {
            this.doLongPolling();
        }
    }

    private void webSocketOpenSuccess(WebSocketOpenSuccessArgs e) throws Exception {
        this._webSocketOpened = true;
        this.activateStream(this._connectArgs, this._responseArgs);
    }

    private void webSocketStreamFailure(WebSocketStreamFailureArgs e) throws Exception {
        ClientResponseArgs responseArgs = new ClientResponseArgs();
        responseArgs.setDynamicProperties(this._responseArgs.getDynamicProperties());
        responseArgs.setException(new Exception(StringExtensions.format((String)"WebSocket stream error. {0}", (Object)e.getException().getMessage())));
        this.streamCallback(responseArgs);
    }

    static {
        _bayeuxVersion = "1.0";
        _bayeuxMinimumVersion = "1.0";
        _argsKey = "fm.args";
        _stateKey = "fm.state";
        _requestUrlCache = new HashMap();
        _requestUrlCacheLock = new Object();
    }
}

